;====================================================================
;樠 ⥬
;
   ORG 100H
;
INIT: DI
   MVI A,81H
   OUT 4
   XRA A
   OUT 10H
   MVI A,0C3H
   STA 0000H   ;  0000H
   STA 0038H
   LXI H,0100H
   SHLD 0001H  ;  0001H
   LXI H,INTERR
   SHLD 0039H
   LXI SP,8000H
   EI
   JMP @BEGIN
;
;p稪 pp뢠
INTERR:  PUSH H
   PUSH D
   PUSH B
   PUSH PSW
;p ⨪
          XRA A
          OUT 07
          IN  07
          ANI 0F8H
          STA JOY
          JNZ INT0
;p p
          MVI A,8AH
          OUT 0
          IN  1
          STA RUSLAT
          LXI B,0FE08H
          LXI H,KEYTAB
INT1:     MOV A,B
          OUT 03
          IN 02
          MOV M,A
          INX H
          MOV A,B
          RLC
          MOV B,A
          DCR C
          JNZ INT1
          INT0:     MVI A,88H      ;⠭ p⮢
          OUT 00
          MVI A,0FFH
          OUT 03
          LXI H,CLOCK   ; pp pp襭 
          MOV A,M
          ANA A
          JZ INT2
	  INX H
          INR M   ; 20 MS p
	  MVI A,50
          CMP M
          JNZ INT2
          MVI M,0        ; ᥪ㭤
          INX H
          INR M
          MVI A,60
          CMP M
          JNZ INT2
          MVI M,0
          INX H          ; 
          INR M
;
INT2:     POP PSW
   POP B
   POP D
   POP H
   EI
   RET
;
CLOCK:    DB 0      ;䫠 pp襭 
TIME00:   DB 0      ;稪 20 MS
TIME01:   DB 0      ;稪 ᥪ㭤
TIME02:   DB 0      ;稪 
;
;TIME00:   EQU 81F0H
;TIME01:   EQU TIME00+1
;TIME02:   EQU TIME01+1
;
;ﭨ  p/LAT, , 
RUSLAT:   DB 11100000B
;
;᪠-⠡ p
KEYTAB:   ;    EQU 0E0F8H ⫠ p
          DB 11111111B   ; TAB      LF UP RT DN
          DB 11111111B   ; HOM P P2 F1 F2 F3 F4 F5
          DB 11111111B   ; 0   1   2   3  4  5  6  7
          DB 11111111B   ; 8   9   :   ;  ,  -  .  /
          DB 11111111B   ; @   A   B   C  D  E  F  G
          DB 11111111B   ; H   I   J   K  L  M  N  O
	  DB 11111111B   ; P   Q   R   S  T  U  V  W
          DB 11111111B   ; X   Y   Z   [  |  ]  ^  SP
;
JOY:      ;    EQU KEYTAB+200H ⫠ p
          DB 0
;
;
;⠡ 梥⮢ 稭  0-
COLTAB:  ;
   DB 000H,0C0H,020H,004H
   DB 0C4H,051H,0B5H,0FFH
   DB 0FFH,000H,000H,000H
   DB 000H,000H,000H,000H
;
;
@BEGIN:   JMP BEGIN
@SETPAL:  JMP SETPAL
@CELL:    JMP CELL
@FRAME:   JMP FRAME
@GETKEY:  JMP GETKEY
@CURSOR:  JMP CURSOR
@DD:      JMP DD
@TIME:    JMP TIME
@NUMBER:  JMP NUMBER
;
@KEYTAB:  EQU KEYTAB
@JOY:     EQU JOY
@COLTAB:  EQU COLTAB
@TIME00:  EQU TIME00
@TIME01:  EQU TIME01
@TIME02:  EQU TIME02
@IMAGE:   EQU 1000H
;
;⥪ pp   "MINSWEEPER"
;
SCREEN:  EQU 0A108H
IMAGE0: EQU 01000H
IMAGE1: EQU 01560H
;

;뢮 ⪨
; [DE]= X, Y
; [A] = ⨯ ⪨
;
CELL:   PUSH H
	PUSH D
	PUSH B
	PUSH PSW
	PUSH PSW
	MOV A,D        ;p
	STC      ;⭮
	CMC      ;樨
	RAR
	MOV D,A
	JNC CELL0
; 
;  権
	LXI H,IMAGE1
	SHLD CELLA+1
	LXI H,SCREEN+200H
	SHLD CELL8+1
	MVI A,25H   ; (DCR H)
	STA CELL9
	MVI A,0F0H
	STA CELL5+1
	JMP CELL7
; 
;  権
CELL0:   LXI H,IMAGE0
	SHLD CELLA+1
	LXI H,SCREEN
	SHLD CELL8+1
	MVI A,24H   ; (INR H)
	STA CELL9
	MVI A,00FH
	STA CELL5+1
;뢮 ⪨
CELL7:   POP PSW
CELLA:   LXI H,IMAGE0   ;롮p p
	LXI B,72 ; 
CELL1:   ANA A
	JZ CELLB
	DAD B ; ⨯=⨯*72
	DCR A
	JMP CELL1
CELLB:  XCHG     ; [DE]=IMAGE
	MOV A,H  ;X=X/2*3
	ADD A
	ADD H
	MOV H,A
        MVI B,12
        XRA A
CELL2:  ADD L ;Y=Y*12
	DCR B
	JNZ CELL2
	MOV L,A
CELL8:  LXI B,SCREEN   ; [HL]=ADDR
	DAD B
	PUSH H
   MVI B,3        ; 3 .
CELL4:   MVI C,12
   PUSH H
CELL3:   LDAX D
   MOV M,A
   INX D
   INX H
   DCR C
   JNZ CELL3
   POP H
   MVI A,20H
   ADD H
   MOV H,A
   DCR B
   JNZ CELL4
   POP H
CELL9:   INR H
   MVI B,3
CELL6:   MVI C,12
   PUSH H
CELL5:   MVI A,00FH
   ANA M
   MOV M,A
   LDAX D
   ORA M
   MOV M,A
   INX D
   INX H
   DCR C
   JNZ CELL5
   POP H
   MVI A,20H
   ADD H
   MOV H,A
   DCR B
   JNZ CELL6
;
   POP PSW
   POP B
   POP D
   POP H
   RET
;
;⠭ ⠡
;梥⮢
;
SETPAL:  EI
   HLT
   PUSH PSW
   PUSH D
   PUSH H
   LXI D,100FH
   LXI H,COLTAB+15
SETP1:   MOV A,E
   OUT 02
   MOV A,M
   OUT 0CH
   DCX H
   OUT 0CH
   DCR E
   OUT 0CH
   DCR D
   OUT 0CH
   INR D
   OUT 0CH
   DCR D
   OUT 0CH
   INR D
   OUT 0CH
   DCR D
   OUT 0CH
   JNZ SETP1
   POP H
   POP D
   POP PSW
   RET
;
;pᮢ p p 
;
FRIM00:   EQU 01AC0H
FRIM01:   EQU FRIM00+24
FRIM02:   EQU FRIM01+24
FRIM03:   EQU FRIM02+24
FRIM04:   EQU FRIM03+24
FRIM05:   EQU FRIM04+24
;
HICOL:    EQU 216   ; ⮫
FRAME:    PUSH H
          PUSH D
          PUSH B
          PUSH PSW
          LXI D,2000H-HICOL
          LXI H,0A008H
          CALL FR0
          LXI H,0BF08H
          CALL FR0
          LXI H,0BE00H
          CALL FR3
          LXI H,0BEE0H
          CALL FR3
;㣫
	  LXI D,FRIM01
          LXI H,0A000H
	  CALL FR5
          LXI D,FRIM02
          LXI H,0A0E0H
          CALL FR5
          LXI D,FRIM03
          LXI H,0BFE0H
          CALL FR5
          LXI D,FRIM04
          LXI H,0BF00H
          CALL FR5
          POP PSW
          POP B
          POP D
          POP H
          RET
;p⨪쭠  p
FR0:      LDA FRIM05       ; p ᪮
          CALL FR1
	  DAD D
          LDA FRIM05+1     ; p쥩 ᪮
	  CALL FR1
          DAD D
          LDA FRIM05+2     ; ⢥p⮩ ᪮
          CALL FR1
          RET
;pᮢ ⮫   ᪮
FR1:      MVI B,HICOL    ; ⮫
FR2:      MOV M,A
          INX H
          DCR B
          JNZ FR2
          RET
;
;p⠫쭠  p
;
FR3:      MOV B,H
FR7:      LXI D,FRIM00
          CALL FR5
FR6:      DCR B
          MOV A,B
	  CPI 0A0H
          RZ
          MOV H,B
          JMP FR7
;pᮢ ⮫  p ᪮
FR5:      MVI C,08
FR4:      LDAX D
          MOV M,A
          INR L
          INX D
          DCR C
          JNZ FR4
          MOV A,L
          SUI 08
          MOV L,A
          MOV A,H
          ADI 20H
          CPI 0A0H
	  RC             ; HL <  80H ?
          MOV H,A        ; HL >= 80H
	  JMP FR5
;
;
;祭 ᪠- ⨪  p
;
GETKEY:   PUSH H
          PUSH D
          PUSH B
          LDA JOY
          ANA A
          JZ GT0
          LXI H,JOYTAB-1
GT1:      RLC
          INX H
          JNC GT1
          MOV D,M
          JMP GT2
GT0:      LXI H,KEYTAB
	  MVI D,0
          MVI B,8
GT4:      MVI C,8
          MOV A,M
GT3:      RLC
          JNC GT2
          INR D
          DCR C
          JNZ GT3
          INX H
          DCR B
          JNZ GT4
          MVI D,0FFH     ; ""
GT2:      ;  pp  D ᮤp ᪠-
          LDA RUSLAT
          ANI 01100000B  ;    , 
          XRI 01100000B  ;
          RLC
          ORA D          ;  
;                         p訥 
AUTO0:    EQU 255
AUTO1:    EQU 80
GT5:      LXI H,LSTKEY   ;⮯p
          CMP M
          JNZ GT6
          INX H
          DCR M
          JZ GT7
          MVI A,0FFH
          JMP GTE
GT7:      MVI M,AUTO1
          JMP GTE
GT6:      MOV M,A
          INX H
          MVI M,AUTO0
GTE:      ANA A
          POP B
          POP D
          POP H
          RET
LSTKEY:   DB 0FFH
          DB 000H
;
;⠡ ᮮ⢥⢨ ᪠  ⨪  p
JOYTAB:   DB 02,01,00,03,56  ; UP RT DN LF SP
;
;pᮢ pp        [HL]= X, Y
;                         [A]=  䠧
CURIMG:   EQU 01B40H
;
CURSOR:   PUSH H
          PUSH D
          PUSH B
          PUSH PSW
;p ⭮ 樨
          MOV C,A
          MOV A,H        ;X=X/2
          STC
          CMC
          RAR
	  MOV H,A
          PUSH H
	  JNC CURS0
;  権
;p   ᪮ !!!!
          LXI D,SCREEN+100H-2000H
          LXI H,CURIMG+192
          JMP CURS1
;    権
CURS0:    LXI D,SCREEN
          LXI H,CURIMG
;롮p 䠧
CURS1:    MOV A,C        ; C=C*24
          ADD A
          ADD A
          ADD A
          MOV C,A
          ADD A
          ADD C
          MOV C,A
	  MVI B,0
          DAD B
	  XCHG      ;[DE]=IMAGE, [HL]=MEMORY
;p p
          POP B
          MOV A,B        ; X=X*3
          ADD A
          ADD B
          MOV B,A
          MOV A,C        ; Y=Y*12
          ADD A
          ADD A
          MOV C,A
          ADD A
          ADD C
          MOV C,A
          DAD B          ; [HL]= ADDRES
          MVI B,2
CURS4:    MVI C,12
CURS2:    LDAX D
	  CMA
          ANA M
	  MOV M,A
          MOV A,H
          ADI 20H
          CPI 0A0H  ; p ᪮⥩ !
          JC CURS3  ; H< A0H ?
          MOV H,A
          JMP CURS2
CURS3:    SUI 60H
          MOV H,A
          INX D
          INR L
          DCR C
          JNZ CURS2
          INR H
          MOV A,L
          SUI 12
          MOV L,A
          DCR B
	  JNZ CURS4
CURS8:    POP PSW
	  POP B
	  POP D
          POP H
          RET
;
;pᮢ   p
;p
DDIMG:    EQU 1CC0H
DD:       PUSH H    ;[HL]= X,Y
          PUSH D
          PUSH B
          PUSH PSW
          LXI D,DDIMG
          MVI B,3   ; p .
DD0:      MVI C,16
DD1:      LDAX D
          MOV M,A
          INX D
	  INR L
          DCR C
	  JNZ DD1
	  MOV A,L
          SUI 16
          MOV L,A
          MOV A,H
          ADI 20H
          MOV H,A
          DCR B
          JNZ DD0
          POP PSW
          POP B
          POP D
          POP H
          RET
;
;p ⥪饣 p
TIME:     PUSH H
          PUSH D
	  PUSH B
          PUSH PSW
	  MVI A,0FFH
	  STA SHFLAG
          MVI B,2
          LXI H,TIME01   ;ᥪ㭤
          LXI D,0BDF0H   ;pᯮ
TIM0:     LDA SHFLAG
          CMA
          STA SHFLAG
          MVI C,0
          MOV A,M
TIM2:     CPI 10    ;筮 pp
          JC TIM1
          SUI 10
          INR C
	  JMP TIM2
;[A]= p  [C]=p p
TIM1:     CALL @NUMBER   ; p
	  LDA @SHFLAG
	  CMA
	  STA @SHFLAG
	  MOV A,C
	  DCR D
	  DCR D
	  CALL @NUMBER   ;p p
	  DCR D
	  DCR D
	  DCR D
	  INX H     ;
	  DCR B
	  JNZ TIM0
	  POP PSW
	  POP B
	  POP D
	  POP H
	  RET
SHFLAG:   DB 0
@SHFLAG:  EQU SHFLAG
;
;p  p
NUMIMG:   EQU DDIMG+16+16+16
NUMBER:   PUSH H
	  PUSH D    ;[DE]= X,Y
          PUSH B    ;[A]=  NUMBER
          LXI H,NUMIMG
          LXI B,96  ; 
NUM0:     ANA A     ;롮p p.
          JZ NUM1
          DAD B
          DCR A
          JMP NUM0
NUM1:     MVI B,3   ;[HL]=IMAGE
NUM3:     MVI C,16  ;[DE]= X,Y
NUM4:     PUSH B
          MOV C,M
          INX H
          MOV B,M
          INX H
          LDA SHFLAG     ;ᤢ?
          ANA A
	  JNZ NUM2  ; -᫨  ᤢ
          PUSH H
	  MOV H,B
          MOV L,C
          DAD H     ; ᤢ p
          DAD H     ;  4 窨 
          DAD H
          DAD H
          MOV C,L
          MOV B,H
          POP H
NUM2:     MOV A,B
          STAX D
          INR D
          MOV A,C
          STAX D
          DCR D
          INR E
          POP B
          DCR C
	  JNZ NUM4
          MOV A,E
	  SUI 16
          MOV E,A
          MOV A,D
          ADI 20H
          MOV D,A
          DCR B
          JNZ NUM3
          POP B
          POP D
          POP H
          RET
;
;
;=====================================================================
;⥪ pp p⪨
; p  㯠 
;p 
;
@ACCESS:  JMP ACCESS
@RND:     JMP RND
@FILL:    JMP FILL
@GETTYPE: JMP GETTYPE
@OPEN:    JMP OPEN
@SETFLAG: JMP SETFLAG
@SHOW:	  JMP SHOW
;
;         00- 05     ⢮ 
;         81- 85     p ⪠  p
;         40- 45     ⪠  p  䫠
@CLEAR:   EQU 80H   ; p ⪠
@EMPTY:   EQU 00H   ; p ⪠
@MINE:    EQU 08H   ;⪠  
@EXPL:    EQU 87H   ;p 
@MARK:    EQU 48H   ; 祭 䫠
@BORD:    EQU 0FFH  ; p  p 
@SHIP:    EQU 0F0H  ;p
;
@GET:     EQU 7EH   ; MOV A,M = 7EH
@PUT:     EQU 77H   ; MOV M,A = 77H
@NULL:    EQU 00H   ; NOP
;
@FIELD:   EQU 4000H ; p ᨢ-
@MAXX:    EQU 19
@MAXY:    EQU 17
@MINNUM:  DB 60     ;⢮   
@FLAGNUM: DB 60
;
ACCESS:   PUSH H
	  PUSH D    ;[DE]= X,Y
	  PUSH B    ;[C]=  p樨
	  MOV B,A   ;[A]= 
	  PUSH B
;
	  MOV A,D   ;pp p 
	  ANA A
	  JM EXT
	  CPI @MAXX+1    ; [D]<0  [D]>@MAXX
	  JNC EXT
	  MOV A,E
	  ANA A
	  JM EXT
	  CPI @MAXY+1    ; [E]<0  [E]>@MAXY
	  JNC EXT
;
GETADDR:  LXI H,@FIELD
	  LXI B,@MAXX+1  ; [HL]= [HL]+ [D]*20
	  MOV A,D
ACC0:     ANA A
	  JZ ACC1
	  DAD B
	  DCR A
	  JMP ACC0
ACC1:     MVI B,0   ; [HL]= [HL]+ [E]
	  MOV C,E
	  DAD B
; p p
	  POP B
	  MOV A,C
	  CPI @GET
	  JNZ ACC2
	  MOV A,M   ;⥭
	  JMP ACCE
ACC2:     CPI @PUT
          MOV A,B
          JNZ ACCE
          MOV M,A
          JMP ACCE
;
EXT:      POP B
	  MVI A,@BORD
;
ACCE:     POP B
	  POP D
	  POP H
	  RET
;
;pp ᥢ砩 楫
;ᥫ    0  255
;
MSKXOR:     EQU 60H ;⮢ ᪠  XOR
;
RND:  PUSH H   ;p .
   PUSH B
   MVI C,07    ;7 宫 横
   LHLD LSTRND ; p.
RND1: MOV A,H  ;p-.
   ANI MSKXOR
   MVI A,1
   JPO RND3 ;p XOR
   XRA A
RND3: ORA L       ;ᥭ p-.
   MOV L,A        ;XOR  pp
   DAD H          ;ᤢ pp
   DCR C          ; 宫.
   JNZ RND1 	  ;横
   MOV A,H        ;p. .
   SHLD LSTRND 	  ;p p-.
   POP B          ;. .
   POP H
   RET            ;室
LSTRND:  DW 695CH ;砫쭮 .
;
; ᨢ-
FILL:     PUSH H
	  PUSH D
	  PUSH B
	  PUSH PSW
;
FIL0:     LXI H,@FIELD   ; 
	  LXI B,360      ; 20 X 18
FIL1:     MVI M,@EMPTY
	  INX H
	  DCX B
	  MOV A,B
	  ORA C
	  JNZ FIL1
	  LDA @MINNUM
	  MOV B,A
          LXI H,1412H    ; 20 X 18
FIL5:     CALL RND       ;p 
FIL3:     CMP H          ; X < [H]=20 ?
	  JC FIL2
	  SUB H
          JMP FIL3
FIL2:     MOV D,A        ; [D]= X
          CALL RND
FIL6:     CMP L          ; Y < [E]=18 ?
          JC FIL4
          SUB L
          JMP FIL6
FIL4:     MOV E,A        ; [E]= Y
	  MVI C,@GET     ;  ?
          CALL ACCESS
          CPI @MINE
          JZ FIL5        ;᫨ - p
          MVI C,@PUT
	  MVI A,@MINE    ;
	  CALL ACCESS   ; 
          DCR B
	  JNZ FIL5  ;᫨ p⠢   
;   p  ⮪
CALC:     MVI E,@MAXY
CAL5:     MVI D,@MAXX
CAL4:     PUSH D
          DCR D
          DCR E
          MVI B,0   ;稪 
          MVI H,3   ;  ᥤ
CAL3:     MVI L,3
CAL2:     MOV A,D
          MVI C,@GET
	  CALL ACCESS
          CPI @MINE
          JNZ CAL1
          INR B
CAL1:     INR E
	  DCR L
	  JNZ CAL2
          DCR E
	  DCR E
          DCR E
	  INR D
	  DCR H
          JNZ CAL3
          POP D
          MVI C,@GET
          CALL ACCESS
          CPI @MINE
          JZ CAL9   ; p
          MOV A,B   ;᫨ CIFRA  5
          CPI 06    ; - ᭮
	  JNC FIL0
          MVI C,@PUT
          CALL ACCESS
          JMP CAL0
CAL9:     MOV A,B   ;᫨ ⭮   6/9
	  CPI 07    ; - ᭮
	  JNC FIL0
CAL0:     DCR D
	  JP CAL4
          DCR E
	  JP CAL5
;
          POP PSW
          POP B
          POP D
          POP H
          RET
;
;p ⨯ p ⪨
GETTYPE:  PUSH B
	  MVI C,@GET
          CALL ACCESS    ;[DE]= X, Y
          MOV C,A
          ANI @SHIP
          CPI @SHIP
	  JZ GTT4
	  MOV A,C
          ANA A
	  JP GTT0
          CPI 88H
	  JZ GTT1
	  CPI @EXPL
          JZ GTT2
          SUI 80H-5 ;p ⨯ p⮩ ⪨
          JMP GTTE
GTT4:     MOV A,C
          XRI @SHIP
          ADI 11
          JMP GTTE
GTT2:     MVI A,3   ;p 
	  JMP GTTE
GTT1:     MVI A,2
          JMP GTTE
GTT0:     ANI 40H   ;p ⪠
          JNZ GTT3  ;⮨  䫠 ?
	  MVI A,0   ;䫠  ⮨
	  JMP GTTE
GTT3:     MVI A,1
GTTE:     POP B
          RET
;
;p⨥ ⪨
OPEN:     PUSH B
          MVI C,@GET
          CALL ACCESS
          CPI @BORD
          JZ OPE
          MOV C,A
          ANI 11000000B  ;⪠ 㦥 p
          JNZ OP0        ; 祭 䫠
	  MOV A,C        ;  p 
          CPI @MINE      ;⪠  
          JNZ OP1
          MVI A,@EXPL    ; p
          MVI C,@PUT
	  CALL ACCESS
	  JMP OPE
OP1:      ORI 10000000B  ;p 'p'
	  MVI C,@PUT
          CALL ACCESS
	  JMP OPE
OP0:      MVI A,@NULL
OPE:      POP B
	  RET
;
;⠭- ⨥ 䫠
FLAG:     EQU 01000000B  ;p '䫠'
SETFLAG:  PUSH B
	  MVI C,@GET
	  CALL ACCESS
	  MOV C,A
	  ANI 80H   ; 'p' ?
	  MVI A,@NULL
	  JNZ SETFE
	  MOV A,C
	  XRI FLAG  ;p p '䫠'
	  MVI C,@PUT
	  CALL @ACCESS
SETFE:    POP B
	  RET
;
; ᥣ 
SHOW:     PUSH D
	  PUSH B
	  PUSH PSW
;
	  MVI D,@MAXX
SH0:      MVI E,@MAXY
SH1:      MVI C,@GET
	  CALL @ACCESS
	  MOV B,A
	  ANI 10000000B  ;p?
	  JNZ SH2
	  MOV A,B
	  ANI 01000000B  ;⮨  䫠?
	  JNZ SH3
	  MOV A,B
	  CPI @MINE      ;?
	  MVI A,2        ;  
	  JZ SH4
	  MOV A,B
	  ADI 5          ;p
SH4:      JMP SH5
SH3:      MOV A,B        ;䫠
	  CPI @MARK
	  MVI A,1        ; 
	  JZ SH5
	  MVI A,4        ;p ⮨ 䫠
SH5:      CALL @CELL
SH2:      DCR E
	  JP SH1
	  DCR D
	  JP SH0
;
	  POP PSW
	  POP B
	  POP D
	  RET
;
;p 
REGION:   PUSH H
	  PUSH D    ;[DE]=X, Y
	  PUSH B
	  PUSH PSW
	  DCR D
	  DCR E
	  MVI H,3
REG0:     MVI L,3
REG1:     CALL @OPEN
	  CPI @BORD
	  JZ REG2
	  MOV C,A
	  CALL @GETTYPE
	  CALL @CELL
	  MOV A,C
	  CPI 80H
	  CZ REGION
REG2:     INR E
	  DCR L
	  JNZ REG1
	  DCR E
	  DCR E
	  DCR E
	  INR D
	  DCR H
	  JNZ REG0
	  POP PSW
	  POP B
	  POP D
	  POP H
	  RET
;
;=======================================================================
;	p pﬨ  
;
SHIP:     EQU 4800H 	;p 砫 ᨢ p
NUMSHIP:  DB 0 		;⢮ p  
;
@ADDSHIP:	JMP ADDSHIP
@MOVSHIP:	JMP MOVSHIP
;
ADDSHIP:  PUSH H
	  PUSH D
	  PUSH B
	  PUSH PSW
	  LXI H,SHIP
	  LDA NUMSHIP
	  ANA A
ADDS1:    JZ ADDS0  ;[HL]= ADDR( SHIP[NUMSHIP] )
	  INX H
	  INX H
	  INX H
	  INX H
	  DCR A
	  JMP ADDS1
ADDS0:	  MVI M,0   ; SHIP[NUMSHIP].FASE=0
	  INX H
	  MOV M,E   ; SHIP[NUMSHIP].Y=Y
	  INX H
	  MOV M,D   ; SHIP[NUMSHIP].X=X
	  INX H
	  MVI M,0   ; SHIP[NUMSHIP].DIR=0
	  LXI H,NUMSHIP
	  INR M     ; NUMSHIP++
;
	  MVI A,@SHIP
	  MVI C,@PUT
	  CALL @ACCESS
	  MVI A,12	; pᮢ p, 騩 p
	  CALL @CELL
	  POP PSW
	  POP B
	  POP D
	  POP H
	  RET
;
NEWSHIP:
NEWMF:	DB 0
NEWMY:	DB 0
NEWMX:	DB 0
NEWMD:	DB 0

MOVSHIP:	PUSH H
	PUSH D
	PUSH B
	PUSH PSW

	LXI H,SHIP
	LDA NUMSHIP
	MOV B,A
MOVS0:	MOV A,B
	ANA A
	JZ MOVSE
	MOV A,M
	INR A
	ANI 3
	MOV M,A
	JNZ MOVS1
	PUSH H
	MOV A,M
	STA NEWMF
	INX H
	MOV A,M
	STA NEWMY
	MOV E,A
	INX H
	MOV A,M
	STA NEWMX
	MOV D,A
	INX H
	MOV A,M
	STA NEWMD
	POP H

	CPI 0
	JNZ MOVS00
	INR D
	JMP MOVS03
MOVS00:	CPI 2
	JNZ MOVS01
	DCR E
	JMP MOVS03
MOVS01:	CPI 4
	JNZ MOVS02
	DCR D
	JMP MOVS03
MOVS02:	CPI 6
	JNZ MOVS03
	INR E
	JMP MOVS03
MOVS03:	MVI C,@GET
	CALL @ACCESS
	CPI @CLEAR
	JZ MOVS2

	CALL @RND
	ANI 110B
	STA NEWMD
	JMP MOVS3
MOVS2:	MOV A,E
	STA NEWMY
	MOV A,D
	STA NEWMX
MOVS3:	PUSH H
	INX H
	MOV E,M
	INX H
	MOV D,M
	POP H
	MVI A,@CLEAR
	MVI C,@PUT
	CALL @ACCESS
	CALL @GETTYPE
	CALL @CELL

	PUSH H
	LDA NEWMF
	MOV M,A
	INX H
	LDA NEWMY
	MOV M,A
	INX H
	LDA NEWMX
	MOV M,A
	INX H
	LDA NEWMD
	MOV M,A
	POP H

MOVS1:	MOV C,M
	INX H
	MOV E,M
	INX H
	MOV D,M
	INX H
	MOV A,M
	INX H

	ANI 4
	ORA C
	ADI @SHIP
	MVI C,@PUT
	CALL @ACCESS
	SUI @SHIP
	ADI 11
	CALL @CELL

	DCR B
	JMP MOVS0

MOVSE:	POP PSW
	POP B
	POP D
	POP H
	RET
;
;=======================================================================
;     㭪 pp
;    MINSWEEPER
;
;
@UP:      EQU 02
@DOWN:    EQU 00
@LEFT:    EQU 03
@RIGHT:   EQU 01
@SPACE:   EQU 56
@ENTER:   EQU 05
@SECRET:  EQU 8+128+64
@ESCAPE:  EQU 13
;
;᭮ pp;
BEGIN:
MAIN:
; ⪠ p    > 4000H
CLS:      DI
	  LXI SP,0
	  LXI D,0
	  LXI B,0B00H
CL0:      PUSH D
	  PUSH D
	  PUSH D
	  PUSH D
	  PUSH D
	  PUSH D
	  PUSH D
	  PUSH D
	  DCX B
	  MOV A,B
	  ORA C
	  JNZ CL0
	  LXI SP,8000H
	  EI
   CALL @SETPAL
	CALL @FRAME
;
MAIN0:    LXI H,0
	  SHLD CLOCK    ; 㫥 p  䫠
	  SHLD CLOCK+2  ; pp襭 
	  LXI H,0BAF0H  ; p p p
	  CALL @DD
	  CALL @TIME
;
	  MVI E,@MAXY
MAIN1:    MVI D,@MAXX
MAIN2:    XRA A
	  CALL @CELL
	  DCR D
	  JP MAIN2
	  DCR E
	  JP MAIN1
;
MAIN3:    CALL @RND      ;p pp RND
	  CALL @GETKEY   ;   
	  CPI 00FFH
	  JNZ MAIN3
MAIN4:    CALL @RND
	  CALL @GETKEY   ;   
	  CPI 00FFH
	  JZ MAIN4
	  XRA A
	  STA NUMSHIP
;
	  CALL @FILL
	  MVI A,1
	  STA CLOCK     ;pp 
;
CURINI:   MVI H,0
	  MVI L,@MAXY
	  SHLD CURNEW
	  SHLD CUROLD
	  XRA A
	  STA CURFAS
;
BLINK0:   CALL @MOVSHIP   ;p p
	  LHLD CUROLD    ;p pp 
	  MOV D,H        ;p 
	  MOV E,L
	  CALL @GETTYPE
	  CALL @CELL
	  LHLD CURNEW    ;pᮢ pp 
	  SHLD CUROLD    ; 
	  LDA CURFAS
	  INR A
	  ANI 00000111B  ; 8 䠧
	  STA CURFAS
BLINK1:   CALL @CURSOR
	  MVI B,20
BLINK4:   CALL @GETKEY
	  CPI 0FFH
	  JNZ BLINK2
;          MVI C,0FFH
;BLINK3:   DCR C
;          JNZ BLINK3
	   DCR B
	  JNZ BLINK4
	  CALL @TIME
	  JMP BLINK0
BLINK2:   LHLD CUROLD
	  MOV D,H
	  MOV E,L
;  
	  CPI @DOWN
	  JZ DOWN
	  CPI @RIGHT
	  JZ RIGHT
	  CPI @UP
	  JZ UP
	  CPI @LEFT
	  JZ LEFT
	  CPI @SPACE
	  JZ SPACE
	  CPI @ENTER
	  JZ ENTER
	  CPI @SECRET
	  JZ SECRET
	  JMP BLINK0
;
DOWN:     MOV A,L
	  DCR A
	  JP DN0
	  MVI A,@MAXY
DN0:      MOV L,A
	  JMP CURMOV
UP:       MOV A,L
	  INR A
	  CPI @MAXY+1
	  JNZ UP0
	  XRA A
UP0:      MOV L,A
	  JMP CURMOV
LEFT:     MOV A,H
	  DCR A
	  JP LF0
	  MVI A,@MAXX
LF0:      MOV H,A
	  JMP CURMOV
RIGHT:    MOV A,H
	  INR A
	  CPI @MAXX+1
	  JNZ RT0
	  XRA A
RT0:      MOV H,A
	  JMP CURMOV
CURMOV:   SHLD CURNEW
	  JMP BLINK0
SPACE:    CALL @OPEN
	  MOV C,A
	  CALL @GETTYPE
	  CALL @CELL
	  MOV A,C
	  CPI 80H
	  CZ REGION
	  CZ @ADDSHIP
	  JMP BLINK0
ENTER:    CALL @SETFLAG
L0:     CALL @GETTYPE
	  CALL @CELL
	  JMP BLINK0
SECRET:   CALL @SHOW
SEC0:     CALL @GETKEY
	  CPI 00FFH
	  JZ SEC0
	  JMP MAIN0
;
CURNEW:   DW 0
CUROLD:   DW 0
CURFAS:   DB 0
;
;=========================================================================
   END
