; Retex
;    
;  () AbleSoft
;  (C) Oleg Vasenyoff
;
	org 0E180h
;For screen editing
STBUF:	EQU 0E000H
STH:	EQU 0E0H
FLBUF:	EQU STBUF+256
LIMTOP:	EQU FLBUF+2
LIMBTM:	EQU LIMTOP+2
ZTOP:	EQU LIMBTM+2
ZEND:	EQU ZTOP+2
ADBUF:	EQU ZEND+2
NLIN:	EQU ADBUF+2
ADEDG:	EQU NLIN+2
EOF:	EQU ADEDG+2
CUR:	EQU EOF+2
HOR:	EQU CUR+2
ADSCR:	EQU HOR+2
;For running line
RLSIZE:	EQU ADSCR+2
RLCNT:	EQU RLSIZE+2
RLADR:	EQU RLCNT+2
RLSCR:	EQU RLADR+2
;For keyboard work
KEY:	EQU RLSCR+2	;kbrd mode
KLAST:	EQU KEY+10
;For buffers
KEYBUF:	EQU KLAST+2
SRBUF:	EQU KEYBUF+8
CHBUF:	EQU SRBUF+17
SKBUF:	EQU CHBUF+17

BEGIN:	DI
	XRA A
	OUT 10H
	LXI SP,100H
	MVI A,0C3H
	STA 0
	LXI H,BEGIN
	SHLD 1
	LXI H,INTRPT
	SHLD 39H
	LXI H,0240H
	SHLD KEY
	MVI A,83H
	OUT 4
	MVI A,9
	OUT 4
	XRA A
	STA RLCNT+1
	LXI D,0FF52H
	CALL COLOR	;interrupts will be enabled there

	LXI H,09FFFH
	SHLD ZTOP
	LXI H,097FFH
	SHLD LIMTOP
	LXI H,0100H
	SHLD LIMBTM
	JMP TRY

MAIN:	;It'll be moved wyshe
TRY:	LHLD LIMTOP
	XCHG
	LHLD ZTOP
	CALL SUBHD
	RC
	MOV A,H
	ORA A
	RZ
	LHLD LIMBTM
	XCHG
	CALL SUBHD
	RC
	MOV A,H
	ORA A
	RZ

CLRAL:	DI
	LXI SP,100H
	LXI H,CLRAL
	SHLD 1
	LXI D,3610H
	CALL COLOR
	LXI H,SRBUF-1
	MVI B,16
	CALL FILHB
	MVI M,'*'
	INX H
	MVI M,1
	LHLD LIMTOP
	MVI M,13
	DCX H
	MVI M,13
	DCX H
	MVI M,255
	SHLD EOF
	LHLD ZTOP
	MVI M,255
	SHLD ZEND
	CALL CLS
	CALL QPUT
	DB 0C0H,0,0A0H,4,0C5H,-3,1,'/',0C9H,-3,1,':'
	DB 0CDH,-3,8AH,32,0D7H,-3,4,'Free',0C0H,-14,6,'Retex',3,0
;	LXI H,NMBUF+10
;	MVI B,11
;	CALL SHWBF
	LXI H,0
	SHLD HOR
	INR L
HOME1:	CALL HME
HOME2:	CNZ PRSCR
LDBF:	LHLD ADBUF
	XCHG
	LXI H,STBUF+255
	PUSH H
CLB1:	LDAX D
	MOV M,A
	CPI 13
	JZ CLB2
	DCX D
	DCR L
	JNZ CLB1
	MVI M,13
CLB2:	MOV A,L
	CMA
	MOV L,A
	MVI H,0
	SHLD FLBUF

CNT:	POP D
	LXI H,0
	LDA HOR
	ORA A
	JZ CNT1
	MOV B,A
CNT0:	LDAX D
	DCR E
	CPI 13
	JNZ CNT2
	MOV C,B
	DAD B
	JMP CNT1
CNT2:	CPI 9
	JNZ CNT3
	MOV A,B
	SUB H
	CPI 7

CNT3:	INR H
	INR L
	DCR B
	JNZ CNT0
CNT1:	SHLD CUR+1
LOOP:	CALL MYSTR
LOP:	LXI SP,100H
	CALL MSX0B
	JNZ INP2
	LXI H,0C0FDH
	call PRSET
	LHLD NLIN
	CALL PRHL
	LDA HOR
	CALL PRA
	LDA FLBUF
	MOV E,A
	LDA HOR
	CMP E
	JNC INP3
	MVI H,STH
	CMA
	MOV L,A
	MOV A,M
	CALL PRA
INP1:	LXI H,0DBFDH
	call PRSET
	LHLD LIMBTM
	XCHG
	LHLD EOF
	CALL SUBHD
	CALL PRHL
	CALL QPUT
	DB 0C6H,-14,095H,32,0DBH,-14,5,23,24,25,26,3,0
INP2:	CALL MSX07
	LXI H,MATC
	LXI D,MATAD-2
	MVI B,26
	CALL SRCOD
	JZ BUKWA
	PUSH D
	LXI D,MATAD+26
	CALL CMPHD
	JC BUSTO
	RET
INP3:	CALL QPUT
	DB 0CAH,-3,131,32,0
	JMP INP1

SRCOD:	CMP M
	INX H
	JZ FNDCD
	DCR B
	JNZ SRCOD
	RET	;Z if nfnd
FNDCD:	XRA A
	MOV H,A
	ADD B
	ADD B	;reset Z
	MOV L,A
	DAD D
	MOV E,M
	INX H
	MOV D,M
	RET

MATC:	DB 4,8,18,127,14,15,28,29,23,24,17,12,10,13,30,31
	DB 20,22,25,26,11,16,6,7,5
MATEC:	DB 27,28,29,30,31,6,'PNCSLI'
MATES:	DW INF,LOAD,SAVE,CLR,NAM,PRNT,SRIN,ENDT,BGN,HOM,SEND
MATAD:	DW ESC,LOP,LOP,SRCH,INSL,EDGE,PGDN,PGUP,VSPL,ZAPL
	DW DWN,UP,CRLF,LOP,LOP,DELL,WRDL,WRDR
	DW LFT,RGT,DELH,INSM,DEL,INS,BS,NUMB

BUSTO:	LXI H,FLBUF+1
	MOV A,M
	ORA A
	RZ
	DCX H
	MOV B,M
	DCX H
	XCHG
	LHLD ADBUF
	MVI C,-1
	CALL SRNXT
	MOV A,C
BUST1:	SBB B
	PUSH D
	PUSH H
	JNC STORE

	LHLD EOF
	XCHG
	POP H
	PUSH H
	MOV C,A
	CALL SUBHD
	MOV A,C
	PUSH B
	MOV C,L
	MOV B,H
	INR C
	INR B
	MOV L,A
	MVI H,-1
	DAD D
	XCHG
	PUSH H
	LHLD LIMBTM
	XCHG
	CALL CMPHD
	JC NRAM
	SHLD EOF
	POP D
OTODV:	LDAX D
	MOV M,A
	INX H
	INX D
	DCR C
	JNZ OTODV
	DCR B
	JNZ OTODV
	POP B
STORE:	POP H
	XTHL
	XCHG
	LHLD ADBUF
	MOV A,B
	ORA A
	JZ STRE1
STRE:	LDAX D
	MOV M,A
	DCX H
	DCX D
	DCR B
	JNZ STRE
STRE1:	MVI M,13
	DCX H
	XRA A
	STA FLBUF+1

	POP D
	XCHG
	CALL CMPHD
	RNC
PODV:	MOV A,M
	STAX D
	DCX H
	DCX D
	INR A
	JNZ PODV
	XCHG
	INX H
	SHLD EOF
	RET

FILHB:	INX H
	MVI M,32
	INR D
	DCR B
	JNZ FILHB
	RET
SHWBF:	MOV A,M
	DCX H
	CALL ?CHPUT
	DCR B
	JNZ SHWBF
	RET
INPBF:	MVI B,0
IB0:	PUSH H
	PUSH D
	CALL ?07
	POP D
	POP H
	CPI 29
	JNZ IB1
	MOV A,B
	ORA A
	JZ IB0
	DCR B
	INX D
	DCR H
	JMP IB0
IB1:	CPI 13
	RZ
	CPI 28
	JZ IB2
	CPI 32
	JC IB0
	STAX D
	CALL ?CHPUT
IB2:	MOV A,B
	CMP C
	JZ IB0
	INR B
	DCX D
	INR H
	JMP IB0
CMPBF:	LDAX D
	CPI '?'
	JZ CMP1
	CPI '*'
	RZ
	CMP M
	RNZ
CMP1:	DCX D
	DCX H
	DCR B
	JNZ CMPBF
	RET

WAITN:	CALL QPUT
	DB -2,0DBH,5,':Skip',0
	CALL QPUT
WA:	LXI H,SKBUF-1
	MVI B,11
	CALL FILHB
WA0:	CALL SRTP
	RNZ
	MVI D,4
WA1:	CALL INTP
	CPI 0E6H
	JNZ WA0
	DCR D
	JNZ WA1	
	MVI D,11
WA2:	CALL INTP
	RNZ
	ORA A
	JZ WA3
	MOV M,A
	DCX H
	DCR D
	JNZ WA2
WA3:	LXI H,0D0FEH
	SHLD ADSCR
	MVI B,11
	LXI H,SKBUF+10
	PUSH H
	CALL SHWBF
	POP H
	LXI D,NMBUF+10
	MVI B,11
	CALL CMPBF
	JNZ WA
	RET

CONF:	CALL MSX07
	ANI 223
	CPI 'Y'
	RZ
	CPI ''
	RZ
	JMP LOP

ESC:	CALL QPUT
	DB 0DBH,-14,5,'Esc+ ',0
	CALL MSX07
	ANI 223
	MVI B,11
	LXI H,MATEC+1
	LXI D,MATES-2
	CALL SRCOD
	JZ HELP
	XCHG
	PCHL

HELP:	CALL QPUT
	DB 0DBH,-14,5,' Help',0C0H,231,128,32,0C0H,143,128,32
	DB 0C0H,55,224,32,0C3H,231,90,'ABLESoft small text media:   '
	DB 29,28,30,31,47,11,'-one move/to the corner   '
	DB 29,28,47,30,31,'+CC-move at a *word/page',0
;	DB 192,0C0H,84,13,'-return, add a line if the end '
;	DB 'F1/F4/BS-ins/del/back a symbol  '
;	DB 'F6/F9-ins/del a line'
;	DB 156,0C0H,58,'F1/F2+YC-overtype/del line end  '
;;;	DB 'F3/cc+F3-*cut/*link to this line'
;	DB 'F5/F10-store/restore lines'
;	DB 120,0C0H,10,'cmp-search'
;	DB 108,0C0H,27,'yc+cc/pyc/nc-keyboard modes'
;	DB 96,0C3H,8,'After ',27,58
;	DB 84,0C0H,21,29,28,30,31,'-move to the edge'
;	DB 72,0C0H,23,'cmp -set search pattern'
;	DB 60,0C0H,42,'P',13,31,30,'-Print all/from/to this line'
;	DB 'N-set Name',48,0CFH,24,'L-Load/merge text'
;	DB 'C-Clear',36,0CFH,11,'S-Save text'
;	DB 24,0C0H,26,'I-Info         H-tHis help'
;	DB 12,0C0H,31,'*-not supported in this version',0
HLP:	CALL WAITC
	CALL MSX07
	ORA A
	JMP HOME2

INF:	CALL QPUT
	DB -2,0DCH,4,'Info',228,0C0H,128,32
	DB 225,0C1H,29,'Real programmer',39,'s text editor'
	DB 210,0C1H,30,'Version 2.36 designed by ',23,24,25,26,3
	DB 195,0C7H,17,1,15,16,17,18,19,20,21,22,3,' MCMXCI'
	DB 156,0C9H,14,'Use TAB & ',29,28,30,31,0
	JMP HLP
	CALL QPUT
	CALL MSX07
	JMP LOP

PRNT:	CALL QPUT
	DB -2,0DAH,6,'',0
	CALL MSX07
	DI
	LHLD EOF
	XCHG
	LHLD ADBUF
	SUI 31
	JZ PRB1
	INR A
	JNZ PRB0
	CALL SRNXT
	XCHG
PRB0:	LHLD LIMTOP
	DCX H
PRB1:	PUSH D
	MOV E,M
	DCX H
PRB2:	CALL PRINT
	JC LOP
	MOV A,E
	CPI 13
	MVI E,10
	JZ PRB2
	POP D
	CALL CMPHD
	JNZ PRB1
	JMP LOP

NAM:	CALL QPUT
	DB -2,0DCH,4,'Name',0
	LXI H,0D5F2H
	LXI D,NMBUF+10
	MVI C,10
	CALL INPBF
	JMP LOP

SAVE:	CALL QPUT
	DB -2,0DCH,4,'Save',0
	DI
	MVI D,8
	XRA A
SV1:	XRI 55H
	MVI E,64
	CALL FILTP
	DCR D
	JNZ SV1
	MVI A,0E6H
	MVI E,5
	CALL FILTP
	LXI H,NMBUF+10
	MVI E,11
SV2:	MOV A,M
	CPI '*'
	JZ SV3-2
	CPI '?'
	JNZ SV3
	MVI A,'?'
SV3:	CALL OUTTP
	DCX H
	DCR E
	JNZ SV2
	XRA A
	CALL OUTTP
	CALL FILTP
	LHLD LIMTOP
	XCHG
	LHLD EOF
	CALL SUBHD
	INR H
	MVI A,0E6H
	CALL OUTTP
	CALL OUTHL
	LXI H,0
SV4:	DCX D
	LDAX D
	CALL OUTTP
	INR A
	JZ SV0
	DAD B
	JMP SV4
SV0:	CALL OUTHL
	JMP LOP
FILTP:	CALL OUTTP
	DCR E
	JNZ FILTP
	RET

NMBUF:	DB 'TXTdeltitnU'
@SUM:	DB -2,0D0H,16,'!Checksum error!',0
@LOD:	DB -2,0DCH,4,'Load',0
LOAD:	CALL WAITN
	JNZ LOP
	LXI D,@LOD
	CALL QPUT
	CALL SRTP
	JNZ LOP
	DI
	CALL INHL
	LXI H,0
	PUSH H
	LHLD LIMBTM
	XCHG
	LHLD EOF
LO1:	CALL CMPHD
	JZ LO2
	CALL INTP
	JNZ LO2
	MOV M,A
	INR A
	JZ LO3
	DCX H
	XTHL
	DAD B
	XTHL
	JMP LO1
LO2:	INX H
	MVI M,13
	DCX H
	MVI M,255
LO3:	SHLD EOF
	CALL INHL
	POP D
	CALL CMPHD
	PUSH PSW
	CALL PRSCR
	POP PSW
	JZ LOP
	LXI D,@SUM
	JMP MESS

@CLR:	DB -2,0D6H,10,' ?',0
CLR:	LXI D,@CLR
	CALL QPUT
	CALL CONF
	JMP CLRAL

@NFND:	DB -2,0CAH,9,'Not found',0
@SRIN:	DB -2,0C8H,8,' Search:',0
SRIN:	LXI D,@SRIN
	CALL QPUT
	LXI H,SRBUF+15
	PUSH H
	MVI B,16
	CALL SHWBF
	POP D
	LXI H,0D0FEH
	MVI C,15
	CALL INPBF
	INR B
	MOV A,B
	STA SRBUF+16
	LHLD LIMTOP
	JMP SR
SRCH:	LDA SRBUF+16
	MOV B,A
	LHLD ADBUF
	CALL SRNXT
	INX H
SR:	XCHG
	LHLD EOF
	XCHG
SR4:	DCX H
	CALL CMPHD
	PUSH D
	LXI D,@NFND
	JZ MESS
	LXI D,SRBUF+15
	PUSH H
	MOV C,B
	CALL CMPBF
	MOV B,C
	POP H
	POP D
	JNZ SR4
	PUSH H
	LHLD ADEDG
	XTHL
	XCHG
	CALL HME
SR5:	CALL ?DN
	JC END0
	CALL DWN2
	JMP SR5

ZAPL:	LHLD ADBUF
	MOV C,L
	MOV B,H
	LHLD LIMTOP
	INX H
	XCHG
	LHLD ZEND
ZA1:	CALL CMPHD
	JZ ZA2
	LDAX B
	MOV M,A
	DCX B
	DCX H
	CPI 13
	JNZ ZA1
	JMP ZA3
ZA2:	CALL BEEP
	INX H
	MVI M,13
	DCX H
ZA3:	MVI M,255
	SHLD ZEND
	JMP DWN

VSPL:	LHLD ZTOP
	SHLD ZEND
VSP1:	MOV A,M
	INR A
	JZ LDBF
	PUSH H
	MVI C,-1
	CALL SRNXT
	MOV B,C
	XRA A
	CMC
	LHLD ADBUF
	POP D
	PUSH D
	PUSH H
	CALL BUST1
	CALL SHDN
	POP D
	CALL ?MSTR
	MVI B,0
	CALL DWN2
	POP H
	CALL SRNXT
	JMP VSP1

INSM:	LXI H,@@IM+1
	MOV A,M
	XRI 15
	MOV M,A
	JMP LOP

NCH:	LXI B,300H
	CALL ?07+3
	CPI '0'
	RC
	CPI ':'
	RNC
	MOV E,A
	CALL ?CHPUT
	MOV A,C
	ADD A
	ADD A
	ADD C
	ADD A
	ADD E
	SUI 48
	MOV C,A
	DCR B
	JNZ NCH+3
	RET

NUMB:	LXI H,0CAFDH
	call PRSET
	CALL NCH
	CPI 13
	JZ LOP
	CPI 255
	JZ LOP
BUKWA:	MOV C,A
	LDA HOR
	MOV E,A
	MVI H,STH
	CMA
	MOV L,A
	LDA FLBUF
	MOV D,A
	MOV A,E
	SUB D
	JNC NBUK
	LDA @@IM+1
	RAR
	JMP CINS
NBUK:	JZ CINS
	MOV B,A
	INR E
	JZ ?BEEP
	DCR E
	CALL FILHB
CINS:	MOV A,D
	CNC ?INS
	MOV M,C
	CALL UPL
	CALL MYSTR
	JMP RGT

INS:	CALL INS0
@@IC:	MVI M,32
	CALL UPL
	JMP LOOP
INS0:	LDA HOR
	MOV E,A
	LDA FLBUF
	MOV D,A
?INS:	SUB E
	JC LOP
	INR A
	MOV B,A
	INR D
	JZ ?BEEP
	MOV A,D
	STA FLBUF
	MVI H,STH
	CMA
	MOV L,A
	MVI M,13
	INX H
	MOV E,L
	MOV D,H
INS1:	INX D
	DCR B
	RZ
	LDAX D
	MOV M,A
	INX H
	JMP INS1

DEL:	LDA FLBUF
	MOV C,A
	LDA HOR
DEL0:	CALL ?DEL
	JMP LOOP
?DEL:	CMP C
	RNC
	MVI H,STH
	CMA
	MOV L,A
	MOV A,M
	STA @@IC+1
	MOV A,C
	DCR A
	STA FLBUF
	MOV E,L
	MOV D,H
DEL1:	DCX H
	MOV A,M
	STAX D
	DCX D
	CPI 13
	JNZ DEL1
UPL:	LDA FLBUF
	CMA
	MOV L,A
	MVI H,STH
	MVI A,32
UPL0:	INR L
	JZ UPL1
	CMP M
	JZ UPL0
UPL1:	DCR L
	MVI M,13
	MOV A,L
	CMA
	MOV L,A
	MVI H,1
	SHLD FLBUF
	RET

BS:	LDA FLBUF
	MOV C,A
	LDA HOR
	ORA A
	JZ DEL0
	DCR A
	CALL ?DEL
	CALL MYSTR
	JMP LFT

DELH:	LDA FLBUF
	MOV E,A
	LDA HOR
	CMP E
	JNC LOP
	STA FLBUF
	MVI H,STH
	CMA
	MOV L,A
	MVI M,13
	CALL UPL
	JMP LOOP

WRDL:
WRDR:	JMP LOP

EDGE:	LHLD NLIN
	LDA CUR
EDG1:	CPI 240
	JZ EDG2
	DCX H
	ADI 10
	JMP EDG1
EDG2:	SHLD NLIN
	LHLD ADEDG
	CALL HME1
	LDA HOR+1
	JMP CR2

BGN:	LHLD ADEDG
	XCHG
	LHLD LIMTOP
	DCX H
	CALL CMPHD
	JMP HOME1
HME:	LXI H,0
	MVI A,240
	SHLD NLIN
	LHLD LIMTOP
	DCX H
	SHLD ADEDG
HME1:	SHLD ADBUF
	STA CUR
	RET

ENDT:	LHLD ADEDG
	PUSH H
	MVI B,1
END1:	CALL ?DWN
	JC END0
	CALL DWN2
	JMP END1

PGDN:	LHLD ADEDG
	PUSH H
	MVI B,23
PG1:	CALL ?DWN
	JC END0
	CALL DWN2
	DCR B
	JNZ PG1
END0:	POP D
	LHLD ADEDG
	CALL CMPHD
	JMP HOME2

PGUP:	LHLD ADEDG
	PUSH H
	MVI B,23
PG2:	CALL ?UP
	JNC END0
	CALL UP2
	DCR B
	JNZ PG2
	JMP END0

CRLF:	CALL ?DWN
	JNC CR1
	DCX H
	XCHG
	LHLD LIMBTM
	XCHG
	CALL CMPHD
	JC NRAM
	SHLD EOF
	MVI M,255
	INX H
	MVI M,13
CR1:	LDA HOR+1
	MOV B,A
	CALL DWN2
	MOV A,B
CR2:	LXI H,0
	SHLD HOR
	ORA A
	JMP HOME2

DWN:	CALL ?DWN
	JC ?BEEP
	MVI B,0
	CALL DWN2
	JMP LDBF
?DWN:	LHLD EOF
	INX H
	XCHG
?DN:	LHLD ADBUF
	CALL SRNXT
	JMP CMPHD
DWN2:	SHLD ADBUF
	LHLD NLIN
	INX H
	SHLD NLIN
	LDA CUR
	SUI 10
	JZ DWN1
	STA CUR
	RET
DWN1:	MOV A,B
	ORA A
	MVI A,240
	CZ SHUP+3
	LHLD ADEDG
	CALL SRNXT
	SHLD ADEDG
	RET

UP:	CALL ?UP
	JNC ?BEEP
	MVI B,0
	CALL UP2
	JMP LDBF
?UP:	LHLD LIMTOP
	DCX H
	XCHG
	LHLD ADBUF
	JMP CMPHD
UP2:	CALL SRPR
	SHLD ADBUF
	LHLD NLIN
	DCX H
	SHLD NLIN
	LDA CUR
	ADI 10
	CPI 250
	JNC UP1
	STA CUR
	RET
UP1:	MOV A,B
	ORA A
	CZ SHDN
	LHLD ADBUF
	SHLD ADEDG
	RET

SHUP:	LDA CUR
	CPI 10
	RZ
	MVI D,0C0H
	MOV E,A
	MVI B,32
SUP1:	MOV A,E
	SUI 10
	MOV L,A
	MOV H,D
	MOV C,E
SUP2:	MOV A,M
	STAX D
	DCR E
	DCR L
	JNZ SUP2
	MOV E,C
	INR D
	DCR B
	JNZ SUP1
	RET
SHDN:	LDA CUR
	SUI 10
	RZ
	MOV C,A
	MVI B,32
	MVI D,0C0H
SDN1:	PUSH B
	MVI E,0
	MVI L,10
	MOV H,D
SDN2:	INR E
	INR L
	MOV A,M
	STAX D
	DCR C
	JNZ SDN2
	POP B
	INR D
	DCR B
	JNZ SDN1
	RET
	
LFT:	LHLD HOR
	MOV A,L
	ORA A
	JZ ?BEEP
	DCR A
LFT1:	STA HOR
	CMP H
	JNC LOP
LFT2:	ANI 0F8H
	STA HOR+1
	CALL PRSCR
	JMP LOOP
HOM:	LHLD HOR
	XRA A
	JMP LFT1

RGT:	LHLD HOR
	MOV A,L
	INR A
	JZ ?BEEP
RGT1:	STA HOR
	MOV L,A
	SUB H
	CPI 32
	JC LOP
	MOV A,L
	SUI 24
	JMP LFT2
SEND:	LHLD HOR
	LDA FLBUF
	CMP L
	JC LFT1
	JMP RGT1

INSL:	XRA A
	MOV B,A
	CMC
	LHLD ADBUF
	CALL BUST1
	CALL SHDN
	JMP LDBF

DELL:	LHLD ADBUF
	PUSH H
	CALL ?DWN
	JC ?BEEP
	POP D
	CALL PODV
	LHLD CUR
	MVI H,0C0H
	call PRSET
	MOV D,L
	LHLD ADBUF
	CALL PRC1
	JMP LDBF

@RAM:	DB -2,0CAH,13,'Out of memory',0
NRAM:	LXI D,@RAM
MESS:	CALL QPUT
?BEEP:	CALL BEEP
	JMP LOOP

QPUT:	XTHL
QP1:	MOV A,M
	INX H
	ORA A
	JZ QP4
	MOV D,A
	MOV E,M
	INX H
	XCHG
	call PRSET
	XCHG
	MOV E,M
	INX H
	MOV A,E
	ANI 1111111B
	MOV D,A
	XRA E
	JNZ FILCH
QP2:	MOV A,M
	INX H
	CALL ?CHPUT
	DCR D
	JNZ QP2
	JMP QP1
FILCH:	MOV A,M
	INX H
QP3:	MOV E,A
	CALL ?CHPUT
	MOV A,E
	DCR D
	JNZ QP3
	JMP QP1
QP4:	XTHL
	RET

PRSCR:	LXI H,0C000H+240
	call PRSET
	LHLD ADEDG
	LDA CUR
	MOV D,A
PRC1:	MOV A,M
	INR A
	JZ PREOF
	LDA ADSCR
	ORA A
	RZ
	CMP D
	JZ NXTLN
	CALL PRSTR
	JMP PRC1
NXTLN:	SUI 10
	STA ADSCR
	CALL SRNXT
	JMP PRC1
PREOF:	LDA ADSCR
	ORA A
	RZ
	XRA A
	CALL ?CHPUT
	JMP PREOF
MYSTR:	LXI D,STBUF+255
?MSTR:	LHLD CUR
	MVI H,0C0H
	SHLD ADSCR
	XCHG
PRSTR:	LDA HOR+1
	INR A
	MOV E,A
	LXI B,1FFH
PRS1:	DCR B
	MVI A,32
	JNZ PRS3
	INR B
	MOV A,M
	DCX H
	CPI 13
	JNZ PRS2
	MVI B,0
	MVI E,1
	JMP PRS1
PRS2:	CPI 9
	JNZ PRS3
	MOV A,C
	ANI 7
	INR A
	MOV B,A
	MVI A,9
PRS3:	DCR C
	DCR E
	JNZ PRS1
	INR E
	CALL ?CHPUT
	JNZ PRS1
	INX H
SRNXT:	MVI A,13
SR1:	INR C
	CMP M
	DCX H
	JNZ SR1
	RET
SRPR:	INX H
	MVI A,13
SR2:	INX H
	CMP M
	JNZ SR2
	DCX H
	RET

PRA:	LXI H,ADSCR+1
	INR M
	MVI E,100
	CALL PRAD
?PRA:	MVI E,10
	CALL PRAD
	MVI E,1
PRAD:	MVI B,47
PRA1:	INR B
	SUB E
	JNC PRA1
	ADD E
	MOV C,A
PRA2:	MOV A,B
	CALL ?CHPUT
	MOV A,C
	RET
PRHL:	LXI D,10000
	CALL PRHLD
	LXI D,1000
	CALL PRHLD
	LXI D,100
	CALL PRHLD
	MOV A,L
	JMP ?PRA
PRHLD:	MVI B,47
PRHL1:	INR B
	CALL SUBHD
	JNC PRHL1
	DAD D
	JMP PRA2

SUBHD:	MOV A,L
	SUB E
	MOV L,A
	MOV A,H
	SBB D
	MOV H,A
	RET
CMPHD:	MOV A,H	;HL?DE
	CMP D
	RNZ
	MOV A,L
	CMP E
	RET

INTRPT:	PUSH H
	PUSH D
	PUSH B
	PUSH PSW
	LXI H,KEY	;flags
	MOV A,M
	XRI 1
	MOV M,A
	ANI 1	;scan or code?
	JZ KCODE
	INX H
	MOV C,M
	MVI A,8AH
	OUT 0
	MOV A,C
	OUT 1
	IN 1
	MOV M,A
	MVI B,0FEH
I1:	MOV A,B
	OUT 3
	RLC
	MOV B,A
	IN 2
	INX H
	MOV M,A
	JC I1
	MVI A,88H
	OUT 0
	MOV A,C
	OUT 1
	MVI A,240
	OUT 3
FIN:	LHLD RLCNT
	MOV A,H
	ORA A
	MOV A,L
	CNZ RUNLIN
	POP PSW
	POP B
	POP D
	POP H
	EI
	RET

KCODE:	LXI H,KBUF
	PUSH H
	LXI H,KEY+9
	MVI C,66
KC2:	MVI B,8
	MOV E,M
	DCX H
KC1:	MOV A,E
	RLC
	MOV E,A
	DCR C
	MOV A,C
	JNC FNDK
	RZ	;nothing
	DCR B
	JNZ KC1
	JMP KC2
FNDK:	CPI 65
	MVI A,32
	RZ
	LXI H,KEY+1
	MVI B,0
	MOV A,C
	CPI 18
	JNC DIGIT	;>17
	MOV A,M
	RLC
	RLC
	RLC	;shift?
	JC CTRL
	MVI A,18
	JMP GETK
CTRL:	RRC
	RRC	;ctrl?
	JC GETK1
	MVI A,36
GETK:	ADD C
	MOV C,A
GETK1:	LXI H,KMAT
	DAD B
	MOV A,M
	RET
KMAT:	DB 00,00,09,04,13,08,29,30,28,31,11,06,27,18,0,10,127,20;	sng
	DB  1,00,09,00,13,08,24,25,23,26,11,07,27,16,00,12,17,22;	sft
	DB 00, 3,09, 2,13,08,24,25,23,26,11,00,27,14,00,00,15,00;	ctr
DIGIT:	CPI 34
	JNC ALPHA	;>33
	MVI E,10000B
	ADI 14
	CPI 44
	JC DI1
	ADD E
DI1:	MOV C,A
	MOV A,M
	RRC
	ANA E
	XRA C
	CPI 32
	RNZ
	MVI C,65
ALPHA:	MOV A,M
	ANI 10100000B
	DCX H
	MOV E,M
	XRA E
	MOV E,A
	RLC
	JC LAT
	LXI H,CMAT-34
	DAD B
	MOV C,M
	JMP SBOR1
CMAT:	DB 9EH,80H,81H,96H,84H,85H,94H,83H
	DB 95H,88H,89H,8AH,8BH,8CH,8DH,8EH
	DB 8FH,9FH,90H,91H,92H,93H,86H,82H
	DB 9CH,9BH,87H,98H,9DH,99H,97H,0BAH
LAT:	RLC
	JNC NQWER
	LXI H,QMAT-34
	DAD B
	MOV A,M
	JMP SBOR
QMAT:	DB 64,70,94,87,76,84,65,85,93,66,81,82,75,86,89,74
	DB 71,90,72,67,78,69,91,68,77,83,80,73,92,79,88,95
NQWER:	MVI A,30
	ADD C
SBOR:	CPI 95
	RZ
	MOV C,A
SBOR1:	MOV A,E
	ANI 100000B
	XRA C
	CPI 176
	RC
	ADI 48
	RET
KBUF:	LXI H,FIN
	PUSH H
@@KB:	LXI D,0
	LXI H,KLAST
	MOV C,M
	MOV M,A
	ORA A
	RZ
	CMP C
	MOV C,A
	INX H
	JZ KOLD
	MVI M,12	;new
KB1:	CPI 4
	JC CCODE
PUTB:	MOV A,E
	INR A
	ANI 7
	CMP D
	RZ
	STA @@KB+1
	MVI A,1
	OUT 0
	LXI H,KEYBUF
	MVI D,0
	DAD D
	XRA A
	OUT 0
	MOV M,C
	RET
KOLD:	DCR M
	RNZ
	INR M	;powtor
	MOV A,E
	CMP D
	RNZ
	MOV A,C
	JMP KB1
CCODE:	LXI D,KEY
	LXI H,1000H
CC1:	DAD H
	DCR C
	JNZ CC1
	LDAX D
	XRA H
	STAX D
	DAD H
	RNC
	INX D
	LDAX D
	XRI 1000B	;lamp
	STAX D
	RET

MSX0B:	EI
	LHLD @@KB+1
	MOV A,L
	SUB H
	RZ
	MVI A,255
	RET
MSX07:	LHLD HOR
	MOV A,L
	SUB H
	ADI 0C0H
	MOV H,A
	LDA CUR
	MOV L,A
?07:	call PRSET
	CALL INV
	CALL WAITC
	PUSH H
	CALL INV
	POP H
	MOV A,H
	INR A
	ANI 7
	STA @@KB+2
	MOV E,H
	MVI D,0
	LXI H,KEYBUF
	DAD D
	MOV A,M
	RET
INV:	LHLD ADSCR
	MVI D,10
INV2:	MOV A,M
@@IM:	XRI 255
	MOV M,A
	DCR L
	DCR D
	JNZ INV2
	RET
WAITC:	CALL MSX0B
	JZ WAITC
	RET
KKILL:	LXI H,0
	SHLD @@KB+1
	RET

PRSET:;	in 3
;	add l
;	inr a
;	mov l,a
	shld ADSCR
	ret
CHPUT:	call PRSET
?CHPUT:	PUSH H
	PUSH D
	PUSH B
	MVI D,0F6H
	MOV E,A
	LHLD ADSCR
	MOV C,L
CH1:	LDAX D
	MOV M,A
	DCR L
	INR D
	JNZ CH1
	INR H
	MOV A,H
	ANI 31
	JZ CH2
	MOV L,C
	JMP CH3
CH2:	MVI H,0C0H
CH3:	SHLD ADSCR
	POP B
	POP D
	POP H
	RET

OUTHL:	MOV A,L
	CALL OUTTP
	MOV A,H
OUTTP:	MVI B,8
TP1:	RLC
	MOV C,A
	XRI 1
	CALL TP2
	MOV A,C
	CALL TP2
	MOV A,C
	DCR B
	JNZ TP1
	RET
TP2:	ANI 1
	OUT 0
@@TO:	MVI A,50
TP3:	DCR A
	JNZ TP3
	RET

SRTP:	DI
	MVI C,0
INTP1:	CALL INTP3
	RNZ
	CPI 0E6H
	RZ
	CPI 19H
	JNZ INTP1
	LXI B,@@NEG
	LDAX B
	XRI 63
	STAX B
	XRA A
	RET
INHL:	CALL INTP
	MOV L,A
	CALL INTP
	MOV H,A
	RET
INTP:	PUSH D
	LXI B,800H
INTP2:	CALL INTP3
	JNZ INTP5
	DCR B
	JNZ INTP2
INTP5:	POP D
	RET
INTP3:	IN 1
	ANI 10H
	MOV E,A
INTP4:	IN 1
	ANI 060H
	CPI 060H
	RNZ
	IN 1
	ANI 10H
	CMP E
	JZ INTP4
@@NEG:	CMC
@@TI:	MVI A,75
	CALL TP3
	MOV A,C
	RAL
	MOV C,A
	RET

COLOR:	MVI A,0C9H
	STA 38H
	EI
	HLT
	MVI B,16
CO1:	MOV A,B
	DCR A
	OUT 2
	ANI 2
	MOV A,D
	JNZ CO2
	MOV A,E
CO2:	MVI C,4
CO3:	OUT 0CH
	DCR C
	JNZ CO3
	DCR B
	JNZ CO1
	MVI A,0C3H
	STA 38H
	jmp 38h

PRINT:	IN 1
	ANI 60H
	CPI 60H
	RC
	IN 5
	RRC
	JC PRINT
	MOV A,E
	OUT 7
	MVI A,8
	OUT 4
	MVI A,9
	OUT 4
	RET

CLS:	LXI B,0
?CLS:	LXI D,0FFF8H
	LXI H,3FF8H
	DI
	LXI SP,0E000H
CLS1:	PUSH B
	PUSH B
	PUSH B
	PUSH B
	DAD D
	JC CLS1
	LXI SP,0FEH
	EI
	RET

BEEP:	DI
	LXI D,0900H
BP1:	DCX D
	MOV A,E
	ANI 10H
	JZ BP2
	INR A
BP2:	OUT 0
	ORA D
	JNZ BP1
	RET

