;****************************************
;*                     *
;*					*
;*       " B O U L D E R   D U S H "    *
;*                  v 1.0     		*
;*     (   "-06")   *
;*					*
;*    ()       *
;*	         		*
;*		   1991.		*
;****************************************
;""   
; , , 2011
;  TASM - A Table Driven Cross Assembler for the MSDOS* Environment (tasm 3.2)
;
;------------------------------------------------
;    "-06".
; (     .
;------------------------------------------------
	.ORG 100H
;
STRINT:	DI
	MVI A,0C3H
	STA 0000H
	STA 0038H
	LXI H,STRINT	;   "/".
	SHLD 0001H
	LXI H,INIT	;  .
	SHLD 0039H
	XRA A		;.  .
	OUT 10H
	EI
	JMP START	;  .
;
;
SCROLL:	.db 0FFH		;   (0FFH -  )
KEYKOD:	.db 0FFH		;     .
KEYKD1:	.db 00H		;      0  7.
;
DOWNK:	.equ 7FH		;  " ".
UPK:	.equ 0DFH	;  " ".
LEFTK:	.equ 0EFH	;  " ".
RIGHTK:	.equ 0BFH	;  " ".
TAB:	.equ 0FEH	;  "".
LF:	.equ 0FDH	;  "".
DEL:	.equ 0F7H	;  "".
CR:	.equ 0FBH	;  "".
;
;    (  ).
;
BORDER:	.db 00H
COLOR:	.db 80H
COLR1:	.db 3FH
COLR2:	.db 87H
COLR3:	.db 17H
COLR4:	.db 38H
COLR5:	.db 80H
COLR6:	.db 80H
COLR7:	.db 80H
COLR8:	.db 0F8H
COLR9:	.db 80H
COLR10:	.db 80H
COLR11:	.db 80H
COLR12:	.db 80H
COLR13:	.db 80H
COLR14:	.db 80H
COLR15:	.db 80H

;
;    ( ,  ).
;
INIT:	PUSH H
	PUSH B
	PUSH D
	PUSH PSW
	MVI A,88H
	OUT 00H
	LXI H,COLR15
	LXI D,100FH
INIT1:	MOV A,E
	OUT 02
	MOV A,M
	OUT 0CH
	OUT 0CH
	OUT 0CH
	OUT 0CH
	OUT 0CH
	DCX H
	OUT 0CH
	DCR E
	OUT 0CH
	DCR D
	OUT 0CH
	JNZ INIT1
	MVI A,8AH
	OUT 00
	MVI A,0FEH
	OUT 03
	IN 02
	STA KEYKOD
	MVI A,0FBH
	OUT 03
	IN 02
	CMA
	STA KEYKD1
	MVI A,88H
	OUT 00
	LDA BORDER
	ANI 0FH
	OUT 02
	LDA SCROLL
	OUT 03
;
	LDA TON		;       .
	ORA A		;   ?
	JZ TSSOUN	;   -     ..
	DCR A		;    1, ..  .  .
	ADD A		;      4,  
	ADD A		;     4 .
	MOV E,A		;   "DE"    .
	MVI D,0
	LXI H,BAZTON	;   "HL"    .
	DAD D		;   "DE"   "HL"   .
	MVI A,0B6H	;   3    2,  -
	OUT 08		;      -  .  .
	MOV A,M		;    .  
	OUT 09		;    2 .
	INX H		;      .
	MOV A,M		;    .  
	OUT 09		;    2 .
	INX H
	MOV E,M		;    "DE"  .
	INX H
	MOV D,M
	XCHG		;    
	SHLD STSOUN	;   .
	XRA A		;      (.. -
	STA TON		;        ).
	JMP EXINIT	;   /   .
;
TSSOUN: LHLD STSOUN	;      ,
	MOV A,H		;     (  )?
	ORA L
	JZ OFSOUN	;   -  !
	DCX H		;  .
	SHLD STSOUN
	JMP EXINIT	;    / .
OFSOUN:	MVI A,0B6H	;   2     .
	OUT 08		;  .      .
EXINIT:	POP PSW
	POP D
	POP B
	POP H
	EI
	RET
;
STSOUN: .dw 0000H
;
;--------------------------------
;   ,
;    
;  "BOULDER".
;--------------------------------
;
VACUUM:	.equ 00	;  .
WALL:	.equ 01	; .
SOIL:	.equ 02	;   ().
STONE:	.equ 03	; .
CRYSTL:	.equ 04	; .
EXIT:	.equ 05	; .
EXPLOS:	.equ 06	; .
BUTTER:	.equ 07	; .
MEN:	.equ 08	; .
TRACE:	.equ 80H	;   (      .).
;
;     (, )   
; ,     "BAZATR".  -
;    ,   .    -
;   "ATRMEN"    .
;
;---------------------------------
;     .
;---------------------------------
;
STOP1:	.equ 00H	; ,  .
STOP2:	.equ 10H	; ,  .
RIGHT:	.equ 20H	;  .
LEFT:	.equ 30H	;  .
UP:	.equ 40H	;  .
DOWN:	.equ 50H	;  .
;
;          
;       ,   
;           ,  
;      .
;	    "INDMEN",   
;          
;   40*22.
;
; 
;**************************************
;  ,   
;   " "
;**************************************
;
START:	LXI SP,7FFFH	;   " ".
	CALL CLEAR	;  .
	HLT		;   (  ).
	XRA A		;   .
	STA NUMBL
	MVI A,6		;    6 .
	STA LIVMEN
NSTART:	LXI H,001DH	;     
	SHLD PLACE	;  (, , ).
	LXI H,TEXT1	;      
	CALL TEXOUT	;  .
	LXI H,0004H
	SHLD PLACE
	LXI H,TEXT2
	CALL TEXOUT
	LXI H,8000H	;      
	SHLD VOCPAN	;     
	XRA A		;
	STA PRGMEN	;    .
	STA PREXIT	;     .
	STA STSTOP	;     ."STOP..".
	STA TON		;  .
	LXI H,0		;    .
	SHLD STSOUN	;
	STA PANVER	;    .
	STA PANHOR	;    .
	MVI A,01H	;  ,   
	STA OPCRYS	;  .
	STA CHLEV	;    .	
	STA STPKEY	;  .
	CALL LDLEV	;  .
	MVI A,01	;      
	STA TIMEDL	;  (   .  .).
	LHLD INDVMS	;    
	CALL INDEX	;       40*22 
	SHLD MVIDEO	;    "OUTVMS"
	LHLD INDMEN	;   ,
	CALL INDEX	;      40*22 
	MVI M,EXIT	;     (,  ..)
	LDA ATRMEN	;    
	ANI 8FH		;   "".
	ORI STOP1
	STA ATRMEN
;
BEGIN:	CALL CALCUL	;  .
BEG1:	CALL WINDOW	;  .
	CALL OUTLIV	;   .
	CALL TSTPAN	;     .
	CALL PANORM	;   .
	LHLD VOCPAN	;     
	MOV A,H		;   .
	SUI 4
	MOV H,A
	SHLD VOCPAN	;      .
	MVI A,TONPAN	;    (. .)
	STA TON
	HLT		;  ,  .
	HLT
	HLT
	CALL TSTPAN	;     .
	LDA PANVER	;    
	MOV B,A
	LDA PANHOR
	ORA B		; :   ( ?)
	JNZ BEG1
	MVI B,12	;    .
BEG2:	PUSH B
	CALL WINDOW
	CALL OUTLIV
	HLT
	HLT
	HLT
	POP B
	DCR B
	JNZ BEG2
	LHLD INDMEN	;    .
	CALL INDEX	;    
	MVI M,EXPLOS	;      .
	MVI A,TIMEXP	;     .
	STA STEXPL
	MVI A,TONEXP	;  
	STA TON
	MVI A,MEN	;    .
	STA BUFEXP
	XRA A		;  .
	STA STPKEY
;
;
;****************************************
;    -  
;   .
;****************************************
;
;  
LOOP:	CALL WINDOW	;    ().
	HLT		;  .  . ,   .
	CALL KEYBOR	;      .
	CALL MOVMEN	;      .
	CALL MOVELM	;      .
	CALL TSTPAN	;   .
	CALL PANORM	;   (  ).
	CALL CALCUL	; ,    .
	CALL OUTLIV	;    -  .
	JMP LOOP	;     . .
;
;*****************************************
;    ()
;    .
;*****************************************
;
;      
; .     
;     . (    ).
;
WINDOW:	HLT		;  .   -.
	LHLD INDVMS	;    ()
	CALL INDEX	;    .
	SHLD MVIDEO	;    .
	CALL VMSOUT	;    .
	CALL MULTIC	;  ( . .)  .
	RET
;
;
;****************************************
;    
;          .
;***************************************
;
;     "BOULDER" -    
; 40  22      .
;         ,  -
;   .    
;  "LEVEL".  /     
;       -   40*22
;    "BAZA",     .
;     2-   40*22     12 
;  .       -
;      "PARLEV".  /   
;         
; .
;	     :
;
;  N 	 .
;  --------------------------------
;    0		     .
;    1		   >>  >>.
;    2		   ()  .
;    3		   >>  >>.
;    4		    . (  . .).
;    5		   >>  >>.
;    6		    ,   .
;    7		,       .
;    8		     (  "").
;    9           1,      "".
;   10		 2   >>  >>.
;   11		 3   >>  >>.
;
LDLEV:	LDA CHLEV	;    ()   :
	ORA A		;  ?
	RZ		;   - .
	PUSH H		;   -  .
	PUSH B
	PUSH D
	PUSH PSW
	MVI A,01	;    
	STA OPLEVE	;  .
	LDA NUMBL	;   .
	LXI H,LEVEL	;  "HL"    .
	lxi	b,440	;  "BC"    .
LDLEV1:	ORA A		;  ? (  ?).
	JZ LDLEV2	;   - .
	DAD B		;   -     ..
	DCR A		;    .
	JMP LDLEV1	;  -   ?
LDLEV2:	LXI D,BAZA	;  "DE" -   .
LDLEV3:	MOV A,M		;     .
	ani	0Fh
	stax	d
	inx	d
	mov	a,m
	rrc\ rrc\ rrc\ rrc
	ani	0Fh
	stax	d
	INX H
	INX D
	DCX B
	MOV A,B
	ORA C
	JNZ LDLEV3
	LDA NUMBL	;       .
	LXI H,PARLEV	;  "HL"     .
	LXI B,12	;  "BC"      .
LDLEV4:	ORA A		;     .
	JZ LDLEV5	;   .  -  .
	DAD B
	DCR A
	JMP LDLEV4
LDLEV5:	MOV E,M		;      
	INX H
	MOV D,M
	INX H
	XCHG
	SHLD INDMEN	;    "INDMEN".
	XCHG
	MOV E,M		;    ( ).
	INX H
	MOV D,M
	INX H
	XCHG
	SHLD INDVMS	;    "INDVMS".
	XCHG
	MOV E,M		;    ,  
	INX H		;   .
	MOV D,M
	INX H
	XCHG
	SHLD INDEXT	;    "INDEXT".
	XCHG
	MOV A,M		;   ,   
	INR A		;  ,      .
	STA STCRYS	;     .
	INX H
	MOV A,M		;    
	INR A		;  , (   )
	STA TIME	;     .
	INX H
	LDA TURBO	;      00H -  1 ,
	ORA A		;      -   .
	JZ COLTUR
	INX H
	MOV A,M		;      "".
	STA COLR1
	INX H
	MOV A,M
	STA COLR2
	INX H
	MOV A,M
	STA COLR3
	MVI A,2		;   "",  2 
	STA STPLOS	;     .
	STA BAZATR+2	;   2    .
	JMP EXLDLV	;   /  .
COLTUR:	MOV A,M		;      "".
	STA COLR1
	MVI A,1		;   "",   
	STA STPLOS	; .
	STA BAZATR+2	;   1    .
EXLDLV:	POP PSW
	POP D
	POP B
	POP H
	RET
;
CHLEV:	.db 00H		;   () .
NUMBL:	.db 00H		;  
INDEXT:	.dw 0000H	;   .
TURBO:	.db 00H		;  ""/"".
;
;******************************************************
;    ( )
;      .
;******************************************************
;
; /      
; "ATRMEN".       
;  ,    "STOP1"  "STOP2"
;   ,  "TIMSTP" (,
;  ,    ).   (
; )    "STPKEY".
;
KEYBOR:	LDA STPKEY	;  .
	ORA A
	RNZ		;    -  .
	LDA KEYKOD	;    .
	CPI 0FFH	;  ?
	JZ SETSTP	;   -    "STOP.."
	PUSH PSW	;    .
	MVI A,STOP1	;    "STOP1" 
	STA BFSTOP	;   "STOP.."
	MVI A,TIMSTP	;     
	STA STSTOP	;   .
	POP PSW		;    .
	CPI UPK		;  ""?
	JZ SETUP	;   "" (UP).
	CPI DOWNK	;  ""?
	JZ SETDOW	;
	CPI RIGHTK	;  ""?
	JZ SETRIG	;
	CPI LEFTK	;  ""?
	JZ SETLEF	;
	JMP SETSTP	;    .
SETUP:	MVI B,UP	;   . ""   "UP".
	JMP SETVEK	;      .
SETDOW:	MVI B,DOWN	;
	JMP SETVEK
SETRIG:	MVI B,RIGHT
	JMP SETVEK
SETLEF:	MVI B,LEFT
	JMP SETVEK
SETSTP:	LDA STSTOP	;      "STOP.."
	DCR A		;   
	STA STSTOP	;  .
	LDA BFSTOP	;      "STOP.."
	MOV B,A		;     "".
	JNZ SETVEK	;      -  .
	XRI 10H		;    .
	STA BFSTOP	;      
	MOV B,A		;   "".
	MVI A,TIMSTP	;     .
	STA STSTOP	;
SETVEK:	LDA ATRMEN	;    
	ANI 8FH		;    .
	ORA B		;    
	STA ATRMEN	;      .
	RET		;   /  .
;
TIMSTP:	.equ 20H		;    "STOP.."
STSTOP:	.db 00H		;     "STOP.."
BFSTOP:	.db 00H		;   "STOP.."
STPKEY:	.db 00H		;   .
;
;********************************************
;      
;********************************************
;
;     
;       , 
;    .  ,  
;       -
;   .    
;    , -
;        ,
;      
;   ,    ""
;  .
;
MOVMEN:	LHLD INDMEN	;     .
	LDA ATRMEN	;    
	ANI 70H		;  .
	CPI 20H		; :  "STOP1"  "STOP2"?
	JNC CONTIN	;   - .
	MVI A,TIMPUS	;  ,      
	STA STPUSH	; .,      ,
	RET		;        .
CONTIN:	MOV C,A		;     . "C".
	CALL TESTVM	;   .     .  "DE".
	CPI WALL	;  ?
	RZ		;   -   "MOVMEN".
	CPI VACUUM	;   ?
	JZ GOVACM	;   -   .
	CPI SOIL	;    ()?
	JZ GOSOIL	;   .
	CPI CRYSTL	;  ?
	JZ GOCRYS	; "" !
	CPI EXIT	;    ?
	JZ GOEXIT	;       .
	CPI STONE	;  ?
	JZ TSTONE	;   - :    "".
	CPI EXPLOS	;  ?
	JZ SETEX1	;   .
	CPI BUTTER	;  ?
	JZ SETEXP	;        .
	RET		;   "MOVMEN"    .
;
GOVACM:	MVI A,TONVAC	;     .  .
	STA TON		; (   "TON").
	JMP SETMEN	;    .  .
GOSOIL:	MVI A,TONSOL	;    .
	STA TON
	JMP SETMEN
GOCRYS:	MVI A,TONCRS	;    .
	STA TON
	MVI A,81H	;   (-1)  ..
	STA OPCRYS	; (      ..).
	JMP SETMEN
GOEXIT:	MVI A,01	;     .
	STA PREXIT	; (. "1"   "PREXIT").
	JMP SETMEN
SETEXP:	MVI M,EXPLOS	;      .
SETEX1:	LHLD INDMEN	;    ,
	CALL INDEX	;       
	MVI M,EXPLOS	;   .
	MVI A,CRYSTL	;        
	ORI 80H		;      .
	STA BUFEXP	; (     "BUFEXP).
	MVI A,TONEXP	;   .
	STA TON
	MVI A,TIMEXP	;    
	STA STEXPL	;   .
	MVI A,01	;     (  "1" 
	STA PRGMEN	;  "PRGMEN").
	RET
TSTONE:	MOV A,C		;      . "C".
	CPI UP		;   ""?
	RZ		;   -  ..    !
	PUSH H		;    .
	PUSH D
	XCHG		;     "HL".
	CALL TESTVM	;    " "  .
	CPI VACUUM	;   ?
	JNZ NOPUSH	;   -    .
	LDA STPUSH	;   -     
	ORA A		;   ?
	JZ MOVSTN	;   -  !
	DCR A		;   -  .  
	STA STPUSH	;    .
NOPUSH:	POP D		;      
	POP H
	RET		;   "MOVMEN"
MOVSTN:	MVI A,STONE	;    
	ORI 80H		;    (  "MOVELM").
	MOV M,A		;     , .."" .
	MVI A,TONMOV	;   .
	STA TON
	MVI A,TIMPUS	;      , 
	STA STPUSH	;    .
	POP D		;        
	POP H
	JMP SETMEN	;    .
;
; /     .
;
;  :  "" - , "HL" -  .
; :  "" - , "HL" -   .  , "DE" - .  .
;
TESTVM:	CPI DOWN	;  ?
	JZ MOVDOW	;   -    .
	CPI UP		;  ?
	JZ MOVUP
	CPI RIGHT	;  ?
	JZ MOVRIG
	CPI LEFT	;  ?
	JZ MOVLEF
	POP PSW		;    -   "SP" 
	RET		;    / "MOVMEN".
;
MOVDOW:	DCR L		;    
	JMP NEWVEK	;       ..
MOVUP:	INR L		;   
	JMP NEWVEK
MOVRIG:	INR H		;   
	JMP NEWVEK
MOVLEF:	DCR H		;   
NEWVEK:	MOV D,H		;     "DE".
	MOV E,L
	CALL INDEX	;   "HL"    .
	MOV A,M		;      "".
	ANI 0CFH	;      .
	RET		;    "TESTVM".
;
; /         .
;
; :  "HL" -   ,  "DE" -   .
; 	       "TRACE" -  -
;  ,    .      
;    ,     
;   .       
;      "VACUUM".
;
SETMEN:	MVI M,MEN	;      .
	LHLD INDMEN	;     
	CALL INDEX	;      .
	MVI M,TRACE	;     .
	XCHG		;     "HL" 
	SHLD INDMEN	;     "INDMEN".
	RET
;
INDMEN:	.dw 0000H	;     40*22.
;
OPCRYS:	.db 00H		;    .
STCRYS:	.db 40H		;  .
TIMEXP:	.equ 5		;  .
STEXPL:	.db 00H		;   .
TIMPUS:	.equ 03H		;   .
STPUSH:	.db 00H		;    .
BUFEXP:	.db 00H		;   ,    .
PREXIT:	.db 00H		;     .
PRGMEN:	.db 00H		;   .
TON:	.db 00H		;     .
;
;     .    
;    "BAZTON".      - 
;   ,   .
;
TONVAC:	.equ 01		;      . 1- .
TONSOL:	.equ 02		; N     .
TONCRS:	.equ 03		; N     .
TONMOV:	.equ 04		; N     .
TONEXP:	.equ 05		; N    .
TONTIM:	.equ 06		; N    ,   .
TONPAN:	.equ 07		; N     .
;
;
BAZTON:	.dw 0050		;     
	.dw 0001		;      
;
	.dw 0000		;   .
	.dw 0001		;    .
;
	.dw 0500		;   .
	.dw 0003		;    .
;
	.dw 1000		;   .
	.dw 0001		;    .
;
	.dw 1200		;  .
	.dw 0003		;   .
;
	.dw 3000		;   ,    .
	.dw 0004		;   .
;
VOCPAN:	.dw 0000		; ,   .
	.dw 0010		; .
;
;***************************************************
;       40*22.
;***************************************************
;
;  /     40*22.
;       
; /  , ..    
;     .. 880 !
;  ,     
; ,      ,
;      ( )
;     - .. 40.
;     ,     -
;       40*22, .. 
;    ,    
;   80  ( 10%   ).
;       ,
;       "",  
;        ,
;        .( "1" 
;     ).  
;  ,         
;        
; .
;
MOVELM:	LXI H,BAZA+40	;  "HL"     (0- .)
	LXI B,880-80	;  "BC"   (  ).
MOVEL1:	PUSH B		;    .
	PUSH H		;   .
	MOV A,M		;     .
	ANI 0CFH	;      .
	CPI STONE	;     ?
	JC NEXELM	;   -     .
	CPI EXIT	;  ?
	JZ NEXELM	;   -  .
	CPI TRACE	;      ?
	JNC NEXELM	;   - .
	CPI EXPLOS	;  ?
	JZ OPEXPL	;   -    .
	CPI BUTTER	;  ?
	JZ OPBUTT	;   -    .
	CPI MEN		;  ?
	JZ NEXELM	; .
	ORI 80H		;  ( ) .
	STA BUFKOD	;    .
	LXI B,0040	;   "BC"     .
	MOV A,L		;    ,.. "   "
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;  ,    ( ).
	ANI 0FH		;        .
	CPI BUTTER	;    . .   ?
	JZ EXPCRY	;   -   !
	MOV A,M		;   -    ,  ...
	ANI 0CFH	;    .
	CPI VACUUM	;   ?
	JNZ TSTPOZ	;  -    .
	LDA BUFKOD	;  -     
	MOV M,A		;      .
	MOV D,H		;      "DE".
	MOV E,L
	DAD B		;    , ..    .
TSBLOW:	MVI M,TRACE	;      .
	XCHG		;   "HL"       ,
	MOV A,L		;  :   "" .
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;   "" ,   "" .
	ANI 0FH		;        ..
	CPI BUTTER	;    .   ?
	JZ EXPCRY	;   -  !
	MOV A,M		;     .  .
	ANI 0CFH	;    .
	CPI VACUUM	;   ?
	JZ NEXELM	;   -     .
	CPI TRACE	;      ?
	JNC NEXELM	;   -  ..
	CPI MEN		;  ?
	JNZ TONBOM	;   -     .
	MVI A,01	;   -    .
	STA PRGMEN
	MVI M,EXPLOS	;    -  .
	MVI A,TIMEXP+8  ;  
	STA STEXPL
	MVI A,TONEXP	;   .
	STA TON
	MVI A,TRACE	;     .
	STA BUFEXP
	JMP NEXELM	;   .  40*22.
TONBOM:	MVI A,TONMOV	;      (   ,
	STA TON		;     ).
NEXELM:	POP H		;      
	POP B		;   .
	INX H		;       40*22
	DCX B		;  .
	MOV A,B		;   .
	ORA C
	JNZ MOVEL1	;    .  - .
	JMP ABTRAC	;        .
;
OPEXPL:	LDA STEXPL	;    ,
	ORA A		;    
	JNZ NOABEX	;      -   .
	LDA BUFEXP	;   -      
	MOV M,A		;    .
	JMP NEXELM	;    .
NOABEX:	DCR A		;    
	STA STEXPL	; 
	JMP NEXELM	;   .
;
;        .
;      ""    
; .          
;    - ..     ,
;         
;    .
;
TSTPOZ: CPI STONE	;  (  )   ?
	JZ NOSTAB	;   -     - !
	CPI CRYSTL	;   ?
	JZ NOSTAB	;  .
	CPI BUTTER	;  ?
	JNZ NEXELM	;   -    ( ..)
NOSTAB:	POP H		;        "SP".
	PUSH H
	MVI E,2		;    .
	LDA STSIDE	;     
	MOV D,A		;        "D".
LSTAB:	INR D		;   (    )
	MOV A,D		; 
	RRC		;      :
	JNC TSTLEF	;  "0" -     ,
	INX H		;  "1" - .
	JMP TSTVC1	;        .
TSTLEF:	DCX H		;      .
TSTVC1:	MOV A,M		;    ( )   
	CPI VACUUM	;   .
	JNZ OTSIDE	;    -   .
	MOV A,L		;       .
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;     .
	CPI VACUUM	;   ?
	JNZ OTSIDE	;   -   .
	LDA BUFKOD	;   -       
	MOV M,A		;  .
	MOV A,D		;    , 
	STA STSIDE	;      .
	XCHG		;      "DE".
	POP H		;   "HL"   
	PUSH H		;     .
	JMP TSBLOW	;       .
OTSIDE:	DCR E 		;   .
	JZ NEXELM	;     -  .
	POP H		;    
	PUSH H
	JMP LSTAB	;       ..
;
;    .       ,
;  .       :
;  ,   ,    
;   ,   . ,  
;  ,   .    
;   ,      .
;      ,     :
; 4-  5-  ,     . ( 
;     "MOVMEN"  "MOVELM",    "OUTSPR" 
;      ANI 0CFH ).
;
OPBUTT: LXI B,0040	;   "BC"    .
	MOV A,M		;    .
	ANI 30H		;   ,    .
	CPI 00H		;  ?
	JZ SUPDOW
	CPI 10H		;  ?
	JZ SUPLEF
	CPI 20H		;  ?
	JZ SUPUP
	CPI 30H		;  ?
	JZ SUPRIG
;
SUPDOW:	MOV A,L		;     .
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;    " "
	CPI MEN		;  ?
	JZ EXPCRY	;   -    .
	POP H		;   ,   "SP".
	PUSH H
	DCX H		;      .
	MOV A,M		;       :
	CPI VACUUM	; ?
	JZ SUPDW1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	JMP TSTSPL	;    -   .
SUPDW1:	MOV D,H		;      "DE".
	MOV E,L
	MOV A,L		;     ( ).
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;      .
	CPI VACUUM	; ?
	JZ SETSPR	;   -   .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	MVI A,00H	;   -    (  ).
	JMP MOVBUT	;      .
SETSPR:	MVI A,30H	;   .
	JMP MOVBUT	;  .
;
SUPLEF:	DCX H		;      .
	MOV A,M		;  .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
TSTSPL:	POP H		;   .
	PUSH H
	DAD B		;    .
	MOV A,M		;     .
	CPI VACUUM	; ?
	JZ SUPLF1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	JMP TSTSPU	;     ( ).
SUPLF1:	MOV D,H		;      "DE".
	MOV E,L
	DCX H		;   .
	MOV A,M		;     :
	CPI VACUUM	; ?
	JZ SETSPD	;   -   .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	MVI A,10H	;   -   .
	JMP MOVBUT	;  .
SETSPD:	MVI A,00	;   .
	JMP MOVBUT	;  .
;
SUPUP:	DAD B		;    .
	MOV A,M		;  .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
TSTSPU:	POP H		;   .
	PUSH H
	INX H		;     .
	MOV A,M		;  .
	CPI VACUUM	; ?
	JZ SUPUP1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	JMP TSTRIG	;     ( ).
SUPUP1:	MOV D,H		;      "DE".
	MOV E,L
	DAD B		;   .
	MOV A,M		;   .
	CPI VACUUM	; ?
	JZ SETSPL	;   -   
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	MVI A,20H	;   -   .
	JMP MOVBUT	;  .
SETSPL:	MVI A,10H	;   .
	JMP MOVBUT	;  .
;
SUPRIG:	INX H		;      .
	MOV A,M		;  .
	CPI MEN		;  ?
	JZ EXPCRY	;   - .
TSTRIG:	POP H		;   .
	PUSH H
	MOV A,L		;     (" ").
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;  .
	CPI VACUUM	; ?
	JZ SUPRG1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	POP H		;   -     (
	PUSH H		;  
	MOV D,H		;  .
	MOV E,L
	MVI A,00H	;    
	JMP MOVBUT	;   ,     .
SUPRG1:	MOV D,H		;      "DE".
	MOV E,L
	INX H		;      .
	MOV A,M		;   .
	CPI VACUUM	; ?
	JZ SETSPU	;   -   .
	CPI MEN		; ?
	JZ EXPCRY	;   -.
	MVI A,30H	;   -   .
	JMP MOVBUT	;  .
SETSPU:	MVI A,20H	;   .
	JMP MOVBUT	;  .
;
MOVBUT:	POP H		;      
	PUSH H
	MVI M,TRACE	;      .
	XCHG		;   "HL"      "DE".
	ORI BUTTER	;   "A"  ,   .
	ORI 80H		;   .
	MOV M,A		;      .
	JMP NEXELM	;       40*22.
;
EXPCRY:	MVI A,CRYSTL	;    
	ORI 80H		;   .
	STA BUFEXP
	JMP EXPEXP
;
EXPTRC:	MVI A,TRACE	;    "".
	STA BUFEXP
	JMP EXPEXP
;
EXPEXP:	MOV A,L		;      ( )
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	DCX H		;     (    9- .)
	MVI D,3		;   .
EXPEX1:	MVI E,3		;   .
EXPEX3:	MOV A,M		;  9 ,  .
	CPI WALL
	CNZ EXP
	DCR E
	JZ EXPEX2
	INX H
	JMP EXPEX3
EXPEX2:	DCX H
	DCX H
	DAD B
	DCR D
	JNZ EXPEX1
	MVI A,TONEXP	;   
	STA TON
	MVI A,TIMEXP+15	;   .
	STA STEXPL
	JMP NEXELM	;      40*22.
;
EXP:	CPI MEN		;     ?
	JNZ EXP1	;   -    .
	MVI A,01
	STA PRGMEN
EXP1:	MVI M,EXPLOS
	RET
;
BUFKOD:	.db 00H		;    
STSIDE:	.db 00H		;    .
;
;
;   . ( /    ,
;            
; .
;
ABTRAC:	LXI H,BAZA	;   "HL"    40*22.
	LXI B,880	;   "BC"   .
ABTR1:	MOV A,M		;     
	ANI 7FH		;  .(    ..)
	MOV M,A		;    .
	INX H		;      
	DCX B		;   .
	MOV A,B		; :    ?
	ORA C
	JNZ ABTR1	;   -  .
	RET
;
;
;*****************************************
; ,    .
;*****************************************
;
CALCUL:	LDA TIMLDR	; -  .
	ORA A		;   0.
	JNZ CALC6	;   - .   .
	LDA PREXIT	;     ..
	ORA A
	JNZ NEXLEV	;   -   . .
	LDA OPCRYS	;     .
	ORA A		;   ?
	JZ CALC1	;   -   .
	XRA A		;  .
	STA OPCRYS
	LDA STCRYS	;     
	DCR A		; .
	JM CALC1	;    -    .
	JZ OPENEX	;  (..    ) - ..
CALC7:	STA STCRYS
	LXI H,131CH	;      .
	SHLD PLACE
	LXI D, 0102H	;    .
	CALL OUTST	;   .
CALC1:	LDA OPLEVE	;   (    ) 
	ORA A		;  .
	JZ CALC2	;  ,   .
	XRA A		;    .
	STA OPLEVE
	LDA NUMBL	;   
	LXI H,091CH	;   .
	SHLD PLACE
	LXI D, 0102H	;    .
	CALL OUTST	;   .
CALC2:	LDA TIMEDL	;     
	DCR A		;   .
	STA TIMEDL
	JNZ CALC3	;    -   .
	LDA CONTDL	;     
	STA TIMEDL	;    .
	LDA TIME	;      () 
	ORA A		;   .
	JZ KILMEN	;    -   .
	DCR A		;   .
	STA TIME
	LXI H,1C1CH	;   .
	SHLD PLACE
	LXI D,0103H	;    .
	CALL OUTST	;   .
CALC3:	LDA TIME
	CPI 20		;     
	JNC CALC9	;     -    
	LDA FAZTIM	;       
	RRC		; .
	STA FAZTIM
	CC FLASHT	;   -   "".
CALC9:	LDA PRGMEN	;    .
	ORA A		;  ?
	JZ CALC4	;   -  . .
	XRA A		;   .
	STA PRGMEN
	LDA LIVMEN	;    .
	ORA A		;   ?
	JZ GMOVE1	; E  -   (  ).
	DCR A		;   .
	STA LIVMEN
GMOVE1:	MVI A,01	;  .
	STA STPKEY
	LDA ATRMEN	;   "STOP1".
	ANI 8FH
	ORI STOP1
	STA ATRMEN
	MVI A,28H	;     
	STA TIMLDR	; .
	MVI A,TIMEXP+10	;      
	STA TIMLIV	; (     ).
	LXI H,0C1CH	;      
	SHLD PLACE	; " ".
	LXI H,TEXT6
	CALL TEXOUT	;  .
	RET		; .
CALC6:	LDA TIMLDR	;    
	DCR A		; 
	STA TIMLDR
	RNZ		;     - 
	LDA LIVMEN	;   ?
	ORA A
	JZ GMOVE2	;   -  .
	MVI A,STONE	;   ,   
NEXLV3:	STA FULKOD
	LDA ATRMEN	;      "".
	ANI 8FH
	ORI RIGHT
	STA ATRMEN
	CALL SCFULL	;   .
	POP PSW		;    
	JMP NSTART	;  .
CALC4:	RET
OPENEX:	LHLD INDEXT	;   ,
	CALL INDEX	;     .
	MVI M,EXIT	;      .
	LXI H,0C1CH	;      ":".
	SHLD PLACE
	LXI H,TEXT4	;   ":00" 
	CALL TEXOUT
	LXI H,0C1CH	;   ": 00"  " "
	SHLD PLACE	; ,   .
	LXI H,TEXT5
	CALL TEXOUT
	JMP CALC1	;   .
KILMEN:	MVI A,01H	;    .
	STA PRGMEN
	LHLD INDMEN	;    
	CALL INDEX
	MVI M,EXPLOS	;     .
	MVI A,TRACE	;     .
	STA BUFEXP
	MVI A,TONEXP	;  .
	STA TON
	MVI A,TIMEXP+8  ;  .
	STA STEXPL
	JMP CALC3	;   .
GMOVE2:	POP PSW		;   .
	DI
	HLT
;
NEXLEV:	LDA PREXIT	; :    2- ?
	CPI 02
	JZ NEXLV1	;   -    
	MVI A,02
	STA PREXIT
	MVI A,10	;      . .
	STA TIMLDN
	MVI A,1		;  .
	STA STPKEY
	LHLD INDMEN	;      .
	CALL INDEX
	MVI M,EXIT
	LDA NUMBL	;   .
	INR A
	STA NUMBL
	LDA LIVMEN	;   1     .
	INR A
	STA LIVMEN
	LXI H,0C1CH	;   "  "
	SHLD PLACE
	LXI H,TEXT7
	CALL TEXOUT
	LXI H,4000H	;    .
	SHLD VOCPAN
	RET
NEXLV1:	LDA TIMLDN	;  ?
	DCR A
	STA TIMLDN
	JNZ NEXLV2	;   - .
	LXI H,0C1CH	;   -   "  "
	SHLD PLACE
	LXI H,TEXT6
	CALL TEXOUT
	MVI A,MEN	;      .
	JMP NEXLV3
NEXLV2:	LHLD VOCPAN	;   .
	MOV A,H
	SUI 4
	MOV H,A
	SHLD VOCPAN
	MVI A,TONPAN
	STA TON
	RET
;
SCFULL:	LXI H,BAZA	;    40*22.
	LXI B,880	;   .
SCFUL1:	LDA FULKOD	;     "FULKOD"
	MOV M,A
	INX H
	DCX B
	MOV A,B
	ORA C
	JNZ SCFUL1
	MVI B,20H	;      .
SCFUL2:	CALL WINDOW	;  
	DCR B		;  ?
	JNZ SCFUL2
	RET
;
FLASHT:	LDA FZFLAS	;    (/).
	INR A
	STA FZFLAS
	ANI 01H		;   - ,   - .
	JNZ INFLAS
	MVI A,11H	;     .
	JMP FLUSH1	;  .
INFLAS:	MVI A,TONTIM	;      .
	STA TON
	MVI A,10H	;   .
FLUSH1:	CALL SYMOUT	;   .
	LXI H,151CH	;     ":"
	SHLD PLACE
	LXI H,TEXT3	;  .
	CALL TEXOUT
	RET	
;
OPLEVE:	.db 00H		;    .
TIME:	.db 140		;    .
TIMEDL:	.db 00H		;    .
CONTDL:	.db 08H		;    .
TIMLDR:	.db 00H		;    .
FULKOD:	.db 00H		;      .
FAZTIM:	.db 11H		;     ":"
FZFLAS:	.db 00H		;  .
TIMLDN:	.db 00H		;     .
;
;******************************************
;    () 
; -     .
;******************************************
;
;     
;    -  1  3.
;
;  : "" -    .
;		     "" -   .
;		     "D" -   (1,2,4,8 -  "SYMOUT")
;
OUTST:	LXI H,0		;   .
	MVI B,8		;  .
	MOV C,A		;    "C".
OUTST1:	MOV A,C
	RLC		;    .
	MOV C,A
	MOV A,L		; -     .
	ADC L
	DAA
	MOV L,A
	MOV A,H
	ADC H
	DAA
	MOV H,A
	DCR B		;   .
	JNZ OUTST1	;   -  "HL" 3-  .-. .
	MOV A,D		;    
	CALL SYMOUT	;  .
	MOV A,E		;    .
	CPI 1
	JZ ONEST
	CPI 2
	JZ TWOST
	MOV A,H		;      3 .
	ANI 0FH		;    .
	ADI 30H		;     ASCII.
	CALL SYMOUT	;   /  .
TWOST:	MOV A,L
	RRC		;   .
	RRC
	RRC
	RRC
	ANI 0FH
	ADI 30H
	CALL SYMOUT
ONEST:	MOV A,L
	ANI 0FH		;   ( )  .
	ADI 30H
	CALL SYMOUT
	RET
;
;
;******************************************
;    
;******************************************
;
;    -
;    .
;    
;  , ..  -
;    .
;
OUTLIV:	LDA LIVMEN	;  -  
	MOV C,A		;   .
	MVI B,5		;    (  ).
	LXI H,0FD10H	;     .
OTLIV1:	SHLD ADRSPR
	DCR C		;  ?
	JM OTLIV2	;    -   .
	JNZ OTLIV4	;         - .
	LDA TIMLIV	;     ( ) - :
	ORA A		;     ?
	JZ OTLIV2	;   -   .
	DCR A		;   -    
	STA TIMLIV
	MVI A,EXPLOS	;       .
	JMP OTLIV3
OTLIV4:	MVI A,MEN
	JMP OTLIV3
OTLIV2:	MVI A,VACUUM
OTLIV3:	PUSH H
	PUSH B
	CALL OUTSPR	;     .
	POP B
	POP H
	DCR H		;     .
	DCR H
	DCR B		;     ?
	JNZ OTLIV1	;   - .
	RET
;
LIVMEN:	.db 06H		;   .
TIMLIV:	.db 00H		;    .
;
;
;*************************************************
;    
;      (
; ),   .
;************************************************
;
; /      
;    
;     .
;
TSTPAN:	PUSH H		;   .
	PUSH D
	PUSH PSW
	LHLD INDVMS	;    
	XCHG		;   "DE".
	LHLD INDMEN	;   .
	MOV A,E		;   "" .  (  ) 
	CMP L		;     .
	JP PANDOW	;   -   .
	ADI HEIGHT-2	;   ""    
	CMP L		;     .
	JM PANUP	;   -   .
TSTPHR:	MOV A,D		;   "" .  (  ) 
	CMP H		;   . .
	JP PANLEF	;   -   .
	ADI LENGTH-2	;   ""    
	CMP H		;   . .
	JP EXPANT
	MVI A,01	;   .
	STA PANHOR
EXPANT:	POP PSW		;       /.
	POP D
	POP H
	RET
;
PANDOW:	MVI A,02	;     .
	STA PANVER
	JMP TSTPHR	;        .
PANUP:	MVI A,01	;    . .
	STA PANVER
	JMP TSTPHR
PANLEF:	MVI A,02	;    . .
	STA PANHOR
	JMP EXPANT	;        /.
;
INDVMS:	.dw 0000H	;    (   ).
;
;*******************************************
;   ()
;      
;  .
;*******************************************
;
;      "BOULDER",
;  16*10    40*22  .
;	..   ""    
; ,        
;  .    ""   
;     (.     
;     ),    
;        .
;	,     
; ""    ( ), 
;         
;   (    ),
;         -
;     .
;	 /    
;   "VMSOUT"     .
;	   
; : "PANVER" - , "PANHOR" - .
;         :
;
; "00" -     .
; "01" -      (  ).
; "02" -     .
;
;   :    8  () .
;		           6  ()    .
; 
PANORM:	PUSH H		;   .
	PUSH PSW
	LHLD INDVMS	;     .
	LDA PANVER	;    .
	ORA A		;   ?
	JZ TSTHOR	;   -  .
	CPI 01		;    ? ( ?).
	JNZ VERDCR	;   -  ( ).
	INR L		;   .
	JMP TSTHOR	;     .
VERDCR:	DCR L		;   .
TSTHOR:	MVI A,01	;      
	STA TIPVMS	; / "VMSOUT".
	LDA PANHOR	;    .
	ORA A		;   ?
	JZ OFTIP	;   -      . . 
	CPI 01		;  ?
	JNZ HORDCR	;   -  .
	INR H		;   .
	JMP TSTZON	;      .
HORDCR:	DCR H		;   .
	JMP TSTZON	;    .
OFTIP:	STA TIPVMS	;      / "VMSOUT".
TSTZON:	MOV A,L		;        
	CPI 0		;  . (0, 6, 12).
	JZ RESVER	;    -   ..
	CPI 6
	JZ RESVER
	CPI 12
	JZ RESVER
ZONHOR:	MOV A,H		;        -
	CPI 0		;  . (0, 8, 16, 24).
	JZ RESHOR	;    -   ..
	CPI 8
	JZ RESHOR
	CPI 16
	JZ RESHOR
	CPI 24
	JZ RESHOR
SAVEIM:	SHLD INDVMS	;    .
	POP PSW		;   .
	POP H
	RET		;   / .
;
RESVER:	XRA A		;    .
	STA PANVER
	JMP ZONHOR	;       .
RESHOR:	XRA A		;    .
	STA PANHOR
	JMP SAVEIM	;     .
;
PANVER:	.db 00H		;   .
PANHOR:	.db 00H		;   .
;
;*****************************************
;   2- 
;   ( ).
;   - 40*22 .
;*****************************************
;
;    
;    40*22    
;   .
;
;  :  L -  ,
;		      H -  ,
;
;  : HL -  .
;
;    :
;
;	"BAZA" -   .
;
INDEX:	PUSH D		;   .
	PUSH H		;  .
	MVI H,0		;   "HL"  ..
	DAD H		; T    8 
	DAD H		;  "HL".
	DAD H
	MOV D,H		;    "DE" 
	MOV E,L
	DAD D		;    5  "HL"  "DE".
	DAD D
	DAD D
	DAD D
	XCHG		;  .  40    "DE".
	POP H		;   
	MOV L,H		;   "HL" 
	MVI H,0		;  .
	DAD D		;   "HL"      .
	LXI D,BAZA	;   "DE"   .
	DAD D		;         "HL"
	POP D		;   "DE" 
	RET		;   / "INDEX".
;
;
;*************************************************************
;       
;      (),     .
;*************************************************************
;
;  :   "MVIDEO"  
;     
; .    
;        -
;     .  
;     
;    "OUTSPR".
;	   
;   ,   
;      
; :   
;    ,   -
;  -  .
; 	   :
;
;	"MVIDEO" -   ()   .
;	"SCREEN" -       .
;	"TIPVMS" -    .
;	"LINEMS" -      .
;	"LENGTH" -      ( ).
;	"HEIGHT" -      ( ).
;
VMSOUT:	PUSH H
	PUSH B
	PUSH D
	PUSH PSW
	LHLD MVIDEO	;    . 
	XCHG		;       DE.
	LXI H,SCREEN	;      .
	LDA TIPVMS	;      :
	ORA A		; "0"-  , "1"- .
	JNZ STRVMS	;        "0".
	MVI B,HEIGHT	;     .
VMS2:	MVI C,LENGTH	;     .
VMS1:	SHLD ADRSPR	; .    ( OUTSPR).
	LDAX D		;      .
	PUSH H
	PUSH B
	PUSH D
	CALL OUTSPR	;    .
	POP D
	POP B
	POP H
	INX D		;      
	INR H		;    
	INR H		;   .
	DCR C		;    ?
	JNZ VMS1	;   -   .
	MOV A,E		;     
	ADI LINEMS-LENGTH ;   ,   
	MOV E,A		;     40*22,    .
	JNC STRSPR	;    -  . .
	INR D		;  .   .
STRSPR:	MOV A,H		;      
	SUI LENGTH*2	;   .
	MOV H,A		; 
	MOV A,L		;     .
	ADI 16		;   = 16   .
	MOV L,A
	DCR B		;   ?
	JNZ VMS2	;   -  ..    .
	JMP EXSVMS	;   - .
STRVMS:	MVI B,LENGTH	;    
STVMS2:	MVI C,HEIGHT	;    .
STVMS1: SHLD ADRSPR	;       .
	LDAX D		;   ""    .
	PUSH B		;      .
	PUSH H
	PUSH D
	CALL OUTSPR	;    .
	POP D		;     .
	LXI H,LINEMS	;      .(.. .).
	DAD D
	XCHG		;  DE -     .
	POP H		;     .
	MOV A,L		;     
	ADI 16		;   .
	MOV L,A
	POP B		;    :
	DCR C		;   ( . ) ?
	JNZ STVMS1	;   -   .
	PUSH B		;  .
	LXI B,LINEMS*HEIGHT ;     . . 
	MOV A,E		;  . .   ( . )
	SUB C
	MOV E,A
	MOV A,D
	SBB B
	MOV D,A
	INX D		;      .
	LXI B,HEIGHT*16	;        ,
	MOV A,L		;         
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	INR H
	INR H		;       .
	POP B		;   
	DCR B		; :   ?
	JNZ STVMS2	;   -    .
EXSVMS:	POP PSW		;   /    
	POP D
	POP B
	POP H
	RET
;
MVIDEO:	.dw 0000H	;     .
SCREEN:	.equ 0E030H	;      .
TIPVMS:	.db 00H		;   .
;
LINEMS:	.equ 0040	;      .
LENGTH:	.equ 0016	;  .
HEIGHT:	.equ 0010	;  .
;
;************************************************
;      "-06"
;   16  16 ,  
;     ,  
;   3-    -
;     
;   . 
; ()  ..    28.08.91.
;***********************************************
;
;          ,
; ..    255 .   
;       
;  .    
;  .   :  
;    ,    
;     "" ( 1  
;   E000-FFFF,  8    8000-9FFF).
;          
;   .   
;      
;  -       -
;    "STPLOS"   
;      .
;	   ( )  
;    (     
;     ).    -
;    ,  
;      
;  (),       (
;       ).
;         
;      3   . 
;       24 -
; ,       -
;  ,        
;       
;   .
; 	,     -  
; ,     .   
;  "0",       
;  .    , 
;         
; , ,   () 
; .
;	- ,    , 
;     , 
;       
;  (  ).
; 	      .
;         , 
;        
;     (   4 ,
;     1-  4-,  2-  3-  ).
; 	     -
;    (,  
;     (  ..) 
;   ).      
;  3-   (=0), ..  
;     .    -
;   -       "MULT",
; T.K. ,      ""  
;         1.
; :      8-, 
;  6   6, . 7 - . 7,  
; 8  8-, 9-, 10-,  9 - 11,12,13 .
;	       
;   "", ..    -
;  , .    
;    .    
;        .
;	      
;  :      -
;   ,     .  
; .
;	    ,  
;  , ..     
;   ( ):   16  16,   
;  "-06",   ,  
;   16  .     
; .        
;        - ,
;      8000-9FFF   
;  , ..       
;  (      
; ).  ,     
;  ,      8000H. ,
;     ,   
;  .  ,    
;         (
; ) ,        
;      .  , 
;      32 .
;
;    :
;
;	 "" -  ,   "ADRSPR" -  
;     (    ).
;        .
;
;    :
;
; "BAZATR" -     .
; "STPLOS" -   .
; "BAZGRF" -   .
; "MULT"   -   ,    .
; "BUFSP"  -       .
; "CHMUL"  -  .
; "STMUL"  -     .
; "FAZMUL" -    . 
; 
;
;      -  ""   ?
;       ""  
; ,    ,     
;  .
;
OUTSPR:	LXI D,BAZGRF	;   .    .
	ANI 0CFH	;      .
	ORA A		; :    "0"?
	JZ ZERSPR	;     .
;
;     "",      .
;
	MOV C,A		;    ""   
	MVI B,0		; ""       .
	LXI H,BAZATR	;   "HL"   . .
	DAD B		;    .   ..  "HL".
	MOV B,M		;     ""  
	MOV A,B		;  "".
	CPI 80H		; :   ?
	JC ADRGRF	;   -      .
;
;        
;   :    ,    
; .     , 
;   3 ( ),      
;         3- -
;   .        
;    ,      
;  .  ,     
;  ,  :    
;  .       
; "-" ..   : 0-, 1-, 2-, 1-, 0-,
;        3- .
;      "FAZMUL"   -
;    .    
; ..          ,
;   ,       
; .
;
	RRC		;    4 , 
	RRC		;      
	RRC		;  .
	RRC
	ANI 07H		;   .
	MOV E,A		;     
	ADD A		;   
	ADD E		;   
	MOV E,A		;   "".
	MOV A,C		;   ""   
	SUI MULT	;      .
	MOV C,A		;    
	ADD A
	ADD C
	ADI MULT	;     .  .
	ADD E		;      -
	MOV C,A		;    .  "" ( 1-   3).
	LDA FAZMUL	;       
	ANI 03H		;       .
	ADD C		;   ""      
	MOV C,A		;   .    "".
;
;        .
;
ADRGRF:	MOV L,C		;  "HL"     
	MVI H,0		; 32 (    ),  
	DAD H		;     .
	DAD H
	DAD H
	DAD H
	DAD H		;   32.
	LXI D,BAZGRF	;  "DE"    .  
	DAD D		;    "HL".
	XCHG		;      .  "DE".
ZERSPR:	LDA STPLOS	;    .
;
;        "-06"  .
;
	PUSH PSW	;    .
PLOSK:	PUSH D		;      .
	LXI H,0		;     "SP"   "HL".
	DAD SP		;   "SP"    "HL" 
	SHLD BUFSP	;    .
	XCHG		;   "HL"     
	DI
	SPHL		;     .
	LHLD ADRSPR	;   "HL"      .
	MVI C,2		;     .
	MOV A,B		;   "A"   
	RRC		;       .
	MOV B,A		;  ""    .
	JC SAVSPR	;    "1",   .
	LXI SP,BAZGRF	;  "0",   " "   .
;
;       ,   
;       " ".
;
SAVSPR:	POP D		;      .
	MOV M,E		;   ,
	INR L		;     ,
	MOV M,D		;   ,
	INR L		;     .
;
;      7 ,   16   .
;
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
;
	DCR C		;    ?
	JZ NEXPLS	;   -     .
	MOV A,L		;     
	SUI 16		;     ( )  .
	MOV L,A
	INR H		;       .
	JMP SAVSPR	;     .
;
;    .
;
NEXPLS:	LHLD BUFSP	;    "SP"  .
	SPHL
	EI
	POP D		;   "DE"     .
	POP PSW		;   "A"   .
	DCR A		;    ?
;--------------------------------------------------------------------
	RZ		;      "OUTSPR".
;--------------------------------------------------------------------
	PUSH PSW	;     .
	LHLD ADRSPR	;      "HL".
	MOV A,H		;   
	SUI 20H		;    .
	MOV H,A
	SHLD ADRSPR	;      .
	JMP PLOSK	;     .
;
;    .
;
;       "OUTSPR",  
;      . ,
;    ,     
; ,        .
;          
; "CHMUL" -       /   
;       .
;    /        
;         ,  
;    .        
;    "OUTSPR",    
;     N -     , -
;   "CHMUL"
;
MULTIC:	LDA STMUL	;     .
	DCR A		;   
	STA STMUL	;  .
	RNZ		;   "MULTIC"    .
	LDA CHMUL	;     
	STA STMUL	;    .
	LDA FAZMUL	;     
	RRC		;      .. 
	RRC		;     .
	STA FAZMUL	;     .
	RET		;   / "MULTIC"
;
;-----------------------------------------------------------------
;  ,   ,   "OUTSPR" 
;			"MULTIC".
;-----------------------------------------------------------------
;
MULT:	.equ 04H		;  ,    .
;
ADRSPR:	.dw 0000H	;      .
STPLOS:	.db 01H		;   .
CHMUL:	.db 01H		;  .
FAZMUL:	.db 64H		;   .
STMUL:	.db 01H		;    .
BUFSP:	.dw 0000H	;      "SP".
;
BAZATR:	.db 00H		;    . (0-  .)
	.db 03H		;   ( 3).
	.db 02H		;    ( 2).
	.db 01H		;   ( 1).
	.db 81H		;   ( 1,  ).
	.db 83H		;    .( 3, ..).
	.db 81H		;   (1, ..).
	.db 81H		;   (1, ..).
ATRMEN:	.db 81H		;   (1, .. - 6 ).
;
;
;*******************************
;   
;*******************************
;
;  : "HL" -   ,  
;   00H.  0EH  7-    8-
; ,  0FH   ,    8-
;  .
;
TEXOUT:	MOV A,M		;   
	ORA A		;   .
	RZ		;  ,  .
	CPI 0EH		;   ?
	JZ SET8		;   - .
	CPI 0FH		;  ?
	JZ RESET8	;   -  .
	PUSH B
	MOV C,A		;    "C".
	LDA REGSYM	;    .
	ORA C		;    .
	POP B	
	CALL SYMOUT	;  .
TXOUT1:	INX H		;   .
	JMP TEXOUT	;  .
;
SET8:	MVI A,80H	;  "1"  7-   .
	STA REGSYM
	JMP TXOUT1
;
RESET8:	XRA A		;   .
	STA REGSYM
	JMP TXOUT1
;
REGSYM:	.db 00H		;   .
;	
;
;************************
;    
;************************
;
;     8*8.
;   (      ),
;       4- .
;
;  :	"" -  ,  "COLSYM" -  ,
; (    . - 80H, A0H, C0H, E0H).
;  "PLACE" -     ,   
;  .       .
;   - 31 (1FH).
; 	       , 
;       . 
;   - "CR"   "LF",    01, 02, 04, 08  
;   .    , -
;    ,   
;    ,    
; (     "INIT").
; 	 10H -   ,   11H - .
;
;
SYMOUT:	PUSH H
	PUSH D
	CPI 20H		;   ?
	JC TSWORK	;   -    .
	sui	20h
	MOV L,A		;     8   "HL".
	MVI H,0
	DAD H
	DAD H
	DAD H
	LXI D,ZGSYM	;     "DE"
	DAD D		;       
	XCHG		;     "DE".
	LHLD PLACE	;   "HL"  .
	MOV A,L		;      
	ADD A		; (     ).
	ADD A
	ADD A
	MOV L,A
	LDA COLSYM	;    (  . )
	ADD H		;      .
	MOV H,A		;  "HL"     .
	LDAX D		;  8-    " ". 
INVERT:	NOP		;      .
	MOV M,A		; 
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	LHLD PLACE
	MOV A,H		;    
	CPI 1FH		; :   ?
	JNC LINEFR	;   -   .
	INR H		;   -      .
	JMP WRPLAC	;    .
TSWORK:	CPI 9		;      ?
	JNC TSWRK1	;   -   "CR"  "LF".
	POP D		;      
	POP H		;    (    RET ).
	CPI 1		;   1?
	JZ SCOLS1
	CPI 2		;  2?
	JZ SCOLS2
	CPI 4		;  4?
	JZ SCOLS4
	CPI 8		;  8?
	JZ SCOLS8
	RET		;   /  ,   ..
SCOLS1:	MVI A,0E0H	;     , 
	STA COLSYM	;  1-  .
	RET
SCOLS2:	MVI A,0C0H	;   2- . .
	STA COLSYM
	RET
SCOLS4:	MVI A,0A0H	;   4- . .
	STA COLSYM
	RET
SCOLS8:	MVI A,80H	;   8- . .
	STA COLSYM
	RET
TSWRK1:	LHLD PLACE	;  .
	CPI 0DH		;   ?
	JNZ TSWNEX	;   -    ..
	MVI H,0		;   -     .
	JMP WRPLAC	;    .
TSWNEX:	CPI 0AH		;   ?
	JNZ TSWRK2	;   -  / .
LINEFR:	MVI H,0		;     .
	MOV A,L		;     :
	ORA A		;    (   ?).
	JZ WRPLAC	;   -      .
	DCR L		;   -   .
WRPLAC:	SHLD PLACE	;    .
EXTSYM:	POP D		;   /  .
	POP H
	RET
TSWRK2:	CPI 10H		;    ?
	JZ ONINV	;   - .
	CPI 11H		;   ?
	JZ OFINV
	JMP EXTSYM	;   /     .
ONINV:	MVI A,2FH	;   "CMA"     
	JMP SETINV
OFINV:	XRA A		;   "NOP"     .
SETINV:	PUSH B
	LXI H,INVERT	;  "HL"   - . .
	LXI D,5		;    
	MVI B,8		;   - .
SINVR1:	MOV M,A		;  -.
	DAD D		;  .
	DCR B
	JNZ SINVR1
	POP B
	JMP EXTSYM
;
COLSYM:	.db 00H		;   .
;
PLACE:	.dw 0000H	;  .
;
;
;***************************************
;    4- 
;   "-06".
;***************************************
;
CLEAR:	PUSH H		;   .
	PUSH B
	PUSH D
	PUSH PSW
	LXI H,0000H	;  HL    SP.
	DAD SP		;   SP    HL.
	LXI SP,0000H	;     0FFFFH.
	LXI D,0000H	;  DE - ,    .
	LXI B,0800H	;  BC - .
CLEAR1:	PUSH D		;     "" .
	PUSH D		;  8  " "  .
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	DCX B		;    
	MOV A,B		;  .
	ORA C		;  ?
	JNZ CLEAR1	;   -  .
	SPHL		;    SP 
	POP PSW		;  .
	POP D
	POP B
	POP H
	RET
;
;
;     :
;
TEXT1:	.db 08H		;    .
	.db 99H,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,8BH
	.db 8AH
	.db 04H		;  .
;	.db ':   :   :   '
	.db "urowenx:   almazy:   wremq:   "
	.db 08H,8AH
	.db 98H,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,8CH
	.db 00H		;  .
;
TEXT2:	.db 08H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 99H,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,8BH
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 8AH,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,8AH
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 8AH,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,8AH
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 98H,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,8CH
	.db 00H
;
TEXT3:	.db 04H
	.db " wremq:",11H	;    ":"
	.db 00H
;
TEXT4:	.db 04H
	.db "       ",01H,"  ",00H	;    ":  "
;
TEXT5:	.db 08H
	.db "i}i wyhod",00H	;   ":00"
;
TEXT6:	.db 08H
	.db "         ",00H	;    " "
;
TEXT7:	.db 08H
	.db " na{el ! ",00H	; ,   .
;
;	

	.org	0E00h
#include "BOLDERbin.asm"
BAZA:			;     880  (40*22).

	.end
