;****************************************
;*                     *
;*					*
;*         "            "	v 1.5	*
;*                       		*
;*     (   "-06")   *
;*					*
;*    ()       *
;*	         		*
;*		   1991.		*
;****************************************
;""   
; , , 2011
;  TASM - A Table Driven Cross Assembler for the MSDOS* Environment (tasm 3.2)
;
;------------------------------------------------
;    "-06".
; (     .
;------------------------------------------------
	.ORG 100H
;
STRINT:	DI
	MVI A,0C3H
	STA 0000H
	STA 0038H
	LXI H,STRINT	;   "/".
	SHLD 0001H
	LXI H,INIT	;  .
	SHLD 0039H
	XRA A		;.  .
	OUT 10H
	JMP START	;  .
;
;
SCROLL:	.db 0FFH		;   (0FFH -  )
KEYKOD:	.db 0FFH		;     .
STATUS:	.db 0FFH		;     .
;
DOWNK:	.equ 7FH		;  " ".
UPK:	.equ 0DFH	;  " ".
LEFTK:	.equ 0EFH	;  " ".
RIGHTK:	.equ 0BFH	;  " ".
TAB:	.equ 0FEH	;  "".
LF:	.equ 0FDH	;  "".
DEL:	.equ 0F7H	;  "".
CR:	.equ 0FBH	;  "".
;
;    (  ).
;
BORDER:	.db 00H
COLOR:	.db 00H
COLR1:	.db 3FH
COLR2:	.db 87H
COLR3:	.db 17H
COLR4:	.db 7BH
COLR5:	.db 00H
COLR6:	.db 00H
COLR7:	.db 00H
COLR8:	.db 0FFH
COLR9:	.db 00H
COLR10:	.db 00H
COLR11:	.db 00H
COLR12:	.db 0DEH
COLR13:	.db 00H
COLR14:	.db 00H
COLR15:	.db 00H
;
;    ( ,  ).
;
INIT:	PUSH H
	PUSH B
	PUSH D
	PUSH PSW
	LDA WRPAL	;     
	ORA A		;  .
	JZ NWRPAL
	MVI A,88H
	OUT 00H
	LXI H,COLR15	;  .
	LXI D,100FH
INIT1:	MOV A,E
	OUT 02
	MOV A,M
	OUT 0CH
	OUT 0CH
	OUT 0CH
	OUT 0CH
	OUT 0CH
	DCX H
	OUT 0CH
	DCR E
	OUT 0CH
	DCR D
	OUT 0CH
	JNZ INIT1
NWRPAL:	MVI A,8AH	;      
	OUT 00		;   8*8 ( ,,/).
	XRA A
	OUT 03
	IN 2
	STA STATUS
	MVI A,0FEH	;      .
	OUT 03
	IN 02
	STA KEYKOD
	MVI A,88H
	OUT 00
	LDA BORDER	;   .
	ANI 0FH
	OUT 02
	LDA SCROLL	;    .
	OUT 03
;
;         .
;
	LDA TON		;       .
	ORA A		;   ?
	JZ TSSOUN	;   -     ..
	DCR A		;    1, ..  .  .
	ADD A		;      4,  
	ADD A		;     4 .
	MOV E,A		;   "DE"    .
	MVI D,0
	LXI H,BAZTON	;   "HL"    .
	DAD D		;   "DE"   "HL"   .
	MVI A,0B6H	;   3    2,  -
	OUT 08		;      -  .  .
	MOV A,M		;    .  
	OUT 09		;    2 .
	INX H		;      .
	MOV A,M		;    .  
	OUT 09		;    2 .
	INX H
	MOV E,M		;    "DE"  .
	INX H
	MOV D,M
	XCHG		;    
	SHLD STSOUN	;   .
	XRA A		;      (.. -
	STA TON		;        ).
	JMP EXINIT	;   /   .
;
TSSOUN: LHLD STSOUN	;      ,
	MOV A,H		;     (  )?
	ORA L
	JZ OFSOUN	;   -  !
	DCX H		;  .
	SHLD STSOUN
	JMP EXINIT	;    / .
OFSOUN:	MVI A,0B6H	;   2     .
	OUT 08		;  .      .
EXINIT:	XRA A
	STA WRPAL
	POP PSW
	POP D
	POP B
	POP H
	EI
	RET
;
STSOUN: .dw 0000H	;   .
WRPAL:	.db 01H		;      ..
;
;--------------------------------
;   ,
;    
;  "BOULDER".
;--------------------------------
;
VACUUM:	.equ 00	;  .
WALL:	.equ 01	; .
SOIL:	.equ 02	;   ().
STONE:	.equ 03	; .
CRYSTL:	.equ 04	; .
EXIT:	.equ 05	; .
EXPLOS:	.equ 06	; .
BUTTER:	.equ 07	; .
MEN:	.equ 08	; .
TRACE:	.equ 80H	;   (      .).
;
;
;---------------------------------
;     .
;---------------------------------
;
;      "ARTMEN"
;
STOP1:	.equ 00H	; ,  .
STOP2:	.equ 10H	; ,  .
RIGHT:	.equ 20H	;  .
LEFT:	.equ 30H	;  .
UP:	.equ 40H	;  .
DOWN:	.equ 50H	;  .
;
;          
;       ,   
;           ,  
;      .
;	    "INDMEN",   
;          
;   40*22.
;
; 
;*******************************
;      
;         
;*******************************
;
GSTART:	LXI H,FONPAL	;     
	CALL MOVPAL	;   .
	MVI A,1		;   .
	STA WRPAL
	HLT		;     .
	CALL CLEAR	;  .
	MVI A,1		;    .
	STA NUMBL
	LXI H,0E030H	;     ()
	SHLD STWIND+1	; .
	MVI A,0F7H	;       
	STA SCROLL	;  (    ).
	MVI A,6		;    6 .
	STA LIVMEN	; (   ).
	lxi	h,demoend-1	;     
	SHLD DEMKOD	; (     ).
;
;     ()     .
;
NSTART:	LXI SP,100H	;     .
	LXI H,001DH	;     
	SHLD PLACE	;  (, , ).
	LXI H,TEXT1	;      
	CALL TEXOUT	;  .
	LXI H,0004H
	SHLD PLACE
	LXI H,TEXT2
	CALL TEXOUT
	CALL AVTOR	;     .
	LXI H,GAMPAL	;    .
	CALL MOVPAL
	MVI A,1
	STA WRPAL
	LXI H,8000H	;      
	SHLD VOCPAN	;     
	XRA A		;
	STA PRGMEN	;    .
	STA PREXIT	;     .
	STA STSTOP	;     ."STOP..".
	STA TON		;  .
	LXI H,0		;    .
	SHLD STSOUN	;
	STA PANVER	;    .
	STA PANHOR	;    .
	MVI A,01H	;  ,   
	STA OPCRYS	;  .
	STA CHLEV	;    .	
	STA STPKEY	;  .
	CALL LDLEV	;  .
	MVI A,01	;      
	STA TIMEDL	;  (   .  .).
	STA STSIDE	;     .
	LHLD INDVMS	;    
	CALL INDEX	;       40*22 
	SHLD MVIDEO	;    "OUTVMS"
	LHLD INDMEN	;   ,
	CALL INDEX	;      40*22 
	MVI M,EXIT	;     (,  ..)
	LDA ATRMEN	;    
	ANI 8FH		;   "".
	ORI STOP1
	STA ATRMEN
;
;      .
;
BEGIN:	CALL CALCUL	;  .
BEG1:	CALL WINDOW	;  .
	CALL OUTLIV	;   .
	CALL TSTPAN	;     .
	CALL PANORM	;   .
	LHLD VOCPAN	;     
	MOV A,H		;   .
	SUI 4
	MOV H,A
	SHLD VOCPAN	;      .
	MVI A,TONPAN	;    (. .)
	STA TON
	HLT		;  ,  .
MOVTO1:	HLT
	HLT
	CALL TSTPAN	;     .
	LDA PANVER	;    
	MOV B,A
	LDA PANHOR
	ORA B		; :   ( ?)
	JNZ BEG1
	MVI B,12	;    .
BEG2:	PUSH B
	CALL WINDOW
	CALL OUTLIV
	HLT
MOVTO2:	HLT
	HLT
	POP B
	DCR B
	JNZ BEG2
	LHLD INDMEN	;    .
	CALL INDEX	;    
	MVI M,EXPLOS	;      .
	MVI A,TIMEXP	;     .
	STA STEXPL
	MVI A,TONEXP	;  
	STA TON
	MVI A,MEN	;    .
	STA BUFEXP
	XRA A		;  .
	STA STPKEY
;
;
;****************************************
;    -  
;   .
;****************************************
;
;  
LOOP:	CALL WINDOW	;    ().
	HLT		;  .  . ,   .
	CALL KEYBOR	;      .
	CALL MOVMEN	;      .
	CALL MOVELM	;      .
	CALL TSTPAN	;   .
	CALL PANORM	;   (  ).
	CALL CALCUL	; ,    .
	CALL OUTLIV	;    -  .
	JMP LOOP	;     . .
;
;*****************************************
;    ()
;    .
;*****************************************
;
;      
; .     
;     . (    ).
;
WINDOW:	LHLD INDVMS	;    ()
	CALL INDEX	;    .
	SHLD MVIDEO	;    .
	CALL VMSOUT	;    .
	RET
;
;
;****************************************
;    
;          .
;***************************************
;
;     "BOULDER" -    
; 40  22      .
;         ,  -
;   .    
;  "LEVEL".  /     
;       -   40*22
;    "BAZA",     .
;     2-   40*22     12 
;  .       -
;      "PARLEV".  /   
;         
; .
;	     :
;
;  N 	 .
;  --------------------------------
;    0		     .
;    1		   >>  >>.
;    2		   ()  .
;    3		   >>  >>.
;    4		    . (  . .).
;    5		   >>  >>.
;    6		    ,   .
;    7		,       .
;    8		     (  "").
;    9           1,      "".
;   10		 2   >>  >>.
;   11		 3   >>  >>.
;
LDLEV:	LDA CHLEV	;    ()   :
	ORA A		;  ?
	RZ		;   - .
	PUSH H		;   -  .
	PUSH B
	PUSH D
	PUSH PSW
	IN 01		;  //.
	ANI 80H		;  / - 
	JNZ TSTRCL
	STA TURBO
	JMP LDL01
TSTRCL:	IN 01
	ANI 40H
	JNZ LDL03
	MVI A,02
	STA TURBO
	JMP LDL01
LDL03:	IN 01
	ANI 20H
	JNZ LDL01
	MVI A,1
	STA TURBO
LDL01:	MVI A,01	;    
	STA OPLEVE	;  .
	LDA NUMBL	;   .
	LXI H,LEVEL	;  "HL"    .
	lxi	b,440
LDLEV1:	ORA A		;  ? (  ?).
	JZ LDLEV2	;   - .
	DAD B		;   -     ..
	DCR A		;    .
	JMP LDLEV1	;  -   ?
word1	.dw 0
word2	.dw 0
LDLEV2:
	LXI D,BAZA	;  "DE" -   .
LDLEV3:
	MOV A,M		;     .
	ani	0Fh
	stax	d
	inx	d
	mov	a,m
	rrc\ rrc\ rrc\ rrc
	ani	0Fh
	stax	d
	INX H
	INX D
	DCX B
	MOV A,B
	ORA C
	JNZ LDLEV3
	LDA NUMBL	;       .
	LXI H,PARLEV	;  "HL"     .
	LXI B,12	;  "BC"      .
LDLEV4:	ORA A		;     .
	JZ LDLEV5	;   .  -  .
	DAD B
	DCR A
	JMP LDLEV4
LDLEV5:	MOV E,M		;      
	INX H
	MOV D,M
	INX H
	XCHG
	SHLD INDMEN	;    "INDMEN".
	XCHG
	MOV E,M		;    ( ).
	INX H
	MOV D,M
	INX H
	XCHG
	SHLD INDVMS	;    "INDVMS".
	XCHG
	MOV E,M		;    ,  
	INX H		;   .
	MOV D,M
	INX H
	XCHG
	SHLD INDEXT	;    "INDEXT".
	XCHG
	MOV A,M		;   ,   
	INR A		;  ,      .
	STA STCRYS	;     .
	INX H
	MOV A,M		;    
	INR A		;  , (   )
	STA TIME	;     .
	INX H
	LDA TURBO	;      00H -  1 ,
	ORA A		;
	JZ COLTUR
	CPI 1		;  1 -  .
	JZ CWET
	MOV A,M		;   1,   MONO.
	STA COLR1
	STA COLR2
	STA COLR3
	JMP CWETMN
CWET:	INX H
	MOV A,M		;      "".
	STA COLR1
	INX H
	MOV A,M
	STA COLR2
	INX H
	MOV A,M
	STA COLR3
CWETMN:	MVI A,2		;   "",  2 
	STA STPLOS	;     .
	STA COLSOI+1	;  2   
	LXI H,0000H	;    "NOP" ,  
	SHLD MOVTO1	;       
	SHLD MOVTO2	;     .
	MVI A,10H	;      
	STA TIMSHO+1	;     .
	JMP EXLDLV	;   /  .
COLTUR:	MOV A,M		;      "".
	STA COLR1
	MVI A,1		;   "",   
	STA STPLOS	; .
	STA COLSOI+1	;  1   .
	LXI H,7676H	;    "HLT"   
	SHLD MOVTO1	;       .
	SHLD MOVTO2
	MVI A,20H	;       
	STA TIMSHO+1	; "".
EXLDLV:	MVI A,1
	STA WRPAL
	POP PSW
	POP D
	POP B
	POP H
	RET
;
CHLEV:	.db 00H		;   () .
NUMBL:	.db 00H		;  
INDEXT:	.dw 0000H	;   .
TURBO:	.db 00H		;  ""/"".
;
;******************************************************
;    ( )
;      .
;******************************************************
;
; /      
; "ATRMEN".       
;  ,    "STOP1"  "STOP2"
;   ,  "TIMSTP" (,
;  ,    ).   (
; )    "STPKEY".
;
KEYBOR:	LDA TURBO	;       
	ORA A		;  .    
	JZ KEYBR1	;      
	LDA PANHOR	;    (  ).
	MOV B,A
	LDA PANVER
	ORA B
	RNZ
KEYBR1:	LDA STPKEY	;  .
	ORA A
	RNZ		;    -  .
	LDA DEMO	;    .
	ORA A		;   ,    
	JZ KEYUPR	;  .
	LDA STATUS	;  ,    
	CPI 0FFH	;    8*8   
	JZ DEMUP1	;    -     .
	POP PSW		;      , 
	JMP START	;    .
DEMUP1:	LHLD DEMKOD	;      .
	MOV A,M		;    ,
	DCX H		;   
	SHLD DEMKOD	; .
	JMP DEMUPR	;     .
KEYUPR:	LDA KEYKOD	;    .
DEMUPR:	CPI 0FFH	;  ?
	JZ SETSTP	;   -    "STOP.."
	CPI TAB		;   ?
	JZ SETEX1	;  .
	CPI CR		;  "" ?
	JZ START	;   .
	PUSH PSW	;    .
	MVI A,STOP1	;    "STOP1" 
	STA BFSTOP	;   "STOP.."
	MVI A,TIMSTP	;     
	STA STSTOP	;   .
	POP PSW		;    .
	CPI UPK		;  ""?
	JZ SETUP	;   "" (UP).
	CPI DOWNK	;  ""?
	JZ SETDOW	;
	CPI RIGHTK	;  ""?
	JZ SETRIG	;
	CPI LEFTK	;  ""?
	JZ SETLEF	;
	JMP SETSTP	;    .
SETUP:	MVI B,UP	;   . ""   "UP".
	JMP SETVEK	;      .
SETDOW:	MVI B,DOWN	;
	JMP SETVEK
SETRIG:	MVI B,RIGHT
	JMP SETVEK
SETLEF:	MVI B,LEFT
	JMP SETVEK
SETSTP:	LDA STSTOP	;      "STOP.."
	DCR A		;   
	STA STSTOP	;  .
	LDA BFSTOP	;      "STOP.."
	MOV B,A		;     "".
	JNZ SETVEK	;      -  .
	XRI 10H		;    .
	STA BFSTOP	;      
	MOV B,A		;   "".
	MVI A,TIMSTP	;     .
	STA STSTOP	;
SETVEK:	LDA ATRMEN	;    
	ANI 8FH		;    .
	ORA B		;    
	STA ATRMEN	;      .
	RET		;   /  .
;
TIMSTP:	.equ 12		;    "STOP.."
STSTOP:	.db 00H		;     "STOP.."
BFSTOP:	.db 00H		;   "STOP.."
STPKEY:	.db 00H		;   .
DEMKOD:	.dw 0000H	;     
;
;********************************************
;      
;********************************************
;
;     
;       , 
;    .  ,  
;       -
;   .    
;    , -
;        ,
;      
;   ,    ""
;  .
;
MOVMEN:	LDA TURBO	;       .
	ORA A
	JZ MOVM00
	LDA PANVER	;    -   
	MOV B,A		;  .
	LDA PANHOR
	ORA B
	RNZ
MOVM00:	LHLD INDMEN	;     .
	LDA ATRMEN	;    
	ANI 70H		;  .
	CPI 20H		; :  "STOP1"  "STOP2"?
	JNC CONTIN	;   - .
	MVI A,TIMPUS	;  ,      
	STA STPUSH	; .,      ,
	RET		;       .
CONTIN:	MOV C,A		;     . "C".
	CALL TESTVM	;   .     .  "DE".
	CPI WALL	;  ?
	RZ 		;   -   "MOVMEN".
	ORA A		;   ?
	JZ GOVACM	;   -   .
	CPI SOIL	;    ()?
	JZ GOSOIL	;   .
	CPI CRYSTL	;  ?
	JZ GOCRYS	; "" !
	CPI EXIT	;    ?
	JZ GOEXIT	;       .
	CPI STONE	;  ?
	JZ TSTONE	;   - :    "".
	CPI EXPLOS	;  ?
	JZ SETEX1	;   .
	CPI BUTTER	;  ?
	JZ SETEXP	;        .
	RET		;   "MOVMEN"    .
;
GOVACM:	MVI A,TONVAC	;     .  .
	STA TON		; (   "TON").
	JMP SETMEN	;    .  .
GOSOIL:	MVI A,TONSOL	;    .
	STA TON
	JMP SETMEN
GOCRYS:	MVI A,TONCRS	;    .
	STA TON
	MVI A,81H	;   (-1)  ..
	STA OPCRYS	; (      ..).
	JMP SETMEN
GOEXIT:	MVI A,01	;     .
	STA PREXIT	; (. "1"   "PREXIT").
	JMP SETMEN
SETEXP:	MVI M,EXPLOS	;      .
SETEX1:	LHLD INDMEN	;    ,
	CALL INDEX	;       
	MVI M,EXPLOS	;   .
	MVI A,CRYSTL	;        
	ORI 80H		;      .
	STA BUFEXP	; (     "BUFEXP).
	MVI A,TONEXP	;   .
	STA TON
	MVI A,TIMEXP	;    
	STA STEXPL	;   .
	MVI A,01	;     (  "1" 
	STA PRGMEN	;  "PRGMEN").
	RET
TSTONE:	MOV A,C		;      . "C".
	CPI UP		;   ""?
	RZ		;   -  ..    !
	PUSH H		;    .
	PUSH D
	XCHG		;     "HL".
	CALL TESTVM	;    " "  .
	ORA A		;   ?
	JNZ NOPUSH	;   -    .
	LDA STPUSH	;   -     
	ORA A		;   ?
	JZ MOVSTN	;   -  !
	DCR A		;   -  .  
	STA STPUSH	;    .
NOPUSH:	POP D		;      
	POP H
	RET		;   "MOVMEN"
MOVSTN:	MVI A,STONE	;    
	ORI 80H		;    (  "MOVELM").
	MOV M,A		;     , .."" .
	MVI A,TONMOV	;   .
	STA TON
	MVI A,TIMPUS	;      , 
	STA STPUSH	;    .
	POP D		;        
	POP H
	JMP SETMEN	;    .
;
; /     .
;
;  :  "" - , "HL" -  .
; :  "" - , "HL" -   .  , "DE" - .  .
;
TESTVM:	CPI DOWN	;  ?
	JZ MOVDOW	;   -    .
	CPI UP		;  ?
	JZ MOVUP
	CPI RIGHT	;  ?
	JZ MOVRIG
	CPI LEFT	;  ?
	JZ MOVLEF
	POP PSW		;    -   "SP" 
	RET		;    / "MOVMEN".
;
MOVDOW:	DCR L		;    
	JMP NEWVEK	;       ..
MOVUP:	INR L		;   
	JMP NEWVEK
MOVRIG:	INR H		;   
	JMP NEWVEK
MOVLEF:	DCR H		;   
NEWVEK:	MOV D,H		;     "DE".
	MOV E,L
	CALL INDEX	;   "HL"    .
	MOV A,M		;      "".
	ANI 0CFH	;      .
	RET		;    "TESTVM".
;
; /         .
;
; :  "HL" -   ,  "DE" -   .
; 	       "TRACE" -  -
;  ,    .      
;    ,     
;   .       
;      "VACUUM".
;
SETMEN:	MVI M,MEN	;      .
	LHLD INDMEN	;     
	CALL INDEX	;      .
	MVI M,TRACE	;     .
	XCHG		;     "HL" 
	SHLD INDMEN	;     "INDMEN".
	RET
;
INDMEN:	.dw 0000H	;     40*22.
;
OPCRYS:	.db 00H		;    .
STCRYS:	.db 40H		;  .
TIMEXP:	.equ 5		;  .
STEXPL:	.db 00H		;   .
TIMPUS:	.equ 01H		;   .
STPUSH:	.db 00H		;    .
BUFEXP:	.db 00H		;   ,    .
PREXIT:	.db 00H		;     .
PRGMEN:	.db 00H		;   .
TON:	.db 00H		;     .
;
;     .    
;    "BAZTON".      - 
;   ,   .
;
TONVAC:	.equ 01		;      . 1- .
TONSOL:	.equ 02		; N     .
TONCRS:	.equ 03		; N     .
TONMOV:	.equ 04		; N     .
TONEXP:	.equ 05		; N    .
TONTIM:	.equ 06		; N    ,   .
TONPAN:	.equ 07		; N     .
;
;
BAZTON:	.dw 0050		;     
	.dw 0001		;      
;
	.dw 0000		;   .
	.dw 0001		;    .
;
	.dw 0500		;   .
	.dw 0003		;    .
;
	.dw 1000		;   .
	.dw 0001		;    .
;
	.dw 1200		;  .
	.dw 0003		;   .
;
	.dw 3000		;   ,    .
	.dw 0004		;   .
;
VOCPAN:	.dw 0000		; ,   .
	.dw 0010		; .
;
;***************************************************
;       40*22.
;***************************************************
;
;  /     40*22.
;       
; /  , ..    
;     .. 880 !
;  ,     
; ,      ,
;      ( )
;     - .. 40.
;     ,     -
;       40*22, .. 
;    ,    
;   80  ( 10%   ).
;       ,
;       "",  
;        ,
;        .( "1" 
;     ).  
;  ,         
;        
; .
;
MOVELM:	LDA TURBO	;       .
	ORA A
	JZ MOVL00
	LDA PANVER	;    -    -
	MOV B,A		;  .
	LDA PANHOR
	ORA B
	RNZ
MOVL00:	LXI H,BAZA+40	;  "HL"     (0- .)
	LXI B,880-80	;  "BC"   (  ).
MOVEL1:	PUSH B		;    .
	PUSH H		;   .
	MOV A,M		;     .
	ANI 0CFH	;      .
	CPI STONE	;     ?
	JC NEXELM	;   -     .
	CPI EXIT	;  ?
	JZ NEXELM	;   -  .
	CPI TRACE	;      ?
	JNC NEXELM	;   - .
	CPI EXPLOS	;  ?
	JZ OPEXPL	;   -    .
	CPI BUTTER	;  ?
	JZ OPBUTT	;   -    .
	CPI MEN		;  ?
	JZ NEXELM	; .
	ORI 80H		;  ( ) .
	STA BUFKOD	;    .
	LXI B,0040	;   "BC"     .
	MOV A,L		;    ,.. "   "
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;  ,    ( ).
	ANI 0FH		;        .
	CPI BUTTER	;    . .   ?
	JZ EXPCRY	;   -   !
	MOV A,M		;   -    ,  ...
	ANI 0CFH	;    .
	ORA A		;   ?
	JNZ TSTPOZ	;  -    .
	LDA BUFKOD	;  -     
	MOV M,A		;      .
	MOV D,H		;      "DE".
	MOV E,L
	DAD B		;    , ..    .
TSBLOW:	MVI M,TRACE	;      .
	XCHG		;   "HL"       ,
	MOV A,L		;  :   "" .
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;   "" ,   "" .
	ANI 0FH		;        ..
	CPI BUTTER	;    .   ?
	JZ EXPCRY	;   -  !
	MOV A,M		;     .  .
	ANI 0CFH	;    .
	ORA A		;   ?
	JZ NEXELM	;   -     .
	CPI TRACE	;      ?
	JNC NEXELM	;   -  ..
	CPI MEN		;  ?
	JNZ TONBOM	;   -     .
	MVI A,01	;   -    .
	STA PRGMEN
	MVI M,EXPLOS	;    -  .
	MVI A,TIMEXP+8  ;  
	STA STEXPL
	MVI A,TONEXP	;   .
	STA TON
	MVI A,TRACE	;     .
	STA BUFEXP
	JMP NEXELM	;   .  40*22.
TONBOM:	MVI A,TONMOV	;      (   ,
	STA TON		;     ).
NEXELM:	POP H		;      
	POP B		;   .
	INX H		;       40*22
	DCX B		;  .
	MOV A,B		;   .
	ORA C
	JNZ MOVEL1	;    .  - .
	JMP ABTRAC	;        .
;
OPEXPL:	LDA STEXPL	;    ,
	ORA A		;    
	JNZ NOABEX	;      -   .
	LDA BUFEXP	;   -      
	MOV M,A		;    .
	JMP NEXELM	;    .
NOABEX:	DCR A		;    
	STA STEXPL	; 
	JMP NEXELM	;   .
;
;        .
;      ""    
; .          
;    - ..     ,
;         
;    .
;
TSTPOZ: CPI STONE	;  (  )   ?
	JZ NOSTAB	;   -     - !
	CPI CRYSTL	;   ?
	JZ NOSTAB	;  .
	CPI BUTTER	;  ?
	JNZ NEXELM	;   -    ( ..)
NOSTAB:	POP H		;        "SP".
	PUSH H
	MVI E,2		;    .
	LDA STSIDE	;     
	MOV D,A		;        "D".
LSTAB:	INR D		;   (    )
	MOV A,D		; 
	RRC		;      :
	JNC TSTLEF	;  "0" -     ,
	INX H		;  "1" - .
	JMP TSTVC1	;        .
TSTLEF:	DCX H		;      .
TSTVC1:	MOV A,M		;    ( )   
	ORA A		;   .
	JNZ OTSIDE	;    -   .
	MOV A,L		;       .
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;     .
	ORA A		;   ?
	JNZ OTSIDE	;   -   .
	LDA BUFKOD	;   -       
	MOV M,A		;  .
	MOV A,D		;    , 
	STA STSIDE	;      .
	XCHG		;      "DE".
	POP H		;   "HL"   
	PUSH H		;     .
	JMP TSBLOW	;       .
OTSIDE:	DCR E 		;   .
	JZ NEXELM	;     -  .
	POP H		;    
	PUSH H
	JMP LSTAB	;       ..
;
;    .       ,
;  .       :
;  ,   ,    
;   ,   . ,  
;  ,   .    
;   ,      .
;      ,     :
; 4-  5-  ,     . ( 
;     "MOVMEN"  "MOVELM",    "OUTSPR" 
;      ANI 0CFH ).
;
OPBUTT: LXI B,0040	;   "BC"    .
	MOV A,M		;    .
	ANI 30H		;   ,    .
	CPI 00H		;  ?
	JZ SUPDOW
	CPI 10H		;  ?
	JZ SUPLEF
	CPI 20H		;  ?
	JZ SUPUP
	CPI 30H		;  ?
	JZ SUPRIG
;
SUPDOW:	MOV A,L		;     .
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;    " "
	CPI MEN		;  ?
	JZ EXPCRY	;   -    .
	POP H		;   ,   "SP".
	PUSH H
	DCX H		;      .
	MOV A,M		;       :
	ORA A		; ?
	JZ SUPDW1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	JMP TSTSPL	;    -   .
SUPDW1:	MOV D,H		;      "DE".
	MOV E,L
	MOV A,L		;     ( ).
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;      .
	ORA A		; ?
	JZ SETSPR	;   -   .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	XRA A		;   -    (  ).
	JMP MOVBUT	;      .
SETSPR:	MVI A,30H	;   .
	JMP MOVBUT	;  .
;
SUPLEF:	DCX H		;      .
	MOV A,M		;  .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
TSTSPL:	POP H		;   .
	PUSH H
	DAD B		;    .
	MOV A,M		;     .
	ORA A		; ?
	JZ SUPLF1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	JMP TSTSPU	;     ( ).
SUPLF1:	MOV D,H		;      "DE".
	MOV E,L
	DCX H		;   .
	MOV A,M		;     :
	ORA A		; ?
	JZ SETSPD	;   -   .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	MVI A,10H	;   -   .
	JMP MOVBUT	;  .
SETSPD:	MVI A,00	;   .
	JMP MOVBUT	;  .
;
SUPUP:	DAD B		;    .
	MOV A,M		;  .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
TSTSPU:	POP H		;   .
	PUSH H
	INX H		;     .
	MOV A,M		;  .
	ORA A		; ?
	JZ SUPUP1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	JMP TSTRIG	;     ( ).
SUPUP1:	MOV D,H		;      "DE".
	MOV E,L
	DAD B		;   .
	MOV A,M		;   .
	ORA A		; ?
	JZ SETSPL	;   -   
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	MVI A,20H	;   -   .
	JMP MOVBUT	;  .
SETSPL:	MVI A,10H	;   .
	JMP MOVBUT	;  .
;
SUPRIG:	INX H		;      .
	MOV A,M		;  .
	CPI MEN		;  ?
	JZ EXPCRY	;   - .
TSTRIG:	POP H		;   .
	PUSH H
	MOV A,L		;     (" ").
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	MOV A,M		;  .
	ORA A		; ?
	JZ SUPRG1	;   -     .
	CPI MEN		; ?
	JZ EXPCRY	;   - .
	POP H		;   -     (
	PUSH H		;  
	MOV D,H		;  .
	MOV E,L
	MVI A,00H	;    
	JMP MOVBUT	;   ,     .
SUPRG1:	MOV D,H		;      "DE".
	MOV E,L
	INX H		;      .
	MOV A,M		;   .
	ORA A		; ?
	JZ SETSPU	;   -   .
	CPI MEN		; ?
	JZ EXPCRY	;   -.
	MVI A,30H	;   -   .
	JMP MOVBUT	;  .
SETSPU:	MVI A,20H	;   .
	JMP MOVBUT	;  .
;
MOVBUT:	POP H		;      
	PUSH H
	MVI M,TRACE	;      .
	XCHG		;   "HL"      "DE".
	ORI BUTTER	;   "A"  ,   .
	ORI 80H		;   .
	MOV M,A		;      .
	JMP NEXELM	;       40*22.
;
EXPCRY:	MVI A,CRYSTL	;    
	ORI 80H		;   .
	STA BUFEXP
	JMP EXPEXP
;
EXPTRC:	MVI A,TRACE	;    "".
	STA BUFEXP
	JMP EXPEXP
;
EXPEXP:	MOV A,L		;      ( )
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	DCX H		;     (    9- .)
	MVI D,3		;   .
EXPEX1:	MVI E,3		;   .
EXPEX3:	MOV A,M		;  9 ,  .
	CPI WALL
	CNZ EXP
	DCR E
	JZ EXPEX2
	INX H
	JMP EXPEX3
EXPEX2:	DCX H
	DCX H
	DAD B
	DCR D
	JNZ EXPEX1
	MVI A,TONEXP	;   
	STA TON
	MVI A,TIMEXP+15	;   .
	STA STEXPL
	JMP NEXELM	;      40*22.
;
EXP:	CPI MEN		;     ?
	JNZ EXP1	;   -    .
	MVI A,01
	STA PRGMEN
EXP1:	MVI M,EXPLOS
	RET
;
BUFKOD:	.db 00H		;    
STSIDE:	.db 00H		;    .
;
;
;   . ( /    ,
;            
; .
;
ABTRAC:	LXI H,BAZA	;   "HL"    40*22.
	LXI B,880	;   "BC"   .
ABTR1:	MOV A,M		;     
	ANI 7FH		;  .(    ..)
	MOV M,A		;    .
	INX H		;      
	DCX B		;   .
	MOV A,B		; :    ?
	ORA C
	JNZ ABTR1	;   -  .
	RET
;
;
;*****************************************
; ,    .
;*****************************************
;
CALCUL:	LDA TIMLDR	; -  .
	ORA A		;   0.
	JNZ CALC6	;   - .   .
	LDA PREXIT	;     ..
	ORA A
	JNZ NEXLEV	;   -   . .
	LDA OPCRYS	;     .
	ORA A		;   ?
	JZ CALC1	;   -   .
	XRA A		;  .
	STA OPCRYS
	LDA STCRYS	;     
	DCR A		; .
	JM CALC1	;    -    .
	JZ OPENEX	;  (..    ) - ..
CALC7:	STA STCRYS
	LXI H,131CH	;      .
	SHLD PLACE
	LXI D, 0802H	;    .
	CALL OUTST	;   .
CALC1:	LDA OPLEVE	;   (    ) 
	ORA A		;  .
	JZ CALC2	;  ,   .
	XRA A		;    .
	STA OPLEVE
	LDA NUMBL	;   
	LXI H,091CH	;   .
	SHLD PLACE
	LXI D, 0802H	;    .
	CALL OUTST	;   .
CALC2:	LDA TIMEDL	;     
	DCR A		;   .
	STA TIMEDL
	JNZ CALC3	;    -   .
	LDA CONTDL	;     
	STA TIMEDL	;    .
	LDA TIME	;      () 
	ORA A		;   .
	JZ KILMEN	;    -   .
	DCR A		;   .
	STA TIME
	LXI H,1C1CH	;   .
	SHLD PLACE
	LXI D,0803H	;    .
	CALL OUTST	;   .
CALC3:	LDA TIME
	CPI 20		;     
	JNC CALC9	;     -    
	LDA FAZTIM	;       
	RRC		; .
	STA FAZTIM
	CC FLASHT	;   -   "".
CALC9:	LDA PRGMEN	;    .
	ORA A		;  ?
	JZ CALC4	;   -  . .
	XRA A		;   .
	STA PRGMEN
	LDA LIVMEN	;    .
	ORA A		;   ?
	JZ GMOVE1	; E  -   (  ).
	DCR A		;   .
	STA LIVMEN
GMOVE1:	MVI A,01	;  .
	STA STPKEY
	LDA ATRMEN	;   "STOP1".
	ANI 8FH
	ORI STOP1
	STA ATRMEN
	MVI A,28H	;     
	STA TIMLDR	; .
	MVI A,TIMEXP+10	;      
	STA TIMLIV	; (     ).
	LXI H,0C1CH	;      
	SHLD PLACE	; " ".
	LXI H,TEXT6
	CALL TEXOUT	;  .
	RET		; .
CALC6:	LDA TIMLDR	;    
	DCR A		; 
	STA TIMLDR
	RNZ		;     - 
	LDA LIVMEN	;   ?
	ORA A
	JZ GMOVE2	;   -  .
	MVI A,STONE	;   ,   
NEXLV3:	STA FULKOD
	LDA ATRMEN	;      "".
	ANI 8FH
	ORI RIGHT
	STA ATRMEN
	CALL SCFULL	;   .
	POP PSW		;    
	LDA PREXIT	; :    . ,  
	CPI 02		;  ?
	JNZ NSTART	;   -  !
	LDA NUMBL	;   -   ..
	CPI 03		;  ?
	JZ GIRL		;   -    .
	JMP NSTART	;  .
CALC4:	RET
OPENEX:	LHLD INDEXT	;   ,
	CALL INDEX	;     .
	MVI M,EXIT	;      .
	LXI H,0C1CH	;      ":".
	SHLD PLACE
	LXI H,TEXT4	;   ":00" 
	CALL TEXOUT
	LXI H,0C1CH	;   ": 00"  " "
	SHLD PLACE	; ,   .
	LXI H,TEXT5
	CALL TEXOUT
	JMP CALC1	;   .
KILMEN:	MVI A,01H	;    .
	STA PRGMEN
	LHLD INDMEN	;    
	CALL INDEX
	MVI M,EXPLOS	;     .
	MVI A,TRACE	;     .
	STA BUFEXP
	MVI A,TONEXP	;  .
	STA TON
	MVI A,TIMEXP+8  ;  .
	STA STEXPL
	JMP CALC3	;   .
GMOVE2:	POP PSW		;   .
	JMP GIRL	;    .
;
NEXLEV:	LDA PREXIT	; :    2- ?
	CPI 02
	JZ NEXLV1	;   -    
	MVI A,02
	STA PREXIT
	MVI A,10	;      . .
	STA TIMLDN
	MVI A,1		;  .
	STA STPKEY
	LHLD INDMEN	;      .
	CALL INDEX
	MVI M,EXIT
	LDA NUMBL	;   .
	INR A
	STA NUMBL
	LDA LIVMEN	;   1     .
	INR A
	STA LIVMEN
	LXI H,0C1CH	;   "  "
	SHLD PLACE
	LXI H,TEXT7
	CALL TEXOUT
	LXI H,4000H	;    .
	SHLD VOCPAN
	RET
NEXLV1:	LDA TIMLDN	;  ?
	DCR A
	STA TIMLDN
	JNZ NEXLV2	;   - .
	LDA DEMO	;    ?
	ORA A
	JNZ START	;   -   .
	LXI H,0C1CH	;   -   "  "
	SHLD PLACE
	LXI H,TEXT6
	CALL TEXOUT
	MVI A,MEN	;      .
	JMP NEXLV3
NEXLV2:	LHLD VOCPAN	;   .
	MOV A,H
	SUI 4
	MOV H,A
	SHLD VOCPAN
	MVI A,TONPAN
	STA TON
	RET
;
SCFULL:	LXI H,BAZA	;    40*22.
	LXI B,880	;   .
SCFUL1:	LDA FULKOD	;     "FULKOD"
	MOV M,A
	INX H
	DCX B
	MOV A,B
	ORA C
	JNZ SCFUL1
TIMSHO:	MVI B,20H	;      .
SCFUL2:	PUSH B
	CALL WINDOW	;  
	POP B
	DCR B		;  ?
	JNZ SCFUL2
	RET
;
FLASHT:	LDA FZFLAS	;    (/).
	INR A
	STA FZFLAS
	ANI 01H		;   - ,   - .
	JNZ INFLAS
	MVI A,11H	;     .
	JMP FLUSH1	;  .
INFLAS:	MVI A,TONTIM	;      .
	STA TON
	MVI A,10H	;   .
FLUSH1:	CALL SYMOUT	;   .
	LXI H,151CH	;     ":"
	SHLD PLACE
	LXI H,TEXT3	;  .
	CALL TEXOUT
	RET	
;
OPLEVE:	.db 00H		;    .
TIME:	.db 140		;    .
TIMEDL:	.db 00H		;    .
CONTDL:	.db 08H		;    .
TIMLDR:	.db 00H		;    .
FULKOD:	.db 00H		;      .
FAZTIM:	.db 11H		;     ":"
FZFLAS:	.db 00H		;  .
TIMLDN:	.db 00H		;     .
;
;******************************************
;    () 
; -     .
;******************************************
;
;     
;    -  1  3.
;
;  : "" -    .
;		     "" -   .
;		     "D" -   (1,2,4,8 -  "SYMOUT")
;
OUTST:	LXI H,0		;   .
	MVI B,8		;  .
	MOV C,A		;    "C".
OUTST1:	MOV A,C
	RLC		;    .
	MOV C,A
	MOV A,L		; -     .
	ADC L
	DAA
	MOV L,A
	MOV A,H
	ADC H
	DAA
	MOV H,A
	DCR B		;   .
	JNZ OUTST1	;   -  "HL" 3-  .-. .
	MOV A,D		;    
	CALL SYMOUT	;  .
	MOV A,E		;    .
	CPI 1
	JZ ONEST
	CPI 2
	JZ TWOST
	MOV A,H		;      3 .
	ANI 0FH		;    .
	ADI 30H		;     ASCII.
	CALL SYMOUT	;   /  .
TWOST:	MOV A,L
	RRC		;   .
	RRC
	RRC
	RRC
	ANI 0FH
	ADI 30H
	CALL SYMOUT
ONEST:	MOV A,L
	ANI 0FH		;   ( )  .
	ADI 30H
	CALL SYMOUT
	RET
;
;
;******************************************
;    
;******************************************
;
;    -
;    .
;    
;  , ..  -
;    .
;
OUTLIV:	LDA LIVMEN	;  -  
	MOV C,A		;   .
	MVI B,5		;    (  ).
	LXI H,0FD10H	;     .
OTLIV1:	SHLD ADRSPR
	DCR C		;  ?
	JM OTLIV2	;    -   .
	JNZ OTLIV4	;         - .
	LDA TIMLIV	;     ( ) - :
	ORA A		;     ?
	JZ OTLIV2	;   -   .
	DCR A		;   -    
	STA TIMLIV
	MVI A,EXPLOS	;       .
	JMP OTLIV3
OTLIV4:	MVI A,MEN
	JMP OTLIV3
OTLIV2:	XRA A
OTLIV3:	PUSH H
	PUSH B
	CALL OUTSPR	;     .
	POP B
	POP H
	DCR H		;     .
	DCR H
	DCR B		;     ?
	JNZ OTLIV1	;   - .
	RET
;
LIVMEN:	.db 06H		;   .
TIMLIV:	.db 00H		;    .
;
;
;*************************************************
;    
;      (
; ),   .
;************************************************
;
; /      
;    
;     .
;
TSTPAN:	PUSH H		;   .
	PUSH D
	PUSH PSW
	LHLD INDVMS	;    
	XCHG		;   "DE".
	LHLD INDMEN	;   .
	MOV A,E		;   "" .  (  ) 
	CMP L		;     .
	JP PANDOW	;   -   .
	ADI HEIGHT-2	;   ""    
	CMP L		;     .
	JM PANUP	;   -   .
TSTPHR:	MOV A,D		;   "" .  (  ) 
	CMP H		;   . .
	JP PANLEF	;   -   .
	ADI LENGTH-2	;   ""    
	CMP H		;   . .
	JP EXPANT
	MVI A,01	;   .
	STA PANHOR
EXPANT:	POP PSW		;       /.
	POP D
	POP H
	RET
;
PANDOW:	MVI A,02	;     .
	STA PANVER
	JMP TSTPHR	;        .
PANUP:	MVI A,01	;    . .
	STA PANVER
	JMP TSTPHR
PANLEF:	MVI A,02	;    . .
	STA PANHOR
	JMP EXPANT	;        /.
;
INDVMS:	.dw 0000H	;    (   ).
;
;*******************************************
;   ()
;      
;  .
;*******************************************
;
;      "BOULDER",
;  16*10    40*22  .
;	..   ""    
; ,        
;  .    ""   
;     (.     
;     ),    
;        .
;	,     
; ""    ( ), 
;         
;   (    ),
;         -
;     .
;	 /    
;   "VMSOUT"     .
;	   
; : "PANVER" - , "PANHOR" - .
;         :
;
; "00" -     .
; "01" -      (  ).
; "02" -     .
;
;   :    8  () .
;		           6  ()    .
; 
PANORM:	PUSH H		;   .
	PUSH PSW
	LHLD INDVMS	;     .
	LDA PANVER	;    .
	ORA A		;   ?
	JZ TSTHOR	;   -  .
	CPI 01		;    ? ( ?).
	JNZ VERDCR	;   -  ( ).
	INR L		;   .
	JMP TSTHOR	;     .
VERDCR:	DCR L		;   .
TSTHOR:	MVI A,01	;      
	STA TIPVMS	; / "VMSOUT".
	LDA PANHOR	;    .
	ORA A		;   ?
	JZ OFTIP	;   -      . . 
	CPI 01		;  ?
	JNZ HORDCR	;   -  .
	INR H		;   .
	JMP TSTZON	;      .
HORDCR:	DCR H		;   .
	JMP TSTZON	;    .
OFTIP:	STA TIPVMS	;      / "VMSOUT".
TSTZON:	MOV A,L		;        
	CPI 0		;  . (0, 6, 12).
	JZ RESVER	;    -   ..
	CPI 6
	JZ RESVER
	CPI 12
	JZ RESVER
ZONHOR:	MOV A,H		;        -
	CPI 0		;  . (0, 8, 16, 24).
	JZ RESHOR	;    -   ..
	CPI 8
	JZ RESHOR
	CPI 16
	JZ RESHOR
	CPI 24
	JZ RESHOR
SAVEIM:	SHLD INDVMS	;    .
	POP PSW		;   .
	POP H
	RET		;   / .
;
RESVER:	XRA A		;    .
	STA PANVER
	JMP ZONHOR	;       .
RESHOR:	XRA A		;    .
	STA PANHOR
	JMP SAVEIM	;     .
;
PANVER:	.db 00H		;   .
PANHOR:	.db 00H		;   .
;
;*****************************************
;   2- 
;   ( ).
;   - 40*22 .
;*****************************************
;
;    
;    40*22    
;   .
;
;  :  L -  ,
;		      H -  ,
;
;  : HL -  .
;
;    :
;
;	"BAZA" -   .
;
INDEX:	PUSH D		;   .
	PUSH H		;  .
	MVI H,0		;   "HL"  ..
	DAD H		; T    8 
	DAD H		;  "HL".
	DAD H
	MOV D,H		;    "DE" 
	MOV E,L
	DAD D		;    5  "HL"  "DE".
	DAD D
	DAD D
	DAD D
	XCHG		;  .  40    "DE".
	POP H		;   
	MOV L,H		;   "HL" 
	MVI H,0		;  .
	DAD D		;   "HL"      .
	LXI D,BAZA	;   "DE"   .
	DAD D		;         "HL"
	POP D		;   "DE" 
	RET		;   / "INDEX".
;
;
;*************************************************************
;       
;      (),     .
;*************************************************************
;
;  :   "MVIDEO"  
;     
; .    
;        -
;     .  
;     
;    "OUTSPR".
;	   
;   ,   
;      
; :   
;    ,   -
;  -  .
; 	   :
;
;	"MVIDEO" -   ()   .
;	"SCREEN" -       .
;	"TIPVMS" -    .
;	"LINEMS" -      .
;	"LENGTH" -      ( ).
;	"HEIGHT" -      ( ).
;
VMSOUT:	LHLD MVIDEO	;    . 
	XCHG		;       DE.
STWIND:	LXI H,SCREEN	;      .
	LDA TIPVMS	;      :
	ORA A		; "0"-  , "1"- .
	JNZ STRVMS	;        "0".
	MVI B,HEIGHT	;     .
VMS2:	MVI C,LENGTH	;     .
VMS1:	SHLD ADRSPR	; .    ( OUTSPR).
	LDAX D		;      .
	PUSH H
	PUSH B
	PUSH D
	CALL OUTSPR	;    .
	POP D
	POP B
	POP H
	INX D		;      
	INR H		;    
	INR H		;   .
	DCR C		;    ?
	JNZ VMS1	;   -   .
	MOV A,E		;     
	ADI LINEMS-LENGTH ;   ,   
	MOV E,A		;     40*22,    .
	JNC STRSPR	;    -  . .
	INR D		;  .   .
STRSPR:	MOV A,H		;      
	SUI LENGTH*2	;   .
	MOV H,A		; 
	MOV A,L		;     .
	ADI 16		;   = 16   .
	MOV L,A
	DCR B		;   ?
	JNZ VMS2	;   -  ..    .
	JMP EXSVMS	;   - .
STRVMS:	MVI B,LENGTH	;    
STVMS2:	MVI C,HEIGHT	;    .
STVMS1: SHLD ADRSPR	;       .
	LDAX D		;   ""    .
	PUSH B		;      .
	PUSH H
	PUSH D
	CALL OUTSPR	;    .
	POP D		;     .
	LXI H,LINEMS	;      .(.. .).
	DAD D
	XCHG		;  DE -     .
	POP H		;     .
	MOV A,L		;     
	ADI 16		;   .
	MOV L,A
	POP B		;    :
	DCR C		;   ( . ) ?
	JNZ STVMS1	;   -   .
	PUSH B		;  .
	LXI B,LINEMS*HEIGHT ;     . . 
	MOV A,E		;  . .   ( . )
	SUB C
	MOV E,A
	MOV A,D
	SBB B
	MOV D,A
	INX D		;      .
	LXI B,HEIGHT*16	;        ,
	MOV A,L		;         
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	INR H
	INR H		;       .
	POP B		;   
	DCR B		; :   ?
	JNZ STVMS2	;   -    .
EXSVMS: JMP MULTIC
;
MVIDEO:	.dw 0000H	;     .
SCREEN:	.equ 0E030H	;      .
TIPVMS:	.db 00H		;   .
;
LINEMS:	.equ 0040	;      .
LENGTH:	.equ 0016	;  .
HEIGHT:	.equ 0010	;  .
;
;*****************************
;    .
;*****************************
;
GIRL:	LXI H,FONPAL	;      
	CALL MOVPAL	;   .
	MVI A,1
	STA WRPAL
	HLT
	CALL CLEAR	;  .
	LXI H,GIRPAL	;      .
	CALL MOVPAL	;    ..
	MVI A,1		;      ..
	STA WRPAL
	EI
	HLT		;     .
	DI
	CALL SHIRMA	;     .
	LXI H,GIRGRF	;     .
	LXI D,0A000H	;  .
	MVI A,22H	;   .
	STA SHIFR
	CALL REARCH	;    .
	CALL RNDPIC	;      .
	LXI B,0FFFFH	; ,   
DELGRF:	DCX B
	XTHL
	XTHL
	XTHL
	XTHL
	XTHL
	XTHL
	MOV A,B
	ORA C
	JNZ DELGRF
	EI
	HLT
STPGIR:	LDA STATUS	;     .
	CPI 0FFH
	JZ STPGIR
	CALL RNDPIC	;     .
	LXI H,FONPAL
	CALL MOVPAL
	MVI A,1
	STA WRPAL
	CALL CLEAR	;  .
	LXI H,GAMPAL	;    .
	CALL MOVPAL
	MVI A,1
	STA WRPAL
	EI
	HLT
	LDA LIVMEN	;  -   ?
	ORA A
	JNZ NSTART	;   -   .
	JMP START	;   -   .
;
;
;
MOVPAL:	LXI D,COLOR	;   ( HL-. ).
	LXI B,10H
MOVBLK: MOV A,M		;   (HL-, DE-, BC-).
	STAX D
	INX H
	INX D
	DCX B
	MOV A,B
	ORA C
	JNZ MOVBLK
	RET
;
SHIRMA:	DI		;   8000-9FFF  FF, ..
	LXI H,0		;     .
	DAD SP
	LXI SP,0A000H
	LXI B,200H
	LXI D,0FFFFH
SHIRM1:	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	DCX B
	MOV A,B
	ORA C
	JNZ SHIRM1
	SPHL
	EI
	RET
;
;**********************************************
; / 8-  
;   ( )  
;                 .
;**********************************************
;
; /    ().
;       
;  (  0-255).  
;      16- 
;     :
;   =    #(6+8)+(11+15)#.
;    .   
;    - 0000.
;
;     65535 
;  65535 .     . ,
;         
;    -.
;
RNDPIC:	LXI H,0		;     .
RNDPC1:	XCHG		;   DE.( ).
	MOV H,D		;   HL,   DE.
	MOV L,E
RNDTN1:	MOV A,H		;      
	RRC		;     8. 
	RRC
	RRC
	ANI 1FH		;    5- . (.  
	MOV B,A		; 32 .    "".
	MOV A,H		;       ( ) 
	ANI 07		;    "".
	MOV H,B		;     "H" (   "L").
	LXI B,8000H	;   ()  .
	DAD B		;   "HL"   .
	MOV C,A		;   ""    .
	ORA A		;    , 
	MVI A,80H	;        
	JZ PICS1	;     .
PICS2:	RRC		;   -    .
	DCR C
	JNZ PICS2
PICS1:	XRA M		;      . .
	MOV M,A
	XCHG		;      .
	MOV A,L		;  6-   0-  . 
	RLC		; .   .
	RLC
	XRA H		;    2  8- .
	MOV C,A		;  . "" -  6  8 .
	MOV A,H		;  15-   0-  .
	RLC
	MOV B,A		;   "".
	RRC		;  11-   0-  . 
	RRC		; 4 .
	RRC
	RRC
	XRA B		;  .  . -  11  15 .
	XRA C		;   #(6+8)+(11+15)# .  .
	CMA		;  
	ANI 01		;  . (    . ).
	DAD H		;    
	ORA L		;      ..
	MOV L,A
	MOV A,H		;      
	ORA L		;   .
	JNZ RNDPC1
	RET		;  0,   65535 . (  )-
;
;     .
;
GIRPAL:	.db 00,38H,2FH,3FH,0C9H,0FH,0FFH,0CFH
	.db 00,00,00,00,00,00,00,00
;
;   .
;
GAMPAL:	.db 00,00,00,00,7BH,00,00,00,0FFH
	.db 00,00,00,0DEH,00,00,00
;
;  .
;
FONPAL:	.db 00,00,00,00,00,00,00,00
	.db 00,00,00,00,00,00,00,00
;
;************************
;   
;************************
;
;    :
;
;	 "" -  ,   "ADRSPR" -  
;     (    ).
;        .
;
;    :
;
; "BAZATR" -     .
; "STPLOS" -   .
; "BAZGRF" -   .
; "MULT"   -   ,    .
; "BUFSP"  -       .
; "CHMUL"  -  .
; "STMUL"  -     .
; "FAZMUL" -    . 
; 
;
OUTSPR:	ORA A		;   ?
	JZ VACSPR	;   -    .
	ANI 0CFH	; .   .
	CPI WALL	; ?
	JNZ F1
	LXI D,BAZGRF+20H	;   .
	MVI B,3			;  .
	JMP ZERSPR		;   .
F1:	CPI SOIL	;  ?
	JNZ F2
	LXI D,BAZGRF+40H
COLSOI:	MVI B,2		;     "STA COLSOI+1".
	JMP ZERSPR
F2:	MVI B,1		;     - 1.
	CPI STONE	; ?
	JNZ F3
	LXI D,BAZGRF+60H
	JMP ZERSPR
F3:	MOV L,A		;     "L"
	LDA FAZMUL	;    ,
	ANI 3		;   
	MOV C,A		;   . "C".
	MOV A,L
	CPI CRYSTL	;  ?
	JNZ F4
	MOV A,C
	ORA A		;  ?
	JNZ F31		;   -  1-.
	LXI D, BAZGRF+80H
	JMP ZERSPR
F31:	DCR A
	JNZ F32
	LXI D,BAZGRF+0A0H
	JMP ZERSPR
F32:	LXI D,BAZGRF+0C0H
	JMP ZERSPR
F4:	CPI BUTTER	; ?
	JNZ F5
	MOV A,C
	ORA A
	JNZ F41
	LXI D,BAZGRF+1A0H
	JMP ZERSPR
F41:	DCR A
	JNZ F42
	LXI D,BAZGRF+1C0H
	JMP ZERSPR
F42:	LXI D,BAZGRF+1E0H
	JMP ZERSPR
F5:	CPI EXPLOS	; ?
	JNZ F6
	MOV A,C
	ORA A
	JNZ F51
	LXI D,BAZGRF+140H
	JMP ZERSPR
F51:	DCR A
	JNZ F52
	LXI D,BAZGRF+160H
	JMP ZERSPR
F52:	LXI D,BAZGRF+180H
	JMP ZERSPR
F6:	CPI EXIT	; ?
	JNZ F7
	MOV A,C
	ORA A
	JNZ F61
	LXI D,BAZGRF+0E0H
	JMP ZERSPR
F61:	DCR A
	JNZ F62
	LXI D,BAZGRF+100H
	JMP ZERSPR
F62:	LXI D,BAZGRF+120H
	JMP ZERSPR
;
;      .
;
F7:	MOV C,A
	LDA ATRMEN
	RRC		;    4 , 
	RRC		;      
	RRC		;  .
	RRC
	ANI 07H		;   .
	MOV E,A		;     
	ADD A		;   
	ADD E		;   
	MOV E,A		;   "".
	MOV A,C		;   ""   
	SUI MULT	;      .
	MOV C,A		;    
	ADD A
	ADD C
	ADI MULT	;     .  .
	ADD E		;      -
	MOV C,A		;    .  "" ( 1-   3).
	LDA FAZMUL	;       
	ANI 03H		;       .
	ADD C		;   ""      
	MOV C,A		;   .    "".
;
;        .
; (      ,   
;        )
;
ADRGRF:	MOV L,C		;  "HL"     
	MVI H,0		; 32 (    ),  
	DAD H		;     .
	DAD H
	DAD H
	DAD H
	DAD H		;   32.
	LXI D,BAZGRF	;  "DE"    .  
	DAD D		;    "HL".
	XCHG		;      .  "DE".
ZERSPR:	LDA STPLOS	;    .
;
;        "-06"  .
;
	PUSH PSW	;    .
PLOSK:	PUSH D		;      .
	LXI H,0		;     "SP"   "HL".
	DAD SP		;   "SP"    "HL" 
	SHLD BUFSP	;    .
	XCHG		;   "HL"     
	DI
	SPHL		;     .
	LHLD ADRSPR	;   "HL"      .
	MVI C,2		;     .
	MOV A,B		;   "A"   
	RRC		;       .
	MOV B,A		;  ""    .
	JC SAVSPR	;    "1",   .
	LXI SP,BAZGRF	;  "0",   " "   .
;
;       ,   
;       " ".
;
SAVSPR:	POP D		;      .
	MOV M,E		;   ,
	INR L		;     ,
	MOV M,D		;   ,
	INR L		;     .
;
;      7 ,   16   .
;
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
	POP D
	MOV M,E
	INR L
	MOV M,D
	INR L
;
	DCR C		;    ?
	JZ NEXPLS	;   -     .
	MOV A,L		;     
	SUI 16		;     ( )  .
	MOV L,A
	INR H		;       .
	JMP SAVSPR	;     .
;
;    .
;
NEXPLS:	LHLD BUFSP	;    "SP"  .
	SPHL
	EI
	POP D		;   "DE"     .
	POP PSW		;   "A"   .
	DCR A		;    ?
;--------------------------------------------------------------------
	RZ		;      "OUTSPR".
;--------------------------------------------------------------------
	PUSH PSW	;     .
	LHLD ADRSPR	;      "HL".
	MOV A,H		;   
	SUI 20H		;    .
	MOV H,A
	SHLD ADRSPR	;      .
	JMP PLOSK	;     .
;
VACSPR:	LXI H,0		;  "" . (  
	DAD SP		;     ).
	SHLD BUFSP
	LHLD ADRSPR
	MOV A,L
	ADI 16
	MOV L,A
	MOV D,H
	MOV E,L
	LXI B,0
	LDA STPLOS
	DI
VACSP1:	SPHL
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	INR H
	SPHL
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	PUSH B
	DCR A
	JZ RVACSP
	MOV A,H
	SUI 20H
	MOV H,A
	DCR H
	MVI A,1
	JMP VACSP1
RVACSP:	LHLD BUFSP
	SPHL
	EI
	RET			
;
;    .
;
MULTIC:	LDA STMUL	;     .
	DCR A		;   
	STA STMUL	;  .
	RNZ		;   "MULTIC"    .
	LDA CHMUL	;     
	STA STMUL	;    .
	LDA FAZMUL	;     
	RRC		;      .. 
	RRC		;     .
	STA FAZMUL	;     .
	RET		;   / "MULTIC"
;
;-----------------------------------------------------------------
;  ,   ,   "OUTSPR" 
;			"MULTIC".
;-----------------------------------------------------------------
;
MULT:	.equ 04H		;  ,    .
;
ADRSPR:	.dw 0000H	;      .
STPLOS:	.db 01H		;   .
CHMUL:	.db 01H		;  .
FAZMUL:	.db 64H		;   .
STMUL:	.db 01H		;    .
BUFSP:	.dw 0000H	;      "SP".
;
BAZATR:	.db 00H		;    . (0-  .)
	.db 03H		;   ( 3).
	.db 02H		;    ( 2).
	.db 01H		;   ( 1).
	.db 81H		;   ( 1,  ).
	.db 83H		;    .( 3, ..).
	.db 81H		;   (1, ..).
	.db 81H		;   (1, ..).
ATRMEN:	.db 81H		;   (1, .. - 6 ).
	NOP
	NOP
	NOP
	NOP
;
; -    .
;
;	 :
;	HL- 
;	DE- 
;	SHIFR -    
;
;	 :
;	DE- 
;
REARCH:	MOV	A,M
	INX	H
	ORA	A
	PUSH	PSW
	JM	RARC0
	ANI	3FH
	MOV	B,A
	ORA	M
	JZ	DONE
	MOV	C,M
	INX	H
	JMP	RARC1
RARC0:	MVI	B,0
	ANI	3FH
	MOV	C,A
RARC1:	POP	PSW
	ANI	40H
	JZ	MOVS
	MOV	A,M
	INX	H
	PUSH	PSW
RARC2:	POP	PSW
	STAX	D
	INX	D
	PUSH	PSW
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	RARC2
	POP	PSW
	JMP	REARCH
;
MOVS:	LDA SHIFR	;    .
	RRC		;  
	STA SHIFR	; .
	STA GETKOD+1	;    .	
MOVS1:	MOV	A,M
GETKOD:	XRI 00H		;   .
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVS1
	JMP	REARCH
DONE:	POP	PSW
	RET
;
SHIFR:	.db 0CCH		;     ..
;
;
;*******************************
;   
;*******************************
;
;  : "HL" -   ,  
;   00H.  0EH  7-    8-
; ,  0FH   ,    8-
;  .
;
TEXOUT:	MOV A,M		;   
	ORA A		;   .
	RZ		;  ,  .
	CPI 0EH		;   ?
	JZ SET8		;   - .
	CPI 0FH		;  ?
	JZ RESET8	;   -  .
	PUSH B
	MOV C,A		;    "C".
	LDA REGSYM	;    .
	ORA C		;    .
	POP B	
	CALL SYMOUT	;  .
TXOUT1:	INX H		;   .
	JMP TEXOUT	;  .
;
SET8:	MVI A,80H	;  "1"  7-   .
	STA REGSYM
	JMP TXOUT1
;
RESET8:	XRA A		;   .
	STA REGSYM
	JMP TXOUT1
;
REGSYM:	.db 00H		;   .
;	
;
;************************
;    
;************************
;
;     8*8.
;   (      ),
;       4- .
;
;  :	"" -  ,  "COLSYM" -  ,
; (    . - 80H, A0H, C0H, E0H).
;  "PLACE" -     ,   
;  .       .
;   - 31 (1FH).
; 	       , 
;       . 
;   - "CR"   "LF",    01, 02, 04, 08  
;   .    , -
;    ,   
;    ,    
; (     "INIT").
; 	 10H -   ,   11H - .
;
;
SYMOUT:	PUSH H
	PUSH D
	CPI 20H		;   ?
	JC TSWORK	;   -    .
	SUI 20H		; .   .
	MOV L,A		;     8   "HL".
	MVI H,0
	DAD H
	DAD H
	DAD H
	LXI D,ZGSYM	;     "DE"
	DAD D		;       
	XCHG		;     "DE".
	LHLD PLACE	;   "HL"  .
	MOV A,L		;      
	ADD A		; (     ).
	ADD A
	ADD A
	MOV L,A
	LDA COLSYM	;    (  . )
	ADD H		;      .
	MOV H,A		;  "HL"     .
	LDAX D		;  8-    " ". 
INVERT:	NOP		;      .
	MOV M,A		; 
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	INX D
	INR L
	LDAX D
	NOP
	MOV M,A
	LHLD PLACE
	MOV A,H		;    
	CPI 1FH		; :   ?
	JNC LINEFR	;   -   .
	INR H		;   -      .
	JMP WRPLAC	;    .
TSWORK:	CPI 9		;      ?
	JNC TSWRK1	;   -   "CR"  "LF".
	POP D		;      
	POP H		;    (    RET ).
	CPI 1		;   1?
	JZ SCOLS1
	CPI 2		;  2?
	JZ SCOLS2
	CPI 4		;  4?
	JZ SCOLS4
	CPI 8		;  8?
	JZ SCOLS8
	RET		;   /  ,   ..
SCOLS1:	MVI A,0E0H	;     , 
	STA COLSYM	;  1-  .
	RET
SCOLS2:	MVI A,0C0H	;   2- . .
	STA COLSYM
	RET
SCOLS4:	MVI A,0A0H	;   4- . .
	STA COLSYM
	RET
SCOLS8:	MVI A,80H	;   8- . .
	STA COLSYM
	RET
TSWRK1:	LHLD PLACE	;  .
	CPI 0DH		;   ?
	JNZ TSWNEX	;   -    ..
	MVI H,0		;   -     .
	JMP WRPLAC	;    .
TSWNEX:	CPI 0AH		;   ?
	JNZ TSWRK2	;   -  / .
LINEFR:	MVI H,0		;     .
	MOV A,L		;     :
	ORA A		;    (   ?).
	JZ WRPLAC	;   -      .
	DCR L		;   -   .
WRPLAC:	SHLD PLACE	;    .
EXTSYM:	POP D		;   /  .
	POP H
	RET
TSWRK2:	CPI 10H		;    ?
	JZ ONINV	;   - .
	CPI 11H		;   ?
	JZ OFINV
	JMP EXTSYM	;   /     .
ONINV:	MVI A,2FH	;   "CMA"     
	JMP SETINV
OFINV:	XRA A		;   "NOP"     .
SETINV:	PUSH B
	LXI H,INVERT	;  "HL"   - . .
	LXI D,5		;    
	MVI B,8		;   - .
SINVR1:	MOV M,A		;  -.
	DAD D		;  .
	DCR B
	JNZ SINVR1
	POP B
	JMP EXTSYM
;
COLSYM:	.db 00H		;   .
;
PLACE:	.dw 0000H	;  .
;
;
;***************************************
;    4- 
;   "-06".
;***************************************
;
CLEAR:	DI
	PUSH H		;   .
	PUSH B
	PUSH D
	PUSH PSW
	LXI H,0000H	;  HL    SP.
	DAD SP		;   SP    HL.
	LXI SP,0000H	;     0FFFFH.
	LXI D,0000H	;  DE - ,    .
	LXI B,0800H	;  BC - .
CLEAR1:	PUSH D		;     "" .
	PUSH D		;  8  " "  .
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	PUSH D
	DCX B		;    
	MOV A,B		;  .
	ORA C		;  ?
	JNZ CLEAR1	;   -  .
	SPHL		;    SP 
	POP PSW		;  .
	POP D
	POP B
	POP H
	EI
	RET
;
;    "      ."
;
AVTOR:	LXI H,AVTSCR	;    .
AVT0:	LXI D,AVTGRF	;    .
	MVI B,24	;      (. ).
AVT1:	MVI C,18	;  .
AVT2:	LDAX D
	MOV M,A
	MOV A,H
	ADI 20H
	MOV H,A
	LDAX D
	MOV M,A
	MOV A,H
	SUI 20H
	MOV H,A
	INX D
	INR H
	DCR C
	JNZ AVT2
	MOV A,H
	SUI 18
	MOV H,A
	INR L
	DCR B
	JNZ AVT1
	RET
;
AVTSCR:	.equ 0810BH	;     .
;
;     :
;
TEXT1:	.db 08H		;    .
	.db 99H,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,8BH
	.db 8AH
	.db 04H		;  .
	.db "urowenx:   almazy:   wremq:   "
	.db 08H,8AH
	.db 98H,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,9DH,9DH,8CH
	.db 00H		;  .
;
TEXT2:	.db 08H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 99H,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,8BH
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 8AH,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,8AH
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 8AH,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,8AH
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H,20H
	.db 20H,20H,20H,20H,20H,20H
	.db 98H,9DH,9DH,9DH,9DH,9DH
	.db 9DH,9DH,9DH,9DH,9DH,8CH
	.db 00H
;
TEXT3:	.db 04H
	.db " wremq:",11H	;    ":"
	.db 00H
;
TEXT4:	.db 04H
	.db "       ",01H,"  ",00H	;    ":  "
;
TEXT5:	.db 08H
	.db "i}i wyhod",00H	;   ":00"
;
TEXT6:	.db 08H
	.db "         ",00H	;    " "
;
TEXT7:	.db 08H
	.db " na{el ! ",00H	; ,   .
;
;***********************************
;  .  .
;         .
;***********************************
;
START:	DI		;  .	
	LXI SP,100H
	LXI H,FONPAL	; .  .
	CALL MOVPAL
	MVI A,1		;   .
	STA WRPAL
	EI
	HLT
	CALL CLEAR
	MVI A,0FFH
	STA SCROLL	
	LDA TURBO	;    .
	STA BUFTUR
	XRA A		;    ( ).
	STA NUMBL
	STA TURBO	;     "".
	STA DEMO	;    .
	MVI A,1
	STA CHLEV	;   
	CALL LDLEV	;  .
	LXI H,0E05FH	;    ,   .
	SHLD STWIND+1
	LXI H,0C700H	;      .
	CALL AVT0
	CALL OUTTXZ	;   .
	LXI H,ZASPAL	;    
	CALL MOVPAL
	MVI A,1
	STA WRPAL
	MVI A,20	;     
	STA TIMSTR	;  .
	MVI A,200
	STA DEMTIM
ZASTAV:	IN 01		;    
	CMA
	ANI 0E0H
	JZ ZAST01	;      -   .
	RLC
	RLC
	RLC
	ANI 3		;     (  ).
	STA BUFTUR	;   ,     .
	CALL OUTTXZ	;    .
ZAST01:	HLT
	CALL WINDOW	;  .
	CALL PANORM	; .
	CALL TSTPAN	;   .
	LDA PANHOR	;     . .
	ORA A
	JNZ ZAST02	;   ,   .
	LDA INDMEN+1	;   -     .
	XRI 27H		; (.    01H,  27H), 
	STA INDMEN+1	;        .
ZAST02:	LXI H,0C050H	;     .
	LXI B,0510H
ZAST03:	CALL SPRAJT	;    .
	INR H
	INR H
	DCR C
	JNZ ZAST03
	LXI H,0C040H
ZAST04:	CALL SPRAJT	;    .
	MOV A,H
	ADI 30
	MOV H,A
	CALL SPRAJT
	MOV A,H
	SUI 30
	MOV H,A
	MOV A,L
	SUI 10H
	MOV L,A
	DCR B
	JNZ ZAST04
	LXI H,0C200H
	LXI B,0202H
ZAST05:	CALL SPRAJT	;   ,  .
	INR H
	INR H
	DCR C
	JNZ ZAST05
	MOV A,H
	ADI 20
	MOV H,A
ZAST06:	CALL SPRAJT
	INR H
	INR H
	DCR B
	JNZ ZAST06
	HLT
	LDA TIMSTR	;      
	ORA A		; .    - 
	JZ ZAST07	;  .
	DCR A
	STA TIMSTR
	JMP ZASTAV
ZAST07:	LDA STATUS
	CMA
	MOV B,A
	IN 01
	CMA
	ANI 0E0H
	ORA B
	JNZ ZAST13
	LDA DEMTIM
	DCR A
	STA DEMTIM
	JZ ZAST14
	JMP ZASTAV
ZAST13:	MVI A,200
	STA DEMTIM
	LDA KEYKOD
	CPI CR		;  "" ?
	JZ ZAST12	;   -    .
	CPI LF		;  "" ?
	JNZ ZASTAV	;   -   .
ZAST14:	MVI A,1		;   - 
	STA DEMO	;   .
ZAST12:	MVI A,20	;      .
	STA TIMSTR
ZAST08:	HLT
	HLT
	CALL WINDOW	;   ,  
	CALL MOVELM	;  .
	LDA TIMSTR
	ORA A
	JZ ZAST00
	DCR A
	STA TIMSTR
	JMP ZAST08
ZAST00:	LDA BUFTUR	;         .
	STA TURBO
	JMP GSTART
;
SPRAJT:	DI		;       .
	PUSH B
	SHLD ADRSPR
	MVI A,CRYSTL
	CALL OUTSPR
	LHLD ADRSPR
	POP B
	EI
	RET
;
OUTTXZ:	LDA BUFTUR	;      .
	RRC
	JNC ZAST10
	MVI A,10H	;    ,  ""   ( 10).
	STA INVCOL+1	;      ( 11).
	MVI A,11H
	STA INVCTL+1
	STA INVRUS+1
	JMP ZAST9
ZAST10:	RRC
	JNC ZAST11
	MVI A,10H	;  .
	STA INVCTL+1
	MVI A,11H
	STA INVCOL+1
	STA INVRUS+1
	JMP ZAST9
ZAST11:	MVI A,10H	;  .
	STA INVRUS+1
	MVI A,11H
	STA INVCOL+1
	STA INVCTL+1
ZAST9:	MVI A,2
	STA LINEFR+1
	LXI H,0208H
	SHLD PLACE
	LXI H,TEXZAS
	CALL TEXOUT
	XRA A
	STA LINEFR+1
	RET
;
BUFTUR:	.db 00		;     .
TIMSTR:	.db 20		;       .
DEMO:	.db 00		;  .
DEMTIM:	.db 200		;        . .
;	
ZASPAL:	.db 00,3FH,0FH,0DEH,0FFH,00,00,00 ;  .
	.db 38H,00,00,00,00,00,00,00
;
TEXZAS:	.db 04H		; 			 .
	.db "  revim         uprawlenie",0AH,0AH
INVCTL:	.db 1,11H," us",11H,8,"-mono     ",1,"wk",8,"-start/na~alo",0AH
INVCOL:	.db 1,11H," ss",11H,8,"-cwet     ",1,"ps",8,"-demonstraciq",0AH
INVRUS:	.db 1,11H,"rus",11H,8,"-turbo   ",1,"tab",8,"-samoubijstwo",0AH
	.db 00
	
;
;
	.org	1380h
#include "BOLDERbin.asm"
BAZA:			;     880  (40*22).

	.end
