/* Tetris 3d editing figures */
#include <alloc.h>
#include <stdio.h>
#include "drvbas.h"

int Xd,Yd,Zd;		/*   */
int XYmd,Xmd;		/*     */
int ZZ,XX,YY;
int cx,cy;		/*      */
int Eye;
int Psh,Gsh;

char *_Gls;		/*   */
char *_Px,*_Py;		/*      (x,y,z) */
char *dat;		/*     TETFIG.DAT */ 
char *fver,*fcvz;	/*  (40),   */
int nver,ncvz,nblc;	/*  (40*3)  (128),
					 (5*3) (  ) */
char *fblc;		/*   */

char x,y,z;		/*    */
char key,pver;
int xc,yc,zc;
int nfig;
FILE fo;		/*   3dfig.dat */

#define K 128		/*     */

#define Cglass	2
#define Cfig	8
#define Sglass	15
#define Sfig	8

/* 	   X-  (x,y,z)		*/
#define Px(x,y,z) _Px[Psh=(z)*XYmd+(y)*Xmd+x]
/*  ,        */
#define Pxs _Px[Psh]
/*	   Y-  (x,y,z)		*/
#define Py(x,y,z) _Py[Psh=(z)*XYmd+(y)*Xmd+x]
#define Pys _Py[Psh]
/*	    			*/
#define Gls(x,y,z) _Gls[Gsh=((z)*Yd+(y))*Xd+x]
#define Glss _Gls[Gsh]
/*	      			*/

#define Mver	120
#define Mcvz	128
#define Mblc	5*3

#define sgn(x) ((x)>0?1:-1)

main(){
puts("Tetris 3D, Edit Figures\n");
dat=loadf("t3dpal.dat");
opfl();
joindrv();
scolor(dat);
progrm();
quit();
}

char waitkey(){char c; while((c=inkey())==0xFF); return c; }

progrm()
{
int xb,yb,zb,ver;
inLWD();initPxy();
initARR();
nfig=0;
for(;;){
CLFIG:
splan(Sglass);cls();
drGlass();
color(2);cur(38,24);decout(nfig);
pver=-1;
ncvz=nver=nblc=0;
xc=yc=zc=x=y=z=1;
/*    */
for(;;){
do{splan(Sfig);color(Cfig);cls();cir3d(x,y,z,3);
   movmark();
  if(key==27) goto BLC;
  if(key=='D') goto CLFIG;
  }while(!key);
/*   */
if ( (ver=putver(x,y,z))>=0 && putcvz(1,ver) )
	{ color(6);cir3d(x,y,z,1); }

for(;;){
   xb=x;yb=y;zb=z;
  do{splan(Sfig);color(Cfig);cls();cir3d(x,y,z,1);
     plot3d(xb,yb,zb);line3d(x,y,z);
     movmark();
     if(key==27) goto NCVZ;
     if(key=='D') goto CLFIG;
  }while(!key);
  if( (ver=putver(x,y,z))>=0 && putcvz(0,ver) )
	{ color(3);plot3d(xb,yb,zb);line3d(x,y,z); }
 }
NCVZ:;
}
/*  */ 
BLC: 
x=y=z=0;
for(;;){
do{splan(Sfig);color(Cfig);cls();box();
  movmark();
  if(key==27) goto SFL;
  if(key=='D') goto CLFIG;
  }while(!key);
if(putblc(x,y,z)) {color(4);box();}
 }
/*    */
SFL: x=y=z=1;figure();conin();
     wrfl();nfig++;
 }
}

movmark()
{
int dx,dy,dz,m;
for(;;){
	splan(Sglass);
	color(4);cur(38,0);decout(x);
	color(2);cur(38,1);decout(y);
	color(3);cur(38,2);decout(z);
	m=dx=dy=dz=0;
	key=waitkey();
	switch(toupper(key)){
		case 25 : m=dy= 1; break;  /* Up */
		case 26 : m=dy=-1; break;  /* Down */
		case 8  : m=dx=-1; break;  /* Left */
		case 24 : m=dx= 1; break;  /* Right */
		case 31 : m=dz= 1; break;  /* CTP */
		case 12 : m=dz=-1; break;  /* Home */

		case ' ' : case 13 : case 27 : return key;
		case 0   : color(8);splan(Sfig);cur(0,0);
			   spic("wsq figura sotretsq(d/n)?");
			   key=toupper(conin());
			   if (key=='D') return key='D';
				else     return key=0;
		case '0' : quit();
	}
if(m) if ( chkmark(x+dx,y+dy,z+dz) ) { x+=dx; y+=dy; z+=dz; return key=0; }
      }
}

chkmark(x,y,z) char x,y,z;{return ( x<Xd && y<Yd && z<Zd );}

putver(x,y,z) char x,y,z;
{
int i;
x-=xc;y-=yc;z-=zc;
for(i=0;i<nver;i+=3)
 if ( x==fver[i] && y==fver[i+1] && z==fver[i+2] ) return i/3;
if (nver>=Mver)
 { splan(Sfig);cur(0,0);color(8);
   spic("mnogo wer{in PUTVER"); conin(); return 0; }
fver[i=nver]=x;fver[nver+1]=y;fver[nver+2]=z;
nver+=3;
color(4);cur(0,1);spic("NVER ");decout(nver);
return i/3;
}

putcvz(d,ver) int d;char ver;
{
if (pver==ver) return 0;
pver=ver;
if (ncvz>=Mcvz)
 { splan(Sfig);cur(0,0); color(8);
   spic("mnogo swqzej PUTCVZ"); conin(); return 0; }
ver|=d?0x80:0;
fcvz[ncvz++]=ver;
color(3);cur(0,2);spic("NCVZ ");decout(ncvz);
return 1;
}

putblc(x,y,z) int x,y,z;
{
if (nblc>=Mblc)
{ splan(Sfig);cur(0,0);color(8);
  spic("mnogo kubikow PUTBLC"); conin(); return 0; }
fblc[nblc]=(x-xc)*2+1+K;
 fblc[nblc+1]=(y-yc)*2+1+K;
  fblc[nblc+2]=(z-zc)*2+1+K;
nblc+=3;
color(6);cur(0,3);spic("NBLC ");decout(nblc);
return 1;
}

initARR()
{
fver=alloc(Mver);
fblc=alloc(Mblc);
fcvz=alloc(Mcvz);
if(!fcvz) errgrf("net pamqti INITARR");
}

inLWD()
{
Xd=7;Yd=7;Zd=4;
XX=190;YY=240;
cx=128;cy=128;
Eye=180;
}

decout(c)int c;
{char strm[20];sprintf(strm,"%-d",c);spic(strm);}

initPxy()
{
int dx,dy,dz,Dx,Dy,Dz;
int x,y,z,XX2,YY2,mx;
Xmd=Xd+1;XYmd=Xmd*(Yd+1);
_Gls=alloc(Xd*Yd*Zd);
_Px=alloc(XYmd*(Zd+1));	_Py=alloc(XYmd*(Zd+1));
if (!_Py) errgrf("net pamqti INITPXY");
mx=max(Xd,Yd);	XX=(XX/mx)*Xd;YY=(YY/mx)*Yd;
dy=YY/Yd;	dx=XX/Xd;	dz=dx;
XX2=XX/2;	YY2=YY/2;
for(x=0;x<=Xd;x++){ Dx=Eye*(dx*x-XX2);
  for(y=0;y<=Yd;y++){ Dy=Eye*(dy*y-YY2);
    for(z=0;z<=Zd;z++){ Dz=Eye+dz*z;
	Px(x,y,z)=cx+Dx/Dz;Pys =cy+Dy/Dz;
   }  }}
}

drGlass()
{
int x,y,z;
color(Cglass);
for(x=0;x<=Xd;x++)
{ plot3d(x,0,0);line3d(x,0,Zd); 
  plot3d(x,Yd,0);line3d(x,Yd,Zd); }
for(y=1;y<Yd;y++)
{ plot3d(0,y,0);line3d(0,y,Zd); 
  plot3d(Xd,y,0);line3d(Xd,y,Zd); }
for(z=0;z<=Zd;z++)
{ plot3d(0,0,z);box3d(Xd,Yd,z); }
for(x=1;x<Xd;x++){ plot3d(x,0,Zd);line3d(x,Yd,Zd); }
for(y=1;y<Yd;y++){ plot3d(0,y,Zd);line3d(Xd,y,Zd); }
}

box(){
plot3d(x,y,z);box3d(x+1,y+1,z);
plot3d(x,y,z+1);box3d(x+1,y+1,z+1);
plot3d(x,y,z);line3d(x,y,z+1);
plot3d(x+1,y,z);line3d(x+1,y,z+1);
plot3d(x,y+1,z);line3d(x,y+1,z+1);
plot3d(x+1,y+1,z);line3d(x+1,y+1,z+1);
}

figure()
{
char set,*ver,dx,dy,dz;int n;
color(Cfig);splan(Sfig);cls();
for(n=0;n<ncvz;n++){
	set=fcvz[n]&0x80;
	ver=fver+(fcvz[n]&0x7F)*3;
	dx=x+ver[0];dy=y+ver[1];dz=z+ver[2];
	if(set) plot3d(dx,dy,dz);
	else	line3d(dx,dy,dz);
}
}

plot3d(x,y,z) int x,y,z;
{plot(Pxs,Py(x,y,z),1);}
line3d(x,y,z) int x,y,z;
{line(Pxs,Py(x,y,z),0);}
box3d(x,y,z) int x,y,z;
{line(Pxs,Py(x,y,z),B);}
cir3d(x,y,z,r) int x,y,z,r;
{circle(Pxs,Py(x,y,z),r);}

char *loadf(fname) char *fname;
  {
   int rl,rp;char *grf;
   if((rp=open(fname,0))==-1)
      {printf("Can't open file %s",fname);exit(1);}
   printf("Loading...%s\n",fname);
   rl=cfsize(rp);	  /*     */  
   grf=alloc(rl*SECSIZ);
   if(grf==0){puts("No Memory");exit(1);}
   read(rp,grf,rl);
   return grf;
  }

errgrf(s) char *s;
{
splan(15);
color(15);
cur(0,0);spic(s);
conin();
quit();
}

quit()
{
clfl();
splan(15);
exitdos();
}

opfl()
{
if(fcreat("3dfig.dat",&fo)==-1){ puts("Can't open file"); exit(1); }
}

clfl(){todos();fclose(&fo);tograph();}

wrfl()
{
int i;
todos();
putc(nver/3,&fo);
for(i=0;i<nver;i+=3)
	{putc(fver[i],&fo);putc(fver[i+1],&fo);putc(fver[i+2],&fo);}
putc(ncvz,&fo);
for(i=0;i<ncvz;i++){putc(fcvz[i],&fo);}
putc(nblc/3,&fo);
for(i=0;i<nblc;i+=3)
	{putc(fblc[i],&fo);putc(fblc[i+1],&fo);putc(fblc[i+2],&fo);}
tograph();
}
