TITLE	TETRIS2
IF1
	INCLUDE TETDEF.MAC
	INCLUDE IBM.MAC
ENDIF
EXTRN CurrPL,KeyCd,PrevK,ACurr,FStat,X,Y,MCode,BrickM,Line4
EXTRN DelM,DelC,Timer,Field,TempV,SetB,ColCur,LineB,Nfig,Score
	DSEG
CurCl	EQU	(LWhite SHL 4) OR Black
YGmOv	EQU	12
MGmOv:	DB	3,YGmOv,(White SHL 4) OR Blue,'GAME',0
	DB	3,YGmOv-1,(White SHL 4) OR Blue,'OVER',0
Win::	DB	1,12,	(White SHL 4) OR LRed,'Victory!',0
Def::	DB	2,12,	(White SHL 4) OR Green,'Defeat',0
Draw::	DB	3,12,	(White SHL 4) OR Blue,'Draw',0
Virgin::DB	2,12,	LWhite,'Virgin',0
WinF::	DB	0
	CSEG

Progrm::
	CALL	ColLow##
	CALL	Clrscr##
StPl2::
	CALL	DrField##
	LDA	OkDrGl##
	CPI	02
	JZ	OkHigh
WaitOD:
	EI
	LDA	OkDrGl
	CPI	02
	JNZ	WaitOD
	JMP	IngmT2
OkHigh:
	EI
	CALL	ColHigh##
IngmT2::
	CALL	InitGm##	;Initialize Game
Ingm::	
	CALL	BegGm		;Begin exec.Game
InNxM:
	CALL	Init_F##	;
CTET2:
	MVI	B,1		;
	LDA	FStat		;Load DOWN flag
	ANI	DownF		;If installed
	CNZ	MoveDn##	;Offset toward down
	LDA	IndPl##		;
	ORA	A
	JNZ	ContT2
	LDA	Tetr2##
	ORA	A
	JZ	ContT2
	LDA	WinF
	ORA	A
	JZ	IsDeath
	CALL	CloseM
	LXI	H,Def
	JMP	EndM
IsDeath:
	LDA	Death
	ORA	A
	JZ	ContT2
	CALL	CloseM
	LXI	H,OppSc##
	CALL	AddrGB
	MOV	A,M
	ADI	01H
	DAA
	MOV	M,A
	LXI	H,Win
	JMP	EndM
ContT2:
	IN	01
	ANI	040H
	JZ	ContT2
	CALL	GetCh##		;Else load pressed key
	CPI	Nokey		;If not pressed
	JZ	CTET2		;Go to CTET2
	CPI	RotK		;Is pressed rotating key?
	JNZ	No_Rot		;No,Jump
	CALL	Rotate##	;Yes,try rotate figure
	JMP	CTET2		;Go to CTET2
No_Rot:
	CPI	DropK		;Drop key ?
	JZ	CTET2		;Yes,nothing to do
	MVI	D,-1		;No,pressed movement key
	CPI	LeftK		;If left key
	JZ	MoveF		;Move figure toward left
	MVI	D,1		;Else toward right
MoveF:
	CALL	MoveLR##	;Move figure
	JMP	CTET2		;Repeat circle
;
;
;------------------
; Initialize game ;
;------------------
;
	CSEG
BegGm::
	LDA	Tetr2##
	ORA	A
	JNZ	Tetr2I
	CALL	InitCL##
	JMP	OkInit
Tetr2I:
	CALL	InitMn##
OkInit:
	XRA	A
	STA	PrevK
	RET
;
;-------------
; Fill Glass ;
;-------------
;
FillGl::
	MVI	C,10
	MVI	D,01
	MVI	H,01
	LDA	CurrPL
	ORA	A
	JZ	FilLn2
	MVI	D,01EH
	MVI	H,0FFH
FilLn2:
	MVI	E,HGl+YGl
	MVI	B,HGl
	LDA	TempV
FilLn1:
	ORA	A
	CALL	Sprite##
	DCR	E
	DCR	B
	JNZ	FilLn1
	MOV	A,D
	ADD	H
	MOV	D,A
	HLT
	HLT
	DCR	C
	JNZ	FilLn2
	RET
;
;------------
; Clear Glass
; for R.T.
;------------
;
RTerm::
	LXI	B,080FFH
	CALL	FlPlBt
	LXI	B,0A0FFH
	CALL	FlPlBt
	LXI	B,0C0FFH
	CALL	FlPlBt
	LXI	B,0E0FFH
	CALL	FlPlBt
	CALL	ClearG
	RET
;
;---------------
; Mission failed
;---------------
;
	DSEG
Death::	DB	0
	CSEG
OverGm::
	LDA	Tetr2
	ORA	A
	JZ	NoT2
	LDA	IndPl##
	ORA	A
	JNZ	ClGlas
	DI
	LDA	Death
	CMA
	STA	Death
	EI
	HLT
	HLT
	JMP	ClGlas
NoT2:
	DI
	LDA	Ready##
	CMA
	STA	Ready
	EI
ClGlas:
	CALL	CloseM
	CALL	RTerm
	CALL	RTerm
	CALL	RTerm
	LDA	Tetr2
	ORA	A
	JNZ	OvTET2
	CALL	SetHi
	JMP	Ingm
OvTET2:
	XRA	A
	STA	X		;Set failed
	LDA	MCode
	ANI	080H
	JNZ	NoBon1
	LXI	H,Lives##
	CALL	AddrGB
	MOV	A,M
	ADI	099H
	DAA
	JNZ	LostLv		;/
	LDA	IndPl
	ORA	A
	JNZ	GOIP
	MVI	A,1
	STA	EndGm##
	JMP	NoBon1
GOIP:
	LDA	CurrPl
	INR	A
	MOV	D,A
	MVI	E,YGl+YGmOv+2
	LXI	H,0802H
	CALL	PlatMN##
	LXI	H,MGmOv
	CALL	StrGl##
CntGO1:
	CALL	StrC##
	ORA	A
	JNZ	CntGO1
	INX	H
	CALL	StrGl
CntGO2:
	CALL	StrC
	ORA	A
	JNZ	CntGO2
	MVI	B,100
	CALL	Wait
	JMP	IngmT2
LostLv:	
	MOV	M,A
	STA	TempV
NoBon1:
	CALL	ClearG
	LDA	IndPl
	ORA	A
	JNZ	Ingm
	LDA	CurrPl
	INR	A
	MOV	D,A
	MVI	E,14+YGl
	LXI	H,0802H
	CALL	PlatMN##
	LXI	H,Def
	LDA	Death
	ORA	A
	JNZ	OutDef
	LXI	H,Draw
OutDef:
	CALL	StrGl
ContD:
	CALL	StrC##
	ORA	A
	JNZ	ContD
	MVI	B,30
	CALL	Wait
	LDA	EndGm
	ORA	A
	JZ	Ingm
	CALL	ClearG
	JMP	GOIP
;
;---------------
; End of mission
;---------------
SegRol 	EQU	123
EndM::
	LDA	IndPl##
	ORA	A
	JNZ	NoPush
	PUSH	H
NoPush:
	LXI	H,NLevel##
	CALL	AddrGB
	MOV	A,M
	CPI	EndGl
	JZ	Happy2
NoEndG:
	MVI	A,1
	CALL	CloseG
	MVI	A,1
	STA	X		;Set O.K.
	LDA	MCode
	ANI	080H
	JZ	NoBR
	LXI	H,Lives
	CALL	AddrGB
	MOV	A,M
	ADI	01H
	DAA
	MOV	M,A
NoBR:
	LDA	IndPl
	ORA	A
	JNZ	Ingm
	CALL	ClearG
	LXI	H,0802H
	LDA	CurrPl
	INR	A
	MOV	D,A
	MVI	E,14+YGl
	CALL	PlatMN
	POP	H
	CALL	StrGl
ContWD:
	CALL	StrC
	ORA	A
	JNZ	ContWD
	MVI	E,YGl
	MVI	D,0DH
	CALL	CntOut
	MVI	B,50
	CALL	Wait
	LDA	EndGm
	ORA	A
	JZ	Ingm
	CALL	ClearG
	JMP	GOIP
;
;-----------------------
; Out column of sprites
; INPUT:
;  D = X offset glass
;  A = sprite number:
;	0   = space
;	1-3 = roll
;-----------------------
;
OutClm:
	PUSH	PSW
	PUSH	B
	PUSH	D
	MVI	E,YGl+HGl
	MVI	C,HGl
	ORA	A
	JZ	OkNumS
	DCR	A
	ADI	Segrol
OkNumS:
	MOV	B,A
	LDA	CurrPl
	INR	A
	ADD	D
	MOV	D,A
	MOV	A,B
OutCC1:
	ORA	A
	CALL	Sprite##
	DCR	E
	DCR	C
	JNZ	OutCC1
	POP	D
	POP	B
	POP	PSW
	RET
;
;------------
; Clear glass
;------------
;
ClearG::
	LXI	B,08000H
	CALL	FlPlBt
	LXI	B,0A000H
	CALL	FlPlBt
	LXI	B,0E000H
	CALL	FlPlBt
	LXI	B,0C0FFH
	CALL	FlPlBt
	LXI	B,0C000H
	CALL	FlPlBt
	RET
;
;---------------------------
; Fill plate by requared byte
; Input:
;	B = requared plate
;	C = requared byte
;----------------------------
;
FlPlBt::
	HLT
	LXI	H,0000
	DAD	SP
	DI
	SHLD	CountK##
	LDA	CurrPL
	INR	A
	ADD	B
	MOV	H,A
	MVI	A,(HGl+YGl+1) SHL 3
	MOV	D,C
	MOV	E,C
	MVI	C,10
FlNxCl:
	MVI	B,HGl/4
	MOV	L,A
	SPHL
FlNxS:
	REPT	16
	PUSH	D
	ENDM
	DCR	B
	JNZ	FlNxS
	INR	H
	DCR	C
	JNZ	FlNxCl
	LHLD	CountK##
	SPHL
	EI
	HLT
	RET

;------------------
; Test end  mission
;------------------
;
IsEndM::
	LDA	MCode
	ANI	07FH
	RZ
OkIndP:
	CPI	01H
	JNZ	IsEnd2
	CALL	TestM1
	RNZ
	JMP	EndOk
IsEnd2:
	CPI	02H
	JNZ	IsEnd3
	CALL	TestM2
	RNZ
	JMP	EndOk
IsEnd3:
	CPI	03H
	JNZ	IsEnd4
	LDA	SetB
	MOV	B,A
	ANI	NowNew
	RZ
	CALL	TestM3
	RNZ
	JMP	EndOk
IsEnd4:
	CPI	04H
	JNZ	IsEnd5
	CALL	TestM1
	RNZ
	CALL	TestM2
	RNZ
	JMP	EndOk
IsEnd5:
	CPI	05H
	JNZ	IsEnd6
	CALL	TestM1
	JZ	EndOk
	CALL	TestM2
	RNZ
	JMP	EndOk
IsEnd6:
	CALL	TestM1
	JZ	EndOk
	LDA	SetB
	MOV	B,A
	ANI	NowNew
	RZ
	CALL	TestM3
	RNZ
	JMP	EndOk
EndOk:
	CALL	CloseM
	POP	H
	POP	H
	POP	H
	LDA	IndPl
	ORA	A
	JNZ	EndM
	LXI	H,OppSc
	CALL	AddrGB
	MOV	A,M
	ADI	01H
	DAA
	MOV	M,A
	INX	H
	DI
	LDA	WinF
	CMA
	STA	WinF
	EI
	HLT
	HLT
	LDA	WinF
	ORA	A
	JZ	OkDraw
	LXI	H,Win
	JMP	EndM
OkDraw:
	LXI	H,Draw
	JMP	EndM
;
;----------------
; Test end D.A.B.
;----------------
;
TestM1:
	LDA	LineB
	ORA	A
	RET
;
;----------------
; Test end F.Y.Q.
;----------------
;
TestM2:
	LDA	FStat
	ANI	LineQ
	RET
;
;-----------------
; Test end S.NN F.
;-----------------
;
TestM3:
	MOV	A,B
	ANI	NOT NowNew
	STA	SetB
	LDA	CurrPL
	ADI	9
	MOV	D,A
	MVI	E,HGl+YGl+2
	MVI	A,LRed
	STA	ColCur
	LDA	Nfig
	MOV	B,A
	CALL	OutZNP##
	MOV	A,B
	ORA	A
	RET
;
;----------------------
; Erase mission message
;----------------------
;
	DSEG
ClearS:
	REPT	10
	DB	' '
	ENDM
	DB	0
;
	CSEG
CloseM::
	LDA	CurrPL
	INR	A
	MOV	D,A
	MVI	E,HGl+YGl+2
	MVI	A,Black
	STA	ColCur
	LXI	H,ClearS
	CALL	ColStr##
	LXI	H,Line4
	XRA	A
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	CALL	OutLn##
	MVI	D,0CH
	LDA	CurrPl
	ORA	A
	JZ	ClMP1
	MVI	D,012H
ClMP1:
	MVI	A,Black
	STA	ColCur
	MVI	B,02
	MVI	A,' '
ClMC2:
	MVI	E,YGl+6
	MVI	C,05
ClMC1:
	CALL	ColChr##
	DCR	E
	DCR	C
	JNZ	ClMC1
	INR	D
	DCR	B
	JNZ	ClMC2
	RET
;
;--------------
; Print message
;--------------
;
SegPFD	EQU	106
	CSEG
OutPF::
	MVI	E,YGl+5
	LDA	CurrPl
	ADI	02H
	MOV	H,A
	MVI	B,4
	MVI	A,SegPFD
OutPF1:
	MOV	D,H
	MVI	C,8
OutPFC:
	STC
	CALL	Sprite##
	INR	A
	INR	D
	DCR	C
	JNZ	OutPFC
	DCR	E
	DCR	B
	JNZ	OutPF1
	RET
;
;-------------
; Wait
;------------
;
Wait::
	LDA	KeyCd
	CPI	RotK
	JZ	ExWait
	CPI	DropK
	JZ	ExWait
	HLT
	DCR	B
	JNZ	Wait
ExWait:
	RET
;
;------------------------
; Solve Game Buf. address
;------------------------
;
AddrGB::
	PUSH	PSW
	PUSH	D
	LDA	CurrPl
	MOV	E,A
	MVI	D,0
	DAD	D
	POP	D
	POP	PSW
	RET
;
ColBW	EQU	(White SHL 4) OR Blue
ColGW	EQU	(White SHL 4) OR LRed
ColRW	EQU	(White SHL 4) OR Green
CntOut::
	LXI	H,OppSc
	MOV	B,M
	MOV	A,L
	ADI	014H
	MOV	L,A
	JNC	NoChC
	INR	H
NoChC:
	MOV	C,M
	MOV	A,B
	CMP	C
	JNZ	SetNB
	MVI	H,ColBW
	MVI	L,ColBW
	JMP	OutCnt
SetNB:
	JNC	SetGR
	MVI	H,ColRW
	MVI	L,ColGW
	JMP	OutCnt
SetGR:
	MVI	H,ColGW
	MVI	L,ColRW
OutCnt:
	MOV	A,H
	STA	ColCur
	MOV	A,B
	PUSHA
	CALL	OutZNP##
	POPA
	MOV	A,D
	ADI	04
	MOV	D,A
	MOV	A,L
	STA	ColCur
	MOV	A,C
	CALL	OutZNP
	RET
;
;------------
; Close glass
;  A = sprite
; (0 or 1)
;------------
CloseG::
	MOV	C,A
	MVI	E,YGl+1
	MVI	B,HGl
	LDA	CurrPl
	INR	A
	MOV	H,A
	MOV	A,C
	ADI	SegRol
EndMC1:
	MOV	D,H
	MVI	C,10
EndMC2:
	ORA	A
	CALL	Sprite##
	INR	D
	DCR	C
	JNZ	EndMC2
	HLT
	INR	E
	DCR	B
	JNZ	EndMC1
	RET
;
;----------
; Happy end
;----------
;
	DSEG
Access:	DB	3,18,	LRed,'ACES      HIGH',0
	DB	2,14,	LGreen,'ACCESS  '
	DB	'              to              '
	DB	'  ELITE   TETERIZERS',0
SegMed	EQU	125
	CSEG
;
Happy::
	DI
	LDA	Ready
	CMA
	STA	Ready
	EI
	XRA	A
	CALL	CloseG
	CALL	ClearG
	LXI	H,Access
	CALL	StrGl
ContHp:
	CALL	StrC
	ORA	A
	JNZ	ContHp
	INX	H
	CALL	StrGl
ContH2:
	CALL	StrC
	ORA	A
	JNZ	ContH2
	MVI	E,YGl+6
	MVI	C,4
	LDA	CurrPl
	ADD	C
	MOV	H,A
	MVI	A,SegMed
HapC1:
	MOV	D,H
	MVI	B,4
HapC2:
	ORA	A
	CALL	Sprite##
	INR	A
	INR	D
	DCR	B
	JNZ	HapC2
	DCR	E
	DCR	C
	JNZ	HapC1
	CALL	SetHi
HapWat:
	LDA	KeyCd##
	CPI	Nokey
	JZ	HapWat
	CPI	LeftK
	JZ	HapWat
	CPI	RightK
	JZ	HapWat
	LDA	Tetr2
	ORA	A
	JZ	Ingm
	CALL	InitOp##
	JMP	Ingm
;
;-----------------------
; Happy end for tetris 2
;-----------------------
Happy2:
	LDA	IndPl
	ORA	A
	JNZ	Happy
	POP	H
	LDA	Death
	ORA	A
	JNZ	NoEndG
	MVI	D,0DH
	MVI	E,YGl
	CALL	CntOut
	JMP	Happy
Ubogo:
	
;
;------------
; Set hiscore
;------------
SetHi:
	LXI	H,ScoreC##
	CALL	AddrGB
	LXI	D,Score
	MVI	C,3
OvGm0:
	LDAX	D
	INX	D
	MOV	M,A
	INX	H
	DCR	C
	JNZ	OvGm0
	LXI	D,Score
	LXI	H,HighSc##
	MVI	C,3
OvGm1:
	LDAX	D
	INX	D
	MOV	B,A
	MOV	A,M
	INX	H
	CMP	B
	JNZ	OvSHS
	DCR	C
	JNZ	OvGm1
	JMP	SetHiR
OvSHS:
	JNC	SetHiR
	MVI	C,3
	LXI	D,HighSc+2
	LXI	H,Score+2
	DI
OvGm2:
	MOV	A,M
	DCX	H
	STAX	D
	DCX	D
	DCR	C
	JNZ	OvGm2
	EI
SetHiR:
	RET
;
	END
