TITLE	HI	(FUNC)
;-------------------------------
; Functions:
;	Hi
; Variables:
;	Color	ColAdr	Bord	Scrol	
;	CPort	Time	KeyCd
;-------------------------------
	IF1
        INCLUDE TETDEF.MAC
	INCLUDE	IBM.MAC
	ENDIF
SUBTTL	Interrupt Handler
;-------------------------------
;    DEF.MAC
;-------------------------------
	DSEG
Color::	DB	000H,080H,0C0H,0D0H,018H,028H,038H,02DH
	DB	036H,07FH,00CH,00EH,007H,05BH,0ADH,0FFH
ColAdr::DW	Color+0FH	;   
Bord::	DB	0		; 
Scrol::	DB	0FFH		;     ()
CPort::	DB	2		;     C

Field1:	REPT	200	;DS	200		;Field for player 1
	DB	0
	ENDM
Field2:	REPT	200	;DS	200		;For player 2
	DB	0
	ENDM

Time::	DW	0		; ,  (0000H - FFFFH)
Tetr2::	DB	0		;1=Tetris II
				;0=Normal Tetris
IndPl::	DB	1		;1=Independ players
				;0=...
Ready::	DB	0		;Ready for another players

EndGm::	DB	0		;Flag of game over state
DelDrop	EQU	2		;DROP delay

BuffCP::			;Buffer for current  player
CurrPL::DB	0		;Current Player
KeyCd::	DB	0		;Key code
PrevK::	DB	0		;Previous pressed key
Field::	DW	Field1		;Field address
FStat::	DB	11000000B	;
ACurr::	DW	0000H		;Current figure pointer
FSprt::	DB	0		;Current sprite
SetB::	DB	00010001B	;
DelM::	DB	030		;Current mission delay 
DelC::	DB	030		;Current delay
Timer::	DB	0		;Delay counter
CountK::DW	PressW		;Delay for keyboard
TempV::	DB	0		;Temporary variable
ColCur::DB	0
X::	DB	0
Y::	DB	0
Score::	DB	0,0,0
Line4::	DB	0,0,0,0
LineB::	DB	0
BrickM::DB	0
MCode::	DB	0
Nfig::	DB	0

BuffSP: 			;for second player
PLS:	DB	014H
KeyCd2:	DB	0
PrevK2:	DB	0
FieldS:	DW	Field2
FStat2:	DB	00000000B
ACurr2:	DW	0000H
Fsprt2:	DB	0
SetB2:	DB	01000010B
DelM2:	DB	030
DelS:	DB	030
Timer2:	DB	0
CounK2:	DW	PressW
TempV2:	DB	0
ColCu2:	DB	0
X2:	DB	0
Y2:	DB	0
Score2:	DB	0,0,0
Line42:	DB	0,0,0,0
LineB2:	DB	0
Brick2:	DB	0
MCode2:	DB	0
Nfig2:	DB	0

;Keys codes

KeyP2::	DS	8
KeyP1::	DS	8

;Mouse mask

MaskM::
	DB	00000010B
	DB	00000001B
	DB	01000000B
	DB	10000000B

;Joystick mask

MaskJ::
	DB	00010000B
	DB	01000000B
	DB	00001000B
	DB	00100000B

AdrSt::	DW	Stack2
;-------------------------------
	CSEG
Hi::	PUSHA

	LXI	D,KeyCd
	LXI	H,KeyCd2
	LDA	CurrPl
	ORA	A
	JZ	KdisP1
	XCHG
KdisP1:
	PUSH	H
CtrlP1::
	LXI	H,KeyP1
	CALL	ScanK		;Scan key for player 1
	POP	D
CtrlP2::
	LXI	H,MaskJ
	CALL	USPIDR		;Scan key for player 2

	MVI	A,1011B
	OUT	04H
	MVI	A,1010B
	OUT	04H

	CALL	FLAGP		;set flags for current  player
	LXI	H,BuffCP	;Load BuffCP address
	LXI	D,BuffSP	;Load BuffSP address
	MVI	B,BuffSP-BuffCP	;Set counter
SWAPBF:
	MOV	C,M
	LDAX	D
	MOV	M,A
	MOV	A,C
        STAX    D
        INX     H
        INX     D
        DCR     B
	JNZ	SWAPBF

	CALL	FLAGP		;Set flags for another player

	LHLD	Time		;  
	INX	H
	SHLD	Time

	LXI	H,0000
	DAD	SP
	XCHG
	LHLD	ADRST
	SPHL
	XCHG
	SHLD	ADRST

	MVI	A,88H
	OUT	00H

	XRA	A	;  
	OUT	02H

	LDA	Scrol	;  
	OUT	03H

	LDA	CurrPl
	ORA	A
	JNZ	ExitHi

	IN	01
	ANI	0E0H
	JZ	Init##
ExitHi:
	POPA
	EI
	RET
;
;-------------------
; Set palette,border,etc.
;-------------------

SETPAL::
	MVI	A,RET
	STA	VecInt
	EI
	HLT
	DI
	MVI	A,88H
	OUT	00H
	MVI	B,0FH
	LHLD	ColAdr
hi1:	MOV	A,B		;  
	OUT	02H 
	MOV	A,M
	OUT	0FH
	OUT	0FH
	OUT	0FH
	OUT	0FH
	OUT	0FH
	DCX	H
	OUT	0FH
	DCR	B
	OUT	0FH
	JP	hi1
	MVI	A,JMP
	STA	VecInt
	MVI	A,088H
	OUT	00
	LDA	Scrol
	OUT	03
	EI
	RET
;
;-------------------
; Define pressed key
;  DE = address
;  HL = keys list
;-------------------
ScanK::
	MVI	C,01H
	MVI	A,8AH
	OUT	00H
SCANC1:
	MOV	A,M
	INX	H
	OUT	03H
	IN	02H
	MOV	B,M
	INX	H
	ANA	B
	JZ	EXITS1
	INR	C
	MOV	A,C
	CPI	05H
	JNZ	SCANC1
EXITS1:
	MOV	A,C
	STAX	D
	RET
;
;------------------------
; Define flags
;------------------------
FLAGP:
	LDA	Timer		;
	ORA	A		;
	JZ	NOTM		;
	DCR	A		;
	STA	Timer		;
NOTM:
	LDA	FStat
	MOV	B,A
	ANI	DropF		;Test DROP flag
	JNZ	NODROP		;Jump,flag is setting
	LDA	KeyCd		;Else
	SUI	DropK		;Is DROP key pressed
	JNZ	NODROP		;No,Jump
	MOV	A,B		;Yes,
	ORI	DropF		;
	STA	FStat		;Set DROP flag,
	MOV	B,A		;
	XRA	A		;
	STA	DelC		;Current delay flag,
NODROP:	
	MOV	A,B		;
	ANI	DownF		;Is DOWN flag setting ?
	RNZ			;Yes,exit
	LDA	DelC		;No,
	ORA	A		;DOWN flag
	JZ	SETFL		;Just now set flag,jump
	DCR	A		;Else increment
	STA	DelC		;Timer flag
	RET
SETFL:
	MOV	A,B		;Set
	ORI	DownF		;DOWN flag
	STA	FStat		;
	RET			;
;
;----------------
; Read mouse stat
;  DE = Address
;  HL = mask
;----------------
;
MouseR::
	MVI	A,10000010B
	OUT	04H
	IN	06
	CMA
	MOV	B,A
JM:
	MVI	C,1
MousC1:
	MOV	A,M
	INX	H
	ANA	B
	JNZ	ExitMR
	INR	C
	MOV	A,C
	CPI	05
	JNZ	MousC1
ExitMR:
	MOV	A,C
	STAX	D
	RET
;
;-------------------
; Read joystick stat
;-------------------
;
USPIDR::
	MVI	A,11010000B
	OUT	4
	IN	7
	MOV	B,A
	JMP	JM
;
	END

