	TITLE	Missions
;
; Decoder of mission
; 
IF1
	INCLUDE IBM.MAC
	INCLUDE TETDEF.MAC
ENDIF
;
	DSEG
GameBf::

MPtr::		DW	MisPtr##	;Pointer of mission
NLevel::	DB	0		;Level number
Lives::		DB	5		;Lives number
NRain::		DB	0		;For rainbow
RanN::		DW	0101H		;Random number for same figures
OppSc::		DB	0		;Score for opponents game type
SelX::		DB	0		;X for 'Select'
SelY::		DB	10		;Y for 'Select'
NSpeed::	DB	0		;Speed for classic tetris
ScoreC::	DB	0,0,0		;Score for classic tetris
FlagW::		DB	0		;Flag of win of opponents
TailB:		DS	5		;Tail of buffer(reserved)

MPtr2:		DW	MisPtr		;Same
NLev2:		DB	0 		;variables
Lives2:		DB	5		;for right
NRain2:		DB	0		;player
RanN2:		DW	0101H
OppSc2:		DB	0
SelX2:		DB	0
SelY2:		DB	10
NSp2:		DB	0
Sc2:		DB	0,0,0
FlagW2:		DB	0
TailB2:		DS	5

;
M01:	DB	1,12,	LRed,	'Destruct',0
M02:	DB	1,12,	LGreen,	'Fulfill  your quota',0
M03:	DB	1,12,	LBlue,	'Survive',0
M031:	DB	3,11,	LBlue,	'figures',0
MSec:	DB	'FIGURES:',0
MLives:	DB	1,18,	LGreen,	'You have',0
MManyL:	DB	4,17,	LGreen,	'lives',0
MOneL:	DB	0,17,	LRed,	'one life !',0
MAnd:	DB	3,10,	LBlue,	'and',0
MOr:	DB	4,10,	LYellow,	'or',0
BonL1:	DB	1,15,	(Red SHL 4) OR LWhite,' BONUS  ',0
BonL2:	DB	1,14,	(Red SHL 4) OR LWhite,'  LEVEL ',0
OkBnL1:	DB	1,15,	(Green SHL 4) OR LWhite,' BONUS  ',0
OkBnL2:	DB	1,14,	(Green SHL 4) OR LWhite,'   LIFE ',0
NoBnL1:	DB	1,15,	(LBlue SHL 4) OR LWhite,'NO BONUS',0
MlastL:	DB	0,15,	LWhite,'Last level',0
EmptyL:	DB	1,1,0,0
;
	CSEG
InitMn::
	CALL	ClearG##
	CALL	InitGl##
	XRA	A
	STA	LineB##
	LDA	MCode##			;Save previos
	STA	Y##			;mission type to Y
	LXI	H,NLevel		;Increase
	CALL	AddrGB##		;level
	MOV	A,M			;number
	CPI	EndGL
	JNZ	OkChNL
	LXI	H,LastLv##
	JMP	NxMs
OkChNL:
	ADI	01H
	DAA
	MOV	M,A			;Save new level value
NoChNL:
	LXI	H,MPtr			;Set pointer
	CALL	AddrGB			;of missions
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG				;HL = mission pointer
NxMs:
	MOV	A,M
	INX	H
	STA	MCode##			;Save mission code
	MOV	A,M
	INX	H
	STA	DelM##			;Save speed of figure
	MOV	A,M
	INX	H			;Save number of figures
	STA	Nfig##			;for 'Survive NN figures'
	MOV	A,M
	INX	H
	ORA	A			;Test flag of quota
	JZ	NoQuot			;Jump for 'not present'
	LXI	D,Line4##		;Else
	MVI	C,4			;set quota
InSetQ:
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	InSetQ
NoQuot:
	MOV	A,M
	INX	H
	ORA	A			;Test flag of glass state
	JZ	InEndM			;Jump for 'Glass is clear'
	STA	BrickM##		;Else it is brick
InC1:					;for 'Destruct ...'
	MOV	A,M
	INX	H			;Test flag of filling
	CPI	0FFH			;0FFH = end
	JZ	InEndM			;else line number is
	XCHG
	LHLD	Field##
	XCHG
	ADD	A
	MOV	B,A
	ADD	A
	ADD	A
	ADD	B
	ADD	E
	MOV	E,A
	JNC	InNoC
	INR	D
InNoC:
	MVI	C,5
InC2:
	MOV	A,M
	INX	H
	MOV	B,A
	RRC
	RRC
	RRC
	RRC
	CALL	SetBIF
	MOV	A,B
	CALL	SetBIF
	DCR	C
	JNZ	InC2
	JMP	InC1			;Jump for next line analys
InEndM:
	XCHG
	LXI	H,MPtr			;Save new
	CALL	AddrGB			;new mission pointer
	MOV	M,E
	INX	H
	MOV	M,D
;
;Print messages
;
PrMess:
	MVI	A,LWhite
	STA	ColCur
	LXI	H,NLevel		;Print
	CALL	AddrGB##		;level number
	MOV	B,M
	MVI	E,HGl+YGl+4
	LDA	CurrPL##
	ADI	8
	MOV	D,A
	MOV	A,B
	CALL	OutZNP##
	LXI	H,MLives		;Print
	CALL	StrGl			;lives number
ContLv:
	CALL	StrC
	ORA	A
	JNZ	ContLv
	LXI	H,Lives
	CALL	AddrGB
	MOV	A,M
	CPI	01H
	JZ	OneLv
	MOV	B,A
	LDA	CurrPL
	ADI	02H
	MOV	D,A
	MVI	E,YGl+18
	MVI	A,LRed
	STA	ColCur
	MOV	A,B
	CALL	OutZNP##
	LXI	H,MManyL
	JMP	ContL
OneLv:
	LXI	H,MOneL
ContL:
	CALL	StrGl
ContL1:
	CALL	StrC
	ORA	A
	JNZ	ContL1
	LDA	Y		;Read previos game code
	ANI	080H		;Test flag of bonus
	JZ	PrNoBL		;Jump for 'no bonus level'
	LXI	H,OkBnL2	;Else
	PUSH	H
	LXI	H,OkBnL1
	LDA	X##		;read previous game status
	ORA	A		;Test for success game end
	JNZ	PrMBon		;Jump for O.K.
	POP	H		;Else
	LXI	H,EmptyL	;Set 'No bonus'
	PUSH	H
	LXI	H,NoBnL1
	JMP	PrMBon
;
PrNoBL:
	LDA	MCode		;Test present game code
	ANI	080H		;for bonus level
	JZ	NoBon		;Jump for 'no bonus level'
	LXI	H,BonL2		;Else
	PUSH	H		;Print 'Bonus level'
	LXI	H,BonL1
PrMBon:
	CALL	StrGl
ContB1:
	CALL	StrC
	ORA	A
	JNZ	ContB1
	POP	H
	CALL	StrGl
ContB2:
	CALL	StrC
	ORA	A
	JNZ	ContB2
NoBon:
	LXI	H,NLevel		;Test for last level
	CALL	AddrGB
	MOV	A,M
	CPI	EndGl
	JNZ	PrPrFD			;Jump for 'no last level'
	LXI	H,MLastL		;Else print 'Last level'
	CALL	StrGl
WOutLL:
	CALL	StrC
	ORA	A
	JNZ	WOutLL
PrPrFD:
	CALL	OutPF##			;Print 'FIRE:PLAY,DROP:MENU'
	LDA	MCode			;Test mission code
	ANI	07FH
	CPI	01H			;Destroy all bricks
	JNZ	InTst2
	CALL	OutDAB			;Print 'Destruct ...'
	LXI	H,M01
	CALL	StrGl
	ORA	A
	JNZ	InNKey
	CALL	Miss01
	JMP	KeyYes
InTst2:
	CPI	02H			;Fulfill your quota
	JNZ	InTst3
	CALL	OutFYQ			;Print quota
	CALL	Miss02			;Print 'Fullfil your quota'
	LXI	H,M02
	JMP	InNKey
InTst3:
	CPI	03H			;Survive NN figures
	JNZ	InTst4
	CALL	OutSNF			;Print number of figures
	CALL	Miss03			;Print 'Survive ...'
	ORA	A
	JNZ	KeyYes
	JMP	InNKey
InTst4:
	CPI	04H			;D.A.B. and/or F.Y.Q.
	JZ	OkTst4
	CPI	05H
	JNZ	InTst6
	CALL	OutDoF
	JMP	OkT41
OkTst4:
	CALL	OutD&F
OkT41:
	CALL	Miss02
	LXI	H,M01
	CALL	StrGl
	ORA	A
	JNZ	KeyYes
	CALL	Miss01
	LDA	MCode
	ANI	07FH
	CPI	04H
	JNZ	OkTst5
	LXI	H,MAnd
	JMP	Cont45
OkTst5:
	LXI	H,MOr
Cont45:
	CALL	StrGl
	ORA	A
	JNZ	KeyYes
	LXI	H,M02
	CALL	DefXYC
	DCR	C
	DCR	C
	DCR	C
	CALL	StrGl1
	JMP	KeyYes
InTst6:
	CPI	06H			;D.A.B. or S. NN F.
	JNZ	InTst7
	CALL	OutDoS
	CALL	Miss03
	ORA	A
	JNZ	KeyYes
	CALL	StrGl
	ORA	A
	JNZ	KeyYes
	LXI	H,MOr
	CALL	StrGl
	ORA	A
	JNZ	KeyYes
	LXI	H,M01
	CALL	DefXYC
	DCR	C
	DCR	C
	DCR	C
	CALL	StrGl1
	ORA	A
	JNZ	KeyYes
	CALL	Miss01
	JMP	KeyYes
InTst7:					;It is reserved for another missions
InNKey:
	CALL	StrGl
KeyYes:
	LDA	KeyCd			;Wait
	CPI	RotK			;Test for FIRE key
	JZ	BegM			;Jump for begin of mission
	CPI	DropK			;Test for DROP key
	JZ	MMenu			;Jump for menu
	CALL	StrC
	JMP	KeyYes
MMenu:
	CALL	Menu##
	CALL	ClearG
	JMP	PrMess
BegM:
	LDA	IndPl##			;Test for I.P.
	ORA	A
	JNZ	InitGF			;Jump for I.P.
	CALL	TestRd##		;Else 'Wait for opponent'
	XRA	A
	STA	Death##
	STA	WinF##
InitGF:
;	LXI	H,GameBf+6
;	CALL	AddrGB
;	MVI	M,0
	MVI	E,HGl+YGl
	LHLD	Field
	MOV	A,L
	ADI	10*HGl-1
	MOV	L,A
	JNC	InOkC
	INR	H
InOkC:
	MVI	B,HGl
	MVI	C,10
InC4:
	PUSH	B
	LDA	CurrPL
	INR	A
	ADI	9
	MOV	D,A
	CALL	Rainbow
	MVI	B,0
InC3:
	LDA	BrickM
	CMP	M
	JNZ	InNBr
	MVI	B,1
InNBr:
	MOV	A,M
	DCX	H
	ORA	A
	JNZ	InOutS
	LDA	SetB##
	ANI	BSprt
InOutS:
	ORA	A
	CALL	Sprite##
	DCR	D
	DCR	C
	JNZ	InC3
	LDA	LineB
	ADD	B
	STA	LineB
	POP	B
	DCR	E
	DCR	B
	JNZ	InC4
	RET
;
;--------------------------
; Print string to glass
; Input:
;	BC = X,Y in glass
;	HL = String address
; Output:
;	All registers
;	 are damaged
;--------------------------
;
StrGl::
	CALL	DefXYC		;Read  X,Y and set color
StrGl1::
	MOV	A,B		;
	CPI	10		;Test overrange X
	JC	StrGl2		;Normally,jump
	MVI	B,0		;Else X=0
	DCR	C		;Y=Y-1
	RZ			;If overrange Y,exit
StrGl2:
	LDA	CurrPL		;Convert
	INR	A		;X
	ADD	B		;to
	MOV	D,A		;absolute coordinate
	MVI	A,YGl+1		;Convert
	ADD	C		;Y to
	MOV	E,A		;absolute coordinate
	MVI	A,4		;Wait
	STA	Timer##		;for 4 interrupt
	INX	H
	LDA	KeyCd##
	CPI	DropK
	RZ			;Return for DROP key
	CPI	RotK
	RZ			;Return for FIRE key
	MOV	A,M		;Test for
	CPI	020H		;symbol 'space'
	JZ	IgnSpc		;Jump,no print space
StrC::
	LDA	Timer##
	ORA	A
	JNZ	StrC
	MOV	A,M		;Read symbol
	ORA	A		;Is end of string?
	RZ			;Yes,exit
PrSym:
	PUSH	PSW
	LDA	SoundS##	;
	ORA	A		;
	CNZ	PWrite##	;Sound of paper writer
	POP	PSW
IgnSpc:
	CALL	ColChr##	;Out symbol
	INR	B		;Increment X coordinate
	JMP	StrGl1		;Repeat
;
;---------------------------       
; Define X,Y,Color for StrGl
; Input:
;	HL=String address
; Damaged: A,BC,HL
;---------------------------
;
DefXYC::
	MOV	B,M		;Read X
	INX	H		;Locate for Y
	MOV	C,M		;Read Y
	INX	H		;Locate for color
	MOV	A,M		;Save
	STA	ColCur##	;Color to COLCUR
	RET			;Return
;
;---------------------
; Print destroy blocks
; Input:
;	DE = X & Y
; Damage: A,B,DE
;---------------------
;
Miss01:
	DCR	E
	LDA	CurrPl
	ADI	02H
	MOV	D,A
	LDA	BricKM
	MVI	B,8
CM01:
	ORA	A
	CALL	Sprite##
	INR	D
	DCR	B
	JNZ	CM01
	RET
;
;---------------------
; Print quota in table
; Input: NONE
; Damage: A
;---------------------
;
Miss02:
	LDA	FStat##		;Set
	ORI	LineQ		;quota
	STA	FStat		;flag
	CALL	OutLn##		;Print quota
	RET
;
;-----------------------
; Print figures quantity
; Input: NONE
; Damage: ALL
;-----------------------
;
Miss03:
	LDA	CurrPL
	INR	A
	MOV	D,A
	MVI	E,HGl+YGl+2
	MVI	A,LBlue
	STA	ColCur
	LXI	H,MSec
	CALL	ColStr##
	MVI	A,LRed
	STA	ColCur
	LDA	Nfig
	CALL	OutZNP##
	LXI	H,M03
	CALL	StrGl
	ORA	A
	JNZ	M03Pr
	MVI	A,LRED
	STA	ColCur
	MVI	E,YGl+12
	LDA	CurrPL
	INR	A
	MOV	D,A
	LDA	Nfig
	CALL	OutZNP##
	LXI	H,M031
	XRA	A
M03Pr:
	RET
;
;---------------------
; Print Rainbow ribbon
; Input:
;	E = Y
;	C = 10
; Damage: NONE
;---------------------
;
Rainbow::
	PUSHA
	LXI	H,NRain
	CALL	AddrGB
	LDA	CurrPl
	INR	A
	MOV	D,A
	MOV	A,M
	ADI	96
RC1:
	CPI	111
	JNZ	RainPS
	MVI	A,96
RainPS:
	ORA	A
	CALL	Sprite##
	INR	A
	INR	D
	DCR	C
	JNZ	RC1
	HLT
	MOV	A,M
	INR	A
	CPI	15
	JNZ	RainOH
	XRA	A
RainOH:
	MOV	M,A
	POPA
	RET
;
YPicM	EQU	YGl+5
StPic	EQU	111
;
;--------------------
; Print D.A.B. sprite
;--------------------
OutDAB:
	MVI	E,YPicM
	MVI	B,StPic
	CALL	OutPic
	RET
;
;--------------------
; Print F.Y.Q. sprite
;--------------------
OutFYQ:
	MVI	E,YPicM
	MVI	B,StPic+4
	CALL	OutPic
	RET
;
;--------------------
; Print S.N.F. sprite
;--------------------
OutSNF:
	MVI	E,YPicM
	MVI	B,StPic+8
	CALL	OutPic
	RET
;
OutD&F:
	CALL	OutDAB
	CALL	OutAnd
PrPFYQ:
	MVI	E,YPicM-3
	MVI	B,StPic+4
	CALL	OutPic
	RET
;
OutDoF:
	CALL	OutDAB
	CALL	OutOr
	JMP	PrPFYQ
;
OutDoS:
	CALL	OutSNF
	CALL	OutOr
	MVI	E,YPicM-3
	MVI	B,StPic
	CALL	OutPic
	RET
;
OutAnd:
	LXI	B,01A1BH
	MVI	A,LBlue
OutAO:
	STA	ColCur
	MVI	E,YPicM-1
	MVI	D,0CH
	LDA	CurrPl
	ORA	A
	JZ	OutAn1
	MVI	D,012H
OutAn1:
	MOV	A,B
	CALL	ColChr
	INR	D
	MOV	A,C
	CALL	ColChr
	RET
;
OutOr:
	LXI	B,01819H
	MVI	A,LYellow
	JMP	OutAO
;
;---------------------------
; Out pictogramms of mission
; Input:
;	B = Start sprite
;	E = Y
; Damage: ALL
;---------------------------
;
OutPic::
	MVI	D,0CH
	LDA	CurrPl
	ORA	A
	JZ	OkPP1
	MVI	D,012H
OkPP1:
	MOV	H,D
	MOV	A,B
	ORA	A
	CALL	Sprite##
	INR	A
	INR	D
	ORA	A
	CALL	Sprite
	INR	A
	MOV	D,H
	INR	E
	ORA	A
	CALL	Sprite
	INR	A
	INR	D
	ORA	A
	CALL	Sprite
	RET
;
;----------------------
; Save byte to field
; Input:
;	A = sprite code
;	DE= address
; Output:
;	(DE)=(DE)+1
; Damage: A
;----------------------
;
SetBIF:
	ANI	0FH
	CPI	0FH
	JNZ	NoBr1
	LDA	BrickM
	JMP	SaveB1
NoBr1:	CPI	0BH
	JC	NoBr2
	ADI	20H-0CH
	JMP	SaveB1
NoBr2:
	ORA	A
	JZ	SaveB1
	ADI	15
SaveB1:
	STAX	D
	INX	D
	RET
;
	END

