TITLE	String	(LIB)
;--------------------------------
; Functions:
;	ChrOut	DigOut	HexOut	WordOut	ColChr	ColStr
;	BinOut
; Variables:
;	ChGen	Screen	ColCur
;--------------------------------
	IF1
	INCLUDE	IBM.MAC
        INCLUDE TETDEF.MAC
	ENDIF

;
SUBTTL	Char Out
;--------------------------------
;    
; : A - 
;	DE-   
; :
;    
;--------------------------------
	CSEG
ChNorm:
	PUSH	H
chout1:	MOV	A,M
	STAX	D
	INR	E
	DCX	H
	DCR	B
	JNZ	chout1
	POP	H
	XRA	A
	RET
;
ChInv:
	PUSH	H	
chnot1:	MOV	A,M
	CMA
	STAX	D
	INR	E
	DCX	H
	DCR	B
	JNZ	chnot1
	POP	H
	XRA	A
	RET
;
ChFull:
	MVI	A,-1
chfot1:	STAX	D
	INR	E
	DCR	B
	JNZ	chfot1
	XRA	A
	RET
;
ChClr:
	MVI	A,0
chcl1:	STAX	D
	INR	E
	DCR	B
	JNZ	chcl1
	RET
;
SUBTTL	Digit Out
;------------------------------
;   
; : DE- 
;	A - 
; :A - ASCII  
;------------------------------
	CSEG
DigOut::
	ANI	0FH
	ADI	30H
	CPI	3AH
	JC	ColChr
	ADI	07H
	JMP	ColChr
;
SUBTTL	HexOut
;-------------------------------
;   
; : DE- 
;	A - 
; :B - 
;	DE-   
;	A - ASCII  
;-------------------------------
	CSEG
HexOut::
	MOV	B,A
	RRC
	RRC
	RRC
	RRC
	CALL	DigOut
	INR	D
	MOV	A,B
	JMP	DigOut
;
SUBTTL	Word Out
;-------------------------------
;     
; : HL -  
;	DE -  
;   HL
;-------------------------------
	CSEG
WordOut::
	MOV	A,H
	CALL	HexOut
	INR	D
	MOV	A,L
	JMP	HexOut
;
SUBTTL	Color Char Out
;------------------------------
;   
; : A - 
;	D -    ( 00..31 )
;	E -    ( 00..31 )
;     Colcur
;   
;------------------------------
	CSEG
Colchr::
	PUSHA
	MOV	L,A
	MVI	H,0		; HL=TabFon+(A*8)
	DAD	H
	DAD	H
	DAD	H
	LXI	B,TabFon##+7
	DAD	B
	MOV	A,D
	ADI	0E0H
	MOV	D,A
	MOV	A,E
	ADD	A
	ADD	A
	ADD	A
	MOV	E,A
	LDA	ColCur##
	MOV	C,A
	RRC
	RRC
	RRC
	RRC
	MOV	B,A	
ColCh0:
	PUSH	H
	MOV	A,B
	MOV	H,A
	RRC
	MOV	B,A
	MOV	A,C
	RRC
	MOV	C,A
	MOV	A,H
	RAL
	ANI	11B
	POP	H
	PUSH	D
	PUSH	B
	MVI	B,8
	CPI	00B
	CZ	ChClr
	CPI	01B
	CZ	ChNorm
	CPI	10B
	CZ	ChInv
	CPI	11B
	CZ	ChFull
	POP	B
	POP	D
ColCh2:	MOV	A,D
	SUI	020H
	MOV	D,A
	CPI	080H
	JNC	ColCh0
OvRng:	POPA
	RET
;
SUBTTL	Color String 
;--------------------------------
;    
; :	HL -   
;	D  -   
;	E  -   
; :HL -  
;	A  = 0
;	DE -  
;--------------------------------
	CSEG
Colstr::
	MOV	A,M
	ORA	A
	RZ
	CALL	ColChr
	INX	H
	INR	D
	JMP	ColStr
;
;-------------------------
; Draw Glasses for players
;-------------------------
	DSEG
ScoreS:	DB	'Score:',0
LevelS::DB	'Level',0
GlSpr:	DB	2,5,6,7,5,6,7,5,6,7,5,1
	DB	4,9,10,8,4,4,4,9,10,10,10,8,4,4,4,9,10,8,4,4,0
GlUpLn::
	DB	5,7,6,5,5,5,5,7,6,5,3
	DB	4,4,8,10,9,4,4,4,8,10,10,10,9,4,4,4,8,10,9,4
SGlSpr	EQU	48
	CSEG
DrGlass::
	LXI	H,GlSpr
	MVI	C,SGlSpr
	MVI	D,0
	LDA	CurrPL##
	ADD	D
	MOV	D,A
	MVI	E,YGl
	MVI	B,WGl+1
CD:	MOV	A,M
	ADD	C
	ORA	A
	CALL	Sprite##
	INR	D
	INX	H
	DCR	B
	JNZ	CD

	MVI	B,HGl+1
CR:	MOV	A,M
	ADD	C
	ORA	A
	CALL	Sprite##
	INR	E
	INX	H
	DCR	B
	JNZ	CR

	MVI	B,WGl+1
CU:	MOV	A,M
	ADD	C
	ORA	A
	CALL	Sprite##
	DCR	D
	INX	H
	DCR	B
	JNZ	CU

	MVI	B,HGl+1
CL:	MOV	A,M
	ADD	C
	ORA	A
	CALL	Sprite##
	DCR	E
	INX	H
	DCR	B
	JNZ	CL
	LDA	Tetr2##
	ORA	A
	JNZ	NoPrSc
	LXI	H,ScoreS
	MVI	E,HGl+YGl+3
	LDA	CurrPL
	MOV	D,A
	MVI	A,LGreen
	STA	ColCur
	CALL	ColStr
NoPrSc:
	LXI	H,LevelS
	MVI	E,HGl+YGl+4
	LDA	CurrPl
	ADI	2
	MOV	D,A
	MVI	A,White
	STA	ColCur
	CALL	ColStr
	RET
;
;-----------------
; Init glass
;-----------------
;
InitGl::
	LHLD	Field##
	MVI	B,200
CING:
	MVI	M,0
	INX	H
	DCR	B
	JNZ	CING
	RET
;
;----------------
; Init game field
;----------------
;
DrField::
	CALL	InitGl
	CALL	DrGlass
	CALL	DrTablo
	CALL	DrPT2
	LDA	Tetr2##
	ORA	A
	JZ	EndDrF
	LDA	IndPl##
	ORA	A
	JNZ	EndDrF
	MVI	D,XTbCn
	MVI	E,YTbCn
	CALL	DrTbCn
EndDrF:
	DI
	LDA	OkDrGl##
	INR	A
	STA	OkDrGl
	RET
;
;-----------
; Draw tablo
;-----------
;
STable	EQU	59
	DSEG
TabloS:	DB	12,8
	DB	59,60,61,62,63,64,60,65
	DB	77,77,66,67,68,69,77,77
	DB	70,71,72,73,74,75,71,76
;
	DB	59,60,61,62,63,64,60,65
	DB	77,77,66,78,79,69,77,77
	DB	70,71,72,80,81,75,71,76
;
	DB	59,60,61,62,63,64,60,65
	DB	77,77,66,82,83,69,77,77
	DB	70,71,72,84,85,75,71,76
;
	DB	59,60,61,86,87,64,60,65
	DB	77,77,66,88,89,69,77,77
	DB	70,71,72,90,91,75,71,76
;
	CSEG
DrTablo::
	LXI	H,TabloS
	LXI	D,00C16H
	CALL	SprNxM##
	RET
;
SegPT2	EQU	147
HeigT2	EQU	6
LenPT2	EQU	8
XPT2	EQU	0CH
YPT2	EQU	029
DrPT2::
	MVI	E,YPT2
	MVI	H,XPT2
	MVI	B,HeigT2
	MVI	A,SegPT2
DrPT21:
	MVI	C,LenPT2
	MOV	D,H
DrPT22:
	STC
	CALL	Sprite
	INR	A
	INR	D
	DCR	C
	JNZ	DrPT22
	DCR	E
	DCR	B
	JNZ	DrPT21
	RET
;
DrTbCn::
	LXI	H,0601H
	CALL	PlatMN##
	MVI	A,(White SHL 4) OR LWhite
	STA	ColCur
	INR	D
	INR	D
	INR	D
	DCR	E
	MVI	A,30
	CALL	ColChr
	INR	D
	MVI	A,31
	CALL	ColChr
	RET
;
	END
