TITLE	TEETRIS
	IF1
	INCLUDE TETDEF.MAC
	INCLUDE	IBM.MAC
	ENDIF
	DSEG
;
;
SpBack	EQU	0
SpFig	EQU	1
ArrSp::	DB	3,2,0,1,1,0,4
StBack	EQU	0
StFig	EQU	16
SErasL	EQU	36
BASE:
T_FIG:	DB	-1,0,0,1,1,0
	DB	0,-1,-1,0,0,1
	DB	1,0,0,-1,-1,0
	DB	0,1,1,0,0,-1

I_FIG:	DB	-2,0,-1,0,1,0
	DB	0,-1,0,1,0,2
	DB	-2,0,-1,0,1,0
	DB	0,-1,0,1,0,2

L_FIG:	DB	-1,0,1,0,1,1
	DB	0,-1,0,1,-1,1
	DB	1,0,-1,0,-1,-1
	DB	0,1,0,-1,1,-1

J_FIG:	DB	1,0,-1,0,-1,1
	DB	0,1,0,-1,-1,-1
	DB	-1,0,1,0,1,-1
	DB	0,-1,0,1,1,1

Z_FIG:	DB	0,1,-1,1,1,0
	DB	-1,0,-1,-1,0,1
	DB	0,1,-1,1,1,0
	DB	-1,0,-1,-1,0,1

S_FIG:	DB	0,1,1,1,-1,0
	DB	-1,0,-1,1,0,-1
	DB	0,1,1,1,-1,0
	DB	-1,0,-1,1,0,-1

O_FIG:	DB	0,1,-1,0,-1,1
	DB	0,1,-1,0,-1,1
	DB	0,1,-1,0,-1,1
	DB	0,1,-1,0,-1,1

EXTRN	KeyCd,FStat,X,Y,ACurr,DelM,DelC,Timer,Field,CurrPL
EXTRN	CountK,PrevK,TempV,FSprt,SetB,Score,Tetr2,Line4
EXTRN	LineB,BrickM,Nfig
;
	CSEG
;
;--------------------
; Get Char from KeyCd
;--------------------
;
GetCh::
	PUSH	B		;
	PUSH	H		;
	PUSH	PSW		;
	LDA	KeyCd		;Load key
	MOV	B,A		;
	CPI	Nokey		;
	JZ	GtChN		;
	LDA	PrevK		;
	CMP	B		;
	JNZ	GtChN		;
	POP	PSW		;
	LHLD	CountK		;
	MOV	A,L		;
	ORA	H		;
	JZ	CtCk0		;
	DCX	H		;
	SHLD	CountK		;
	MVI	A,Nokey		;
	JMP	GtRet		;
CtCk0:
	LXI	H,PressR	;
	SHLD	CountK		;
	MOV	A,B		;
	JMP	GtRet		;
GtChN:
	LXI	H,PressW	;
	POP	PSW		;
	JNC	GtChOk		;
	LXI	H,DelMen	;
GtChOk:
	SHLD	CountK		;
	MOV	A,B		;
	STA	PrevK		;
GtRet:
	POP	H		;
	POP	B		;
	RET			;
;

;--------------------------
; Initialize figure
; Output:
;	A = 0FFH - O.K.
;	    000H - Game over
;---------------------------
Init_F::
	LDA	Tetr2##
	ORA	A
	CNZ	IsEndM##
	HLT
	HLT
	CALL	Random		;Generate random number
	MVI	H,0
	MOV	L,A		;Saved figure
	MOV	C,A		;
	LXI	D,ArrSp		;
	DAD	D		;
	LDA	SetB		;
	ORI	Nownew		;
	STA	SetB		;
	ANI	NSet		;
	RRC			;
	RRC			;
	RRC			;
	RRC			;
	MOV	B,A		;
	ADD	A		;
	ADD	A		;
	ADD	B		;
	MOV	B,M		;
	ADD	B		;
	ADI	StFig		;
	STA	FSprt		;
	MOV	L,C		;Mult on 24
	MVI	H,0		;
	DAD	H		;
	DAD	H		;
	DAD	H		;
	PUSH	H		;
	DAD	H		;
	POP	D		;
	DAD	D		;
	LXI	D,BASE		;Adding
	DAD	D		;To base address
	MVI	E,HGl-2		;Set Y=18
	MVI	D,5		;Set X=5
INSETX:
	CALL	TestDr		;Test draw
	ORA	A		;Test result
	JNZ	Noindr		;No draw,Game over
	MOV	A,D		;Load X
	STA	X		;Save X
	MOV	A,E		;Load Y
	STA	Y		;Save Y
	SHLD	ACurr		;Save ACurr
	LDA	FSprt		;
	CALL	Draw_F		;figure
	LDA	DelM		;
	STA	DelC		;
	LDA	FStat		;
	ANI	(LineQ OR NPres);
	STA	FStat		;
	LDA	Nfig		;
	ADI	099H		;
	DAA			;
	STA	Nfig		;
	XRA	A		;
	CMA			;Set RA=0FFH
	RET			;Return O.K.
Noindr:
	XRA	A		;Reset RA
	RET			;Return GAME OVER
;
;---------------------
; Draw figure
;---------------------
;
Draw_F::
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	C,A
	LDA	X
	INR	A
	MOV	D,A
	LDA	CurrPL
	ADD	D
	MOV	D,A
	LDA	Y
	ADI	YGl+1
	MOV	E,A
	PUSH	D
	MOV	A,C
	ORA	A
	CALL	Sprite##
	LHLD	ACurr
	MVI	B,3
CL1:
	POP	D		;Load X & Y from Stack
	PUSH	D		;Save X & Y to Stack
	MOV	A,M		;Load increment X
	INX	H		;
	ADD	D		;
	MOV	D,A		;D=New X
	MOV	A,M		;Load increment Y
	INX	H		;
	ADD	E		;
	MOV	E,A		;E=New Y
	MOV	A,C
	ORA	A
	CALL	Sprite##	;Output new symbol
	DCR	B
	JNZ	CL1
	POP	D		;Restore Stack
	POP	H
	POP	D
	POP	B
	RET
;
;------------------------
; Move figure toward down
;------------------------
;
MoveDn::
	LHLD	ACurr		;Load ACurr
	LDA	X		;Save X
	MOV	D,A		;To RD
	LDA	Y		;Load Y
	DCR	A		;Decrement Y
	MOV	E,A		;& save to RE
	CALL	TestDr		;Test movement
	ORA	A		;
	JNZ	NoMDn		;Jump
	LDA	SetB		;
	ANI	BSprt		;
	CALL	Draw_F		;Figure
	MOV	A,E		;Save
	STA	Y		;New Y
	LDA	FSprt
	CALL	Draw_F		;Figure
	LDA	DelM		;
	STA	DelC		;
	LDA	FStat		;
	ANI	NOT DownF	;
	STA	FStat		;
	MOV	B,A		;
	ANI	DropF		;
	RZ
	LDA	SoundS		;
	ORA	A		;
	LDA	Y		;
	CNZ	DropEff##	;
	LDA	SetB		;
	ANI	FullDn		;
	JNZ	NotFul		;
	MOV	A,B		;
	ANI	NOT DropF	;
	MOV	B,A		;
NotFul:
	MOV	A,B		;
	STA	FStat		;
	XRA	A
	STA	DelC		;
	LXI	D,DropSc	;
	CALL	IncScr		;
	RET			;
NoMDn:
	MVI	B,3		;For 4 boxes
	INR	E		;
	CALL	SetXY		;
CMDn:
	MOV	D,M
	INX	H
	LDA	X
	ADD	D
	MOV	D,A
	MOV	E,M
	INX	H
	LDA	Y
	ADD	E
	MOV	E,A
	CALL	SetXY
	DCR	B
	JNZ	CMDn
	CALL	DelLn
	CALL	Init_F
	ORA	A
	RNZ	
	POP	H
	JMP	OverGm##
;
;------------------
; Sub MoveDn
; Input:
;	DE = X & Y
; Output:
;	Field(X,Y)=1
;------------------
;
SetXY::
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	MOV	A,E		;
	ADD	A		;Now
	MOV	H,A		;X,Y E Field
	ADD	A		;
	ADD	A		;
	ADD	H		;Now A=Y*10
	ADD	D		;Now A=Field Index
	LHLD	Field		;Load field address
	ADD	L		;Add
	MOV	L,A		;index
	JNC	RdMF		;
	INR	H		;
RdMF:
	MVI	M,1		;Set Field(X,Y)=1
	POP	H		;
	POP	D		;
	POP	B		;
	RET			;

;-----------------
; Delete lines
;-----------------
;
DelLn::
	LHLD	Field		;
	MVI	A,HGl-1		;
	STA	TempV		;
	LDA	BrickM		;
	MOV	B,A		;
	MVI	E,0		;Init erasable line counter
DLNXL:
	PUSH	H		;
	MVI	D,0		;
	MVI	C,10		;Scanning 10 bytes (1 line)
DLC1:
	MOV	A,M		;Read byte from line
	ORA	A		;Test this byte
	JZ	DLEC		;If ZERO,exit
	CMP	B		;
	JNZ	DLNBL		;
	MVI	D,1		;
DLNBL:
	INX	H		;Increment for next line byte
	DCR	C		;If end is not achived
	JNZ	DLC1		;Jump for test next byte
	POP	H		;
	INR	E		;
	LDA	LineB		;
	SUB	D
	STA	LineB		;
	CALL	TryCQ		;
	CALL	EraseL		;Else erase line
;	LDA	LineB
;	SUB	D
;	STA	LineB
	JMP	DLNXL		;
DLEC:
	POP	H		;Compute
	MVI	A,10		;Next
	ADD	L		;Line
	MOV	L,A		;Address
	JNC	DLNC		;
	INR	H		;
DLNC:
	LDA	TempV		;
	DCR	A		;
	STA	TempV
	JNZ	DLNXL		;
ExitDL:
	CALL	ChanLN		;
	RET
;
;-----------------
; Try change quota
;-----------------
;
TryCQ:
	PUSH	B
	PUSH	H
	LDA	Tetr2
	ORA	A
	JZ	TCQEnd
	LXI	H,Line4+3
	MVI	C,4
TrCQ2:
	MOV	A,M
	ORA	A
	JZ	TrCQ1
	MOV	A,C
	CMP	E
	JNZ	TCQEnd
	MVI	A,099H
	ADD	M
	DAA
	MOV	M,A
	XRA	A
	MOV	E,A
	CALL	OutLn
	JMP	TCQEnd
TrCQ1:
	DCX	H
	DCR	C
	JNZ	TrCQ2
TCQEnd:
	POP	H
	POP	B
	RET
;
;--------------------
; Change Lines quota
;--------------------
;
ChanLN::
	MOV	A,E
	ORA	A
	RZ
	CPI	05
	RNC
	LXI	H,Line4-1
	MVI	D,0
	DAD	D
	LDA	Tetr2
	ORA	A
	JNZ	ChLnT2
	MOV	A,M
	INR	A
	DAA
	MOV	M,A
	CALL	OutLn
	RET
ChLnT2:
	MOV	D,E
ChLnTb:
	MOV	A,E
	CMP	D
	JNC	ChLnC1
ChLnC2:
	DCX	H
	DCR	D
	JNZ	ChLnTb
	CALL	OutLn
	RET
ChLnC1:
	MOV	A,M
	ORA	A
	JZ	ChLnC2
	MVI	B,099H
	ADD	B
	DAA
	MOV	M,A
	MOV	A,E
	SUB	D
	MOV	E,A
	JMP	ChLnTb
;	
	
;----------------
; Erase line and
; Change line
;----------------
;
	DSEG
TempSt:	DW	0
LowByte:DB	0
NxtAdr:	DB	0
	CSEG
EraseL::
	PUSH	B
	PUSH	D
	PUSH	H
	XCHG
	LXI	H,10
	DAD	D
	LDA	TempV
	ADD	A
	MOV	B,A
	ADD	A
	ADD	A
	ADD	B
	MOV	B,A
ERLC1:
	MOV	A,M
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	ERLC1
	MVI	B,10
	XRA	A
ResTB:
	STAX	D
	INX	D
	DCR	B
	JNZ	ResTB
	CALL	PressL
NoErSp:
	HLT
	DI
	LXI	H,0000
	DAD	SP
	SHLD	TempSt
	LDA	TempV
	MOV	B,A
	MVI	A,HGl+YGl
	SUB	B
	ADD	A
	ADD	A
	ADD	A
	STA	LowByte
	MVI	A,080H
NxtPl:
	STA	NxtAdr
	MOV	H,A
	LDA	CurrPL
	INR	A
	ADD	H
	MOV	H,A
	MVI	B,10
NxtCol:
	LDA	LowByte
	MOV	C,A
	ADI	8
	MOV	L,A
	SPHL
	MOV	L,C
	LDA	TempV
	MOV	C,A
DnCol:
	REPT	4
	POP	D
	MOV	M,E
	INR	L
	MOV	M,D
	INR	L
	ENDM
	DCR	C
	JNZ	DnCol
	INR	H
	DCR	B
	JNZ	NxtCol
	LDA	NxtAdr
	ADI	020H
	JNZ	NxtPl
	LHLD	TempSt
	SPHL
	EI
	HLT
	MVI	E,HGl+YGl
	LDA	CurrPL
	INR	A
	MOV	D,A
	MVI	C,10
	LDA	SetB
	ANI	BSprt
ErC1S:
	ORA	A
	CALL	Sprite
	INR	D
	DCR	C
	JNZ	ErC1S
	LXI	D,KillLN
	CALL	IncScr
;
	LDA	Tetr2##
	ORA	A
	JNZ	NoClT
	LDA	BrickM
	DCR	A
	STA	BrickM
	JNZ	NoClT
	LXI	H,NSpeed##
	CALL	AddrGB##
	MOV	A,M
	INR	A
	CPI	0BH
	JNZ	NoEnd
	REPT	6
	POP	H
	ENDM
	JMP	Happy##
NoEnd:
	MOV	M,A
	MVI	A,LWhite
	STA	ColCur
	CALL	OutSpd
NoClT:
	POP	H
	POP	D
	POP	B
	RET
;
;-----------------
; Pressing of line
;-----------------
;
PressL::
	LDA	TempV			;
	MOV	B,A
	MVI	A,HGl+YGl
	SUB	B
	MOV	E,A
	LDA	FStat
	ANI	NPres
	JZ	RetPr
	RLC
	RLC
	DCR	A
	RLC
	RLC
	ADI	SErasL
	MOV	B,A
	MVI	H,4
ErLn2:
	LDA	CurrPL
	INR	A
	MOV	D,A
	MOV	A,B
	MVI	C,10
ErLn1:
	ORA	A
	CALL	Sprite##
	INR	D
	DCR	C
	JNZ	ErLn1
	HLT
	LDA	SoundS##
	ORA	A
	CNZ	DelEff##
	INR	B
	DCR	H
	JNZ	ErLn2
RetPr:
	LDA	SoundS
	ORA	A
	CNZ	DelEff
	RET
;
;-------------------
; Rotate figure
;-------------------
;
Rotate::
	LDA	X		;Load X
	MOV	D,A		;Save X to D
	LDA	Y		;Load Y
	MOV	E,A		;Save Y to E
	LDA	FStat		;Load PCurr flag
	ANI	PCurr		;
	INR	A		;Change PCurr
	CPI	4		;Test overflow
	JNZ	NO_4		;Not overflow,jump
	MVI	B,0		;Save new PCurr to RB
	LHLD	ACurr		;Load ACurr
	MOV	A,L		;
	SUI	18		;without 18
	MOV	L,A		;
	JNC	NO_AC		;Test C flag
	DCR	H		;
	JMP	NO_AC		;
NO_4:
	MOV	B,A		;save new PCurr to RB
	LHLD	ACurr		;Load ACurr
	MOV	A,L		;
	ADI	6		;Add 6
	MOV	L,A		;
	JNC	NO_AC		;
	INR	H		;
NO_AC:
	CALL	TestDr		;Test new position
	ORA	A		;Can draw figure ?
	JNZ	NoRt		;No,jump
	LDA	SetB		;
	ANI	BSprt		;
	CALL	Draw_F		;figure
	SHLD	ACurr		;Save new ACurr
	LDA	FStat		;
	INR	A		;Save new
	STA	FStat		;
	LDA	Fsprt		;
	CALL	Draw_F		;figure
	LDA	SoundS##	;
	ORA	A
	CNZ	RotEff##
NoRT:	RET
;
;-----------------------
; Movement figure toward
;    left & right
;    Input:
;	D =  1 - toward right
;	  = -1 - ...    left
;---------------------------
;
MoveLR::
	LHLD	ACurr		;Load ACurr
	LDA	Y		;Save Y
	MOV	E,A		;to E
	LDA	X		;Load X
	ADD	D		;Add offset
	MOV	D,A		;Save X to D
	CALL	TestDr		;Test movement
	ORA	A		;If can't move
	RNZ			;Jump
	LDA	SetB		;
	ANI	BSprt		;
	CALL	Draw_F		;Figure
	MOV	A,D		;Save
	STA	X		;new X
	LDA	FSprt		;
	CALL	Draw_F		;Figure
NoMRL:	RET			;
;
;---------------------------
; Reset RA if figure can't draw
; Input:
;	HL = ACurr
;	DE = X & Y
; Output:
;	A =  0 - O.K.
;	    FF - figure can't move down
;----------------------------
;
TestDr::
	PUSH	B		;Save  BE
	PUSH	H		;Save  HL
	MVI	B,4		;Init counter
	PUSH	D		;Save central X,Y
CT1:
	CALL	Is_xy		;
	ORA	A		;Test  result
	JNZ	NoDr		;Jump if don't draw
	POP	D		;Load X,Y from stack
	PUSH	D		;Save X,Y
	MOV	A,M		;Load increment for X
	INX	H		;
	ADD	D		;
	MOV	D,A		;D=New X
	MOV	A,M		;Load increment for Y
	INX	H		;
	ADD	E		;
	MOV	E,A		;E=New Y
	DCR	B		;Decrement counter
	JNZ	CT1		;Jump if don't riched end
	XRA	A		;
NoDr:				;Draw failed
	POP	D		;Restore
	POP	H		;Registers
	POP	B		;BC,DE,HL
	RET			;Return		
;

;---------------------
; Sub TESTDF
;  Field(X,Y)=1?
; Input:
;	DE = X & Y
; Output:
;  A = 0 - O.K.
;     FF - D,F(X,Y)=1
;---------------------
;
Is_xy::
	PUSH	H		;Save RH
	PUSH	B		;Save RB
	MOV	A,D		;Load X
	ORA	A		;Test X<0
	JM	Noxy		;Yes,jump
	CPI	10		;Test X>9
	JNC	Noxy		;Yes,jump
	MOV	A,E		;Now test Y
	CPI	20		;Test Y>19
	JNC	Noxy		;Yes,Jump
	ORA	A		;Test Y<0
	JM	Noxy		;Yes,Jump
	ADD	A		;Now
	MOV	H,A		;X,Y E Field
	ADD	A		;
	ADD	A		;
	ADD	H		;Now A=Y*10
	ADD	D		;Now A=Field Index
	LHLD	Field		;Load field address
	ADD	L		;Add
	MOV	L,A		;index
	JNC	ReadFl		;
	INR	H		;
ReadFl:
	MOV	A,M		;Now HL=required byte
	ORA	A		;
	JZ	Retxy		;
Noxy:	
	MVI	A,0FFH		;Set A=1 for overflow L,R,U
Retxy:
	POP	B		;Restore B
	POP	H		;Restore H
	RET			;Return
;
;--------------
; Change Score
; Input:
;	DE = Adding value
;-------------
;
IncScr::
	LDA	Tetr2
	ORA	A
	JNZ	EndInS
	LXI	H,Score+2
	MOV	A,M
	ADD	E
	DAA
	MOV	M,A
	DCX	H
	MOV	A,M
	ADC	D
	DAA
	MOV	M,A
	DCX	H
	MOV	A,M
	ACI	00
	DAA
	MOV	M,A
	CALL	OutScore
EndInS:
	RET
;
;-------------
; Print Score
;-------------
;
OutScore::
	MVI	A,ColDig
	STA	ColCur##
	LXI	H,Score
	MVI	E,HGl+YGl+3
	LDA	CurrPL
	ADI	6
	MOV	D,A
	MVI	C,3
OutSc1:
	MOV	A,M
	CALL	HexOut##
	INR	D
	INX	H
	DCR	C
	JNZ	OutSc1
	RET
;
;-------------
; Print Lines
;-------------
;
	DSEG
ColLns:	DB	LGreen,LRed,Yellow,LBlue
	CSEG
OutLn::
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	H,ColLns
	PUSH	H
	LXI	H,Line4
	MVI	B,0
	MVI	C,4
	MVI	E,LnNY
	MVI	D,LnNX1
	MVI	A,ColLnN
	STA	ColCur
	LDA	CurrPL
	ORA	A
	JZ	OLnP1
	MVI	D,LnNX2
OLnP1:
	XTHL
	MOV	A,M
	INX	H
	STA	ColCur
	XTHL
	MOV	A,M
	CALL	OutZNP
	MOV	A,M
	ORA	B
	MOV	B,A
	INX	H
	MOV	A,E
	SUI	3
	MOV	E,A
	DCR	C
	JNZ	OLnP1
	MOV	A,B
	ORA	A
	JNZ	OutNQ
	LDA	FStat
	ANI	NOT LineQ
	STA	FStat
OutNQ:
	POP	H
	POP	H
	POP	D
	POP	B
	RET
;
;-------------------------------
; Out Lines witnout leading zero
;-------------------------------
;
OutZNP::
	ORA	A
	JNZ	OZNP1
	MVI	A,' '
	CALL	ColChr##
	INR	D
	CALL	ColChr##
	DCR	D
	RET
OZNP1:
	PUSH	B
	MOV	B,A
	RRC
	RRC
	RRC
	RRC
	ANI	00001111B
	JNZ	OZNPB1
	MVI	A,' '
	JMP	OLB
OZNPB1:
	ADI	'0'
OLB:
	CALL	ColChr##
	INR	D
	MOV	A,B
	ANI	00001111B
	ADI	'0'
	CALL	ColChr##
	DCR	D
	POP	B
	RET
;
SUBTTL	Delay
;------------------------------
;   A/50 
; : A -  
; :A = 0
;------------------------------
Delay::
	HLT
	DCR	A
	JNZ	Delay
	RET
;
SUBTTL	Random
;-------------------
;   
; ĺ  
; ĺ HL -  
;-------------------
	DSEG
RanNum::DW	0101H
	CSEG
Random::
	LXI	H,rannum
	LDA	IndPl##
	ORA	A
	JNZ	NoInd
	LXI	H,RanN##
	CALL	AddrGB##
NoInd:
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	MVI	C,16
rnd1:	MOV	A,H
	DAD	H
	ANI	60H
	JPE	rnd2
	INX	H
rnd2:	DCR	C
	JNZ	rnd1
	XCHG
	MOV	M,D
	DCX	H
	MOV	M,E
	LXI	H,RanNum
	MOV	M,E
	INX	H
	MOV	M,D
	MOV	A,E
	MVI	B,07
	CALL	Div
	RET
;
;----------
; Out Speed
;----------
;
OutSpd::
	LDA	CurrPl
	ADI	08
	MOV	D,A
	MVI	E,YGl+HGl+4
	LXI	H,NSpeed
	CALL	AddrGB
	MOV	A,M
	PUSH	PSW
	CPI	0AH
	JNZ	OkNSp
	MVI	A,010H
OkNSp:
	CALL	OutZNP
	POP	PSW
	DCR	A
	MOV	E,A
	MVI	D,0
	LXI	H,SpeedP##
	DAD	D
	MOV	A,M
	STA	DelM
	MVI	A,NxtSpd
	STA	BrickM
	RET
;
SUBTTL	Div
;-------------------------------
;   	
; : A = 	
;	B = 	
; :A =   	
;	B = 	
;	C = 	
;-------------------------------
	CSEG
Div::	
	MVI	C,0
div1:	CMP	B
	RC
	SUB	B
	INR	C
	JMP	div1
;
	END
