;-------------------------------------------------
; KRBIOS.ASM
;  ⥬ p p  p
; 㧭殢 P..
; () 1993-1994
; . pp
;-------------------------------------------------


;---  p ---

START:	EQU	2100H

FONT:   EQU     START-0A00H

; p 梥⮢
C0:     EQU     0	;p
C1:     EQU     30H	;
C2:     EQU     7	;p
C3:     EQU     0C0h	;ᨭ

; p p
KTAB:   EQU     9
KLFEED: EQU     10
KCR:    EQU     13
KBS:    EQU     127
KLF:    EQU     8
KUP:    EQU     25
KRG:    EQU     24
KDN:    EQU     26
KHOME:  EQU     31
KEND:   EQU     12
KESC:   EQU     27
KF1:    EQU     1
KF2:    EQU     2
KF3:    EQU     3
KF4:    EQU     4
KF5:    EQU     5
KSP:    EQU     32

TSHIFT: EQU     20H	;᪠  
TCTRL:  EQU     40H	;᪠  
TALF:   EQU     80H	;᪠  /

MAXRBLEN:	EQU	8; 楢 p


;p p
JLEFT:	EQU	0
JRIGHT:	EQU	1
JCENTER:	EQU	2
JNOJUST:	EQU	3




;---  p室 ---

	ORG	START
;p室  pp
	JMP     INIT	;樠
	JMP	PUTC	;뢮 ᨬ  ᫥ p 
	JMP	PUTCH	;뢮 ᨬ  ⥩
	JMP	PUTS	;⪠ p  뢮 p ⥪
	JMP	SETATR	;⠭ p ⥪
	JMP	INKEY	;   
	JMP	GETCH	;     p⪮ p祭 pp
	JMP	GOTOXY	;樮p pp
	JMP	SETCUR	;⠭ pp pp
	JMP	MOVLIN	;p p
	JMP	SCROLL	;⠭ ᤢ p
	JMP	SETJUST ;⠭ pp p
	JMP	PRJUST  ; p  p
	JMP	PRINTINT; ᫠
	JMP	SETAUTO	;⠭ pp ⮯p
	JMP	GETS	; p  ᮫  p

;---  p p ---

; p pp

CURADR: DW 0A0F6H	;p pp  p
CURMSK: DB 0F0H		;᪠  뢮 pp (0F0h,0Fh)
CURY:   DB 0		;p
CURX:   DB 0		;
CURH:   DB 2		; pp, p
CURVIS: DB 0		; pp (0-)
CURBLK: DB 10		;  pp (10 - 5 )
CURCNT: DB 1		;稪 

; p p

BORDER:		DB 0	;梥 pp
STARTROW:       DB 255	;砫쭠 p pp (p)
ATTRIB:  	DB 1	;⥪騩 梥 뢮
;梥 -  00000,   - ᪮  뢮 ᨬ;  - 梥 䮭
MAXY:		DB 24	;ᨬ p p
MAXX:		DB 63	;ᨬ p ⮫

;⠡ 梥⮢  pp襭 512256, p
COLTAB: DB C0,C0,C1,C1
	DB C1,C1,C1,C1
	DB C0,C0,C1,C1
	DB C1,C1,C1,C1

; p p (p冷  !!!)

SCAN:   DB      255	;᪠- 
TOG:    DB      0	;ﭨ -䨪p
TFLAG:	DB	0	;䫠  -䨪p
REPCNT: DB      100	;稪  ⮯p
LOCK:   DB      0	;ﭨ pp
AUTODELAY:	DB	50	;p p 砫 ⮯p
AUTOSPEED:	DB	5	;᪮p ⮯p
RELEASECNT:	DB	3	;稪 襭 p 

RBHEAD: DB 0		;㪠⥫  砫 楢 p
RBTAIL: DB 0		;㪠⥫   楢 p
RBLEN:	DB 0		;⢮ ᨬ  楢 p
RINGBUF:DS 16		;楢 p

ESCFLAG: DB 0		;䫠 ESC-᫥⥫쭮

;---  ⠡ pp ---

;⠡  p 
KEYTAB: DB KTAB, KLFEED, KCR, KSP, KLF, KUP, KRG, KDN
	DB KHOME, KEND, KESC, KF1, KF2, KF3, KF4, KF5

;⠡  pp  p⨢ p
RUSTAB: ; A-
;	DB '@HP'
	DB 158,128,129,150,132,133,148,131
	DB 149,136,137,138,139,140,141,142
	DB 143,159,144,145,146,147,134,130
	DB 156,155,135,152,157,153,151,154

;⠡  p᪫ ᥢp䨪  p
GRAPH:
;	jcukeng[]zh
;	fywaproldv\
;	q^smitxb@
;	¿ҷ
;	Ŵ׶
;	н
;	˻Ѹ
;	ιص
;	ʼϾ
	DB '²óֱӷٽ۴'
	DB '̺Ըȵ߹'

;	DB 247,199,245,194,248,210,195,179
;	DB 252,208,218,214,249,211,183,250
;	DB 215,192,182,217,189,191,254,180
;	DB 241,197,205,196,243,186,193,254
;	DB 246,198,244,203,178,209,204,221
;	DB 251,207,201,213,177,212,184,176
;	DB 216,200,181,188,190,187,219,185
;	DB 240,206,223,220,242,222,202,255


;--- ᭮  ---

;pp 樠樨
;⠭ p稥 p  頥 p
INIT:
	DI
	MVI     A,0C3H
	STA     38H
	LXI     H,INTER
	SHLD    39H
;⪠  p
	LXI	H,0
	SHLD	TOG
	SHLD	RBHEAD
	XRA	A
	STA	LOCK
	STA	RBLEN
	STA	ATTRIB
	DCR	A
	STA	SCAN
;⠭ pp p
	LXI	H,3F18H
	SHLD	MAXY

	CALL	CLS
;⠭    pp
	LXI	H,20AH
	CALL	SETCUR
	LXI	H,500H+50
	CALL	SETAUTO

	RET


SETAUTO:
;H-᪮p ⮯p L-p p 砫
	SHLD	AUTODELAY
	RET


;뢮 ᨬ  p p 
;ᨬ - p. 
; pp p
PUTC:
	PUSH    PSW
	PUSH    D
	PUSH    H

	LHLD	CURY

	CPI	KCR
	JZ	PCCR
	CPI	KUP
	JZ	PCUP
	CPI	KDN
	JZ	PCDN
	CPI	KRG
	JZ	PCRG
	CPI	KLF
	JZ	PCLF
	CPI	KHOME
	JZ	PCHOME
	CPI	KEND
	JZ	PCEND
	CPI	KBS
	JZ	PCLF
	CPI	KESC
	JZ	PCESC

	MOV	D,A
	LDA	ESCFLAG
	ORA	A
	MOV	A,D
	JZ	PCPUT

	XRA	A
	STA	ESCFLAG
	MOV	A,D
	SUI	'0'
	JC	PCPUT
	CPI	7+1
	JNC	PCPUT

	STA	ATTRIB
	JMP	PCEX
PCUP: 	;pp p
	DCR	L
	JP	PCGXY
	LDA	MAXY
	MOV	L,A
	JMP	PCGXY
PCDN:	;pp 
	INR	L
	LDA	MAXY
	CMP	L
	JNC	PCGXY
	MVI	L,0
	JMP	PCGXY
PCLF:	;pp 
	DCR	H
	JP	PCGXY
	LDA	MAXX
	MOV	H,A
	JMP	PCGXY
PCRG:	;pp p
	INR	H
	LDA	MAXX
	CMP	H
	JNC	PCGXY
	MVI	H,0
	JMP	PCGXY
PCHOME:	;pp  砫
	LXI	H,0
	JMP	PCGXY
PCEND:	;⪠ p
	CALL	CLS
	JMP	PCEX
PCESC:
	STA	ESCFLAG
	JMP	PCEX
PCPUT:
	CALL	PUTCH
;p室  ᫥ 
	INR	H
	LDA	MAXX
	CMP	H
	JNC	PCGXY
PCCR:	;pp  ᫥ p
	MVI	H,0
	INR	L
	LDA	MAXY
	CMP	L
	JNC	PCGXY
	MOV	L,A
	CALL	SCRLUP
PCGXY:
	CALL	GOTOXY
PCEX:
	POP     H
	POP	D
	POP	PSW
	RET

;pp ᤢ p  p p
SCRLUP:
	XRA	A
	LXI	D,NULLP
	CALL	PUTS
	MVI	A,-10
	CALL	SCROLL
	LDA	MAXY
	CALL	PUTS
	RET

;㪠⥫   p
NULLP:  DB 0


;⪠ p
CLS:
	LDA	MAXY
	INR	A
	INR	A
	MOV	H,A
	LXI	D,NULLP
	XRA	A
CLS1:
	CALL	PUTS
	INR	A
	CMP	H
	JC	CLS1

	XRA	A
	STA	STARTROW
	LXI	H,0
	CALL	GOTOXY
	RET


;뮤 ᨬ  ⥪  pp
;ᨬ - p. 
; pp p
PUTCH:
	PUSH    PSW
	PUSH    B
	PUSH    D
	PUSH    H
;p pp
	CALL    CURHID
	MOV	E,A
;⪠   ᮮ⢥⢨  梥⮬
	LHLD	CURADR
	LDA	CURMSK
	MOV	D,A
	CMA
	MOV	C,A
	LDA	ATTRIB
	RRC
	JC	PCH1
	MVI	D,0
;⪠ p ᪮⥩
PCH1:
	MVI	B,10
PCH2:
	MOV	A,M
	ANA	C
	ORA	D
	MOV	M,A
	INR	L
	DCR	B
	JNZ	PCH2
;᫥ ᪮
	MOV	A,L
	SUI	10
	MOV	L,A
	MOV	A,H
	XRI	60H
	MOV	H,A
	ANI	40H
	JNZ	PCH1

;᫥ ᬥ饭 ᨬ  pp
	MVI	D,0
	LXI	H,FONT
	XCHG
	DAD	H
	XCHG
	DAD	D
	XCHG
	DAD	H
	DAD	H
	DAD	D
	XCHG

	LHLD	CURADR
	LDA	CURMSK
	MOV	C,A
	ORA	A
	MOV	A,H
	JM	$+5
	XRI	60H
	MOV	H,A
;뢮 ᨬ  
	MVI     B,10
PCH5:
	LDAX    D
	RRC
	RRC
	RRC
	RRC
	ANA     C
	XRA     M
	MOV     M,A
	INX     D
	INR     L
	DCR     B
	JNZ     PCH5

	MOV     A,H
	XRI     60H
	MOV     H,A

	MVI     B,10
PCH6:
	DCX     D
	DCR     L
	LDAX    D
	ANA     C
	XRA     M
	MOV     M,A
	DCR     B
	JNZ     PCH6

PCHEX:
; pp
	CALL    CURSHW

	POP     H
	POP     D
	POP     B
	POP     PSW
	RET


;pp ⠭ 梥
SETATR:
	PUSH	H
	LXI	H,ATTRIB
	MOV	H,M
	STA	ATTRIB
	MOV	A,H
	POP	H
	RET



;--------------------------------------------------------
;pp  ᨬ  p  
;p:  -  ᨬ  . p
;	   - ﭨ -䨪p
;	   - ᪠- 
;pp p뢠  pp p,
;  ᢥ⮤ /  梥 pp
;--------------------------------------------------------
GETCH:
	CALL	INKEY
	ORA	A
	RNZ
	MOV	A,B
	ORA	A
	JZ	GETCH

	MOV	A,C
	ANI	TSHIFT
	RLC
	RLC
	RLC
	STA	BORDER

	JMP	GETCH

	RET


;--------------------------------------------------------
;pp  ᨬ  p  
;p:  -  ᨬ  . p
;	   - ﭨ -䨪p
;	   - ᪠- 
;p  pp p p頥:
;          - 0
;	   - ᪠  pp
;	   -   pp
;--------------------------------------------------------
INKEY:
;᫨ p ,  室
	LXI	B,0
	LDA     RBLEN
	ORA	A
	RZ

	PUSH	D
	PUSH    H
;p   楢 p
	DI
	DCR	A
	ANI	MAXRBLEN-1
	STA	RBLEN

	LDA	RBTAIL
	MOV	E,A
	MVI	D,0
	INR	A
	ANI	MAXRBLEN-1
	STA	RBTAIL

	LXI	H,RINGBUF
	DAD	D
	DAD	D
; - ᪠-,  -  䨪p
	MOV	C,M
	INX	H
	MOV	B,M

	EI
;-----------------

	MOV	A,C
	CPI	64
	JC	IK0
;᫨ 뫮 p祭 pp
	LDA	LOCK
	XRA	B
	STA	LOCK
	MOV	C,A
	XRA	A
	JMP	IKEX

IK0:
	CPI     16
	JNC     IK1
; p 
	MOV     L,A
	MVI     H,0
	LXI     D,KEYTAB
	DAD     D

	MOV     A,M
	JMP     IKEX
IK1:
	CPI     32
	JNC     IK2
; p
	ADI	32
	CPI	60
	JC	$+5
	XRI	16
	MOV	L,A

	MOV	A,B
	ANI	TSHIFT
	MOV	A,L
	JZ	$+5
	XRI	16
	JMP	IKEX
IK2:
	MOV	A,B
	ANI	TCTRL
	JNZ	IKGRAPH
; 㪢
	MOV	A,C
	CPI	63
	JC	IKNBS
;  
	MOV	H,B
	MOV	A,B
	ANI	TALF
	JNZ	IKRUS
	MOV	A,B
	ANI	TSHIFT
	MVI	A,KBS
	JZ	IKEX
	MVI	A,'_'
	JMP	IKEX

IKNBS:
	LDA     LOCK
	XRA     B
	MOV     H,A	;H -  pp p
IKBS:
	MOV	A,H
	ANI	TALF
	JZ	IKLAT
IKRUS:
;p᪨ 䠢
	MOV	A,C
	SUI	32
	LXI	D,RUSTAB
	ADD	E
	MOV	E,A
	MOV	A,D
	ACI	0
	MOV	D,A
	LDAX	D
	MOV	L,A

	MOV	A,H
	ANI	TSHIFT
	MOV	A,L
	JNZ	IKEX

	CPI	144
	JC	$+5
	ADI	48
	ADI	32
	JMP	IKEX

IKLAT:
;⨭᪨ 䠢 (  ⥩,  p,  )
	MOV	A,H
	ANI	TSHIFT
	MOV	A,C
	JNZ	$+5
	ADI	32
	ADI	32
	JMP	IKEX

IKGRAPH:
;ᥢp䨪
	LDA	LOCK
	XRA	B
	ANI	TSHIFT
	MOV	A,C
	JNZ	$+5
	SUI	32

	MOV	L,A
	MVI	H,0
	LXI	D,GRAPH
	DAD	D
	MOV	A,M
	JMP	IKEX

IKEX:
;室 ( ᢥ⫮ 饬)
	POP     H
	POP	D
	RET




;--------------------------------------------------------
;pp pp뢠
;   ᭮ p
;뢮 pp,   p,

INTER:
	PUSH    B
	PUSH    D
	PUSH    H
	PUSH    PSW
;⠭ pppp
	LXI     H,COLTAB+15
	MVI     B,15
IN1:
	MOV     A,B
	OUT     2
	MOV     A,M
	OUT     12
	NOP
	OUT	12
	NOP
	OUT	12
	DCX     H
	DCR     B
	JP      IN1

;pp   ﭨ 䨪p
	LXI	H,TOG
	IN	1
	CMA
	ANI	0E0H
	CMP	M
	JZ	INT1	;᫨  
	ORA	A
	JNZ	INT0	;᫨  饭,  ...
;p祭 pp
	XRA	A
	MOV	M,A
	LDA	TFLAG
	MOV	B,A
	MVI	C,255
	JMP	IADDS1	;ᮮ ᥬ  ⮬ p⭮ ᮡ⨨
INT0:
	MOV	M,A
	STA	TFLAG
INT1:
;p p  
	MVI     A,8AH
	OUT	0
	XRA	A
	OUT     0
;᫨ 祣  ,  室
	XRA	A
	OUT	3
	IN	2
	INR	A
	JZ	INOPRESS
INSCAN:
;⥯p   p ,   
	LXI	B,0FEFFH
INT2:
	MOV	A,B
	OUT	3
	IN	2
	INR	A
	JNZ	INT4

	MOV	A,C
	ADI	8
	MOV	C,A
	MOV	A,B
	RLC
	MOV	B,A
	JC	INT2
; ᯥ  
INOPRESS:
;稪 ⥫쭮 ᪠
;᫨   ᪠  p⪮ p
;  p.
	LXI	H,RELEASECNT
	DCR	M
	JNZ	INOTHING
;⥯p  㦥 筮 饭, ⠪  襬...
	MVI	M,1
	MVI	A,-1
	STA	SCAN
	JMP	INOTHING


INT4:
;᫨ ᪠- 
	DCR	A
INT5:
	INR	C
	RRC
	JC	INT5
;⠭ 稪   p 	
	LXI	H,RELEASECNT
	MVI	M,3

; ⠬ p   ( 㤮⢠)
	MOV	A,C
	CPI	3
	JZ	INT6
	CPI	63
	JNZ	INT7
INT6:
	XRI	3CH
	MOV	C,A
INT7:
;᫨   㦥    ...
	LDA	SCAN
	CMP	C
	LDA	AUTODELAY	;50 -  p  砫 ⮯p
	JNZ	IADDSCAN
	LDA	TFLAG
	ORA	A
	LDA	AUTODELAY	;筮...
	JNZ	IADDSCAN
;... ⮯p
	LXI	H,REPCNT
	DCR	M
	JNZ	INOTHING

	LDA	AUTOSPEED	;p ⮯p

IADDSCAN:
;   楢 p
	STA	REPCNT
	MOV	A,C
	STA	SCAN
	LDA	TOG
	MOV	B,A
IADDS1:
	XRA	A
	STA	TFLAG

	LDA	RBLEN
	CPI	MAXRBLEN
	JNC	INOTHING

	INR	A
	STA	RBLEN

	LDA	RBHEAD
	ANI	MAXRBLEN-1
	ADD	A
	LXI	H,RINGBUF
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A

	MOV	M,C
	INX	H
	MOV	M,B

	LDA	RBHEAD
	INR	A
	ANI	MAXRBLEN-1
	STA	RBHEAD

INOTHING:
;p p
	MVI     A,88H
	OUT     0
;⠭ p
	LDA     STARTROW
	OUT     3
;梥 pp
	LDA	BORDER
	ORI	16	;᮪ pp襭
	OUT	2

	LDA	LOCK
	ANI	TALF
	RLC
	ADI	6
	OUT	0

;뢮 pp
	LDA	CURBLK
	ORA	A
	JZ	IN3

	LXI     H,CURCNT
	DCR     M
	JNZ	IN3

	MOV     M,A
	LXI     H,CURVIS
	MOV     A,M
	XRI     1
	MOV     M,A
	CALL    CURPUT
IN3:

	POP     PSW
	POP     H
	POP     D
	POP     B
	EI
	RET




;뢮 pp  p
CURPUT:
	LHLD    CURADR
	LDA     CURMSK
	MOV     C,A
	LDA     CURH
	MOV     B,A
CP1:    
        DCR     B
	RM
	MOV     A,M
        XRA     C
        MOV     M,A

        MOV     A,H
        XRI     60H
	MOV     H,A

        MOV     A,M
	XRA     C
        MOV     M,A

        MOV     A,H
        XRI     60H
        MOV     H,A

        INR     L
        JMP     CP1

	RET


CURSAV: DB 0

;p pp
CURHID:
	PUSH    PSW
	PUSH    B
	PUSH    H

	LDA     CURSAV
	ORA     A
	JNZ     CH1

	LDA     CURVIS
	ORA     A
	DI
	CNZ     CURPUT
	XRA     A
	STA     CURVIS

	LXI     H,CURH
	MOV     A,M
	STA     CURSAV
	MVI     M,0
	EI

CH1:    POP     H
	POP     B
	POP     PSW
	RET


; pp
CURSHW:
	PUSH    PSW
	PUSH    B
	PUSH    D

	LDA     CURSAV
	ORA     A
	JZ      CSH1

	DI
	STA     CURH
	CALL    CURPUT
	XRA     A
	STA     CURSAV
	INR     A
	STA     CURVIS
	LDA	CURBLK
	STA	CURCNT
	EI
CSH1:
	POP     H
	POP     B
	POP     PSW
	RET


;⠭ pp pp
SETCUR:
	CALL	CURHID
	MOV	A,H
	STA	CURSAV
	MOV	A,L
	STA	CURH
	JMP	CURSHW


;p饭 pp
;室: H - , L - p
; pp p, p 
GOTOXY:
	PUSH    B
	PUSH    D

	XCHG
	LHLD	CURY
	PUSH	H
	XCHG

	SHLD	CURY
	MOV     A,H
	ANI     63
	RAR
	MVI     C,0F0H
	JNC     $+5
	MVI     C,15

	ORI     0A0H
	MOV     D,A

	MOV     A,L
	CALL	MUL10
	MOV     E,A

	LDA     STARTROW
	SUB     E
	SUI     9
	MOV     E,A

	CALL    CURHID

	XCHG
	SHLD    CURADR
	MOV     A,C
	STA     CURMSK

	CALL    CURSHW

	POP     H
	POP     D
        POP     B
	RET


;-----------------------------------------
;뢮 p
;᭠砫 p 頥, ⥬ 뢮
;⥪  ᨬ    32
;pp:
;	DE - 㪠⥫  p ⥪
;	  - p p
; pp p
;-----------------------------------------
PUTS:
	PUSH    PSW
	PUSH    B
	PUSH    D
	PUSH    H
;p pp
	CALL	CURHID
	CALL	MUL10
	MOV     C,A

	LDA     STARTROW
	SUB     C
	SUI     9
	MOV     L,A
;梥  ⪨
	LDA     ATTRIB
	RRC
	MVI     C,0
	JNC     $+5
	MVI     C,255
;⪠ p
	PUSH    D

	MVI     D,10
PSC1:
	MVI	H,0A0H
        MVI     A,16
PSCE2:
	MOV     M,C
	INR     H
        MOV     M,C
        INR     H
	MOV     M,C
        INR     H
        MOV     M,C
        INR     H
        DCR     A
        JNZ     PSCE2

	INR     L
	DCR     D
	JNZ     PSC1

	POP     D
;⮢  뢮
	MOV     A,L
	SUI     10
	MOV     L,A

	MVI     H,0A0H
;H - ᪮  뢮
	MVI     C,0F0H
; - ᪠ ᨬ

PS1:    LDAX    D
	INX     D
	CPI     ' '
	JC      PSEX
	JNZ     PS2	;p  뢮
	MOV     A,H
	XRI     60H
	MOV     H,A
	JMP     PS3
PS2:
	PUSH    D
	PUSH    H
;祭 ᬥ饭  pp
	MOV     L,A
	MVI     H,0
	DAD     H
	XCHG
	LXI     H,FONT
	DAD     D
	XCHG
	DAD     H
	DAD     H
	DAD     D
	XCHG
	POP     H
;뢮   ᪮
	MVI     B,10
PSM1:
	LDAX    D
	RRC
	RRC
	RRC
	RRC
	ANA     C
	XRA     M
	MOV     M,A
	INX     D
	INR     L
	DCR     B
	JNZ     PSM1
;p祭 ᪮⥩
	MOV     A,H
	XRI     60H
	MOV     H,A
;뢮  p ᪮
	MVI     B,10
PSM2:
	DCX     D
	DCR     L
	LDAX    D
	ANA     C
	XRA     M
	MOV     M,A
	DCR     B
	JNZ     PSM2

	POP     D
PS3:
;p祭 ᪨
	MOV     A,C
	CMA
	MOV     C,A
	ORA     A
	JP      PS1
;p祭 樨
	MOV     A,H
	INR     A
	MOV     H,A
	ANI	1FH	;᫨   p...
	JNZ     PS1	; 

PSEX:
	CALL    CURSHW

	POP     H
	POP     D
	POP     B
	POP     PSW
	RET
;-----------------------------------------


MUL10:	;㬭   10
	ADD	A
	PUSH	B
	MOV	C,A
	ADD	A
	ADD	A
	ADD	C
	POP	B
	RET


;p p
;B - p-筨
; - p-p
; - ⢮ p  p
;pp  p
MOVLIN:
	ORA	A
	RZ
	CALL	MUL10
	MOV	D,A

	MOV	A,C
	CALL	MUL10
	MOV	L,A
	MOV	A,B
	CALL	MUL10
	MOV	E,A

	LDA	STARTROW
	MOV	H,A
	SUB	E
	MOV	E,A
	MOV	A,H
	SUB	L
	MOV	L,A

	CALL CURHID

	MOV	A,C
	CMP	B
	RZ
	MOV	B,D
	JNC	ML3

ML1:
	MVI	H,0A0H
	MOV	D,H
	MVI	C,64
ML2:
	LDAX	D
	MOV	M,A
	INR	D
	INR	H
	DCR	C
	JNZ	ML2

	DCR	E
	DCR	L
	DCR	B
	JNZ	ML1
	CALL	CURSHW
	RET
ML3:
	MOV	A,L
	SUB	B
	MOV	L,A
	MOV	A,E
	SUB	B
	MOV	E,A
ML4:
	INR	E
	INR	L
	MVI	H,0A0H
	MOV	D,H
	MVI	C,64
ML5:
	LDAX	D
	MOV	M,A
	INR	H
	INR	D
	DCR	C
	JNZ	ML5

	DCR	B
	JNZ	ML4
	CALL	CURSHW
	RET

;ᤢ p
; -  ᪮쪮 ᤢ
SCROLL:
	PUSH	H
	LXI	H,STARTROW
	ADD	M
	MOV	M,A
	POP	H
	RET




DIGIT10:
	PUSH	B
	MVI	C,0
DG1:
	INR	C
	DAD	D
	JC	DG1
	DCR	C

	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A

	MOV	A,C
	ADI	'0'
	POP	B
	RET

ITOA:
;HL-INT, BC-STR

	LXI	D,-10000
	CALL	DIGIT10
	STAX	B
	INX	B

	LXI	D,-1000
	CALL	DIGIT10
	STAX	B
	INX	B

	LXI	D,-100
	CALL	DIGIT10
	STAX	B
	INX	B
	
	LXI	D,-10
	CALL	DIGIT10
	STAX	B
	INX	B
	
	MOV	A,L
	ADI	'0'
	STAX	B
	INX	B
	XRA	A
	STAX	B
	RET

PRINTINT:
;HL-NUM
	PUSH	B
	PUSH	D
	PUSH	H

	LXI	B,INTBUF
	CALL	ITOA

	LXI	H,INTBUF
PRI1:
	MOV	A,M
	CPI	'0'
	JNZ	PRI2
	INX	H
	JMP	PRI1
PRI2:
	ORA	A
	JNZ	PRI3
	DCX	H
PRI3:
	CALL	PRJUST
	POP	H
	POP	D
	POP	B
	RET

STRLEN:
;HL-STRING ASCIIZ, RET: A-LEN
	PUSH	H
	MVI	C,0
SL1:
	MOV	A,M
	INX	H
	INR	C
	ORA	A
	JNZ	SL1
	DCR	C
	MOV	A,C
	POP	H
	RET


INTBUF:	DS	6

JUSTIFY:	DB	JLEFT
JUSTFILL:	DB	' '
JUSTWID:	DB	64


SETJUST:
;A=JUSTIFY, H-JUSTWID, L-JUSTFILL
	STA	JUSTIFY
	SHLD	JUSTFILL
	RET


PRJUST:
;HL-ASCIIZ STRING (LEN<128)
	PUSH	B
	PUSH	D
	PUSH	H

	CALL	STRLEN
	MOV	C,A

	LXI	D,0
	LDA	JUSTWID
	MOV	B,A

	LDA	JUSTIFY
	CPI	JNOJUST
	JNC	PJPUT

	MOV	A,B
	SUB	C
	JNC	PJ1
	MOV	C,B
	JMP	PJPUT
PJ1:
	MOV	B,A
	LDA	JUSTIFY
	CPI	JLEFT
	JNZ	PJ2
	MOV	E,B
	JMP	PJPUT
PJ2:
	CPI	JRIGHT
	JNZ	PJ3
	MOV	D,B
	JMP	PJPUT
PJ3:
	MOV	A,B
	ORA	A
	RAR
	MOV	D,A
	ACI	0
	MOV	E,A
PJPUT:
	LDA	JUSTFILL
PJP1:
	DCR	D
	JM	PJP2
	CALL	PUTC
	JMP	PJP1
PJP2:
	DCR	C
	JM	PJP3
	MOV	A,M
	INX	H
	CALL	PUTC
	JMP	PJP2
PJP3:
	LDA	JUSTFILL
	DCR	E
	JM	PJP4
	CALL	PUTC
	JMP	PJP3
PJP4:
	POP	H
	POP	D
	POP	B
	RET



COMPDH:
	MOV	A,D
	CMP	H
	RNZ
	MOV	A,E
	CMP	L
	RET

SUBDH:
	MOV	A,E
	SUB	L
	MOV	C,A
	MOV	A,D
	SBB	H
	MOV	B,A
	RET



INDEX:
	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET



STRCPY:
;C-NUM<128
;DE-SRC
;HL-DST

	CALL	COMPDH
	RZ
	JNC	SCP1

	MOV	A,C
	CALL	INDEX
	XCHG
	MOV	A,C
	CALL	INDEX
SCP0:
	DCR	C
	RM
	DCX	D
	DCX	H
	MOV	A,M
	STAX	D
	JMP	SCP0
SCP1:
	DCR	C
	RM
	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	JMP	SCP1


STRSET:
;A-NUM<128
;B-CHAR
;HL-STR

	DCR	A
	RM
	MOV	M,B
	INX	H
	JMP	STRSET




;p pp
ST:	DW	0	;p p
LEN:	DB	0	; p
MAXLEN:	DB	0	;ᨬ쭠  p
X:	DB	0	;  p
XY:	DW	0	;砫쭠  pp


GETS:
;pp  p  ᮫
;室 pp:
;DE - 㪠⥫  p
;p  p - ᨬ쭠  p
;p  - p쭠 
;稭  p쥣  p室  p
;pp:  p
;室 p室 p  ᨬ    32

	SHLD	FILTER1
	SHLD	FILTER2
	LDAX	D
	STA	MAXLEN
	INX	D
	LDAX	D
	STA	LEN

	INX	D
	XCHG
	SHLD	ST

	LXI	H,0
	CALL	GOTOXY
	SHLD    XY
	CALL	GOTOXY

	XRA	A
	STA	X

	LDA	LEN
	LHLD	ST
	CALL	INDEX
	MVI	M,0
	CALL	PRST

	LHLD	XY
	CALL	GOTOXY
	PUSH	B
	PUSH	D
FILTER1:	EQU	$+1
	CALL	GETCH
	POP	D
	POP	B

	CPI	' '
	JC	LPEN
	MOV	C,A

	LDA	LEN
	MVI	B,0
	LHLD	ST
	CALL	STRSET

	LDA	LEN
	MOV	B,A
	MVI	A,' '
GS1:
	CALL	PUTC
	DCR	B
	JP	GS1

	XRA	A
	STA	LEN
	STA	X

	LHLD	XY
	CALL	GOTOXY
	MOV	A,C
	JMP	LPEN

LOOP:
	LDA	X
	LHLD	XY
	ADD	H
	MOV	H,A

	CALL	GOTOXY
	PUSH	B
	PUSH	D
FILTER2:	EQU	$+1
	CALL	GETCH
	POP	D
	POP	B
LPEN:
	LXI	H,LOOP
	PUSH	H

	CPI	KLF
	JZ	CLEFT
	CPI	KRG
	JZ	CRIGHT
	CPI	KHOME
	JZ	CHOME
	CPI	KEND
	JZ	CEND
	CPI	KF2
	JZ	CDEL
	CPI	KBS
	JZ	CBSPACE
	CPI	' '
	JNC	CDEF

	POP	H
	MOV	B,A
	LHLD	ST
	DCX	H
	LDA	LEN
	MOV	M,A
	MOV	A,B
	RET

CLEFT:
	LDA	X
	ORA	A
	RZ
	DCR	A
	STA	X
	RET

CRIGHT:
	LDA	LEN
	LXI	H,X
	CMP	M
	RC
	RZ
	INR	M
	RET

CHOME:
	XRA	A
	STA	X
	RET

CEND:
	LDA	LEN
	STA	X
	RET

CDEL:
	LDA	X
	MOV	B,A
	LXI	H,LEN
	SUB	M
	RNC

	DCR	M
	CMA
	INR	A
	MOV	C,A

	MOV	A,B
	LHLD	ST
	CALL	INDEX
	MOV	E,L
	MOV	D,H
	INX	D
	CALL	STRCPY
PRST:
	LDA	X
	LHLD	ST
	CALL	INDEX
PRST1:
	MOV	A,M
	CALL	PUTC
	INX	H
	ORA	A
	JNZ	PRST1
	RET

CBSPACE:
	CALL	CLEFT
	LDA	X
	LHLD	XY
	ADD	H
	MOV	H,A
	CALL	GOTOXY
	JMP	CDEL

CDEF:
	MOV	B,A
	LDA	MAXLEN
	DCR	A
	LXI	H,LEN
	CMP	M
	RC
	RZ

	INR	M
	LDA	X
	SUB	M
	CMA
	INR	A
	MOV	C,A

	LDA	X
	LHLD	ST
	CALL	INDEX

	PUSH	H
	MOV	E,L
	MOV	D,H
	INX	H
	CALL	STRCPY
	POP	H

	MOV	M,B
	CALL	PRST
	JMP	CRIGHT






;That's all, folks

;------H------

	END

