;----- KRedit v1.0 ---------
;   ⮢ pp
; 㧭殢 ..    () 1994
;     .pp
;---------------------------

;------- p --------

KRBIOS:	EQU	2100H

; pp KRBIOS

KRINIT:	EQU	KRBIOS+0
PUTC:	EQU	KRBIOS+3
PUTCH:	EQU	KRBIOS+6
PUTS:	EQU	KRBIOS+9
SETATR:	EQU	KRBIOS+12
INKEY:	EQU	KRBIOS+15
;GETCH:	EQU	KRBIOS+18
GOTOXY:	EQU	KRBIOS+21
SETCUR:	EQU	KRBIOS+24
MOVLIN:	EQU	KRBIOS+27
SCROLL:	EQU	KRBIOS+30
SETJUST:EQU	KRBIOS+33
PRJUST:	EQU	KRBIOS+36
PRINTINT:EQU	KRBIOS+39
SETAUTO:EQU	KRBIOS+42
GETS:	EQU	KRBIOS+45

;----   -----
KTAB:   EQU     9
KLFEED: EQU     10
KCR:    EQU     13
KBS:    EQU     127
KLF:    EQU     8
KUP:    EQU     25
KRG:    EQU     24
KDN:    EQU     26
KHOME:  EQU     31
KEND:   EQU     12
KESC:   EQU     27
KF1:    EQU     1
KF2:    EQU     2
KF3:    EQU     3
KF4:    EQU     4
KF5:    EQU     5
KSP:    EQU     32

;---- ᪠- ------
STAB:	EQU	0
SLFEED:	EQU	1
SCR:	EQU	2
SBS:	EQU	63
SLF:	EQU	4
SUP:	EQU	5
SRG:	EQU	6
SDN:	EQU	7
SHOME:	EQU	8
SEND:	EQU	9
SESC:	EQU	10
SF1:	EQU	11
SF2:	EQU	12
SF3:	EQU	13
SF4:	EQU	14
SF5:	EQU	15

;--- ᪨ 䨪p ---
TSHIFT: EQU     020H
TCTRL:  EQU     040H
TALF:   EQU     80H

;--- p p ---
MINX:	EQU	0
MINY:	EQU	0
MAXX:	EQU	63
MAXY:	EQU	24

;--- p p ----
JLEFT:	EQU	0
JRIGHT:	EQU	1
JCENTER:	EQU	2
JNOJUST:	EQU	3

;--- p ⥪ ----
MAXLEN:	EQU	128

TEXT:	EQU	2A00H
EOL:	EQU	KCR
EOT:	EQU	0

;⢮  㭪権
FNUM:	EQU	30

;p FCB
FCB:	EQU	5CH




	ORG	100H
	JMP	BEGIN

;⥪  ᮮ饭

NULLP:	DB	0
EOLPTR:	DB	EOL
MENULINE:	DB 'KRedit v1.1    . pp     㧭殢 ..  (C) 1994',0
STATLINE:	DB ' :                                        :       ',0
TINSERT:	DB '⠢',0
TOVERT:		DB '',0

RUS:	DB	'p',0
LAT:	DB	'',0
STR:	DB	'p',0
PROP:	DB	'',0

SELECT:	DB ' 롮p: I-⥭ O- L- R- Q-室',0

FSTR:	DB 50,0
	DS 50
FREPL:	DB 50,0
	DS 50
FIND:	DB ' :',0
REPLACE:DB ' :',0
TFINDING: DB ' ...',0
SNOFND: DB ' p  ',0
CONFIRM:DB '  ? Y-  N-  G-  2-室',0
TOOLONG:DB '  p',0
GLOBAL:	DB 0

FILE:	DB ' :',0
BAK:	DB 'BAK'
WRNAME: DB ' Hp  䠩 !!!',0
NOFOUND:DB '    !!!',0
WRITERR:DB '訡 ',0
FNAME:	DB 15,0
	DS 15

;ᮮ⢥⢨   㭪権
CODETAB:DB SLF,  0,SRG, 0,SUP, 0,SDN,0
	DB SHOME,0,SEND,0,SF1, 0,SF2,0
	DB CTAB, 0,SBS, 0,SESC,0,SCR,0

	DB SLF,  TCTRL,SRG, TCTRL,SUP,TCTRL,SDN,TCTRL
	DB SHOME,TCTRL,SEND,TCTRL,          SF2,TCTRL

	DB SUP,TSHIFT,SDN,TSHIFT,SF1,TSHIFT,SF2,TSHIFT

	DB SUP,  TCTRL+TSHIFT,SDN, TCTRL+TSHIFT
	DB SHOME,TCTRL+TSHIFT,SEND,TCTRL+TSHIFT

	DB SF3,0,SF4,0,SF5,0

FTAB:	DW CLEFT,CRIGHT,CUP,  CDOWN
	DW CHOME,CEND,  CINS, CDEL
	DW CTAB, CBSPACE,FUNC,SPLIT

	DW CWDLF,CWDRG, CPGUP,CPGDN
	DW CTOP, CBOTTOM,     CDELLIN

	DW CMARKUP,CMARKDN,CCOPY,CCUT

	DW CMKPGUP,CMKPGDN,CMKTOP,CMKBOT

	DW CCENTER,CFORMAT,CBOUNDS


;p pp
CURBLK:	DB	5	; 
CURH:	DB	2	;⥪ 

CURHINS:	DB	2	; pp ⠢
CURHOVRT:	DB	10	; pp 

;p 뢮 ⥪

ATNORMAL:	DB	0	;p⮩ ⥪
ATMARKED:	DB	1	;뤥 ⥪
ATMENU:		DB	1	;

;⥬ p
INTDOS:	DW	0	;p pp뢠 ⥬
INTKR:	DW	0	;p pp뢠 pp
PORT10:	DB	0	;ﭨ p 10
LOADEND:DW	0A000H	; 䠩  

;p ⥪
MEMTOP:	DW	0A000H	;p p 
TTOP:	DW	TEXT-1		;㪠⥫  砫 ⥪
TEND:	DW	0A000H	;㪠⥫   ⥪
TOPLIN:	DW	TEXT		;㪠⥫  p p p  ⥪
BTOP:	DW	0	;㪠⥫  砫   ⥪
BEND:	DW	0	;㪠⥫   
SADR:	DW	TEXT	;㪠⥫  pp㥬 p
PSADR:	DW	0	;㪠⥫  ᫥   p
Y:	DB	MINY+1	;p⨪쭠  pp
X:	DB	0	;p⠫쭠  pp
DX:	DB	0	;ᬥ饭 p  p⠫
LINE:	DW	0	;p pp㥬 p  ⥪
MAXLINE:DW	40	;⢮ p  ⥪
LEN:	DB	0	; pp㥬 p
MODIFIED:	DB	0	;䫠 樨 p

INSERT:	DB	0		;䫠 p ⠢
AUTOINDENT:	DB	1	;䫠 p ⮮㯠
HYPHENIZE:	DB	1	;䫠 p

OLDTOPLIN:	DW	0	;p p p
OLDDX:		DB	0	;p ᤢ


;p
ST:	DS	MAXLEN	;p p
BUF:	DS	MAXLEN	;p㣮 p p




;----- 㯮p⥫ 㭪樨 ------

INVHL:
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	RET


COMPDH:
	MOV	A,D
	CMP	H
	RNZ
	MOV	A,E
	CMP	L
	RET

SUBDH:
	MOV	A,E
	SUB	L
	MOV	C,A
	MOV	A,D
	SBB	H
	MOV	B,A
	RET

INDEX:
	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET



;----- 䨪p  pp -----

ISUPLAT:
	CPI	'A'
	CMC
	RNC
	CPI	'Z'+1
	RET

ISLOWLAT:
	CPI	'a'
	CMC
	RNC
	CPI	'z'+1
	RET

ISUPCYR:
	CPI	''
	CMC
	RNC
	CPI	''+1
	RC
	CPI	240
	STC
	RZ
	CPI	242
	STC
	RZ
	CPI	244
	STC
	RZ
	CPI	246
	STC
	RZ
	ORA	A
	RET

ISLOWCYR:
	CPI	''
	CMC
	RNC
	CPI	''+1
	RC
	CPI	224
	CMC
	RNC
	CPI	''+1
	RC
	CPI	241
	STC
	RZ
	CPI	243
	STC
	RZ
	CPI	245
	STC
	RZ
	CPI	247
	STC
	RZ
	ORA	A
	RET

ISDIGIT:
	CPI	'0'
	CMC
	RNC
	CPI	'9'+1
	RET

ISXDIGIT:
	CALL	ISDIGIT
	RC
	CALL	TOUPPER
	CPI	'A'
	CMC
	RNC
	CPI	'F'+1
	RET

ISLAT:
	CALL	ISUPLAT
	RC
	JMP	ISLOWLAT

ISCYR:
	CALL	ISUPCYR
	RC
	JMP	ISLOWCYR

ISUPPER:
	CALL	ISUPLAT
	RC
	JMP	ISUPCYR

ISLOWER:
	CALL	ISLOWLAT
	RC
	JMP	ISLOWCYR

ISALPHA:
	CALL	ISLAT
	RC
	JMP	ISCYR

ISALNUM:
	CALL	ISALPHA
	RC
	JMP	ISDIGIT

TOUPPER:
	CALL	ISLOWLAT
	JNC	TU1
	SUI	32
	RET
TU1:
	CALL	ISLOWCYR
	RNC
	CPI	''+1
	JNC	TU2
	SUI	32
	RET
TU2:
	CPI	''+1
	JNC	TU3
	SUI	224-144
	RET
TU3:
	DCR	A
	RET


;---- 騥 㭪樨 p   ------

MEMCPY:
;BC-NUM
;DE-SRC
;HL-DST

	CALL	COMPDH
	RZ
	JNC	MCP1

	DAD	B
	XCHG
	DAD	B
MCP0:
	MOV	A,B
	ORA	C
	RZ
	DCX	B
	DCX	D
	DCX	H
	MOV	A,M
	STAX	D
	JMP	MCP0
MCP1:
	MOV	A,B
	ORA	C
	RZ
	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCX	B
	JMP	MCP1


;---- p 㭪樨 ------

STRCPY:
;C-NUM<128
;DE-SRC
;HL-DST

	CALL	COMPDH
	RZ
	JNC	SCP1

	MOV	A,C
	CALL	INDEX
	XCHG
	MOV	A,C
	CALL	INDEX
SCP0:
	DCR	C
	RM
	DCX	D
	DCX	H
	MOV	A,M
	STAX	D
	JMP	SCP0
SCP1:
	DCR	C
	RM
	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	JMP	SCP1


STRSET:
;A-NUM<128
;B-CHAR
;HL-STR

	DCR	A
	RM
	MOV	M,B
	INX	H
	JMP	STRSET


STRLEN:
;HL-STRING ASCIIZ, RET: A-LEN
	PUSH	H
	MVI	C,0
SL1:
	MOV	A,M
	INX	H
	INR	C
	ORA	A
	JNZ	SL1
	DCR	C
	MOV	A,C
	POP	H
	RET

STRCMP:
	LDAX	D
	ORA	A
	STC
	RZ

	CPI	'?'
	JNZ	SC1
	MOV	A,M
	ORA	A
	JNZ	SC2
SC1:
	CPI	'*'
	JNZ	SC3

	INX	D
	PUSH	H
	CALL	STRSTR
	POP	H
	RET

SC3:
	CALL	TOUPPER
	MOV	C,A

	MOV	A,M
	ORA	A
	RZ

	CALL	TOUPPER
	SUB	C
	ORA	A
	RNZ
SC2:
	INX	D
	INX	H
	JMP	STRCMP


STRSTR:
	PUSH	D
	PUSH	H
	CALL	STRCMP
	MOV	A,M
	POP	H
	POP	D
	RC

	ORA	A
	RZ
	INX	H
	JMP	STRSTR


;----- ᯮ⥫ 㭪樨 -----

CURPOS:
	CALL	XCHECK
	LXI	H,OLDDX
	LDA	DX
	CMP	M
	JNZ	PUTPAGE

	LHLD	OLDTOPLIN
	XCHG
	LHLD	TOPLIN
	CALL	COMPDH
	JZ	CP1
PUTPAGE:
	CALL	PUTTXT
	LHLD	TOPLIN
	SHLD	OLDTOPLIN
	LDA	DX
	STA	OLDDX
CP1:
	LHLD	Y
	LDA	DX
	SUB	H
	CMA
	INR	A
	MOV	H,A
	CALL	GOTOXY
	LHLD	SADR
	CALL	TEXTATR
	LHLD	CURBLK
	CALL	SETCUR
	RET


SCROLLDN:
	PUSH	B
	mvi	b,MAXY
	mvi	c,MAXY-1
	mvi	a,MINY+3
	call	MOVLIN

	mvi	a,10
	call	SCROLL
	POP	B
	RET


SCROLLUP:
	PUSH	B
	mvi	b,-2
	mvi	c,-1
	mvi	a,MINY+3
	call	MOVLIN

	mvi	a,-10
	call	SCROLL
	POP	B
	RET


ASTX:
	LDA	X
	LXI	H,ST
	JMP	INDEX


XCHECK:
	LXI	H,DX
	LDA	X
	CMP	M
	JNC	XC1

	ANI	0F0h
	mov	m,a
	ret
XC1:
	sub	m
	cpi	MAXX+1
	rc
	lda	X
	ani	0F0H
	sui	MAXX-15
	mov	m,a
	ret


TEXTLINE:
;HL-STR	,OUT: HL-LINENUM
	DCX	H
	XCHG
	LHLD	TTOP
	INX	H
	LXI	B,0
TXL1:
	CALL	COMPDH
	JC	TXL2
	CALL	NEXT
	JNC	TXL2
	INX	B
	JMP	TXL1
TXL2:
	XCHG
	MOV	L,C
	MOV	H,B
	RET


;-------  㭪樨 -------

INBLOCK: ;DE-ADR
	LHLD	BTOP
	CALL	COMPDH
	CMC
	RNC
	LHLD	BEND
	CALL	COMPDH
	RET


TEXTATR:
	PUSH	D
	XCHG
	CALL	INBLOCK
	XCHG
	LDA	ATNORMAL
	JNC	$+6
	LDA	ATMARKED
	CALL	SETATR
	POP	D
	RET


BLKCPY:
	LHLD	BEND
	XCHG
	LHLD	BTOP
	CALL	SUBDH
	RC

	XCHG
	DCX	H
	SHLD	BEND

	LHLD	SADR
	MOV	D,H
	MOV	E,L
	DAD	B
	CALL	MOVTXT

	LHLD	BEND
	INX	H
	SHLD	BEND
	RNC

	LHLD	BTOP
	XCHG
	CALL	MEMCPY
	RET

BLKDEL:
	LHLD	BTOP
	XCHG
	LHLD	SADR
	CALL	COMPDH
	JNC	BD1

	LHLD	BEND
	CALL	SUBDH
	RZ
	RNC

	LHLD	SADR
	DAD	B
	SHLD	SADR
	SHLD	TOPLIN
	SHLD	OLDTOPLIN
	MVI	A,MINY+1
	STA	Y
BD1:
	LHLD	BEND
	XCHG
	LHLD	BTOP
	CALL	MOVTXT
	RET


BLKBOUND:
;DE-ADR, A-RETCODE: 0-BOTH, 1-TOP, 2-BOTTOM, 3-NEW
	PUSH	D
	LHLD	BTOP
	XCHG
	LHLD	BEND
	CALL	COMPDH
	POP	D
	MVI	A,3
	RZ

	CALL	COMPDH
	MVI	A,2
	RZ

	LHLD	BTOP
	CALL	COMPDH
	MVI	A,1
	RZ

	XRA	A
	RET



BLKCHECK:
	LHLD	BTOP
	XCHG
	LHLD	BEND
	CALL	COMPDH
	RC
	SHLD	BTOP
	XCHG
	SHLD	BEND
	RET


SETBLOCK:
;DE-OLD, HL-NEW
;A-CODE, 0-BOTH,1-TOP,2-BOTTOM,3-NEW

	PUSH	H
	CALL	BLKBOUND
	POP	H

	CPI	1
	JZ	SB1

	CPI	2
	SHLD	BEND
	JZ	SB2

	XCHG
SB1:
	SHLD	BTOP
SB2:
	PUSH	PSW
	CALL	BLKCHECK
	POP	PSW
	RET


;------- 㭪樨 뢮 ---------

PUTST:
	LHLD	SADR
	CALL	TEXTATR

	LXI	H,ST
	LDA	DX
	CALL	INDEX
	XCHG
	LDA	Y
	CALL	PUTS
	RET

PRINTX:
	PUSH	H

	LDA	ATMENU
	CALL	SETATR
	LXI	H,3200H+MAXY
	CALL	GOTOXY
	LXI	H,300H+' '
	MVI	A,JRIGHT
	CALL	SETJUST

	LDA	X
	MOV	L,A
	MVI	H,0
	CALL	PRINTINT

	POP	H
	RET
	

PRINTY:
	PUSH	H

	LDA	ATMENU
	CALL	SETATR
	LXI	H,3600H+MAXY
	CALL	GOTOXY
	LXI	H,500H+' '
	MVI	A,JLEFT
	CALL	SETJUST

	LHLD	LINE
	CALL	PRINTINT
	
	POP	H
	RET

PRINTXY:
	CALL	PRINTX
	CALL	PRINTY
	RET


PRINTFREE:
	PUSH	B
	PUSH	D
	PUSH	H
	LDA	ATMENU
	CALL	SETATR
	LXI	H,0D00H+MAXY
	CALL	GOTOXY
	LXI	H,500H+' '
	MVI	A,JLEFT
	CALL	SETJUST
	
	LHLD	MEMTOP
	XCHG
	LHLD	TEND
	CALL	SUBDH
	MOV	H,B
	MOV	L,C
	CALL	PRINTINT

	POP	H
	POP	D
	POP	B
	RET


PUTTXT:
	LXI	H,0
	CALL	SETCUR

	LHLD	TOPLIN
	MVI	B,1
PTX1:
	CALL	TEXTATR
	MOV	A,M
	CPI	EOT
	JNZ	$+4
	DCX	H

	XCHG
	LDA	Y
	CMP	B
	JNZ	PTX11
	LDA	MODIFIED
	ORA	A
	JZ	PTX11
	LHLD	SADR
	CALL	COMPDH
	JNZ	PTX11

	CALL	PUTST
	LHLD	PSADR
	MOV	A,B
	JMP	PTX12
PTX11:
	MVI	C,0
	LXI	H,BUF
	CALL	DECODE

	LXI	H,BUF
	LDA	DX
	CALL	INDEX
	XCHG
	MOV	A,B
	CALL	PUTS
PTX12:
	INR	A
	MOV	B,A
	CPI	MAXY
	JC	PTX1
PTEX:
	RET


;---- pp -----

BEGIN:
	DI
	LXI	SP,KRBIOS-0A00H

	IN	10H
	STA	PORT10
	LHLD	39H
	SHLD	INTDOS
	XRA	A
	OUT	10H
	CALL	KRINIT
	LHLD	39H
	SHLD	INTKR

	CALL	DOSON
	CALL	PROTECT
	LXI	D,FCB
	MVI	C,15	;OPEN
;	CALL	5
;	ORA	A
;	JP	FIN1
REP:
	LXI	SP,KRBIOS-0A00H
	CALL	DOSOFF
	
	LDA	ATMENU
	CALL	SETATR

	LXI	D,MENULINE
	MVI	A,MINY
	CALL	PUTS
	MVI	A,MAXY
	LXI	D,STATLINE
	CALL	PUTS

	MVI	A,0
	CALL	SETATR

	LHLD	TEND
	CALL	INIT
	INX	H
	SHLD	MAXLINE
	XCHG
	SHLD	TEND

	LHLD	TTOP
	MVI	M,EOT

	LXI	H,TEXT
	SHLD	SADR
	SHLD	TOPLIN
	CALL	GETSTR

	LXI	H,0
	SHLD	OLDTOPLIN
	SHLD	BTOP
	SHLD	BEND
	SHLD	LINE

	XRA	A
	STA	X
	STA	DX
	MVI	A,MINY+1
	STA	Y

	xra	a
	sta	INSERT
	CALL	PRINTX
	CALL	PRINTY
	CALL	PRINTFREE
	MVI	C,0
	CALL	PRINTREG
	CALL	CINS
	JMP	LOOP


;------  横 ---------

LOOP:
	CALL	CURPOS
LP2:
	CALL	GETCH

	LXI	H,LOOP
	PUSH	H

	LXI	H,CODETAB
	MOV	E,A
	MVI	D,FNUM
LP3:
	MOV	A,C
	CMP	M
	INX	H
	JNZ	LP4

	MOV	A,B
	CMP	M
	JZ	LP5
LP4:
	INX	H
	DCR	D
	JNZ	LP3

	MOV	A,E
	CPI	' '
	JNC	DEFAULT

	POP	H
	JMP	LP2
LP5:
	MVI	A,FNUM
	SUB	D
	ADD	A
	MOV	E,A
	MVI	D,0
	LXI	H,FTAB
	DAD	D

	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	PCHL


;------ 㭪樨 pp -------

CINS:
	LDA	INSERT
	XRI	1
	STA	INSERT

	LDA	CURHINS
	MOV	H,A
	LXI	D,TINSERT
	JNZ	CI1
	LDA	CURHOVRT
	MOV	H,A
	LXI	D,TOVERT
CI1:
	LDA	CURBLK
	MOV	L,A
	SHLD	CURBLK
	CALL	SETCUR

	LDA	ATMENU
	CALL	SETATR
	LXI	H,1800H+MAXY
	CALL	GOTOXY
	LXI	H,800H+' '
	MVI	A,JCENTER
	CALL	SETJUST
	
	XCHG
	CALL	PRJUST
	RET


CDEL:
	CALL	ASTX
	MOV	A,M
	ORA	A
	JZ	CONCAT
	STA	MODIFIED

	LDA	X
	MOV	C,A
	CALL	ASTX
	MOV	D,H
	MOV	E,L
	INX	D

	LDA	LEN
	SUB	C
	INR	A
	MOV	C,A
	CALL	STRCPY

	LXI	H,LEN
	DCR	M
PRINTST:
	LXI	H,0
	CALL	SETCUR
	LHLD	SADR
	CALL	TEXTATR
	CALL	ASTX

	LDA	DX
	MOV	D,A
	LDA	X
	SUB	D
	MOV	D,A
	LDA	Y
	MOV	E,A
	XCHG
PRS1:
	PUSH	H
	CALL	GOTOXY
	POP	H
	LDAX	D
	INX	D
	CALL	PUTCH
	ORA	A
	JZ	PRS2
	INR	H
	MOV	A,H
	ANI	MAXX
	JNZ	PRS1
PRS2:
	RET


CTAB:
	LDA	X
	ANI	0F8H
	ADI	8
	MOV	B,A
	CPI	MAXLEN-1
	RNC

	LDA	INSERT
	ORA	A
	JZ	CTBEX

	LDA	X
	MOV	C,A
	LDA	LEN
	SUB	C
	JC	CTBEX

	MOV	C,A
	ADD	B
	CPI	MAXLEN-1
	RNC
	STA	LEN
	STA	MODIFIED

	CALL	ASTX

	XCHG
	MOV	A,B
	LXI	H,ST
	CALL	INDEX
	CALL	STRCPY

	LDA	X
	SUB	B
	CMA
	INR	A
	MOV	C,B
	MVI	B,' '
	CALL	STRSET

	CALL	PRINTST
	MOV	B,C
CTBEX:
	MOV	A,B
	STA	X
	CALL	PRINTX
	RET

	
CONCAT:
;᪫ p
; ⥪饩 p 楯 ᫥
;p SADR, ⠭ MODIFIED
	LDA	LEN
	MOV	B,A
;᫨ ⥪ p ᫥,  ᪫ 祣
	LHLD	PSADR
	CALL	NEXT
	RNC
	LHLD	PSADR
	XCHG
;p᪮p ᫥ p  p
	LXI	H,BUF
	MVI	C,0
	CALL	DECODE
;᫨ 㬬p   ᨬ쭮,   ...
	LDA	X
	ADD	C
	CPI	MAXLEN-1
	RNC
; ᪫
	STA	LEN
	MVI	A,1
	STA	MODIFIED
;   PSADR
	LHLD	PSADR
	XCHG
	SHLD	PSADR

	PUSH	H	
	CALL	BLKBOUND
	POP	H

	CPI	3
	JZ	CNC0
	CPI	0
	JZ	CNC0

	CALL	SETBLOCK
CNC0:	
;p⮪  殬 p  窮 ᪫  p	
	MOV	A,B
	LXI	H,ST
	CALL	INDEX
	
	LDA	X
	SUB	B
	MVI	B,' '
	CNZ	STRSET
;ᮥ p
	LXI	D,BUF
	CALL	STRCPY
;饥 ⢮ p 㬥訫
	LHLD	MAXLINE
	DCX	H
	SHLD	MAXLINE
;뢥 ᪫ p
	CALL	PUTST
;᫨ p ᠬ  p  p
	LDA	Y
	INR	A
	MOV	C,A
	MVI	A,MAXY
	SUB	C
	RZ

	MOV	C,A
	LHLD	PSADR
CNC1:
	DCR	C
	JZ	CNC2
	CALL	NEXT
	JC	CNC1

	LXI	H,EOLPTR
CNC2:
;p᪮p  p  p
	CALL	TEXTATR
	XCHG
	LXI	H,BUF
	MVI	C,0
	CALL	DECODE
;ᤢ  p p  ⥪饩 p
	LDA	Y
	INR	A
	MOV	C,A
	INR	A
	MOV	B,A
	
	MVI	A,MAXY
	SUB	B
	CNC	MOVLIN
;뢥  p
	LDA	DX
	LXI	H,BUF
	CALL	INDEX
	XCHG
	MVI	A,MAXY-1
	CALL	PUTS
;⠭ ⥪騩 梥 
	RET


SPLIT:
	LDA	X
	MOV	C,A
	LDA	LEN
	CMP	C
	JNC	SPL1
	STA	X
SPL1:
	LXI	H,ST
	MVI	B,0
	LDA	AUTOINDENT
	ORA	A
	JZ	SPL3
SPL2:
	MOV	A,M
	CPI	' '
	JNZ	SPL3
	INX	H
	INR	B
	JMP	SPL2
SPL3:
	LDA	X
	CMP	B
	JNC	SPL4
	MOV	B,A
SPL4:
	MOV	A,B
	LXI	H,ST
	CALL	INDEX

	PUSH	H
	LXI	D,ST
	LXI	H,BUF
	LDA	X
	MOV	C,A
	CALL	STRCPY
	POP	D

	LDA	X
	MOV	C,A
	CALL	ASTX
	XCHG

	LDA	LEN
	SUB	C
	INR	A
	MOV	C,A

	ADD	B
	DCR	A
	STA	LEN

	CALL	STRCPY

	PUSH	B

	LDA	X
	SUB	B
	MVI	B,0
	CALL	STRSET

	LDA	Y
	INR	A
	MOV	B,A
	INR	A
	MOV	C,A

	MVI	A,MAXY
	SUB	C
	CNC	MOVLIN

	LXI	H,ST
	LDA	DX
	CALL	INDEX
	XCHG
	LDA	Y
	INR	A
	CPI	MAXY
	CC	PUTS

	MVI	A,1
	STA	MODIFIED
	CALL	PUTSTR

	LHLD	MAXLINE
	INX	H
	SHLD	MAXLINE

	LXI	D,BUF
	LXI	H,ST
	LDA	X
	STA	LEN
	MOV	C,A
	CALL	STRCPY
	MVI	M,0

	LHLD	SADR
	SHLD	PSADR

	POP	B
	MOV	A,B
	STA	X
	CALL	PRINTX

	CALL	PUTST
	JMP	CDOWN
	

CDELLIN:
	LHLD	SADR
	CALL	NEXT
	RNC

	LXI	H,ST
	MVI	B,0
	LDA	LEN
	CALL	STRSET

	XRA	A
	STA	X
	STA	LEN
	CALL	PRINTX

	JMP	CONCAT


CBSPACE:
	LDA	X
	ORA	A
	RZ
	DCR	A
	STA	X
	CALL	PRINTX

	CALL	ASTX
	MOV	A,M
	ORA	A
	JNZ	CDEL
	RET


;---- 㭪  ------

DEFAULT:
	MOV	B,A

	LDA	X
	MOV	C,A
	CALL	ASTX

	MOV	A,M
	ORA	A
	JNZ	DEF1

	MOV	A,C
	CPI	MAXLEN-1
	RNC

	LDA	LEN
	MOV	D,A
	LXI	H,ST
	CALL	INDEX

	MOV	A,C
	STA	LEN
	SUB	D

	MOV	C,B
	MVI	B,' '
	CALL	STRSET
	MOV	B,C
	JMP	DEF2
DEF1:
	LDA	INSERT
	ORA	A
	JZ	DEF3

	LDA	X
	MOV	C,A
	LDA	LEN
	CPI	MAXLEN-1
	RNC

	SUB	C
	MOV	C,A

	CALL	ASTX
	MOV	D,H
	MOV	E,L
	INX	H
	CALL	STRCPY
DEF2:	
	LDA	LEN
	INR	A
	STA	LEN
DEF3:
	CALL	ASTX

	MOV	M,B

	CALL	PRINTST

	MVI	A,1
	STA	MODIFIED
	JMP	CRIGHT



;----- 㭪樨 p饭 ------
CRIGHT:
	LDA	X
	CPI	MAXLEN-1
	RNC
	INR	A
	STA	X
	CALL	PRINTX
	RET

CLEFT:
	LDA	X
	ORA	A
	RZ
	DCR	A
	STA	X
	CALL	PRINTX
	RET

CUP:
	CALL	PUTSTR
	LDA	MODIFIED
	ORA	A
	JZ	CUP1

	LHLD	SADR
	CALL	GETSTR
	CALL	PUTST
CUP1:
	LHLD	SADR
	CALL	PREV
	RNC

	CALL	GETSTR

	LHLD	LINE
	DCX	H
	SHLD	LINE
	CALL	PRINTY

	LDA	Y
	CPI     MINY+1
	JZ	CUP3

	DCR	A
	STA	Y
	RET
CUP3:
	CALL	SCROLLDN
	LHLD	SADR
	SHLD	TOPLIN
	SHLD	OLDTOPLIN
	CALL	PUTST
	RET

CDOWN:
	CALL	PUTSTR
	LDA	MODIFIED
	ORA	A
	JZ	CDN1

	LHLD	SADR
	CALL	GETSTR
	CALL	PUTST
CDN1:
	LHLD	SADR
	CALL	NEXT
	RNC

	SHLD	SADR
CDN2:
	LHLD	LINE
	INX	H
	SHLD	LINE
	CALL	PRINTY

	LHLD	SADR
	CALL	GETSTR

	LDA	Y
	CPI	MAXY-1
	JNC	CDN5
	INR	A
	STA	Y
	RET
CDN5:
	CALL	SCROLLUP
	LHLD	TOPLIN
	CALL	NEXT
	SHLD	TOPLIN
	SHLD	OLDTOPLIN
	CALL	PUTST
	RET

CHOME:
	XRA	A
	STA	X
	CALL	PRINTX
	RET

CEND:
	LDA	LEN
	STA	X
	CALL	PRINTX
	RET


CWDLF:
	CALL	ASTX
	XCHG
CWL1:
	LDAX	D
	CALL	ISALPHA
	JNC	CWL2
	DCX	D
	JMP	CWL1
CWL2:
	LDAX	D
	ORA	A
	RZ
	CALL	ISALPHA
	JC	CWL3
	DCX	D
	JMP	CWL2
CWL3:
	LXI	H,ST
	CALL	SUBDH
	MOV	A,C
	STA	X
	RET


CWDRG:
	CALL	ASTX
	XCHG
CWR1:
	LDAX	D
	CALL	ISALPHA
	JNC	CWR2
	INX	D
	JMP	CWR1
CWR2:
	LDAX	D
	ORA	A
	RZ
	CALL	ISALPHA
	JC	CWR3
	INX	D
	JMP	CWR2
CWR3:
	LXI	H,ST
	CALL	SUBDH
	MOV	A,C
	STA	X
	RET



CPGUP:
	CALL	PUTSTR
	LHLD	SADR
	XCHG
	LHLD	TOPLIN
	MVI	C,MAXY-MINY-2
CPU1:
	CALL	PREV
	JNC	CPU2
	XCHG
	CALL	PREV
	XCHG

	PUSH	H
	LHLD	LINE
	DCX	H
	SHLD	LINE
	POP	H

	DCR	C
	JNZ	CPU1
CPU2:
	SHLD	TOPLIN
	LHLD	SADR
	XCHG

	CALL	PRINTY

CBLK:	
	PUSH	D
	PUSH	H
	CALL	GETSTR
	POP	H
	POP	D
	RET

CPGDN:
	CALL	PUTSTR
	LHLD	TOPLIN
	XCHG
	LHLD	SADR
	MVI	C,MAXY-MINY-2
CPD1:
	CALL	NEXT
	JNC	CPD2
	XCHG
	CALL	NEXT
	XCHG

	PUSH	H
	LHLD	LINE
	INX	H
	SHLD	LINE
	POP	H

	DCR	C
	JNZ	CPD1
CPD2:
	XCHG
	SHLD	TOPLIN
	LHLD	SADR
	XCHG

	CALL	PRINTY
	JMP	CBLK



CTOP:
	CALL	PUTSTR
	MVI	A,MINY+1
	STA	Y
	XRA	A
	STA	X
	LXI	H,0
	SHLD	LINE
	CALL	PRINTXY

	LHLD	SADR
	XCHG
	LHLD	TTOP
	INX	H
	SHLD	TOPLIN
	JMP	CBLK

CBOTTOM:
	CALL	PUTSTR
	LHLD	TEND
	MVI	C,MAXY-MINY-1
CBT1:
	CALL	PREV
	JNC	CBT2
	DCR	C
	JNZ	CBT1
CBT2:
	SHLD	TOPLIN
	MVI	A,MAXY-MINY-1
	SUB	C
	STA	Y
	XRA	A
	STA	X
	LHLD	MAXLINE
	DCX	H
	SHLD	LINE
	CALL	PRINTXY

	LHLD	SADR
	XCHG
	LHLD	TEND
	CALL	PREV
	JMP	CBLK

;------- 㭪樨 pp ------

BLANKS:
	LDAX	D
	CPI	' '
	JZ	BL1
	CPI	KTAB
	JZ	BL1
	CPI	KCR
	JZ	BL1
	CPI	KLFEED
	RNZ
BL1:
	INX	D
	JMP	BLANKS	
	

LETTERS:
	MVI	C,0
LET1:
	LDAX	D
	CPI	' '+1
	RC
	INX	D
	INR	C
	JMP	LET1


VOWELS:	DB 'I'

ISVOWEL:	;䨪p .  - ᨬ CY=1 - ᭠
	CALL	TOUPPER
	PUSH	B
	PUSH	H
	LXI	H,VOWELS
	MVI	B,14
ISV1:
	CMP	M
	STC
	JZ	ISV2
	INX	H
	DCR	B
	JNZ	ISV1
	ORA	A
ISV2:
	POP	H
	POP	B
	RET


FINDVOWEL:	;   ᫮. CY=1 - 
	LDAX	D
	CALL	ISVOWEL
	RC
	CPI	' '+1
	CMC
	RNC
	INX	D
	JMP	FINDVOWEL


SPLITWORD:
; ᫮  BUF   .  -  
;p: CY=1 - ᯥ譮 C - ⨬ 
	MVI	B,255
	LXI	D,BUF
SW1:
	CALL	FINDVOWEL	;   ⥪饩 樨
	JC	SW11	;᫨ 
	MOV	A,B
	CMP	C
	RNC
	MOV	C,A
	JMP	SPLITWORD
SW11:	
;᫨  ᭮
	LXI	H,BUF
	PUSH	B
	CALL	SUBDH
	MOV	A,C
	POP	B

	CMP	C	;p  ⨬
	JNC	SW2	;᫨   p室
	MOV	B,A	; -  ᭮  p
	INX	D	;᪠ 
	JMP	SW1
SW2:
	CMP	B
	CMC
	RNC

	ADD	B
	INR	A
	RAR
	DCR	A
	CMP	C
	INR	A
	MOV	C,B
	JNC	SPLITWORD

	MOV	C,A
	LXI	H,BUF
	CALL	INDEX

	DCX	H
	MOV	A,M
	CALL	ISCYR
	JNC	SW3

	INX	H
	MOV	A,M
	CALL	TOUPPER
	CALL	ISUPCYR
	JNC	SW3
	CPI	''
	JZ	SW3
	CPI	''
	JZ	SW3
	CPI	''
	JZ	SW3
	CPI	''
	STC
	RNZ
SW3:
	MOV	C,B
	JMP	SPLITWORD



GETWORD:
	LXI	H,BUF
GW1:
	PUSH	H
	CALL	BLANKS
	LHLD	BEND
	CALL	COMPDH
	POP	H
	RNC

	PUSH	D
	CALL	LETTERS
	POP	D
	CALL	STRCPY
	MVI	M,0

	PUSH	H
	DCX	H
	MOV	A,M
	CPI	'-'
	JNZ	GW2

	DCX	H
	MOV	A,M
	CALL	ISALPHA
	JC	GW3
GW2:
	LXI	H,BUF
	CALL	STRLEN
	POP	H
	STC
	RET
GW3:
	LDAX	D
	CPI	KCR
	JNZ	GW2
	POP	H
	DCX	H

	JMP	GW1


PINDENT:DB	3
PRIGHT:	DB	60
WORDS:	DB	0
WLEN:	DB	0
STP:	DW	ST

FILLST:
	XRA	A
	STA	WORDS
;᫨ ᫮ 㦥   p
	LDA	WLEN
	MOV	C,A
	ORA	A
	JNZ	FS1	; p室
FS0:	; ᫮
	CALL	GETWORD
	STA	WLEN
	RNC	;室 ᫨  
FS1:	;p ⮪ p   ᫮
	MOV	A,B
	SUB	C
	JM	FS2	;p室 ᫨ ᫮  室
FS11:	;p ᫮  p
	MOV	B,A
	PUSH	D
	LHLD	STP
	LXI	D,BUF
	CALL	STRCPY
	POP	D
	SHLD	STP
; ᫮  p - 0
	XRA	A
	STA	WLEN
	MOV	A,B	;᫨ p 
	ORA	A
	STC
	RZ		; 室
;⠢ p ᫥ ᫮
	MVI	M,' '
	INX	H
	SHLD	STP
;- ᫮ 㢥稫
	LXI	H,WORDS
	INR	M
;㬥 ⮪ 権  p (- p)
	DCR	B
	JNZ	FS0	;᫨  ,  
; : 㤠 p
;	INR	B
	JMP	FS3
FS2:	;᫨ pp襭 p
	LDA	HYPHENIZE
	ORA	A
	JZ	FS3	; 
;  ᨬ  p
	MOV	A,B
	CPI	3
	JC	FS3
;p ᫮  p   
	DCR	A
	MOV	C,A	;⤥  ᨬ
	PUSH	B
	PUSH	D
	CALL	SPLITWORD
	POP	D
	MOV	A,C
	POP	B
	JNC	FS3	; ᫨  稫
;㬥 ⮪ p 
	MOV	C,A
	MOV	A,B
	SUB	C
	DCR	A
	MOV	B,A
;p p   p  p
	PUSH	D
	LHLD	STP
	LXI	D,BUF
	PUSH	B
	CALL	STRCPY
	POP	B
;p p pᮬ
	MVI	M,'-'
	INX	H
	SHLD	STP
;㢥 - ᫮
	LXI	H,WORDS
	INR	M
; p  ᫮  p
	LDA	WLEN
	SUB	C
	STA	WLEN
;p ⮪ ᫮  砫 p
	LXI	H,BUF
	MOV	C,A
	CALL	STRCPY
	POP	D
;᫨  ⠫   p,  室
	MOV	A,B
	ORA	A
	STC
	RZ
	DCR	B
;pp p
FS3:
	LDA	WLEN
	MOV	C,A
	LDA	WORDS	;᫨ p ,  p 
	ORA	A	; ᫮  
	JZ	FS11

	DCR	A	;᫨  ᫮,  p 
	STC
	RZ

	INR	B
	MOV	L,A
	MVI	C,1
	MOV	A,B
FS4:
	SUB	L
	JM	FS5
	JZ	FS5
	INR	C
	JMP	FS4
FS5:
	ADD	L
	MOV	B,A
; - - p p, 
; - 砫쭠 p p-1

	LXI	H,WORDS
	DCR	M

	PUSH	D

	LXI	D,ST
FS6:
	PUSH	B

	CALL	BLANKS
	CALL	LETTERS

	LHLD	STP
	XCHG
	CALL	SUBDH
	XCHG	

	POP	H
	PUSH	H
	MVI	H,0
	DAD	D

	PUSH	D
	CALL	STRCPY
	POP	H

	POP	B
	PUSH	B
	MOV	A,C
	MVI	B,' '
	CALL	STRSET
	XCHG

	POP	B
	
	LHLD	STP
	MOV	A,C
	CALL	INDEX
	SHLD	STP

	DCR	B
	JNZ	FS7
	DCR	C
	JZ	FS8
FS7:
	LXI	H,WORDS
	DCR	M
	JNZ	FS6
FS8:
	POP	D
	STC
	RET



CFORMAT:
	CALL	BLKBOUND
	CPI	3
	RZ
	CALL	PUTSTR
	LHLD	BEND
	SHLD	SADR
	SHLD	PSADR
	DCX	H
	SHLD	BEND

	LHLD	BTOP
	XCHG

	XRA	A
	STA	WLEN

	LDA	PINDENT
	MOV	C,A
	MVI	B,' '
	LXI	H,ST
	CALL	STRSET
	SHLD	STP
CFOR1:
	LDA	PRIGHT
	SUB	C
	MOV	B,A

	CALL	FILLST
	PUSH	PSW
	PUSH	D

	LDA	WORDS
	ORA	A
	JZ	CFOR11

	LHLD	STP
	MVI	M,0
	MVI	A,1
	STA	MODIFIED
	CALL	PUTSTR

	LHLD	SADR
	CALL	NEXT
	SHLD	SADR
	SHLD	PSADR

	LXI	H,ST
	SHLD	STP
	MVI	C,0
CFOR11:
	POP	D
	POP	PSW
	JC	CFOR1

	XRA	A
	STA	MODIFIED
	LHLD	BEND
	INX	H
	SHLD	BEND
	SHLD	SADR
	CALL	BLKDEL
	JMP	BLOP


CBOUNDS:
	LDA	LEN
	STA	PRIGHT
	LXI	D,ST
	CALL	BLANKS
	LXI	H,ST
	CALL	SUBDH
	MOV	A,C
	STA	PINDENT
	CALL	PUTST
	RET


CCENTER:
	LXI	D,ST
	CALL	BLANKS
	LXI	H,ST
	CALL	SUBDH
	MOV	B,C

	LDA	LEN
	SUB	B
	MOV	C,A

	LDA	PRIGHT
	SUB	C
	JNC	$+4
	XRA	A

	RAR
	MOV	B,A
	ADD	C
	STA	LEN

	INR	C
	MOV	A,B
	CALL	INDEX
	CALL	STRCPY

	MOV	A,B
	MVI	B,' '
	LXI	H,ST
	CALL	STRSET

	MVI	A,1
	STA	MODIFIED
	CALL	PUTST
	RET


;------- 㭪樨 pp --------

CMARK:
	CALL	SETBLOCK
	LHLD	TOPLIN
	SHLD	OLDTOPLIN
	JMP	PUTTXT


CMARKUP:
	LHLD	SADR
	PUSH	H
	CALL	CUP
	POP	D
	LHLD	SADR
CMKUP1:
	CALL	SETBLOCK
	ORA	A
	JZ	PUTTXT
	JMP	PUTST


CMARKDN:
	CALL	PUTSTR
	LHLD	SADR
	CALL	GETSTR
	LHLD	SADR
	CALL	NEXT
	RNC

	XCHG
	LHLD	SADR
	XCHG
	CALL	CMKUP1
	JMP	CDN1


CMKPGUP:
	CALL	CPGUP
	JMP	CMARK


CMKPGDN:
	CALL	CPGDN
	JMP	CMARK


CMKTOP:
	CALL	CTOP
	JMP	CMARK


CMKBOT:
	CALL	CBOTTOM
	JMP	CMARK


;------- p樨   --------

CCOPY:
	LHLD	SADR
	XCHG
	CALL	INBLOCK
	JNC	CCP1
	DCX	D
	CALL	INBLOCK
	RC
CCP1:
	CALL	PUTSTR
	CALL	BLKCPY
	LHLD	SADR
	CALL	GETSTR

	LHLD	BEND
	XCHG
	LHLD	BTOP
	CALL	SUBDH
;p饭 
;	LHLD	SADR
;	SHLD	BTOP
;	DAD	B
;	SHLD	BEND
	JMP	BLOP


CCUT:
	CALL	PUTSTR
	LHLD	SADR
	XCHG
	CALL	INBLOCK
	JNC	CCT1
	LHLD	BEND
	SHLD	SADR
CCT1:
	CALL	BLKDEL
BLOP:
;騥 p樨  
	CALL	PUTTXT
	LHLD	SADR
	CALL	GETSTR

	LHLD	SADR
	CALL	TEXTLINE
	SHLD	LINE
	LHLD	TEND
	CALL	TEXTLINE
	INX	H
	SHLD	MAXLINE
	CALL	PRINTY
	RET


;----- 䨫p -------

;㭪 樠樨 䨫p
;p 㪠⥫   ⥪ HL
; p ⢮ p HL  㪠⥫   ⥪ DE
INIT:
	CALL	TEXTLINE
	XCHG
	MVI	M,EOL
	INX	H
	MVI	M,EOT
	XCHG
	RET


NEXT:
	PUSH	H
TNX1:
	MOV	A,M
	INX	H
	CPI	EOL
	JZ	TNX2
	CPI	EOT
	JNZ	TNX1
TNX3:
	POP	H
	RET
TNX2:
	MOV	A,M
	CPI	EOT
	JZ	TNX3

	CPI	KLFEED
	JNZ	$+4
	INX	H
	
	INX	SP
	INX	SP
	STC
	RET

PREV:
	PUSH	H
TPV1:
	DCX	H
	MOV	A,M
	CPI	KLFEED
	JZ	TPV12
	CPI	KCR
	JZ	TPV2
	CPI	EOT
	JNZ	TPV1
	POP	H
	RET
TPV12:	
	DCX	H
	MOV	A,M
	CPI	KCR
	JNZ	TPV22
TPV2:
	DCX	H
TPV22:
	MOV	A,M
	CPI	KLFEED
	JZ	TPV3
	CPI	KCR
	JZ	TPV3
	CPI	EOT
	JNZ	TPV2
TPV3:
	INX	SP
	INX	SP
	INX	H
	STC
	RET

;DE-p, HL-p, C-
DECODE:
	LDAX	D
	INX	D
	CPI	KTAB
	JNZ	TDEC2
TDEC1:
	MVI	M,KSP
	INX	H
	INR	C
	MOV	A,C
	CPI	MAXLEN
	JNC	TDEC3

	ANI	7
	JNZ	TDEC1
	JMP	DECODE
TDEC2:
	CPI	KCR
	JZ	TDEC3
	MOV	M,A
	INX	H
	INR	C
	MOV	A,C
	CPI	MAXLEN
	JC	DECODE
TDEC3:
	LDAX	D
	CPI	KLFEED
	JNZ	$+4
	INX	D

	MOV	A,M
	ORA	A
	RZ
	MVI	M,0
	INX	H
	JMP	TDEC3

;p p  p pp  p ⥪
;DE-p pp
;HL-p ⥪
;-  p
;p:
;HL-㪠뢠  ᫥  ᫥ ᨬ p ⥪ 祩

ENCODE:
TENC00:
	LDAX	D
	ORA	A
	JNZ	TENC0

	MVI	M,EOL
	INX	H
	RET
TENC0:
	CPI	' '
	JZ	TENC1

	MOV	M,A
	INX	H
	INX	D
	INR	C
	JMP	TENC00
TENC1:
	PUSH	H
	MVI	B,0
TENC2:
	LDAX	D
	CPI	' '
	JNZ	TENC3

	INX	D
	INR	B
	INR	C
	MOV	A,C
	ANI	7
	JNZ	TENC2

	MOV	A,B
	CPI	1
	MVI	M,KTAB
	JNZ	$+5
	MVI	M,' '
	INX	H

	MVI	B,0
	JMP	TENC2
TENC3:
	ORA	A
	JNZ	TENC4
	POP	H
	JMP	TENC00
TENC4:
	INX	SP
	INX	SP
TENC5:
	DCR	B
	JM	TENC00
	MVI	M,' '
	INX	H
	JMP	TENC5


;---- p樨  p p ------

GETSTR:
	PUSH	D
	PUSH	H

	SHLD	SADR
	XRA	A
	STA	MODIFIED

	MOV	C,A
	LXI	D,ST
	XCHG
	CALL	DECODE

	MOV	A,C
	STA	LEN
	XCHG
	SHLD	PSADR

	POP	H
	POP	D
	RET

PUTSTR:
	LDA	MODIFIED
	ORA	A
	RZ

	PUSH	B
;	CALL	CUTTRAILS

	MVI	C,0
	LXI	H,ST
	LXI	D,ST
	CALL	ENCODE

	XCHG
	LXI	H,ST
	CALL	SUBDH
	MOV	A,C
	STA	LEN

	LHLD	PSADR
	XCHG
	LHLD	SADR
	DAD	B
MTCALL:
	CALL	MOVTXT-1a47h

	LHLD	SADR
	LXI	D,ST
	LDA	LEN
	MOV	C,A
	CALL	STRCPY

	POP	B
	RET


PROTECT:
	LXI	H,MENULINE+500
	LXI	D,-500
	DAD	D
	XCHG
	LHLD	MTCALL+1
PT1:
	LDAX	D
	ORA	A
	JZ	PT2
	CALL	INDEX
	INX	D
	JMP	PT1
PT2:
	SHLD	MTCALL+1
	RET


MOVTXT:
;DE-SRC, HL-DST, RET: CF-SUCCESS
	PUSH	B
	PUSH	D
	PUSH	H

	XCHG
	CALL	SUBDH
	PUSH	D
	PUSH	H
	LHLD	MEMTOP
	XCHG
	LHLD	TEND
	DAD	B
	CALL	COMPDH
	POP	D
	XTHL
	JC	MT3

	PUSH	H
	DCX	D
	LHLD	BTOP
	CALL	COMPDH
	JNC	MT1
	DAD	B
	SHLD	BTOP
MT1:
	LHLD	BEND
	CALL	COMPDH
	JNC	MT2
	DAD	B
	SHLD	BEND
MT2:
	INX	D
	LHLD	TEND
	XCHG
	CALL	SUBDH
	INX	B
	POP	D
	XCHG

	CALL	MEMCPY
	POP	H
	SHLD	TEND
	CALL	PRINTFREE
	PUSH	H
	ORA	A
MT3:
	POP	H
	CMC
	POP	H
	POP	D
	POP	B
	RET


;----------------------

GETCH:
	CALL	INKEY
	ORA	A
	RNZ
	MOV	A,B
	ORA	A
	JZ	GETCH
	CALL	PRINTREG
	JMP	GETCH


PRINTREG:
	LDA	ATMENU
	CALL	SETATR
	PUSH	PSW

	LXI	H,400H+' '
	MVI	A,JCENTER
	CALL	SETJUST
	LXI	H,2000H+MAXY
	CALL	GOTOXY
	PUSH	H

	MOV	A,C
	RLC
	LXI	H,RUS
	JC	$+6
	LXI	H,LAT
	CALL	PRJUST

	MOV	A,C
	RLC
	ANI	1
	ADI	6
	OUT 	0

	MOV	A,C
	ANI	TSHIFT
	LXI	H,STR
	JZ	$+6
	LXI	H,PROP
	CALL	PRJUST

	POP	H
	CALL	GOTOXY
	POP	PSW
	CALL	SETATR

	RET

;-----------------------

FUNC:
	CALL	PUTSTR

	LDA	ATMENU
	CALL	SETATR
	LXI	D,SELECT
	MVI	A,MINY
	CALL	PUTS
	
	LXI	H,0
	CALL	SETCUR

	CALL	GETCH
	LXI	H,FUNCEX
	PUSH	H

	MOV	A,C
	CPI	'I'-32
	JZ	FINPUT
	CPI	'O'-32
	JZ	FOUTPUT
	CPI	'L'-32
	JZ	FSEARCH
	CPI	'R'-32
	JZ	FREPLACE
	CPI	'Q'-32
	JZ	FQUIT
	POP	H
FUNCEX:
	LDA	ATMENU
	CALL	SETATR
	LXI	D,MENULINE
	MVI	A,MINY
	CALL	PUTS
	LHLD	SADR
	CALL	GETSTR
	RET


FMATCH:
	LXI	D,FIND
	MVI	A,MINY
	CALL	PUTS
	LXI	H,205H
	CALL	SETCUR
FM1:
	LXI	H,700H+MINY
	CALL	GOTOXY

	LXI	D,FSTR
	LXI	H,GETCH
	CALL	GETS

	CPI	KCR
	STC
	RZ
	CPI	KESC
	RZ
	JMP	FM1

FSEARCH:
	CALL	FMATCH
	RNC
FSER2:
	LXI	D,TFINDING
	MVI	A,MINY
	CALL	PUTS

	LXI	H,X
	INR	M
	LHLD	SADR
	PUSH	H

FSER3:
	PUSH	H
	CALL	GETSTR
	CALL	ASTX
	LXI	D,FSTR+2
	CALL	STRSTR
	XCHG
	POP	H
	JC	FSER4

	XRA	A
	STA	X
	CALL	NEXT
	JC	FSER3

	LXI	D,SNOFND
	CALL	PUTERR

	POP	H
	CALL	GETSTR
	ORA	A
	RET
FSER4:
	PUSH	D
	SHLD	SADR
	XCHG

	MVI	C,MAXY-MINY-1
	LHLD	TOPLIN
FSER5:
	CALL	COMPDH
	JZ	FSER6

	CALL	NEXT
	DCR	C
	JNZ	FSER5

	XCHG
	SHLD	TOPLIN
	MVI	C,MAXY-MINY-1
FSER6:
	MVI	A,MAXY
	SUB	C
	STA	Y

	LHLD	SADR
	CALL	TEXTLINE
	SHLD	LINE
	POP	D

	LXI	H,ST
	CALL	SUBDH
	MOV	A,C
	STA	X

	CALL	PRINTXY
	POP	H
	STC
	RET


FREPLACE:
	XRA	A
	STA	GLOBAL
	CALL	FMATCH
	RNC

	LXI	D,REPLACE
	MVI	A,MINY
	CALL	PUTS
	LXI	H,205H
	CALL	SETCUR
FREP1:
	LXI	H,800H+MINY
	CALL	GOTOXY
	LXI	D,FREPL
	LXI	H,GETCH
	CALL	GETS

	CPI	KCR
	JZ	FREP2
	CPI	KESC
	RZ
	JMP	FREP1
FREP2:
	CALL	FSER2
	RNC
	CALL	CURPOS

	LDA	GLOBAL
	ORA	A
	JZ	FREP22
	CALL	INKEY
	ORA	A
	JZ	FREP3
	XRA	A
	STA	GLOBAL
FREP22:
	LDA	ATMENU
	CALL	SETATR
	LXI	D,CONFIRM
	MVI	A,MINY
	CALL	PUTS

	CALL	GETCH

	MOV	A,C
	CPI	'Y'-32
	JZ	FREP3
	CPI	'N'-32
	JZ	FREP2
	CPI	'G'-32
	RNZ
	STA	GLOBAL
FREP3:
	LDA	FSTR+1
	MOV	C,A
	LDA	FREPL+1
	SUB	C
	MOV	B,A

	LDA	LEN
	ADD	B
	CPI	MAXLEN
	JNC	FREP4

	LDA	X
	ADD	C
	MOV	C,A
	LXI	H,ST
	CALL	INDEX

	XCHG
	MOV	A,C
	ADD	B
	LXI	H,ST
	CALL	INDEX

	LDA	LEN
	SUB	C
	MOV	C,A
	CALL	STRCPY

	CALL	ASTX
	LXI	D,FREPL+2
	LDA	FREPL+1
	MOV	C,A
	CALL	STRCPY

	LDA	LEN
	ADD	B
	STA	LEN

	LXI	H,ST
	CALL	INDEX
	MVI	M,0

	LDA	X
	MOV	C,A
	LDA	FREPL+1
	ADD	C
	STA	X

	MVI	A,1
	STA	MODIFIED

	CALL	PUTST
	CALL	PUTSTR
	JMP	FREP2
FREP4:
	LXI	D,TOOLONG
	CALL	PUTERR
	RET





;----- ᮢ᪨ 㭪樨 ------

DOSON:
	DI
	MVI	A,23H
	OUT	10H
	LHLD	39H
	SHLD	INTKR
	LHLD	INTDOS
	SHLD	39H
	EI
	RET

DOSOFF:
	DI
	XRA	A
	OUT	10H
	LHLD	39H
	SHLD	INTDOS
	LHLD	INTKR
	SHLD	39H
	EI
	RET


FILLFCB:
	MVI	M,0

	INX	D
	LDAX	D
	DCX	D
	CPI	':'
	JNZ	FF1

	LDAX	D
	CALL	TOUPPER
	CPI	'A'
	CMC
	RNC
	CPI	'D'+1
	RNC

	SUI	'A'-1
	MOV	M,A
	INX	D
	INX	D
FF1:
	INX	H
	MVI	B,8
FF2:
	LDAX	D
	ORA	A
	JZ	FF4
	INX	D

	CPI	'*'
	JZ	FF9
	CPI	'.'
	JZ	FF4
	CPI	' '+1
	CMC
	RNC
	CPI	128
	RNC

	CALL	TOUPPER
	MOV	M,A
	INX	H
	DCR	B
	JNZ	FF2
FF3:
	LDAX	D
	ORA	A
	JZ	FF5

	INX	D
	CPI	'.'
	JZ	FF5

	XRA	A
	RET
FF4:
	MOV	A,B
	MVI	B,' '
	CALL	STRSET
FF5:
	MVI	B,3
FF6:
	LDAX	D
	ORA	A
	JZ	FF11
	INX	D

	CPI	'*'
	JZ	FF10
	CPI	128
	RNC
	CPI	' '+1
	CMC
	RNC

	CALL	TOUPPER
	MOV	M,A
	INX	H
	DCR	B
	JNZ	FF6
FF7:
	LDAX	D
	ORA	A
	RNZ
FF8:
	MVI	M,0
	STC
	RET
FF9:
	MOV	A,B
	MVI	B,'?'
	CALL	STRSET
	JMP	FF3
FF10:
	MOV	A,B
	MVI	B,'?'
	CALL	STRSET
	JMP	FF7
FF11:
	MOV	A,B
	MVI	B,' '
	CALL	STRSET
	JMP	FF8


GETFN:
	LXI	D,FILE
	MVI	A,MINY
	CALL	PUTS
GFN1:
	LXI	H,600H+MINY
	CALL	GOTOXY
	LXI	H,205H
	CALL	SETCUR

	LXI	D,FNAME
	LXI	H,GETCH
	CALL	GETS

	CPI	KCR
	JZ	GFN2
	CPI	KESC
	RZ
	JMP	GFN1
GFN2:
	CALL	INKEY
	ORA	A
	JNZ	GFN2
	
	LXI	D,FNAME+2
	LXI	H,FCB
	CALL	FILLFCB
	RC

	LXI	D,WRNAME
	CALL	PUTERR
	JMP	GETFN

PUTERR:
	MOV	A,L
	RRC
	RRC
	RRC

	CALL	SETATR
	MVI	A,MINY
	CALL	PUTS

	INR	L

	CALL	INKEY
	ORA	A
	JZ	PUTERR

	LDA	ATMENU
	CALL	SETATR
	RET


;㭪 ⥭ 䠩

FINPUT:
	CALL	GETFN
	RNC

	XRA	A
	STA	FCB+32

	CALL	DOSON

	LXI	D,FCB
	MVI	C,15	;OPEN
	CALL	5

	ORA	A
	JP	FIN1

	CALL	DOSOFF

	LXI	D,NOFOUND
	CALL	PUTERR
	JMP	FINPUT
;p㧪 䠩
FIN1:
	LXI	D,TEXT
FIN2:
	LHLD	MEMTOP
	CALL	COMPDH
	JNC	FIN3

	PUSH	D
	MVI	C,26	;SETDMA
	CALL	5

	LXI	D,FCB
	MVI	C,20	;READ
	CALL	5

	POP	D
	LXI	H,128
	DAD	D
	MVI	M,0
	XCHG

	ORA	A
	JZ	FIN2
FIN3:
	XCHG
	SHLD	LOADEND
	JMP	REP


FOUTPUT:
	CALL	GETFN
	RNC

	XRA	A
	STA	FCB+32

	CALL	DOSON
	LXI	D,80H
	MVI	C,26	;SETDMA
	CALL	5

	LXI	D,FCB
	MVI	C,17	;FINDFIRST
	CALL	5
	ORA	A
	JM	FOUT0

	RRC
	RRC
	RRC

	LXI	H,80H+1
	CALL	INDEX
	XCHG
	LXI	H,FCB+1
	MVI	C,31
	CALL	STRCPY

	LXI	D,FCB
	LXI	H,FCB+16
	MVI	C,9
	CALL	STRCPY

	LXI	D,BAK
	LXI	H,FCB+16+9
	MVI	C,3
	CALL	STRCPY

	LXI	D,FCB+16
	MVI	C,19	;DELETE
	CALL	5

	LXI	D,FCB
	MVI	C,23	;RENAME
	CALL	5

FOUT0:
	LXI	D,FCB
	MVI	C,22	;CREATE
	CALL	5
	ORA	A
	JP	FOUT1

	CALL	DOSOFF
	LXI	D,WRITERR
	CALL	PUTERR
	RET
FOUT1:
	LXI	D,TEXT
FOUT2:
	LHLD	TEND
	CALL	COMPDH
	JNC	FOUT3

	PUSH	D
	MVI	C,26	;SETDMA
	CALL	5

	LXI	D,FCB
	MVI	C,21	;READ
	CALL	5

	POP	D
	LXI	H,128
	DAD	D
	XCHG

	ORA	A
	JZ	FOUT2
FOUT3:
	LXI	D,FCB
	MVI	C,16	;CLOSE
	CALL	5


	CALL	DOSOFF
	RET

FQUIT:
	XRA	A
	CALL	SETATR
	MVI	A,KEND
	CALL	PUTC

	CALL	DOSON
	JMP	0






	END
