/*
	BDOS.H - for SuperSoft C.1.2.3 - February 1993.
	  Copyright (c) by Perlin Production Co. Ltd.

	This file contains global definitions of BDOS
	calling codes of CPM  -  MicroDOS operational
	systems.

		This file generates no code.
 */

#define CC_ERR		0	/* Error of BDOS function call: in <HL> */

#define CC_SYSRST	0	/* System reset				*/
#define CC_CONIN	1	/* Read symbol from CON:		*/
#define CC_CONOUT	2	/* Write symbol to  CON:		*/
#define CC_RDR		3	/* Read symbol from RDR:		*/
#define CC_PUN		4	/* Write symbol to  PUN:		*/
#define CC_LST		5	/* Write symbol to  LST:		*/
#define CC_CON		6	/* Directional I/O with CON:		*/
#define CC_IAD		7	/* Addition. input drive condition code */
#define CC_OAD		8	/* Addit. output drive condition code	*/
#define CC_PUTS		9	/* Write string to the console		*/
#define CC_GETS		10	/* Read string to the console buffer	*/
#define CC_CONCOND	11	/* Current console condition		*/
#define CC_CPMVER	12	/* Return CP/M version			*/
#define CC_RSTALL	13	/* Reset ALL registered disk drives	*/
#define SET_DRIVE	14	/* Set disk drive SET_DRIVE		*/
#define CC_OPEN		15	/* Open file				*/
#define CC_CLOSE	16	/* Close file				*/
#define CC_FIND		17	/* Find first file occurance in DIR	*/
#define CC_NEXT		18	/* Find next occurance in DIRECTORY	*/
#define CC_DELETE	19	/* Delete file				*/
#define CC_READ		20	/* Sequential record reading		*/
#define CC_WRITE	21	/* Sequential record writing		*/
#define CC_CREAT	22	/* Create and open file			*/
#define CC_RENAME	23	/* Rename file				*/
#define CC_COND		24	/* Get drives condition vector		*/
#define GET_DRIVE	25	/* Get current drive number		*/
#define SET_DMA		26	/* Set addres of DMA-buffer SET_DMA	*/
#define CC_VECTOR 	27	/* Get Dispose Drive Vectror's addres	*/
#define CC_SDRO		28	/* Set current drive to READ-ONLY	*/
#define CC_DPROT	29	/* Get Drive Protection Vector		*/
#define ATTRIBS		30	/* Set file attributes: R/O R/W DIR SYS */
#define CC_DPARMS	31	/* Get Disk Parameters Block addres	*/
#define CC_USER		32	/* Get/Set user code			*/
#define CC_RREAD	33	/* Random record read			*/
#define CC_RWRITE	34	/* Random record write			*/
#define CC_CFS		35	/* Compute file size (CPM 2.0 only)	*/
#define CC_SRR		36	/* Set random record number		*/
#define CC_RSTDRV	37	/* Reset selected disk drives		*/


/*
 *	Now some BDOS calls, that not supported in all CP/M versions,
 *	but must in any MicroDOS, version not lower than 3.1 or
 *	YDOS (Yanus-Bios MicroDOS) , or SCP operational systems.
 */

#ifdef	MicroDOS

#define CC_RFILLZ	40	/* Random writing with filling zeros	*/
#define CC_SMSCTC	44	/* Set a multi-sector counter		*/
#define CC_SERCND	45	/* Set an Error-Condition Mode		*/
#define CC_GFRESP	46	/* Get a free space of selected disk	*/
#define CC_CNGPRG	47	/* Changing program			*/
#define CC_SPSCB	49	/* Set params.of a System Control Block */
#define CC_EXBDOS	50	/* Call BIOS or Extended BDOS operations*/
#define CC_BIOS		50	/* The same as EXBDOS, but used for BIOS*/
#define CC_SDATE	104	/* Set date				*/
#define CC_GDATE	105	/* Get date				*/
#define CC_EXITCODE	108	/* Get or set Program Exitcode		*/
#define CC_DELIM	110	/* Get or set sequence delimeter	*/
#define CC_WARRAY	111	/* Write array of data to the CON:	*/
#define CC_PARRAY	112	/* Print array of data on the PRN:	*/
#define CC_SPFCB	152	/* Set PFCB buffer			*/

#endif


/*
 *	Now some Extended BDOS calls (called as CC_EXBDOS, then this code).
 */
#ifdef CC_EXBDOS

#define CC_FEXCNG	129	/* Ex-BDOS file exchange		*/
#define CC_DEXCNG	130	/* Ex-BDOS drive exchange		*/
#define CC_SFCONIN	131	/* Ex-BDOS set file for CON: input	*/
#define CC_SSTDCON	132	/* Ex-BDOS set CON: to stadart input	*/
#define CC_SBUFCON	133	/* Ex-BDOS set buffer CON: input	*/
#define CC_GCONFIRM	240	/* Ex-BDOS get confirm			*/
#define CC_WFNAME	242	/* Ex-BDOS write filename		*/
#define CC_WDECIM	243	/* Ex-BDOS write in a decimal format	*/

#endif


struct WORDREGS
{
	unsigned	bc;
	unsigned	de;
	unsigned	hl;
	unsigned	psw;
	unsigned	flags;
	unsigned	cflag;
};

struct	BYTEREGS
{
	char	c;
	char	b;
	char	e;
	char	d;
	char	l;
	char	h;
	char	a;
};


union	REGS
{
	struct WORDREGS x;
	struct BYTEREGS s;
};
