/*
	BIOS.H -for SuperSoft C.1.2.3 - February 1993.
	 Copyright (c) by Perlin Production Co. Ltd.

	This file contains global definitions of BIOS
	entry points of CPM  -  MicroDOS operational
	systems.

		This file generates no code.
 */

#define BOOT		0	/* "Cold start"			*/
#define WBOOT		1	/* "Hot start"			*/
#define CONST		2	/* CONIN status			*/
#define CONIN		3	/* Console input		*/
#define CONOUT		4	/* Console output		*/
#define LIST		5	/* Output to LST:		*/
#define AUXOUT		6	/* Output to AUX:		*/
#define AUXIN		7	/* Input from AUX:		*/
#define HOME		8	/* Head to track 0		*/
#define SELDSK		9	/* Select disk drive		*/
#define SETTRK		10	/* Set track			*/
#define SETSEC		11	/* Set sector			*/
#define SETDMA		12	/* Set DMA			*/
#define READ		13	/* BIOS sector reading		*/
#define WRITE		14	/* BIOS sector writing		*/
#define LISTST		15	/* BIOS LST: status		*/
#define SECTRAN		16	/* Translation of sector number	*/

#ifdef EX_BIOS

/*	Expansion BIOS functions for CP/M 3.1	*/

#define CONOST		17	/* CONOUT status		*/
#define AUXIST		18	/* AUXIN status			*/
#define AUXOST		19	/* AUXOUT status		*/
#define DEVTBL		20	/* Addr. regist. dev. tab. CTBL */
#define DEFINI		21	/* Initialization of phys. dev. */
#define DRVTBL		22	/* Addres of Drive Table DTBL	*/
#define MULTIO		23	/* Set # of sectors in multisect*/
#define FLUSH		24	/* NOT IN USE			*/
#define MOVE		25	/* Move Memory <----> Memory	*/
#define TIME		26	/* NOT IN USE			*/
#define SELMEM		27	/* Select bank in memory CPM3.0 */
#define SETBNK		28	/* Set bank of memory		*/
#define XMOVE		29	/* Move Bank <-----> Bank	*/
#define RESERV1		30	/* Reserved for a user function */
#define RESERV2		31	/* Reserved for a user function */
#define RESERV3		32	/* Reserved for a user function */

#endif EX_BIOS

/*
 *	NOTE :	Functions number 1,27-32 can be use ONLY AS A BIOS CALLS.
 *		Functions 8-14,23 can be called as a functions of BDOS
 *		call number 50 (Extended BDOS calls)
 */
