; conio.inc
;
;         Perlin Production Co. Ltd., copyleft July 2011 (])            
;
;  G r a p h i c a   M i n i m a l i s t a   L i b r a r y   ( G M L )  
;                      Console Input/Output.                            
;

; Conditional compilations, affecting this file:

; _NOGML - disables all GML declarations for CP/M console targets
; _TXTWN - enables text windowing API extensions for GML targets

; Virtual - to ASCII keyboard mapping and
; BOLD BIOS - compatible escape sequences

VK_HOME		EQU	01h
VK_PGDN		EQU	03h
VK_RIGHT	EQU 	04h
VK_UP		EQU	05h
VK_END		EQU	06h	; <>
VK_DEL		EQU	07h
VK_LEFT		EQU	08h
VK_TAB		EQU	09h
VK_LF		EQU	0Ah	; <>
VK_CR		EQU	0Dh
VK_PGUP		EQU	12h
VK_LOC		EQU	17h	; <RusLat> locale switch
VK_DOWN		EQU	18h
VK_LINE		EQU	19h	; Line deletion
VK_ESC		EQU	1Bh
VK_SPC		EQU	20h
VK_BACK		EQU	7Fh

VK_BELL		EQU	07h
VK_ENTER	EQU	VK_CR

VK_F1		EQU	VK_PGUP
VK_F2		EQU	VK_DEL
VK_F3		EQU	VK_LINE
VK_F4		EQU	VK_PGDN
VK_F5		EQU	VK_LOC

; ESC - sequences, must be preceeded by VK_ESC

ESC_CSH	EQU	3Ah	; Visible cursor
ESC_CHD	EQU	3Bh	; Hidden cursor
ESC_CLS	EQU	4Ah	; Clear screen
ESC_CLR	EQU	4Bh	; Clears row right from cursor
ESC_GXY	EQU	59h	; Places cursor at x-20h, y-20h
ESC_LAT	EQU	5Bh	; Latin
ESC_RUS	EQU	5Ch	; Russian
ESC_NRM	EQU	61h	; Normal text
ESC_INV	EQU	62h	; Inversed text

IFNDEF	_NOGML

; F O N T   M A N A G E M E N T

;SIZ_FHDR	EQU	20h	; Font header size
;Font header format:
;=============== 16 bytes ==================================================
;	FNT_NAM:DS	8	; Name, right-padded to 8 bytes with zeroez
;	FNT_SIG:DB	'FNT'
;	FNT_PAD:DS	5	; Padding, not used right now
;=============== 16 bytes ==================================================
;	FNT_FMT:DW	0	; Font format, including packing (DBL FONTS)
;	FNT_FCH:DB	0	; ASCII code of first character
;	FNT_BPC:DB	8	; Bytes per character
;	FNT_NCH:DW	100H	; Number of characters IN THIS FILE!
;	FNT_HGT:DB	8	; Symbol height in pixels
;	FNT_WDT:DB	8	; Symbol width in pixels
;	FNT_COL:DB	32	; Number of columns
;	FNT_RSV:DS	7	; Reserved bytes
;---------------------------------------------------------------
;	1. Font size = FNT_BPC * FNT_NCH
;	2. Number of columns: ((FNT_RES+1) * 256) / FNT_WDT
;==========================================================================



EXT	FntLd
;****************************************************************
; LOADS FONT FROM DISK DRIVE and ALLOCATES it in heap
; Input:
;	<DE> - 12 bit filename
; Returns:
;	CY=0 - success <HL> - address of loaded font for FntSet
;	CY=1 - error   <DE> - error code
; Remarks:
;	Call free <HL> to free font from RAM
;****************************************************************



EXT	FntSet
;****************************************************************
; SETS CURRENT FONT FOR UNIVERSAL FONT DRIVER
;
; <HL> - font header address
; <A>  - row height
;
; Returns:
;	CY=0 - success
;	CY=1 - error   <DE> - error code
; Remarks:
; Function performs non-destructive error check:
; previous font can be still used if FntSet fails
;****************************************************************
;MINRHT	EQU	4	; Minimum row height



EXT	FntBMP
;************************************************************************
; Calculating ASCII symbol bitmap starting address                      *
; Input: <A> - ASCII code						*
; Output:<HL>- symbol image						*
; Saves all registers except <PSW>
;************************************************************************



; C U R S O R   P O S I T I O N I N G
; Functions below save all registers unless stated otherwice


EXT	GetX	; Out: <A> X
EXT	GetY	; Out: <A> Y
EXT	SetX	; In:  <A> X, Out: <CY> = 0 - success
EXT	SetY	; In:  <A> Y, Out: <CY> = 0 - success
EXT	GoHome	; homes cursor at position 0,0
EXT	GoToXY	; In:  <D> X    ,<E> Y
EXT	ClrTxt	; clears screen, sets scrolling to FF, homes cursor
EXT	CR	; 0Dh handler
EXT	LF	; 0Ah handler
EXT	CRLF



; C H A R A C T E R   O U T P U T
; All character output functions return <CY> = 0 on success

EXT	PutCh
;****************************************************************
; Puts character on a text screen to a CURPOS in SETCOL color
; Input: <A> - ASCII code
; Output:  <CY>=1   
; All registers are saved
;****************************************************************

EXT	PutX	; <A>
EXT	PutWX	; <HL> 
EXT	PutS	; In: <HL> Out: <HL> + number of printed symbols



; T E X T   W I N D O W S

IFDEF	_TXTWN

DEF_WND	MACRO	WndName,BCol,WCol,X,Y,Xsize,Ysize,PtrBrd
WndName:
 DB	BCol	; Border back and foreground
 DB	WCol	; Window back and foreground
 DB	Y
 DB	X
 DB	Ysize
 DB	Xsize
 DW	PtrBrd	; Border structure pointer to 6 bytes
EndM

; Both functions below save all registers, but affect SetCol

EXT	PutBrd	; <HL> - DEF_WND structure
EXT	PutWnd	; <HL> - DEF_WND structure

;	:
;	Byte structure of 6 bytes
;	_, _, _,
;	_,  ,    

EXT	D_BORD
EXT	S_BORD
EXT	H_BORD
EXT	V_BORD

EndIF	;_TXTWN

EndIF	; _NOGML
