;HdrFnt.inc

FFM_SL8	EQU	0	; L/R 8-bit wide font
FFM_SX8	EQU	1	; H/R 8-bit wide font
FFM_DL8	EQU	2	; L/R 8-bit wide font
FFM_DX8	EQU	3	; H/R 8-bit wide font

FNT_BNK	EQU	1	; Suggested memory bank to store fonts

;=============== 16 bytes ==================================================
;FH_NAM:DB	'Digital8'	; Name, right-padded to 8 bytes with zeroez
;FH_SIG:DB	'FNT'		; File signature
;FH_INF:DB	0,'PPC',0	; Info bytes
;=============== 16 bytes ==================================================
;FH_VER:DB	1		; Font header version
;FH_FMT:DB	FFM_SL8		; Font format, including packing (DBL FONTS)
;FH_FCH:DB	0		; ASCII code of first character
;FH_BPC:DB	8		; Bytes per character
;FH_NCH:DW	100H		; Number of characters IN THIS FILE!
;FH_HGT:DB	8		; Symbol height in pixels
;FH_WDT:DB	8		; Symbol width in pixels
;FH_COL:DB	32		; Number of columns
;FH_BNK:DB	FNT_BNK		; Suggested memory bank to store font
;FH_BSE:DW	0		; Suggested base address to store font
;FH_FSZ:DW	0		; Will become FH_BPC * FH_NCH (font size)
;FH_RSV:DW	101h		; Reserved bytes
;--------------------------------------------------------------------------
; Maximum Number of columns: ((FNT_RES+1) * 256) / FNT_WDT
;==========================================================================

SIZ_FH	EQU	20h	; Font header size

FH_NAM	EQU	0
FH_SIG	EQU	FH_NAM+8
FH_INF	EQU	FH_SIG+3
FH_VER	EQU	FH_INF+5
FH_FMT	EQU	FH_VER+1
FH_FCH	EQU	FH_FMT+1
FH_BPC	EQU	FH_FCH+1
FH_NCH	EQU	FH_BPC+1
FH_HGT	EQU	FH_NCH+2
FH_WDT	EQU	FH_HGT+1
FH_COL	EQU	FH_WDT+1
FH_BNK	EQU	FH_COL+1
FH_BSE	EQU	FH_BNK+1
FH_FSZ	EQU	FH_BSE+2
FH_RSV	EQU	FH_FSZ+2
