;HdrSpt.inc
;
;             Perlin Production Co. Ltd., February 2012                 
;
;  G r a p h i c a   M i n i m a l i s t a   L i b r a r y   ( G M L )  
;      S P R I T E   F I L E   H E A D E R   F O R M A T                
;

;====== Sprite formats ==================================================

SF_PBP	EQU	1	; Plane-by-plane
SF_PTP	EQU	2	; Pixel-through-planes
SF_BTP	EQU	3	; Byte-through-planes
SF_WBC	EQU	4	; Bi-directional word columns
SF_ABC	EQU	5	; Bi-directional plane-by-plane alpha-sprite

;====== Header format for sprite definition =============================

;SH_SIG:	DB	'SPT'	; Sprite Header signature
;SH_VER:	DB	VER_SH	; Sprite Header version
;SH_FMT:	DB	SF_WBC	; Sprite Format
;SH_SHW:	DW	1010h	; sprite size in Pixels, (WxH)
;SH_DEP:	DB	3	; sprite depth (number of planes in sprites)
;SH_WHD:	DW	0	; CALCULATED: single sprite size IN BYTES
;SH_CNT:	DB	NSPRITES; Number of sprites in file
;SH_BNK:	DB	1	; Suggested memory bank 0-4, RECALC to PAGE
;SH_BSE:	DW	8000h	; Suggested Base address in memory
;SH_SAT:	DW	0	; CALCULATED: size of Sprite Addressing Table

;====== Header data offsets and size ====================================

SH_SIG	EQU	0
SH_VER	EQU	SH_SIG+3
SH_FMT	EQU	SH_VER+1
SH_SHW	EQU	SH_FMT+1
SH_DEP	EQU	SH_SHW+2
SH_WHD	EQU	SH_DEP+1
SH_CNT	EQU	SH_WHD+2
SH_BNK	EQU	SH_CNT+1
SH_BSE	EQU	SH_BNK+1
SH_SAT	EQU	SH_BSE+2
SIZ_SH	EQU	SH_SAT+2	; Size of sprite header

;====== Memory layout ===================================================
; SIZ_SH bytes of header is followed by Sprite Addressing Table with
; SH_CNT * sizeof(WORD) size. SAT is generated during sprite file
; loading and allocated with sprite header.
;------ IF (SH_BNK == 0) sprites in SH_FMT follow SAT in main RAM -------
;       ELSE sprites are located separately in memory page that is
;            corresponding to SH_BNK
;------------------------------------------------------------------------

;====== Notes ===========================================================
; Value of SH_BNK is RECALCULATED to machine-dependent memory page
; On Vector-06c this recalculated  value is used to switch RAM Drive
; access mode via port 10h. It may differ on other machines.
;------------------------------------------------------------------------
