;	
;	      Perlin Production Corporation,    May   1993 (c).       
;	
;	  Processor directives, for register  pairs, made as macros.  
;	
;
;============================================================================
; S A V I N G   R E G I S T E R S
;============================================================================

PushX	Macro
	push	h
	push	d
	push	b
EndM


PopX	Macro
	pop	b
	pop	d
	pop	h
EndM


PushA	Macro
	PushX
	push	psw
EndM


PopA	Macro
	pop	psw
	PopX
EndM

;============================================================================
; D A T A   E X C H A N G E
;============================================================================

; Exchange register pairs
;	xchg
;	XCRP	psw, b
;	XCRP	h,b
;	XCRP	d,b
; Bytes:4
; Side-effects: none

XCRP	Macro	RP1,RP2
	push	RP1
	push	RP2
	pop	RP1
	pop	RP2
EndM


; Exchange register pair with memory
; Bytes: 9
; Side-effects: none

XCRPM	Macro	RP,VAR
	push	RP
	lhld	VAR
	xthl
	shld	VAR
	pop	RP
EndM	


; Exchange memory words VAR1,VAR2
; Bytes: 18
; Side-effects: none

XCWM	MACRO	VAR1,VAR2
	IfDef	O_SIZE
		push	h
		lhld	VAR2
		XCRPM	h,VAR1
		shld	VAR2
		pop	h
	Else
		push h
		push d
		lhld VAR1
		xchg
		lhld VAR2
		shld VAR1
		xchg
		shld VAR2
		pop d
		pop h
	EndIF
EndM


; Exchange <BC> and *<SP> (xthl for equivalent <BC>)
; Side-effects: none

XTBC	Macro
	push	h
	push	b
	pop	h	; <HL> = <BC>
	xthl		; <SP> = <BC>
	push	h
	pop	b
	pop	h		
EndM


; Exchange <DE> and *<SP> (xthl for equivalent <DE>)
; Side-effects: none

XTDE	Macro
	xchg
	xthl
	xchg
EndM

;============================================================================
; C O M P A R I S O N
;============================================================================

; Compare <RPH1,RPL1> with <RPH2,RPL2>
; Bytes: 4
; Side-effects: Changes flags, <A> is not saved

CmpRP	Macro	RPH1,RPL1,RPH2,RPL2
	mov	a,RPL1
	sub	RPL2
	mov	a,RPH1
	sbb	RPH2
EndM


; Compare <B,C> with <RPH,RPL>
; Bytes: 4
; Side-effects: Changes flags, <A> is not saved

CmpBC	Macro	RPH,RPL
	CmpRP	B,C,RPH,RPL
EndM


; Compare <D,E> with <RPH,RPL>
; Bytes: 4
; Side-effects: Changes flags, <A> is not saved

CmpDE	Macro	RPH,RPL
	CmpRP	D,E,RPH,RPL
EndM


; Compare <H,L> with <RPH,RPL>
; Bytes: 4
; Side-effects: Changes flags, <A> is not saved

CmpHL	Macro	RPH,RPL
	CmpRP	H,L,RPH,RPL
EndM


; Compare <B,C> with [VAR]
; Bytes: 9
; Side-effects: Changes flags, <A> is not saved

CmpBCM	Macro	VAR
	push	h
	lhld	VAR
	CmpBC	H,L
	pop	h
EndM


; Compare <D,E> with [VAR]
; Bytes: 9
; Side-effects: Changes flags, <A> is not saved

CmpDEM	Macro	VAR
	push	h
	lhld	VAR
	CmpDE	H,L
	pop	h
EndM


; Compare <H,L> with [VAR]
; Bytes: 11
; Side-effects: Changes flags, <A> is not saved

CmpHLM	Macro	VAR
	push	d
	xchg
	lhld	VAR
	CmpDE	H,L
	xchg
	pop	d
EndM

;============================================================================
; D A T A   A C C E S S   A N D   M U T A T I O N
;============================================================================
; Direct data access
;----------------------------------------------------------------------------

; Load word memvar directly to <BC> (lhld equivalent for <BC>)
; Bytes: 7
; Side-effects: none

LBCD	Macro	MemVar
	push	h
	lhld	MemVar
	mov	b,h
	mov	c,l
	pop	h
EndM


; Load word memvar directly to <DE> (lhld equivalent for <DE>)
; Bytes: 5
; Side-effects: none

LDED	Macro	MemVar
	xchg
	lhld	MemVar
	xchg
EndM


; Store word from <BC> directly to memvar (shld equivalent for <BC>)
; Bytes: 7
; Side-effects: none

SBCD	MACRO	MemVar
	push	h
	mov	h,b
	mov	l,c
	shld	MemVar
	pop	h
EndM


; Store word from <DE> directly to memvar (shld equivalent for <DE>)
; Bytes: 5
; Side-effects: none

SDED	Macro	MemVar
	xchg
	shld	MemVar
	xchg
EndM

;-----------------------
; Indirect data access
;-----------------------

LDEX	Macro
	mov	e,m
	inx	h
	mov	d,m
	inx	h	; hmmm...
EndM

LHLX	Macro
	LDEX
	xchg
EndM



; C HLL equivalent: _rp = *(*_base + _rp);
; <H> and <PSW> can't be used for _rp.Only <D> or <B>
; Bytes: 9
; Side-effects: none

_LDBX	Macro	_rp,_base
	push	h

	lhld	_base
	dad	_rp

	IFIDN	<'&_rp'>,<'d'>
		mov	e,m		; 8
	ELSE
		IFIDN	<'&_rp'>,<'D'>
			mov	e,m
		ELSE
			mov	c,m
		ENDIF
	ENDIF

	inx	h
	mov	_rp,m

	pop	h
EndM


; Bytes: 11

_LDBXH	Macro	_base
	xchg
	_LDBX	d,_base
	xchg
EndM


; Load Displacement from Base Pointer indirectly
;	Load <RP> by Value at Base Pointer Value Plus Displacement
;	C equivalent:	_rp = *(*_base + _disp);
;	Use for reading WORDs in structure using structure pointer and offset
; 	If <_disp> parameter is not provided, <_disp> = contents of <_rp>
; Bytes: worst case: 14, best case: 12
; Side-effects: none
; Examples:
;  LDBX D,MemVar	<=>	DE = *(*MemVar+DE)
;  LDBX B,MemVar,1Eh	<=>	BC = *(*MemVar+1Eh)
;  LDBX H,MemVar 	<=>	HL = *(Memvar+HL)

LDBX	Macro	_rp,_base,_disp
	IfNB	<_disp>
		lxi	_rp,_disp
	EndIF

	IfIDN	<'&_rp'>,<'h'>
		_LDBXH	_base
	Else
		IfIDN	<'&_rp'>,<'H'>
			_LDBXH	_base
		Else
			_LDBX	_rp,_base
		EndIF
	EndIF
EndM


;============================================================================
; A R I T H M E T I C S
;============================================================================

; Inverts each bit of <RPH,RPL> to produce one's complement.
; Add one to RP (inx RPH) to produce two's complement
; Flags remain unchanged
; Bytes: 8
; Side-effects: none

CMRP	Macro	RPH,RPL
	push	psw
	mov	a,RPL
	cma
	mov	RPL,a
	mov	a,RPH
	cma
	mov 	RPH,a
	pop	psw
EndM


; Inverts each bit of <H,L> to produce one's complement.
; Add one to <HL> (inx H) to produce two's complement
; Flags remain unchanged
; Bytes: 8
; Side-effects: none

CMHL	Macro
	CMRP	H,L
EndM


; Inverts each bit of <D,E> to produce one's complement.
; Add one to <DE> (inx D) to produce two's complement
; Flags remain unchanged
; Bytes: 8
; Side-effects: none

CMDE	Macro
	CMRP	D,E
EndM


; Inverts each bit of <B,C> to produce one's complement.
; Add one to <BC> (inx B) to produce two's complement
; Flags remain unchanged
; Bytes: 8
; Side-effects: none

CMBC	Macro
	CMRP	B,C
EndM


; Subtract <RPH2,RPL2> from <RPH1,RPL1>
; Bytes: 6
; Side-effects: Changes flags, <A> is not saved

SubRP	Macro	RPH1,RPL1,RPH2,RPL2
	mov	a,RPL1
	sub	RPL2
	mov	RPL1,a
	mov	a,RPH1
	sbb	RPH2
	mov	RPH1,a
EndM


; Subtract <RPH,RPL> from <H,L>
; Bytes: 6
; Side-effects: Changes flags, <A> is not saved

SubHL	Macro	RPH,RPL
	SubRP	H,L,RPH,RPL
EndM


; Subtract <RPH,RPL> from <D,E>
; Bytes: 6
; Side-effects: Changes flags, <A> is not saved

SubDE	Macro	RPH,RPL
	SubRP	D,E,RPH,RPL
EndM


; Subtract <RPH,RPL> from <B,C>
; Bytes: 6
; Side-effects: Changes flags, <A> is not saved

SubBC	Macro	RPH,RPL
	SubRP	B,C,RPH,RPL
EndM


; Subtract word in memory from <H,L>
; <HL> = <HL> - [VAR]
; Bytes: 13
; Side-effects: Changes flags, <A> is not saved
; On Vector-06c it is slower than SubDM or SubBM

SubHLM	MACRO	VAR
	push	d
	xchg
	lhld	VAR
	SubDE	H,L
	xchg
	pop	d
EndM


; Subtract word in memory from <D,E>
; <DE> = <DE> - [VAR]
; Bytes: 11
; Side-effects: Changes flags, <A> is not saved

SubDEM	MACRO	VAR
	push	h
	lhld	VAR
	SubDE	H,L
	pop	h
EndM


; Subtract word in memory from <B,C>
; <BC> = <BC> - [VAR]
; Bytes: 11
; Side-effects: Changes flags, <A> is not saved

SubBCM	MACRO	VAR
	push	h
	lhld	VAR
	SubBC	H,L
	pop	h
EndM
