.REQUEST SPRITE
;
;             Perlin Production Co. Ltd., July 2011 (c)                 
;
;  G r a p h i c a   M i n i m a l i s t a   L i b r a r y   ( G M L )  
;      A proud descendant of PPCLIB Professional v.3.0, (c) 1993        
;      S P R I T E   V I S U A L I S A T I O N   R O U T I N E S        
;
; Define the following to use

; SBP_REL - BiPlanar	BiDirectional	Non-Transparent Sprite 2x16x16
; SPT_REL - MultiPlanar	BiDirectional	Non-Transparent Sprite Nx16x16

; BSP_REL - BiPlanar	BiDirectional	Color0-Transparent Sprite 2x16x16
; BPS_REL - BiPlanar	Unidirectional	Color0-Transparent Sprite 2x[8X]xY

; ASP_REL - BiPlanar	Unidirectional	Alpha-Transparent Sprite 2x16x16
; APS_REL - MultiPlanar Unidirectional	Alpha-Transparent Sprite Nx[8X]xY
; XPS_REL - BiPlanar	BiDirectional	Alpha-Transparent Sprite 2x[8X]xY 

; 
;  P I X E L   S H A D E R S 
; 

PS_OR	EQU	0	; Indexes for SetAPS,SetBPS
PS_XOR	EQU	1

EXT	PgeSPT	; memory page for sprites

; 
;  N O N   -    T R A N S P A R E N T   S P R I T E S 
; 

IFDEF	SBP_REL
; 
;  M o d u l e   D e c l a r a t i o n s 
; 

EXT Spt216
; Puts Bi-Planar Non-Transparent 2x16x16 pixels sprite in adjacent planes
; Sprite organization	: PLANE-AFTER-PLANE
; Byte order		: BIDIRECTIONAL COLUMNS
; PLANE0: 16x times bottom to top, then RIGHT, then 16x times top to bottom
; PLANE1: 16x times bottom to top, then LEFT,  then 16x times top to bottom
; Non-reentrable. Interrupts should be disabled
; In:
; <HL>	- sprite address
; <DE>	- screen address
;  <A>	- RAM drive setting
; Registers are not saved

ENDIF	; SBP_REL


IFDEF	SPT_REL
; 
;  M o d u l e   D e c l a r a t i o n s 
; 

EXT Spt16
; Puts Multi-Planar Non-Transparent Nx16x16 pixels sprite in adjacent planes
; Sprite organization	: PLANE-AFTER-PLANE
; Byte order		: BIDIRECTIONAL COLUMNS
; PLANE0: 16x times bottom to top, then RIGHT, then 16x times top to bottom
; PLANE1: 16x times bottom to top, then LEFT,  then 16x times top to bottom
; Faster than $Spt16. Assumes LXI B,20xxh is used
; Non-reentrable. Interrupts should be disabled
; In:
; <HL>	- sprite address
; <DE>	- screen address
;  <A>	- RAM drive setting (sprite page, see PGE_DEF macro)
;  <B>	- MUST BE 20H
;  <C>	- number of planes 1-4
; Registers are not saved


EXT $Spt16
; Puts Multi-Planar Non-Transparent Nx16x16 pixels sprite in adjacent planes
; Sprite organization	: PLANE-AFTER-PLANE
; Byte order		: BIDIRECTIONAL COLUMNS
; PLANE0: 16x times bottom to top, then RIGHT, then 16x times top to bottom
; PLANE1: 16x times bottom to top, then LEFT,  then 16x times top to bottom
; Non-reentrable. Interrupts should be disabled
; <HL>	- sprite address
; <DE>	- screen address
;  <A>	- RAM drive setting (sprite page, see PGE_DEF macro)
;  <C>	- number of planes 1-4
; Registers are not saved

ENDIF	;SPT_REL

; 
;  C O L O R - 0   -   T R A N S P A R E N T   S P R I T E S 
; 

IFDEF	BSP_REL
; 
;  M o d u l e   D e c l a r a t i o n s 
; 

EXT TSp216
; Puts Bi-Planar Color-0 Transparent 2x16x16 pixels sprite in adjacent planes
; Sprite organization	: PLANE-AFTER-PLANE
; Byte order		: BIDIRECTIONAL COLUMNS
; PLANE0: 16x times bottom to top, then RIGHT, then 16x times top to bottom
; PLANE1: 16x times bottom to top, then LEFT,  then 16x times top to bottom
; 
;  SPRITE i  SPRITE i+1 
; 
;  PLANE  i  PLANE  i+1 
; 
; Non-reentrable.; Needs disabled interrupts
; <HL>	- sprite address
; <DE>	- screen address
;  <A>	- RAM drive setting (sprite page, see PGE_DEF macro)
; Registers are not saved

ENDIF	; BSP_REL

; 
;     P L A N E   - T H R O U G H ,    B I - P L A N A R     
;  C O L O R - 0   -   T R A N S P A R E N T   S P R I T E S 
; 

IFDEF	BPS_REL

; Sprite organization	: PLANE-THROUGH
; Byte order		: COLUMNS from BOTTOM to TOP, LEFT to RIGHT
; 
;  SPRITE i  SPRITE i+1  SPRITE i+2  SPRITE i+3 
; 
;  PLANE 0i  PLANE  1i   PLANE 0i+1  PLANE 1i+1 
; 

; 
;  M o d u l e   D e c l a r a t i o n s 
; 

EXT BPSOR
; Put Bi-Planar Color-0 - Transparent Sprite 2x[8X]xY to
; adjacent VRAM planes from sprite page, addressed by PgeSpt
; using PS_AND Pixel Shader Operatior
; Input: same as PutBPS
; Non-reentrable, disables interrupts
; Input:
; <HL>	- sprite address
; <DE>	- screen address
; <B>   - sprite width in bytes
; <C>	- sprite height in pixels
; Out:
; <B>	= 0
; <C>	- SAVED sprite height in pixels
; <D>	- screen column address + sprite width in bytes
; <E>	- SAVED screen address vertical coordinate


EXT BPSXOR
; Put Bi-Planar Color-0 - Transparent Sprite 2x[8X]xY to
; adjacent VRAM planes from sprite page, addressed by PgeSpt
; using PS_XOR Pixel Shader Operatior
; Input: same as PutBPS
; Non-reentrable, disables interrupts
; Input:
; <HL>	- sprite address
; <DE>	- screen address
; <B>   - sprite width in bytes
; <C>	- sprite height in pixels
; Out:
; <B>	= 0
; <C>	- SAVED sprite height in pixels
; <D>	- screen column address + sprite width in bytes
; <E>	- SAVED screen address vertical coordinate


EXT BPS_PS
; Put Bi-Planar Color-0 - Transparent Sprite 2x[8X]xY to
; adjacent VRAM planes from sprite page, addressed by PgeSpt
; using requested Pixel Shader Operation
; Non-reentrable, disables interrupts
; Input:
; <HL>	- sprite address
; <DE>	- screen address
; <B>   - sprite width in bytes
; <C>	- sprite height in pixels
; <A>	- pixel shader operation: PS_OR, PS_XOR, etc.
; Out:
; <B>	= 0
; <C>	- SAVED sprite height in pixels
; <D>	- screen column address + sprite width in bytes
; <E>	- SAVED screen address vertical coordinate


EXT SetBPS
; Sets bi-planar pixel shader operation to be used by PutBPS
; Input: <A> - operation index (PS_AND,PS_XOR)
; Saves all registers
; Out: <CY> - error flag, <DE> - error if <CY> is set


EXT PutBPS
; Put Bi-Planar Color-0 Transparent 2x[8X]xY sprite
; from requested memory page to adjacent VRAM planes
; using Pixel Shader operation, preset by SetBPS
; Non-reentrable, disables interrupts
; Input:
; <HL>	- sprite address
; <DE>	- screen address
; <B>   - sprite width in bytes
; <C>	- sprite height in pixels
; <A>	- sprite memory page
; Out:
; <B>	= 0
; <C>	- SAVED sprite height in pixels
; <D>	- screen column address + sprite width in bytes
; <E>	- SAVED screen address vertical coordinate

EndIF	; BPS_REL



; 
;  A L P H A   -   C H A N N E L   S P R I T E S 
; 

IFDEF	ASP_REL
; 
;  M o d u l e   D e c l a r a t i o n s 
; 

EXT ASp216
; Puts Bi-Planar 2x16x16 Alpha-Transparent Sprite in adjacent planes
; Roughly 3 times slower than TSp216
; Alpha sprite organization: PLANE-AFTER-PLANE
; Byte order: BIDIRECTIONAL COLUMNS
; PLANE0: 16x times bottom to top, then RIGHT, then 16x times top to bottom
; PLANE1: 16x times bottom to top, then LEFT,  then 16x times top to bottom
; 
;   ALPHA i   SPRITE i   ALPHA i+1  SPRITE i+1 
; 
;  BYTE i ON PLANE k      BYTE i+1 ON PLANE k    
; 
; ALPHA - channel byte FOR PLANE, contains 1 in transparent bits
; SPRITE  byte contains 8 bits of image FOR PLANE
;
; Non-reentrable
; Needs disabled interrupts
; <HL>	- sprite address
; <DE>	- screen address
;  <A>	- RAM drive setting (sprite page, see PGE_DEF macro)
; Registers are not saved

ENDIF	; ASP_REL


IFDEF	APS_REL
; 
;  M o d u l e   D e c l a r a t i o n s 
; 
;PutAMS	- Put Multi-Planar Alpha Sprite. Presets: Pixel Shader
;PutAPS	- Put Multi-Planar Alpha Sprite. Presets: Pixel Shader, Depth
;SetAPS	- Sets Alpha Sprite Pixel Shader
;GetASD	- Gets Preset Alpha Sprite Depth
;SetASD	- Sets Preset Alpha Sprite Depth

; Alpha sprite organization: PLANE-AFTER-PLANE
; Byte order: COLUMNS from BOTTOM to TOP, LEFT to RIGHT
; 
;   ALPHA i   SPRITE i   ALPHA i+1  SPRITE i+1 
; 
;  BYTE i ON PLANE k      BYTE i+1 ON PLANE k    
; 
; ALPHA - channel byte FOR PLANE contains 1 in transparent bits
; SPRITE  byte contains 8 bits of image FOR PLANE


EXT	PutAMS
; Displays Multi-Planar Alpha Sprite
; Uses Preset Pixel Shader and RAM drive page
; Non-reentrable
; Input:
; <A>	- sprite depth
; <B>	- sprite width in bytes
; <C>	- sprite height in pixels
; <DE>	- screen address
; <HL>	- sprite address
; Pixel Shader Operation ( see SetAPS )
; [PgeSPT] - RAM drive setting for sprite memory page (see PGE_DEF macro)
; Saves: <BC>, <L>


EXT	PutAPS
; Saves: <BC>, <L>
; Displays Multi-Planar Alpha Sprite with preset depth
; Uses Preset Pixel Shader, Pixel Depth and RAM drive page
; Non-reentrable
; Input:
; <B>	- sprite width in bytes
; <C>	- sprite height in pixels
; <DE>	- screen address
; <HL>	- sprite address
; Alpha Sprite Depth ( see SetASD )
; Pixel Shader Operation ( see SetAPS )
; [PgeSPT] - RAM drive setting for sprite memory page (see PGE_DEF macro)
; Saves: <BC>, <L>


EXT	SetAPS
; Sets Alpha Sprite Multi-Planar Pixel Shader
; In <A> - Pixel Shader index
; Saves all registers
; Out: <CY> - error flag, <DE> - error if <CY> is set


EXT	GetASD
; Sets Preset Alpha Sprite Depth
; Out: <A> - Alpha Sprite Depth


EXT	SetASD
; Sets Preset Alpha Sprite Depth
; In: <A> - Alpha Sprite Depth

ENDIF	; APS_REL


IFDEF	XPS_REL	;BiPlanar BiDirectional Alpha-Transparent Sprite 2x[8X]xY 
; 
;  M o d u l e   D e c l a r a t i o n s 
; 

EXT PutXPS
; Puts BiPlanar BiDirectional Alpha Sprite 2x[8X]xY to
; adjacent VRAM planes using requested Pixel Shader Operation
; Non-reentrable, disables interrupts
; Alpha sprite format:
; { [AlphaByte][ImageByte] } all bytes for Plane 0
; { [AlphaByte][ImageByte] } all bytes for Plane 1
; Byte addressing is bi-directional columns
; bottom->top->bottom->top
; Input:
; <HL>	- sprite address
; <DE>	- screen address
; <B>   - sprite width in bytes
; <C>	- sprite height in pixels
; <A>	- sprite memory page


EXT SetXPS
; Sets Pixel Shader Operation for PutXPS
; In <A> - Pixel Shader index
; Out: <CY> - error flag, <DE> - error if <CY> is set
; Saves all registers

ENDIF	; XPS_REL
