/*
	SYSP.H - for SuperSoft C.1.2.3 - November 1993.
	  Copyright (c) by Perlin Production Co. Ltd.

	This file contains definitions of CPM BIOS structures
	and disk parameters that are machine independent.

		This file generates no code.
 */

/*
	 		/		 
		 128			26			3.25K
		 256			16			4.00K
		 512			 9			4.50K
		1024			 5			5.00K
*/


/* 32     ( 1- 0-  )  */

struct ISectDesk
{
	unsigned	_LoadAddress;	/*   DOS */
	unsigned	_RunAddress;	/*   DOS */
	unsigned	_Count;		/*   .  */
	char		_SizeDisk;	/*   0-5.25", 1-8" */
	char		_Density;	/*   0-FM, 1-MFM */
	char		_TpI;		/* 0-48 TpI, 1-96 TpI, 2-135 TpI */
	char		_SkewFactor;	/* 1-   ELSE */
					/*    */
					/* ,    */
					/*    */
	char		_SecSize;	/* 0-128, 1-256, 2-512, 3-1024 */
	char		_InSide;	/* 0-, 1- */
	unsigned	_SecPerTrack;	/*     .*/
	unsigned	_TrkPerDisk;	/*      */

/*	    ( DPB) */

	unsigned	_SPT;	/*  128-    */
	char		_BSH;	/*      */
				/*  .-  */
				/*     */
				/* BSH = log2 (< >/128) .. */
				/* = log2 (   / ) */
	char		_BLM;	/*     */
				/* BLM=(  /)-1 */
	char		_EXM;	/*   */
				/* EXM=(BLM+1)*128/1024 - 1 - [DSM/256] */
	unsigned	_DSM;	/*        1 */
	unsigned	_DRM;	/*       1 */
	unsigned	_AL;	/* .     */
	unsigned	_CKS;	/*     */
				/* CKS=(DRM+1)/4.     0 */
	unsigned	_OFS;	/*  system tracks */


	char		_CheckSum;	/*   ISectDesk */
	char		_SecTran[96];	/*    */
};



struct STDPB
{
	unsigned	SPT;	/*  128-    */
	char		BSH;	/*      */
				/*  .-  */
				/*     */
				/* BSH = log2 (< >/128) .. */
				/* = log2 (   / ) */
	char		BLM;	/*     */
				/* BLM=(  /)-1 */
	char		EXM;	/*   */
				/* EXM=(BLM+1)*128/1024 - 1 - [DSM/256] */
	unsigned	DSM;	/*        1 */
	unsigned	DRM;	/*       1 */
	unsigned	AL;	/* .     */
	unsigned	CKS;	/*     */
				/* CKS=(DRM+1)/4.     0 */
	unsigned	OFS;	/*  system tracks */
};


/*      DPB,  */
/*       7 : */

struct STDskParm
{
	char	HeadSpeed;	/* 0-6, 1-12, 2-20, 3-30, 80H-3 */
	char	SecPerTrack;	/*      */
	char	InSec;		/* 0-single sided, 1-double sided */
	char	SecSize;	/*  .  0-128,...3-1024 */
	char	Track;		/*    */
	char	Drive;		/*   - 00000100 */
	char	Info;		/*    .  */
};


/*   BIOS SELDSK  <HL>  0    */
/*     : Diskette Parameter Header */

struct STDPH
{
	unsigned	XLT;	/*    ->  */
	char	WorkZone[6];	/*   BDOS */
	unsigned	DIRBUF;	/*  128-     DIR */
	unsigned	DPBV;	/*     */
	unsigned	CSV;	/*       */
				/* .  ,  0 */
	unsigned	ALV;	/*      */
				/*     */
				/*   .   */
 				/*      */
};

#define DINFO	struct	ISectDesk
#define	DPB	struct	STDPB
#define	DPARMS	struct	STDskParm
#define DPH	struct	STDPH
