/*
*****************************************************************************
*		Perlin Production Co. Ltd. December , 1992 (c).		    *
*	WIOS.H file header for WINDOW package, SuperSoft C 1.2.3 compiler   *
*                         v e r s i o n   3 . 2                             *
*    LAST CHANGES: 01.12.1993.						    *
*****************************************************************************
*/

#define	W_VERSION	32

/*	Error numbers for WINERR function */

#define MAXERRN 8	/* Maximum error number */
#define WENOERR 0	/* No errors during window operations */
#define WENOOR	1	/* Error number out of range */
#define WECOOSC	2	/* Cursor out of screen */
#define WECOOCW	3	/* Cursor out of current window */
#define WECREAT	4	/* Can't open window : no dynamic memory */
#define WESHAD  5	/* Bad shadow position */
#define WEMNDEF 6	/* Menu not defined */
#define WENOTM  7	/* Structure is not a menu */
#define WENOTP  8	/* No place for text in window */

/*	ASCII-codes to write border	*/

#define DBLD 0x98	/* Double border, left-down corner */
#define DBLU 0x99	/* Double border, left-upper corner */
#define DBRD 0x8C	/* Double border, right-down corner */
#define DBRU 0x8B	/* Double border, right-upper corner */
#define DBVL 0x8A	/* Double border, vertical line */
#define DBHL 0x9D	/* Double border, horizontal line */
#define DBCS 0x9E	/* Double border, cross */
#define DBVHR 0x9C	/* Double border, vertical and horizontal right */
#define DBVHL 0x89	/* Double border, vertical and horizontal left */
#define DBHVU 0x9A	/* Double border, horizontal and vertical up */
#define DBHVD 0x9B	/* Double border, horizontal and vertical down */
 
#define SBLD 0x90	/* Single border, left-down corner */
#define SBLU 0xAA	/* Single border, left-upper corner */
#define SBRD 0xA9	/* Single border, right-down corner */
#define SBRU 0x8F	/* Single border, right-upper corner */
#define SBVL 0x83	/* Single border, vertical line */
#define SBHL 0x94	/* Single border, horizontal line */
#define SBCS 0x95	/* Single border, cross */
#define SBVHR 0x93	/* Single border, vertical and horizontal right */
#define SBVHL 0x84	/* Single border, vertical and horizontal left */
#define SBHVU 0x91	/* Single border, horizontal and vertical up */
#define SBHVD 0x92	/* Single border, horizontal and vertical down */

#define HBLD  164	/* Horizontal border, left-down corner */
#define HBLU  165	/* Horizontal border, left-upper corner */
#define HBRD  142	/* Horizontal border, right-down corner */
#define HBRU  136	/* Horizontal border, right-upper corner */
#define HBVL  131	/* Horizontal border, vertical line */
#define HBHL  157	/* Horizontal border, horizontal line */
#define HBCS  168	/* Horizontal border, cross */
#define HBVHR 133	/* Horizontal border, vertical and horizontal right */
#define HBVHL 150 	/* Horizontal border, vertical and horizontal left */
#define HBHVU 161 	/* Horizontal border, horizontal and vertical up */
#define HBHVD 159 	/* Horizontal border, horizontal and vertical down */

#define VBLD  163 	/* Vertical border, left-down corner */
#define VBLU  166	/* Vertical border, left-upper corner */
#define VBRD  141	/* Vertical border, right-down corner */
#define VBRU  135	/* Vertical border, right-upper corner */
#define VBVL  138	/* Vertical border, vertical line */
#define VBHL  148	/* Vertical border, horizontal line */
#define VBCS  167	/* Vertical border, cross */
#define VBVHR 134	/* Vertical border, vertical and horizontal right */
#define VBVHL 151	/* Vertical border, vertical and horizontal left */
#define VBHVU 162	/* Vertical border, horizontal and vertical up */
#define VBHVD 160	/* Vertical border, horizontal and vertical down */
/*
 *		Shadow symbols
 */
#define NO_SHADOW	0
#define SHADOW1		0x80
#define SHADOW2		0x81
#define SHADOW3		0x82
/*
 *		Psevdo-Graphical symbols
 */
#define PSBLNK 0xAB	/* Psevdo - blank */
#define PSDWN  0xAC	/* Psevdo - down  */
#define PSLFT  0xAD	/* Psevdo - left  */
#define PSRGT  0xAE	/* Psevdo - right */
#define PSUP   0xAF	/* Psevdo - up    */

/*
 *		Package structures
 */
	/*	B O R D E R	*/

struct bdr_type
{
	char hor;
	char vert;
	char ul;
	char ur;
	char dr;
	char dl;
};

#define	BORDER	struct bdr_type

/*	Definition of WIOS pre-defined border structures */

extern BORDER bdr_s;
extern BORDER bdr_d;
extern BORDER bdr_h;
extern BORDER bdr_v;

/* Standard names of POINTERS to borders, defined in WIOS.REL */

#define NO_BORD 0		/* No border */
#define S_BORD  & bdr_s		/* Single border */
#define D_BORD  & bdr_d		/* Double border */
#define H_BORD  & bdr_h		/* Horizontal, vertical border */
#define V_BORD	& bdr_v		/* Vertical, horizontal border */



		/*	W I N D O W	*/

struct wndesc
{
 char	xs;		/* Start  x-coordinate ABSOLUTE */
 char	ys;		/* Start  y-coordinate ABSOLUTE */
 char	xe;		/* End by x-coordinate ABSOLUTE */
 char	ye;		/* End by y-coordinate ABSOLUTE */
 char	t_xs;		/* Text start position by x-coordinate ABSOLUTE */
 char	t_ys;		/* Text start position by y-coordinate ABSOLUTE */
 char	t_xe;		/* Text end   position by x-coordinate ABSOLUTE */
 char	t_ye;		/* Text end   position by y-coordinate ABSOLUTE */
 char	l_mg;		/* Left margin */
 char	r_mg;		/* Right margin */
 char	t_lgt;		/* Text length in window */
 char	t_hgt;		/* Text heigth in window */
 char	row;		/* Current row    position of window cursor RELATED */
 char	col;		/* Current column position of window cursor RELATED */
 char	bgrnd;		/* Background color : NORM_VID or REV_VID */
 char	bdr_att;	/* Border color attrib NORM_VID or REV_VID */
 char	fill;		/* Symbol that fills window */
 char	shadow;		/* Shadow-symbols, or NO_SHADOW */
 int	item;		/* Number of current item in menu */
 BORDER	*brd;		/* Pointer to the BORDER structure */
 char	*hot_k;		/* Pointer to the text with hot_keys */
 char	**wtxt;		/* Pointer to pointers to window-text */
 char	*name;  	/* Pointer to window name, or to NULL */
 int	(*helpfun)();	/* Pointer to popup help information function */
};

#define WINDOW	struct wndesc
#define	SIZE_WN	sizeof(wndesc)	/* Not ANSI, nor UNIX way of sizeof() */

extern int werrno;

/*
	Values, returned by menu() and menu_bar() functions
*/

#define	NO_CHOICE	(-1)
#define	PREV_MENU	(-2)
#define	POST_MENU	(-3)
