/* WINSAMP1.C
 *
 *		Perlin Production Co.Ltd. December 1993 (c).
 *	This program demonstrates a new style of programming for
 *	WIOS runtime library (TM) version 3.2.
 */

#include "stddef.h"
#include "wios.h"
#include "conio.h"

/*	Main menu help functions	*/

extern	int	m_hlpfun();

/*	Submenu functions		*/

extern	int	sbmnu0();
extern	int	sbmnu1();
extern	int	sbmnu2();
extern	int	sbmnu3();

#define	APP_VER		32		/* Application version */
#define	M_ITEMS		4		/* Number of main menu items */

WINDOW	*MESWIN,*HELPWIN;

main()
{
	WINDOW	*MAIN;
	char	*m_items[M_ITEMS];
	char	*m_hots;
	int	(*sm_ptr[M_ITEMS])();
	int	choice;


	if ( w_version() != APP_VER )
	{
		printf("Incompatible WIOS version %d\n",w_version());
		printf("Re-link this application with WIOS ver. %d",APP_VER);
		exit(1);
	}

	init_wns();

	defglwin();

	if ( (MAIN=w_creat(MAIN)) == NULL ) fatal();
	def_wn(0,0,MAXX,2,D_BORD,MAIN);
	sw_name("Main menu",MAIN);
	sw_shadow(NO_SHADOW,MAIN);
	sw_fill(SHADOW_2,MAIN);

	m_items[0]="<F>irst";
	m_items[1]="<S>econd";
	m_items[2]="<T>hird";
	m_items[3]="f<O>urth";
	m_hots="FSTO";
	sm_options(m_hots,m_items,MAIN,m_hlpfun);

	sm_ptr[0]=sbmnu0;
	sm_ptr[1]=sbmnu1;
	sm_ptr[2]=sbmnu2;
	sm_ptr[3]=sbmnu3;

	cls();
	hd_csr();
	set_wn(MAIN);
	set_wn(MESWIN);
	set_wn(HELPWIN);
	
	while ( (choice=menu_bar(MAIN)) > NO_CHOICE )
	{
		do
		{
			choice=mb_item(choice,MAIN);	    /* Fixup item   */
			/* NOTE that submenu functions MUST return a CHOICE:*/
			choice=(*(sm_ptr[choice]))(choice); /* Call submenu */
		}
		while ( choice < NO_CHOICE );	/* Loop until no selection */
	}



	/* You can process a CHOICE exit code when leaving main menu: */

	switch (choice)
	{
		case	PREV_MENU:	break;
		case	POST_MENU:	break;
		case	NO_CHOICE:	break;
	}
	goto_xy(0,MAXY);
	sh_csr();
}


defglwin()
{
	if ( (MESWIN=w_creat(MESWIN)) == NULL ) fatal();
	defs_wn(20,10,30,5,V_BORD,MESWIN);
	sw_name("Message window",MESWIN);
	sb_color(REV_VID,MESWIN);

	if ( (HELPWIN=w_creat(HELPWIN)) == NULL ) fatal();
	defs_wn(5,19,MAXX-5,4,S_BORD,HELPWIN);
	sw_name("Help",HELPWIN);
}	


fatal()
{
	printf("You've got a trouble: %s",winerr());
	exit(1);
}


int	m_hlpfun(item_num)
int	item_num;
{
	char *item_help[M_ITEMS];
	register int i;

	item_help[0]="This opens MENU 0";
	item_help[1]="This goes to MENU 1";
	item_help[2]="This works with MENU 2";
	item_help[3]="This EXITS program";

	mv_chome(MESWIN);
	w_puts("We are in main menu.   ",MESWIN);
	mv_csr(2,1,HELPWIN);
	w_puts("                                          ",HELPWIN);
	mv_csr(2,1,HELPWIN);
	w_puts(item_help[item_num],HELPWIN);
}


/*****************************************************************************/
#define	FIRST		(&ws0)
#define MS0_ITEMS	3

extern	int	sbhlp0();

int	sbmnu0(choice)
int	choice;
{
	WINDOW	ws0;
	char	*s0opt[MS0_ITEMS];
	int	subchoice;

	where_we(choice);

	defs_wn(1,3,20,MS0_ITEMS+2,V_BORD,FIRST);
	sw_name("Submenu_0",FIRST);

	s0opt[0]="<F>irst subitem";
	s0opt[1]="<S>econd subitem";
	s0opt[2]="<T>hird subitem";

	sm_options("FST",s0opt,FIRST,sbhlp0);
	set_wn(FIRST);
	subchoice=menu(FIRST);
	unset_wn(FIRST,BLANK,NORM_VID);
	return(subchoice);
}


sbhlp0(subitem)
int	subitem;
{
	mv_csr(2,1,HELPWIN);
	w_puts("                        ",HELPWIN);
	mv_csr(2,1,HELPWIN);
	w_puts("SUBMENU0. Subitem #",HELPWIN);
	w_putdec(subitem,HELPWIN);
}



/*****************************************************************************/

#define	SECND		(&ws1)
#define MS1_ITEMS	3

extern	int	sbhlp1();

int	sbmnu1(choice)
int	choice;
{
	WINDOW	ws1;
	char	*s1opt[MS1_ITEMS];
	int	subchoice;

	where_we(choice);

	defs_wn(10,3,20,MS1_ITEMS+2,H_BORD,SECND);
	sw_color(REV_VID,SECND);
	sw_name("Submenu_1",SECND);

	s1opt[0]="<F>irst subitem";
	s1opt[1]="<S>econd subitem";
	s1opt[2]="<T>hird subitem";

	sm_options("FST",s1opt,SECND,sbhlp1);
	set_wn(SECND);
	subchoice=menu(SECND);
	unset_wn(SECND,BLANK,NORM_VID);
	return(subchoice);
}


sbhlp1(subitem)
int	subitem;
{
	mv_csr(2,1,HELPWIN);
	w_puts("                             ",HELPWIN);
	mv_csr(2,1,HELPWIN);
	w_puts("SUBMENU1. Subitem #",HELPWIN);
	w_putdec(subitem,HELPWIN);
}



/*****************************************************************************/

int	sbmnu2(choice)
int	choice;
{
	where_we(choice);
	while(!ki());
	return(NO_CHOICE);
}

/*****************************************************************************/

int sbmnu3(choice)
int	choice;
{
	char	c;

	where_we(choice);
	w_puts("\nExit to CP/M [Y/N] ?",MESWIN);
	while ( !(c=toupper(ki())));
	if ( c == 'Y' )
	{	
		goto_xy(0,MAXY);
		sh_csr();
		exit(0);
	}
	cl_wn(MESWIN);
	return(NO_CHOICE);
}


where_we(choice)
int	choice;
{
	cl_wn(MESWIN);
	w_puts("We are in submenu #",MESWIN);
	w_putdec(choice,MESWIN);
}
