/*  MAKE.C

******************************************************************************
*                                                                            *
*            Perlin Production Corporation, 1992,1993,1994 (c).              *
*                Source code for SuperSoft C compiler v.1.2.3.               *
******************************************************************************/


#include "stdio.h"

#define	FATAL	fatal()
#define	MAXLIBS	10
#define SUBNAME "BLD.SUB"
#define	NPHASE	3
#define	FNLEN	8

extern	int	puts();

FILE	*fd;
char	*fname;

char	outline[80];
char	userfn[80];

int main(argc,argv)
int	argc;
char	**argv;
{
	char	libname[MAXLIBS][8];
	int	nlibs,nsources,i,j;
	int	linking;
	char	*source,*cptr,key,instring[80];
	char	*phasname[NPHASE],*phase[NPHASE],*phext[NPHASE],*ext[NPHASE];
	int	recompile[9];

	phasname[0]="COMPILATION";
	phasname[1]="OPTIMIZATION";
	phasname[2]="RUNNING ASSEMBLER";
	phase[0]="cc ";
	phase[1]="c2 ";
	phase[2]="m80 =";
	phext[0]=".c\n";
	phext[1]=".cod\n";
	phext[2]=".asm\n";
	ext[0]=".bak\n";
	ext[1]=".cod\n";
	ext[2]=".asm\n";
	linking=TRUE;
	for (i=0 ; i < 9 ; i++) recompile[i]=TRUE;

	copyright();
	switch (argc)
	{
		case 1:
		{
			fname=SUBNAME;
			break;
		}
		case 2:
		{
			strcpy(userfn,argv[1]);
			for ( cptr=userfn ; *cptr && *cptr != '.' ; cptr++ );
			*cptr='\0';
			fname=strcat(userfn,".SUB");
			break;
		}
		default: return(1);
	}
	puts("\nDo you want to have a COM file after running batch [Y/N] ");
	while ( (key=getkey()) != 'Y' && key != 'N');
	putchar(key);
	if (key == 'N' ) linking=FALSE;
	do
	{
	    puts("\n\nInput number of source files to be processed [1-9]:");
	    scanf("%1d",&nsources);
	}
	while ( nsources < 1 || nsources > 9 );


	if (linking)
	{
		puts("\n");
		for ( i=0 ; i < nsources ; i++ )
		{
			puts("\nDo you want to RECOMPILE source file number ");
			putdec(i+1);
			puts(" [Y/N] ");
			while ( (key=getkey()) != 'Y' && key != 'N');
			putchar(key);
			if (key == 'N' ) recompile[i]=FALSE;
		}
		puts("\n\nNow You can specify up to ");
		putdec(MAXLIBS);
		puts(" addition runtime libraries to be processed\n");
		puts("by linker during building Your C-program.\n");
	puts("Please enter only NAME of library without dot & extension.\n");
	puts("To finish specifying press <ENTER> instead of library name.\n");
		nlibs=0;
		do
		{
			puts("\nLibrary NAME:");
			gets(instring);
			while (strlen(instring) > FNLEN)
			{
				puts("LIBRARY NAME TOO LONG. REPEAT, PLEASE");
				puts("\nLibrary NAME:");
				gets(instring);
			}
			strcpy(libname[nlibs++],instring);
		}
		while ( instring[0]!='\0' && nlibs < MAXLIBS);
	}
	nlibs--;
	unlink(fname);
	if ( (fd=fopen(fname,"W",1024)) == NULL ) FATAL;

	if (linking)
	toSUB(
	";Building project $1 for SuperSoft C compiler, ver.1.2.3 (c).");
	else
	toSUB(
	";Compiling source(s) to REL by SuperSoft C ver.1.2.3 (c).");

	useinfo(toSUB,nsources,recompile);
	
	for (i=0 ; i < 3 ; i++)
	{
		toSUB("\n;\t\t*** ");
		toSUB(phasname[i]);
		toSUB(" ***\n\n");
		for(j=0 ; j < nsources ; j++)
		{
			if ( recompile[j] )
			{
				toSUB(formcmd(phase[i],phext[i],j));
				toSUB(eracmd(ext[i],j));
			}
		}
	}
	if (linking)
	{
		toSUB("\n;\t\t*** LINKING ***\n");
		toSUB("\nl80m ");
		source="$0,";
		for (i=0 ; i < nsources ; i++)
		{
			source[1]=i+'1';
			toSUB(source);
		}
		toSUB("c2pre,");
		for (i=0 ; i < nlibs ; i++)
		{
			toSUB(libname[i]);
			toSUB("/s,");
		}
		toSUB("libc/s,c2post,$1/n/e\n");
		for(j=0 ; j < nsources ; j++)
		{
			if (recompile[j]) toSUB(eracmd(".rel\n",j));
		}
	}
	if ( fclose(fd) == ERROR ) FATAL;
	puts("\nProject batch file ");
	puts(fname);
	puts(" successfully created.");
	useinfo(puts,nsources,recompile);
	return(0);
}


copyright()
{
	puts("\t\tPerlin Production Co. Ltd. November 1993 (c).\n");
	puts("\t\t    Submit files C Preprocessor v.1.0.\n");
	puts("This program makes batch compilation file ");
	puts("for SuperSoft C 1.2.3 compiler TM.\n");
	puts("\t\t    Usage: MAKE [ SUBFILENAME [.SUB] ]\n");
	puts("\t\t    SUBFILENAME by default is ");
	puts(SUBNAME);
	puts("\n");
}


char	getkey()
{
	char	key;

	while( !(key=ki()) );
	return(toupper(key));
}



char	*formcmd(sphase,ext,nsrc)
char	*sphase;
char	*ext;
int	nsrc;
{
	char	*s;

	s="$0";
	s[1]=nsrc+'1';
	strcpy(outline,sphase);
	strcat(outline,s);
	return(strcat(outline,ext));
}


char	*eracmd(ext,nsrc)
char	*ext;
int	nsrc;
{

	strcpy(outline,"E $0");
	outline[3]=nsrc+'1';
	return(strcat(outline,ext));
}

toSUB(s)
char	*s;
{
	if (fputs(s,fd) == ERROR ) FATAL;
}


fatal()
{
	perror(fname);
	exit(1);
}


useinfo(func,nsources,recompile)
int	(*func)();
int	nsources;
int	*recompile;
{
	char	*cstr,*relstr;
	int	i;

	(*func)("\n;Command line to start this batch:\n;SUBMIT ");
	(*func)(fname);
	cstr=" C_#";
	relstr=" REL_#";
	for ( i=0 ; i < nsources ; i++)
	{
		if (recompile[i])
		{
			cstr[3]=i+'1';
			(*func)(cstr);
		}
		else
		{
			relstr[5]=i+'1';
			(*func)(relstr);
		}
	}
	(*func)("\n;where C_ files will be fully recompiled.\n");
}
