/************************************************************************/
/*	Perlin Production Co. Ltd. July 2012				*/
/*	GAS, bi-directional Alpha Sprite image Generator, v.2.1		*/
/************************************************************************/
/* GASLib.C */

#include "stdio.h"
#include "fdlib.h"
#include "gas.h"

usage(_text)
char* _text;
{
 printf("Usage:\n");
 rev_vid();
 printf("GAS width height alpha image output [phases] [depth] [cmode]\n\n");
 nrm_vid();
 printf("-- Parameters:\n");
 printf("1. width  - sprite width,           bytes  1..%d\n", MAXSW);
 printf("2. height - sprite height,          pixels 1..%d\n", MAXSH);
 printf("3. alpha  - sprite alpha bitmap file, plane-by-plane\n");
 printf("4. image  - sprite image bitmap file, plane-by-plane\n");
 printf("-- Optional Parameters:\n");
 printf("5.[phases]- number of shifted image phases 1..[%d]\n", MAXPHS);
 printf("6.[depth] - sprite depth,      [%d] planes 1..%d\n", DEFSD, MAXSD);
 printf("7.[cmode] - [%d]: colour mode: 0-normal, 1-inverted bits\n",DEFINV);

 if (_text)
 {
	printf("\n");
	trouble(_text, 0);
	printf("0x7");
 }
}



banner(_text)
char* _text;
{
 printf("Perlin Production Co. Ltd. August 2012\n");
 printf("GAS, bi-directional Alpha Sprite image Generator, ver. 3.0\n");
 printf("In: equal size alpha & image files, plane-by-plane bitmap format.\n");
 printf("Interleaves files contents byte by byte, alpha byte first.\n");
 printf("Reverses byte sequencing for odd columns of interleaved image.\n");
 printf("If phases > 1, output image is ");
 rev_vid();
 printf("one byte wider");
 nrm_vid();
 printf(", shift is 8/phases bits right.\n");
 printf("Alpha bitmap is always inverted. In inverted colour mode, maximum\n");
 printf("colour transparency mask is in alpha file, else-in bits of image.\n");
 usage(_text);
}



ReadFD(_fd, _depth, _width, _height, _incwdt)
FD*		_fd;
unsigned	_depth;
unsigned	_width;
unsigned	_height;
int		_incwdt;
{
	unsigned i;
	unsigned szRead, szPlane, szRdAll;
	char	*p;

	szRead	= _width * _height;
	szPlane	= (_width + _incwdt) * _height;
	szRdAll	= _depth * szPlane;

	if (_fd->bufsiz != szRdAll)
		trouble("invalid buffer size in",_fd->name);

	p = _fd->buf;

	for (i=0; i < _depth; ++i)
	{
		if ((read(_fd->file,p,szRead)) != szRead)
			trouble("read error in",_fd->name);

		p += szPlane;
	}
}


InvBuf(_fd)
FD*	_fd;
{
 unsigned	i;
 unsigned	size;
 char*		p;

 size	= _fd->bufsiz;
 p	= _fd->buf;

 for (i=0; i < size; ++i) p[i] = ~p[i];
}


InvPln(_fd,_depth,_width,_height)
FD*		_fd;
unsigned	_depth;
unsigned	_width;
unsigned	_height;
{
	char		*l,*r,tmp;
	unsigned	i,j,dhalf,size,size2;

	if (_depth < 2) return;

	dhalf	= _depth / 2;
	size	= _width * _height;
	size2	= size * 2;
	l	= _fd->buf;
	r	= l + (_depth - 1) * size;

	for (i=0; i < dhalf; ++i)
	{
		for (j=0; j < size; ++j) *l++ = *r++;
		r -= size2;
 	}
}


RarBuf(_fd, _lmask, _amt, _depth, _width, _height)
FD*		_fd;
char		_lmask;
unsigned	_amt;	/* amount of rotation right 1..7 */
unsigned	_depth;
unsigned	_width;
unsigned	_height;
{
	unsigned	d,w,h;
	unsigned	szPlane, szLine;
	char		*p, *plane;
	unsigned char	c, mask, lamt;

	_amt	&= 7;

	if (!_amt) return;	/* 1 */

	lamt	= 8 - _amt;	/* 7 */
	plane	= _fd->buf;
	szPlane	= _width * _height;
	szLine	= szPlane - _height;

	for(d=0; d < _depth; ++d)
	{
 		for(h=0; h < _height;++h)
		{
			p	= plane + h;
			mask	= _lmask << lamt;

		 	for(w=0; w < _width; ++w)
	 		{
				c	= *p;
				*p	= (c >> _amt) | mask;
				mask	= c << lamt;

				p += _height;
			}
		
		}
		plane += szPlane;
	}
}



DisInp	(_name,_size)
char		*_name;
unsigned	_size;
{
	FILE*	fd;
	char	*d;
	char	dpname[20];

	strncpy(dpname,_name,12); /* 0/a:12345678 */
	for (d=dpname ; *d ; ++d )
		if (*d == '.')
		{
			*d = 0;
			break;
		}
	strcat(dpname,".DIS");

	printf("\nGenerating disassembler input pipeline %s ",dpname);

	if (fd = fopen(dpname,"w",128))
	{
		fprintf(fd,"%x\n0\n0\n",_size);
		printf(".");
		fprintf(fd,"NNYNNNNY0-%x\n\n\n",_size);
		printf(".");
		fclose(fd);
		printf(". succeded\n");
	}
	else printf("failed\n");
}
