/*
 *	Perlin Production Co. Ltd. September 1993 (c).
 *			GRAB2.C
 */

#include "stdio.h"
#include "wios.h"
#include "conio.h"
#include "grab.h"

static char	pixarr[NPANELS][32];

int	sav_sprite(xs,ys,xe,ye,sav_format)
int	xs,ys,xe,ye,sav_format;
{
	WINDOW		attention;
	int		pcounter,colnum,rawnum,panel,nob;
	int		bcounter,i,k,sign;
	unsigned	base,position,bytepos,nbytes,ncolumns;
	char		c,masc,hmasc,lmasc;

	base=(xs << 4) + ys;
	nbytes=ye-ys+1;
	ncolumns=(xe-xs+1) >> 4;

	switch(sav_format)
	{
	case AS_BITMAP :
	    for (pcounter=0 ; pcounter < NPANELS ; pcounter++)
	    {
		if ( (p_enabled[pcounter]) == TRUE )
	    	{
			position=base;
			colnum = ncolumns;
			while (colnum--)
			{
				if ((seek (src,position,START)) == ERROR)
			  		trouble("Seek error in ",srcname);
			 	if ((read (src,scrcol,nbytes)) != nbytes)
			  		trouble ("Read error in ",srcname);
			 	if ((write(dst,scrcol,nbytes)) != nbytes)
		  	  		trouble ("Can't write to ",dstname);
			 	position+=VSIZE;
			}
	    	}
		base+=PANEL_BIAS;
	    }
	    break;
	case AS_SPRITE:
	    for (i=0; i < ncolumns; ++i)
	    {
		position = base;
	   	for (k=0; k < nbytes; ++k)
	   	{
		    bytepos = position++;
		    for (pcounter=0 ; pcounter < NPANELS ; ++pcounter)
		    {
		    	if ( (p_enabled[pcounter]) == TRUE )
	    	   	{
				if ((seek (src,bytepos,START)) == ERROR)
			  		trouble("Seek error in ",srcname);
			 	if ((read (src,scrcol,1)) != 1)
			 		 trouble ("Read error in ",srcname);
			 	if ((write(dst,scrcol,1)) != 1)
		  	  		trouble ("Can't write to ",dstname);
			}
			bytepos += PANEL_BIAS;
		    }
	   	}
		base += VSIZE;
	    }
	    break;
	case AS_WBITMAP:
	    sign=1;
	    bcounter = 0;
	    for (pcounter=0 ; pcounter < NPANELS ; pcounter++)
	    {
		if ( (p_enabled[pcounter]) == TRUE )
	    	{
		    colnum = ncolumns;
		    position=base;
		    if (bcounter & 0x1) position += VSIZE*(ncolumns-1);

		    while (colnum--)
		    {
			if ((seek (src,position,START)) == ERROR)
				trouble("Seek error in ",srcname);
			if ((read (src,scrcol,nbytes)) != nbytes)
				trouble ("Read error in",srcname);

			if (sign < 0)
			{
				k = nbytes-1;
				for (i=0; i < nbytes/2;++i)
				{
					c = scrcol[i];
					scrcol[i]=scrcol[k];
					scrcol[k--]=c;
				}
		 	}
			if ((write(dst,scrcol,nbytes)) != nbytes)
			 		trouble("Can`t write to",dstname);

			if (bcounter & 0x1) position-=VSIZE;
		 	else position += VSIZE;
		 	sign *= -1;
		    }
		    ++bcounter;
	    	}
	    	base+=PANEL_BIAS;
	    }
	    break;
	case AS_PIXELS :
	    defs_wn(9,10,60,3,V_BORD,&attention);
	    set_wn(&attention);
	    w_puts( "Please wait. This procedure demands much time to be done."
	          , &attention
		  );
	    for ( rawnum = 0 ; rawnum < nbytes ; rawnum++,base++ )
	    {
	        for ( bytepos=base,colnum=0
		    ; colnum < ncolumns
		    ; colnum++,bytepos+=VSIZE
		    )
		{
		    for ( position=bytepos,panel=0
			; panel < NPANELS
			; panel++,position+=PANEL_BIAS
			)
		    {
		        if ((seek(src,position,START)) == ERROR)
				trouble("Seek error in",srcname);
			if ((read(src,&pixarr[panel][colnum],1)) != 1)
				trouble("Read error in",srcname);
		    }
		}
		    
		for ( nob=0, colnum=0 ; colnum < ncolumns ; colnum++ )
		{
		    for ( masc=0x80 ; masc ; nob++,masc >>=2 )
		    {
			scrcol[nob]=0;
			for ( hmasc=0x80,lmasc=0x8,panel=0
			    ; panel < NPANELS
			    ; panel++,hmasc >>= 1,lmasc >>=1
			    )
			{
			    if (masc & pixarr[panel][colnum])
				scrcol[nob] |= hmasc;
			    if ( (masc >> 1) & pixarr[panel][colnum] )
				scrcol[nob] |= lmasc;
			}
		    }
		}
		if ((write(dst,scrcol,nob)) != nob)
		    trouble ("Can't write ",dstname);
	    }
	    break;
	}
	if (close(dst)==ERROR) trouble("Error closing",dstname);
	return (SUCCESS);
}
