/*
 ----------------------------------------------------------------
 |    Perlin Production Corporation, February-April 1993 (c).	|##
 |   WINDOW PACKAGE Source Code for SuperSoft C 1.2.3 compiler.	|##
 |    V e r s i o n  3.2 , part 23. LAST CHANGES: 30.10.1994.	|##
 ----------------------------------------------------------------##
  #################################################################

			LIST OF FUNCTIONS:
	w_alloc
	w_destroy
	w_new
	w_news
	sw_wntyp
*/

#include "stdio.h"
#include "wios.h"


WINDOW	*w_alloc()
{
	WINDOW	*wp;
	werrno = ( (wp=malloc(SIZE_WN)) == NULL ) ? WECREAT : WENOERR;
	return (wp);
}


w_destroy(wp)
WINDOW	*wp;
{
	unset_wn(wp);
	free (wp->winbuffer);
	if (wp->tfdynamic == TRUE) free(wp);
}



WINDOW	*w_new(xst,yst,xend,yend,border,state)
char xst,yst,xend,yend,state;
BORDER *border;
{
	WINDOW *wp;

	werrno=WENOERR;
	if (wp=w_alloc())
	{
		def_wn(xst,yst,xend,yend,border,wp);
		wp->tfdynamic=TRUE;
		if (state==POPUP)
		{
			if (sw_wntyp(POPUP,wp)==ERROR)
			{
				w_destroy(wp);
				wp=NULL;
			}
		}
	}
	werrno = ( wp ? WENOERR : WEALLOCATE );
	return wp;
}


WINDOW	*w_news(xst,yst,xs,ys,border,state)
char xst,yst,xs,ys,state;
BORDER *border;
{
	return w_new(xst,yst,xst+xs-1,yst+ys-1,border,state);
}



int	sw_wntyp(state,wp)
char	state;
WINDOW	*wp;
{
	int	nbytes;

	werrno=WENOERR;
	if (wp->winstate == state) return SUCCESS;
	switch (state)
	{
		case ORDINARY:
		{
			free(wp->scrbuffer);
			wp->scrbuffer=NULL;
			wp->winstate=ORDINARY;
			break;
		}
		case POPUP:
		{
			nbytes=((wp->xe-wp->xs+1)*(wp->ye-wp->ys+1)) << 1;
			if ((wp->scrbuffer=malloc(nbytes))==NULL)
			{
				werrno=WEALLOCATE;
				return ERROR;
			}			
			wp->winstate=POPUP;
			break;
		}
		default:
			return ERROR;
	}
}
