#include <windows.h>
#include <string.h>
#include <dos.h>
#include "..\..\di.hpp"
#include "..\..\..\plugin.hpp"
#include "edd.hpp"
#include "..\common.cpp"
#include "utilites.cpp"


BOOL WINAPI IsImage(char *Name,const unsigned char *Data,int DataSize)
{
	HANDLE ReadHandle = CreateFile(Name,
		GENERIC_READ,
		FILE_SHARE_READ|FILE_SHARE_WRITE,
		NULL,
		OPEN_EXISTING,
		FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);
	if (ReadHandle == INVALID_HANDLE_VALUE) return(FALSE);
	FileSize = GetFileSize(ReadHandle,NULL);
	if (FileSize != 0x40000) goto Bad;
	NextPositionG = 0x3e800;
	do {
		SetFilePointer(ReadHandle,NextPositionG,NULL,FILE_BEGIN);
		ReadFile(ReadHandle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User != 0xe5 && Header.User != 0x10)
			if (Header.User > 0x10 || Header.Records > 0x80 || Header.Unknown1 != 0 || Header.Unknown2 != 0) goto Bad;
		NextPositionG += sizeof(Header);
	} while (NextPositionG < 0x3f000);
	CloseHandle(ReadHandle);
	return(TRUE);
Bad:
	CloseHandle(ReadHandle);
	return(FALSE);
}
BOOL WINAPI ImgPrepare(HANDLE ReadHandle)
{
	Track = 0;
	Sector = 1;
	NeedRead = TRUE;
	return(TRUE);
}
int WINAPI GetImgItem(HANDLE ReadHandle,struct PluginPanelItem *Item)
{
	if (NeedRead) {
		NextPositionG = CalcOffset(Track,Sector);
		NextPositionG = SetFilePointer(ReadHandle,NextPositionG,NULL,FILE_BEGIN);
		if (NextPositionG == 0xFFFFFFFF) return(IMG_READERROR);
		if (NextPositionG > FileSize) return(IMG_READERROR);
		if (!ReadFile(ReadHandle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) return(IMG_READERROR);
		unsigned char CRC1;
		if (!GetCRConRAM(ReadHandle,Track,Sector,&CRC1)) return(IMG_BADENTRY);
		unsigned char CRC2 = CalcCRC(Buffer);
		if (CRC1 != CRC2) return(IMG_BADENTRY);
		NeedRead = FALSE;
		NeedCount = 0;
	}
	memcpy(&Header,&Buffer[NeedCount*32],sizeof(Header));
	if (Header.User != 0xe5 && Header.Records != 0x80) {
		if (Header.User == 0x00)
			FillData(Item,Header);
		else if (Header.User != 0x10) {
			FillData(Item,Header);
			char NewName[6+1+13];
			strcpy(NewName,"user_");
			char Char = (Header.User < 9) ? Header.User+'0' : Header.User+'a'-10;
			NewName[5] = Char;
			NewName[6] = '\0';
			strcat(NewName,"\\");
			strcat(NewName,FullName);
			strcpy(Item->FindData.cFileName, NewName);
		}
	}
	NeedCount++;
	if (NeedCount == 4) {
		NeedRead = TRUE;
		Sector++;
		if (Sector == 9) {
			Sector = 1;
			Track++;
		}
	}
	if (Header.User != 0xe5 && Header.Records != 0x80 && FullName[0] == '\0') return(IMG_BADENTRY);
	if (Track == 2) return(IMG_EOF);
	return(IMG_SUCCESS);
}
BOOL WINAPI GetFormatName(char *FormatName,char *DefaultExt)
{
	strcpy(FormatName,"EDD for MicroDOS");
	strcpy(DefaultExt,"EDD");
	return(TRUE);
}
int WINAPI MakeNewImage(HANDLE WriteHandle)
{
	char Buf[32*1024];
	char Crc[256*0xe];
	memset(Buf,0xe5,sizeof(Buf));
	memset(Crc,0x80,sizeof(Crc));
	for (int I=0; I<8; I++) if (!WriteFile(WriteHandle,&Buf,sizeof(Buf),&WriteSize,NULL)) return(FALSE);
	SetFilePointer(WriteHandle,0x3f000,NULL,FILE_BEGIN);
	if (!WriteFile(WriteHandle,&Crc,sizeof(Crc),&WriteSize,NULL)) return(FALSE);
	return(TRUE);
}
int WINAPI CopyToPC(HANDLE Handle,char *Source,struct PluginPanelItem Item)
{
	int Result = FALSE;
	char *p;
	int r;
	int U = 0;

	strlwr(Source);
	if ((p = strchr(Source,'\\')) != NULL) {
		if ((strncmp(Source,"user_",5) != 0)) return(IMG_FUNCNOTSUPPORTED);
		U = (Source[5] <= '9') ? Source[5]-'0' : Source[5]-'a'+10;
		r = p-Source+1;
		string_delete(Source,0,r);
	}
	if (Item.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) 
		return(CopyOneFolder(Handle,Source,Item));
	else
		return(CopyOneFile(Handle,U,Source,Item));
}
int WINAPI DelFile(HANDLE Handle,char *Source,struct PluginPanelItem Item)
{
	int Result = FALSE;
	char *p;
	int r;
	int U = 0;

	strlwr(Source);
	if ((p = strchr(Source,'\\')) != NULL) {
		if ((strncmp(Source,"user_",5) != 0)) return(IMG_FUNCNOTSUPPORTED);
		U = (Source[5] <= '9') ? Source[5]-'0' : Source[5]-'a'+10;
		r = p-Source+1;
		string_delete(Source,0,r);
	}
	if (Item.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) 
		return(DeleteOneFolder(Handle,Source,Item));
	else
		return(DeleteOneFile(Handle,U,Source,Item));
}
int WINAPI FileExistOnImage(HANDLE Handle,WIN32_FIND_DATA FindData,char *Data)
{
	int User;
	int Len = strlen(Data);

	strlwr(Data);
	if (Len != 0) {
		if (Len != 6) return(IMG_BADDATA);
		if (strncmp(Data,"user_",5) != 0) return(IMG_BADDATA);
		User = (Data[5] <= '9') ? Data[5]-'0' : Data[5]-'a'+10;
		if (User > 0x0f) return(IMG_BADDATA);
	} else User = 0;
	if (*FindData.cAlternateFileName != 0)
	    return(FExist(Handle,FindData.cAlternateFileName,User));
	else
	    return(FExist(Handle,FindData.cFileName,User));
}
int WINAPI CopyFromPC(char *FileName,HANDLE Handle,struct PluginPanelItem Item,char *Data1,int Data2)
{
	return(IMG_FUNCNOTSUPPORTED);
}