//         
DWORD CalcOffset(int Track,int Sector)
{
	unsigned char track = Track;
	unsigned char sector = Sector;
	track ^= 0xff;
	if (track < 0xfc) track -= 0x13;
		else track -= 3;
	return(((int)track<<10)-((int)sector<<7));
}
//        
BOOL GetCRConRAM(HANDLE ReadHandle,int Track,int Sector,unsigned char *CRC)
{
	unsigned char crc;
	DWORD Offset = (Track<<4)+(Sector<<1)+0x3EFFE;
	SetFilePointer(ReadHandle,Offset,NULL,FILE_BEGIN);
	ReadFile(ReadHandle,CRC,1,&ReadSize,NULL);
	ReadFile(ReadHandle,&crc,1,&ReadSize,NULL);
	if (*CRC != crc) return(FALSE);
	return(TRUE);
}
//      
BOOL SetCRConRAM(HANDLE WriteHandle,int Track,int Sector,unsigned char *CRC)
{
	DWORD Offset = (Track<<4)+(Sector<<1)+0x3EFFE;
	SetFilePointer(WriteHandle,Offset,NULL,FILE_BEGIN);
	if (!WriteFile(WriteHandle,CRC,1,&ReadSize,NULL)) return(FALSE);
	if (!WriteFile(WriteHandle,CRC,1,&ReadSize,NULL)) return(FALSE);
	return(TRUE);
}
//     
unsigned char CalcCRC(unsigned char *Buffer)
{
	unsigned char CRC = 0;
	for (int I=0; I<128; I++) CRC += Buffer[I];
	return(CRC);
}
BOOL CreateChain(HANDLE ReadHandle,int User,char *Source,struct PluginPanelItem Item)
{
	DWORD Count = 0;
	DWORD NextPosition;
	unsigned char NeedCount;
	int Track = 0;
	int Sector = 1;
	BOOL NeedRead = TRUE;

	memset(Chain,0,sizeof(Chain));
	while (1) {
		if (NeedRead) {
			NextPosition = CalcOffset(Track,Sector);
			NextPosition = SetFilePointer(ReadHandle,NextPosition,NULL,FILE_BEGIN);
			if (NextPosition == 0xFFFFFFFF) return(FALSE);
			if (NextPosition > FileSize) return(FALSE);
			if (!ReadFile(ReadHandle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) return(FALSE);
			unsigned char CRC1;
			if (!GetCRConRAM(ReadHandle,Track,Sector,&CRC1)) return(FALSE);
			unsigned char CRC2 = CalcCRC(Buffer);
			if (CRC1 != CRC2) return(FALSE);
			NeedRead = FALSE;
			NeedCount = 0;
		}
		memcpy(&Header,&Buffer[NeedCount*32],sizeof(Header));
		if (Header.User == User) {
			MakeCorrectName(FullName,Name,Ext);
			if (strcmp(FullName,Source) == 0) {
				for (int I=0; I<16; I++,Count++) Chain[Count] = Header.FAT[I];
				if (Header.Records != 0x80) break;
			}
		}
		NeedCount++;
		if (NeedCount == 4) {
			NeedRead = TRUE;
			Sector++;
			if (Sector == 9) {
				Sector = 1;
				Track++;
			}
		}
		if (Track == 2) return(FALSE);
	}
	FileSizeOnImage = (Header.Extent << 14) + (Header.Records << 7);
	return(TRUE);
}
// ""   
BOOL ReadSector(HANDLE Handle,int Track,int Sector,void *Buffer)
{
	memset(Buffer,0,128);
	SetFilePointer(Handle,CalcOffset(Track,Sector),NULL,FILE_BEGIN);
	if (!ReadFile(Handle,Buffer,128,&ReadSize,NULL)) return(FALSE);
	return(TRUE);
}
int CopyOneFile(HANDLE Handle,int User,char *Source,struct PluginPanelItem Item)
{
	HANDLE WriteHandle;
	int I = 0;

	WriteHandle = CreateFile(Source,
		GENERIC_WRITE,
		0,
		NULL,
		CREATE_NEW,
		FILE_ATTRIBUTE_ARCHIVE|FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);
	if (WriteHandle == INVALID_HANDLE_VALUE) return(FALSE);
	if (!CreateChain(Handle,User,Source,Item)) goto Bad;
	while (Chain[I] != 0) {
		for (int J=1; J<9; J++) {
			unsigned char CRC1;
			unsigned char CRC2;

			if (FileSizeOnImage == 0) break;
				else FileSizeOnImage -= 128;
			if (!ReadSector(Handle,Chain[I],J,&Buffer)) goto Bad;
			CRC1 = CalcCRC(Buffer);
			if (!GetCRConRAM(Handle,Chain[I],J,&CRC2)) goto Bad;
			if (CRC1 != CRC2) goto Bad;
			if (!WriteFile(WriteHandle,&Buffer,128,&WriteSize,NULL)) goto Bad;
		}
		I++;
	}
	CloseHandle(WriteHandle);
	return(TRUE);
Bad:
	CloseHandle(WriteHandle);
	return(FALSE);
}
//     
int CopyOneFolder(HANDLE Handle,char *Directory,struct PluginPanelItem Item)
{
	char SaveDir[NM];
	DWORD NextPosition;
	BOOL Success = FALSE;
	unsigned char NeedCount;
	int Track = 0;
	int Sector = 1;
	BOOL NeedRead = TRUE;

	GetCurrentDirectory(sizeof(SaveDir),SaveDir);
	int UserNumber = (Directory[5] <= '9') ? Directory[5]-'0' : Directory[5]-'a'+10;
	if (UserNumber > 0x0f) return(IMG_BADDATA);
	CreateDirectory(Directory,NULL);
	if (!SetCurrentDirectory(Directory)) return(FALSE);
	while (1) {
		if (NeedRead) {
			NextPosition = CalcOffset(Track,Sector);
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (NextPosition == 0xFFFFFFFF) break;
			if (NextPosition > FileSize) break;
			if (!ReadFile(Handle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) break;
			unsigned char CRC1;
			if (!GetCRConRAM(Handle,Track,Sector,&CRC1)) break;
			unsigned char CRC2 = CalcCRC(Buffer);
			if (CRC1 != CRC2) break;
			NeedRead = FALSE;
			NeedCount = 0;
		}
		memcpy(&Header,&Buffer[NeedCount*32],sizeof(Header));
		if (Header.User == UserNumber && Header.Records != 0x80) {
			struct PluginPanelItem Item;

			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			if (!CopyOneFile(Handle,UserNumber,Item.FindData.cFileName,Item)) break;
			//    ,   
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (!ReadFile(Handle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) break;
		}
		NeedCount++;
		if (NeedCount == 4) {
			NeedRead = TRUE;
			Sector++;
			if (Sector == 9) {
				Sector = 1;
				Track++;
			}
		}
		if (Track == 2) {
			Success = TRUE;
			break;
		}
	}
	SetCurrentDirectory(SaveDir);
	return(Success);
}
//  
int DeleteOneFile(HANDLE Handle,int User,char *Source,struct PluginPanelItem Item)
{
	BOOL Found = FALSE;
	DWORD NextPosition;
	unsigned char NeedCount;
	int Track = 0;
	int Sector = 1;
	BOOL NeedRead = TRUE;

	while (1) {
		if (NeedRead) {
			NextPosition = CalcOffset(Track,Sector);
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (NextPosition == 0xFFFFFFFF) break;
			if (NextPosition > FileSize) break;
			if (!ReadFile(Handle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) break;
			unsigned char CRC1;
			if (!GetCRConRAM(Handle,Track,Sector,&CRC1)) break;
			unsigned char CRC2 = CalcCRC(Buffer);
			if (CRC1 != CRC2) return(FALSE);
			NeedRead = FALSE;
			NeedCount = 0;
		}
		memcpy(&Header,&Buffer[NeedCount*32],sizeof(Header));
		MakeCorrectName(FullName,Name,Ext);
		if (Header.User == User && strcmp(FullName,Source) == 0) {
			Found = TRUE;
			Header.User = 0xe5;
			memcpy(&Buffer[NeedCount*32],&Header,sizeof(Header));
			SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (!WriteFile(Handle,&Buffer,sizeof(Buffer),&WriteSize,NULL)) break;
			unsigned char CRC = CalcCRC(Buffer);
			if (!SetCRConRAM(Handle,Track,Sector,&CRC)) break;
		}
		NeedCount++;
		if (NeedCount == 4) {
			NeedRead = TRUE;
			Sector++;
			if (Sector == 9) {
				Sector = 1;
				Track++;
			}
		}
		if (Track == 2) break;
	}
	return(Found);
}
//     
int DeleteOneFolder(HANDLE Handle,char *Directory,struct PluginPanelItem Item)
{
	int UserNumber = (Directory[5] <= '9') ? Directory[5]-'0' : Directory[5]-'a'+10;
	char SaveDir[NM];
	DWORD NextPosition;
	BOOL Success = FALSE;
	unsigned char NeedCount;
	int Track = 0;
	int Sector = 1;
	BOOL NeedRead = TRUE;

	while (1) {
		if (NeedRead) {
			NextPosition = CalcOffset(Track,Sector);
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (NextPosition == 0xFFFFFFFF) break;
			if (NextPosition > FileSize) break;
			if (!ReadFile(Handle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) break;
			unsigned char CRC1;
			if (!GetCRConRAM(Handle,Track,Sector,&CRC1)) break;
			unsigned char CRC2 = CalcCRC(Buffer);
			if (CRC1 != CRC2) break;
			NeedRead = FALSE;
			NeedCount = 0;
		}
		memcpy(&Header,&Buffer[NeedCount*32],sizeof(Header));
		if (Header.User == UserNumber) {
			struct PluginPanelItem Item;

			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			if (!DeleteOneFile(Handle,UserNumber,Item.FindData.cFileName,Item)) break;
			//    ,   
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (!ReadFile(Handle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) break;
		}
		NeedCount++;
		if (NeedCount == 4) {
			NeedRead = TRUE;
			Sector++;
			if (Sector == 9) {
				Sector = 1;
				Track++;
			}
		}
		if (Track == 2) {
			Success = TRUE;
			break;
		}
	}
	SetCurrentDirectory(SaveDir);
	return(Success);
}
//   
BOOL FExist(HANDLE Handle,char *Source,int User)
{
	return(IMG_FUNCNOTSUPPORTED);
}