#include <windows.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include "..\..\di.hpp"
#include "..\..\..\plugin.hpp"
#include "fdd.hpp"
#include "..\common.cpp"
#include "utilites.cpp"


BOOL WINAPI IsImage(char *Name,const unsigned char *Data,int DataSize)
{
	const unsigned char *D = Data;
	DWORD C = 0xa000;

	do {
		if (D[C] != 0xe5 && D[C] != 0x10) {
			if (D[C] > 0x10 || D[C+15] > 0x80 || D[C+14] != 0 || D[C+13] != 0) return(FALSE);
			for (int I=0; I<8; I++) if ((D[C+17+I*2] > 2) || (!isprint(D[C+1+I]))) return(FALSE);
		}
		C += sizeof(Header);
	} while (C < 0xb000);
	return(TRUE);
}
BOOL WINAPI ImgPrepare(HANDLE Handle)
{
	FileSize = GetFileSize(Handle,NULL);
	if (FileSize > 0xa000) {
		NextPositionG = 0xa000;
		return(TRUE);
	}
	return(FALSE);
}
int WINAPI GetImgItem(HANDLE Handle,struct PluginPanelItem *Item)
{
	NextPositionG = SetFilePointer(Handle,NextPositionG,NULL,FILE_BEGIN);
	if (NextPositionG == 0xFFFFFFFF) return(IMG_READERROR);
	if (NextPositionG > FileSize) return(IMG_READERROR);
	if (!ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL)) return(IMG_READERROR);
	if (Header.User != 0xe5 && Header.Records != 0x80) {
		if (Header.User == 0x00)
			FillData(Item,Header);
		else if (Header.User != 0x10) {
			FillData(Item,Header);
			char NewName[6+1+13];
			strcpy(NewName,"user_");
			char Char = (Header.User <= 9) ? Header.User+'0' : Header.User+'a'-10;
			NewName[5] = Char;
			NewName[6] = '\0';
			strcat(NewName,"\\");
			strcat(NewName,FullName);
			strcpy(Item->FindData.cFileName, NewName);
		}
	}
	NextPositionG += sizeof(Header);
	if (NextPositionG > 0xb000) return (IMG_EOF);
	if (Header.User != 0xe5 && Header.Records != 0x80 && FullName[0] == '\0') return(IMG_BADENTRY);
		else return(IMG_SUCCESS);
}
BOOL WINAPI GetFormatName(char *FormatName,char *DefaultExt)
{
	strcpy(FormatName,"FDD for MicroDOS");
	strcpy(DefaultExt,"FDD");
	return(TRUE);
}
int WINAPI CopyFromPC(char *FileName,HANDLE Handle,struct PluginPanelItem Item,char *Data1,int Data2)
{
	if (Item.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		return(IMG_FUNCNOTSUPPORTED);
	else
		return(CopyFileFromPC(FileName,Handle,Item,Data1,Data2));
}
int WINAPI MakeNewImage(HANDLE Handle)
{
	char Buf[41*1024];
	memset(Buf,0xe5,sizeof(Buf));
	for (int I=0; I<20; I++) WriteFile(Handle,&Buf,sizeof(Buf),&WriteSize,NULL);

	return(TRUE);
}
int WINAPI CopyToPC(HANDLE Handle,char *Source,struct PluginPanelItem Item)
{
	int Result = FALSE;
	char *p;
	int r;
	int U = 0;

	strlwr(Source);
	if ((p = strchr(Source,'\\')) != NULL) {
		if ((strncmp(Source,"user_",5) != 0)) return(IMG_FUNCNOTSUPPORTED);
		U = (Source[5] <= '9') ? Source[5]-'0' : Source[5]-'a'+10;
		r = p-Source+1;
		string_delete(Source,0,r);
	}
	if (Item.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) 
		return(CopyOneFolder(Handle,Source,Item));
	else
		return(CopyOneFile(Handle,U,Source,Item));
}
int WINAPI DelFile(HANDLE Handle,char *Source,struct PluginPanelItem Item)
{
	int Result = FALSE;
	char *p;
	int r;
	int U = 0;

	strlwr(Source);
	if ((p = strchr(Source,'\\')) != NULL) {
		if ((strncmp(Source,"user_",5) != 0)) return(IMG_FUNCNOTSUPPORTED);
		U = (Source[5] <= '9') ? Source[5]-'0' : Source[5]-'a'+10;
		r = p-Source+1;
		string_delete(Source,0,r);
	}
	if (Item.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) 
		return(DeleteOneFolder(Handle,Source,Item));
	else
		return(DeleteOneFile(Handle,U,Source,Item));
}
int WINAPI FileExistOnImage(HANDLE Handle,WIN32_FIND_DATA FindData,char *Data)
{
	int User;
	int Len = strlen(Data);

	strlwr(Data);
	if (Len != 0) {
		if (Len != 6) return(IMG_BADDATA);
		if (strncmp(Data,"user_",5) != 0) return(IMG_BADDATA);
		User = (Data[5] <= '9') ? Data[5]-'0' : Data[5]-'a'+10;
		if (User > 0x0f) return(IMG_BADDATA);
	} else User = 0;
	if (*FindData.cAlternateFileName != 0)
	    return(FExist(Handle,FindData.cAlternateFileName,User));
	else
	    return(FExist(Handle,FindData.cFileName,User));
}
