// ""   
BOOL ReadSector(HANDLE Handle,int Track,int Head,int Sector,void *Buffer)
{
	memset(Buffer,0,1024);
	DWORD Offset = Track*1024*10+Head*1024*5+(--Sector)*1024;
	SetFilePointer(Handle,Offset,NULL,FILE_BEGIN);
	return(ReadFile(Handle,Buffer,1024,&ReadSize,NULL));
}
// ""   
BOOL SaveSector(HANDLE Handle,int Track,int Head,int Sector,void *Buffer)
{
	DWORD Offset = Track*1024*10+Head*1024*5+(--Sector)*1024;
	SetFilePointer(Handle,Offset,NULL,FILE_BEGIN);
	return(WriteFile(Handle,Buffer,1024,&WriteSize,NULL));
}
//    ,   
void ClusterSplit(DWORD Cluster,int *Track,int *Head,int *Sector)
{
	*Track = 8 + (Cluster / 5);
	*Head = *Track % 2;
	*Track >>= 1;
	*Sector = 1 + Cluster % 5;
	return;
}
//     
BOOL CreateChain(HANDLE Handle,int User,char *Source,struct PluginPanelItem Item)
{
	DWORD Count = 0;

	memset(Chain,0,sizeof(Chain));
	int NextPosition = 0xa000;

	if (*Source == 0) {
		//    ,      
		while (1) {
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (!ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL)) return(FALSE);
			if (Header.User < 0x10)
				for (int I=0; I<8; I++) if (Header.FAT[I] != 0) Chain[Header.FAT[I]] = 1;
			NextPosition += sizeof(Header);
			if (NextPosition == 0xb000) break;
		}
		DWORD Sum = 1;
		for (int I=2; I<390; I++) Sum *= Chain[I];
		if (Sum != 0) return(FALSE);
	} else {
		//        
		while (1) {
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
			if (Header.User == User) {
				MakeCorrectName(FullName,Name,Ext);
				if (strcmp(FullName,Source) == 0) {
					for (int I=0; I<8; I++,Count++) Chain[Count] = Header.FAT[I];
					if (Header.Records != 0x80) break;
				}
			}
			NextPosition += sizeof(Header);
			if (NextPosition == 0xb000) return(FALSE);
		}
		FileSizeOnImage = (Header.Extent << 14) + (Header.Records << 7);
	}
 	return(TRUE);
}
//  ""   MicroDOS
void CorrectName(char *D)
{
	for (unsigned int I=0; I<strlen(D); I++) if (D[I] == '~' || D[I] == '_') D[I] = '@';
	strupr(D);
}
//     MicroDOS
void MakeVECName(char *D,char *S)
{
	memset(D,0x20,16);
	if (strchr(S,0x2e)) {
		for (unsigned int I=0; S[I] != 0x2e; I++) D[I] = S [I];
		for (unsigned int J=8; S[I+1]; I++,J++) D[J] = S[I+1];
		D[J] = 0x00;
	} else
		for (unsigned int I=0; S[I]; I++) D[I] = S [I];
	D[0x0b] = 0x00;
	CorrectName(D);
	return;
}
//   
BOOL FExist(HANDLE Handle,char *Source,int User)
{
	BOOL Found = FALSE;
	DWORD NextPosition = 0xa000;

	CorrectName(Source);
	while (1) {
		NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		MakeCorrectName(FullName,Name,Ext);
		strupr(FullName);
		if (Header.User == User && strcmp(FullName,Source) == 0) {
			Found = TRUE;
			break;
		}
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) break;
	}
	return(Found);
}
//     
int GetEntryCount(HANDLE Handle)
{
	int Count = 0;
	DWORD NextPosition = 0xa000;
	HEADER Header;

	while (1) {
		NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User < 0x10) Count++;
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) break;
	}
	return(Count);
}
//      
int GetChainCount(HANDLE Handle)
{
	int Count = 0;
	DWORD NextPosition = 0xa000;
	HEADER Header;

	while (1) {
		NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User < 0x10) for (int I=0; I<8; I++) if (Header.FAT[I] != 0) Count++;
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) break;
	}
	return(Count);
}
//       
BOOL GetEntryOffset(HANDLE Handle,DWORD *Offset)
{
	DWORD NextPosition = *Offset;
	HEADER Header;

	while (1) {
		NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User > 0x10) {
			*Offset = NextPosition;
			break;
		}
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) return(FALSE);
	}
	return(TRUE);
}
//    
int CopyFileFromPC(char *FileName,HANDLE Handle,struct PluginPanelItem Item,char *Data1,int Data2)
{
	char ResultName[NM];
	int EntryCount,EntryChain;
	DWORD Offset = 0xa000;
	DWORD Tmp;
	int User = 0;
	int ExtentNumber = 0;
	int ChainPosition = 2;
	int Len = strlen(Data1);
	int FATPosition = 0;
	int Track;
	int Head;
	int Sector;
	DWORD nFileSize;

	*ResultName = 0;
	if (!CreateChain(Handle,User,ResultName,Item)) return(IMG_NOENTRY);
	int NeedEntry = (Item.FindData.nFileSizeLow / 16384) + 1;
	int NeedChain = Item.FindData.nFileSizeLow / 2048 + 1;
	EntryCount = GetEntryCount(Handle);
	EntryChain = GetChainCount(Handle);
	if (NeedChain + EntryChain > 390) return(IMG_DISKFULL);
	if (NeedEntry + EntryCount > 128) return(IMG_NOENTRY);

	if (*Item.FindData.cAlternateFileName != 0) 
		MakeVECName(ResultName,Item.FindData.cAlternateFileName);
	else
		MakeVECName(ResultName,Item.FindData.cFileName);
	FileSizeOnImage = Item.FindData.nFileSizeLow;
	nFileSize = Item.FindData.nFileSizeLow;
	if (Len != 0) if (Len < 6 && strcmp(Data1,"user_") != 0) return(IMG_BADDATA);
		else User = (Data1[5] <= '9') ? Data1[5]-'0' : Data1[5]-'a'+10;
	if (User > 15) return(IMG_BADDATA);
	HANDLE NewHandle = CreateFile(FileName,
		GENERIC_READ,
		FILE_SHARE_READ|FILE_SHARE_WRITE,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_ARCHIVE|FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);
	if (NewHandle == INVALID_HANDLE_VALUE) return(FALSE);
	memset(&Header.FAT,0,sizeof(Header.FAT));
	Header.User = User;
	strcpy(Header.Name,ResultName);
	Header.Unknown1 = 0;
	Header.Unknown2 = 0;
	while (FileSizeOnImage > 0) {
		while (Chain[ChainPosition] != 0) ChainPosition++;
		memset(Buffer,0x1a,sizeof(Buffer));
		if (!ReadFile(NewHandle,&Buffer,sizeof(Buffer),&ReadSize,NULL)) {
			CloseHandle(NewHandle);
			return(FALSE);		
		}
		Header.FAT[FATPosition] = ChainPosition;
		Chain[ChainPosition] = 1;
		Tmp = ChainPosition << 1;
		for (int J=0; J<2; J++) {
			ClusterSplit(Tmp,&Track,&Head,&Sector);
			SaveSector(Handle,Track,Head,Sector,&Buffer[1024*J]);
			Tmp++;
		}	
		++FATPosition &= 7;
		FileSizeOnImage -= 2048;
		if (FATPosition == 0 || FileSizeOnImage <= 0) {
			Header.Extent = ExtentNumber;
			int Rec = (nFileSize + 127) >> 7;
			Header.Records =  (Rec > 0x7f) ? 0x80 : Rec;
			if (Header.Records == 0x80) nFileSize -= 16384;

			GetEntryOffset(Handle,&Offset);
			SetFilePointer(Handle,Offset,NULL,FILE_BEGIN);
			WriteFile(Handle,&Header,sizeof(Header),&WriteSize,NULL);
			memset(Header.FAT,0,sizeof(Header.FAT));
			ExtentNumber++;
			if (Header.Records == 0x80 && FileSizeOnImage == 0) {
				Header.Extent = ExtentNumber;
				Header.Records = 0x00;
				GetEntryOffset(Handle,&Offset);
				SetFilePointer(Handle,Offset,NULL,FILE_BEGIN);
				WriteFile(Handle,&Header,sizeof(Header),&WriteSize,NULL);
				break;
			}
		}
	}
	CloseHandle(NewHandle);
	return(TRUE);
}
//   
int CopyOneFile(HANDLE Handle,int User,char *Name,struct PluginPanelItem Item)
{
	HANDLE WriteHandle;
	int I = 0;

	WriteHandle = CreateFile(Name,
		GENERIC_WRITE,
		0,
		NULL,
		CREATE_NEW,
		FILE_ATTRIBUTE_ARCHIVE|FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);
	if (WriteHandle == INVALID_HANDLE_VALUE) return(FALSE);

	if (!CreateChain(Handle,User,Name,Item)) {
		CloseHandle(WriteHandle);
		return(FALSE);
	}
	while (Chain[I] != 0) {
		DWORD Sum;
		int Tmp,Track,Head,Sector;

		Sum = 0;
		Tmp = Chain[I] << 1;
		for (int J=0; J<2; J++) {
			ClusterSplit(Tmp,&Track,&Head,&Sector);
			ReadSector(Handle,Track,Head,Sector,&Buffer[1024*J]);
			Sum += ReadSize;
			Tmp++;
		}
		if (FileSizeOnImage > 2048)
			FileSizeOnImage -= 2048;
		else 
			Sum = FileSizeOnImage;
		if (!WriteFile(WriteHandle,&Buffer,Sum,&WriteSize,NULL)) {
			CloseHandle(WriteHandle);
			return(FALSE);
		}
		I++;
	}
	CloseHandle(WriteHandle);
	return(TRUE);
}
//     
int CopyOneFolder(HANDLE Handle,char *Folder,struct PluginPanelItem Item)
{
	char SaveDir[NM];
	int User;
	BOOL Success = FALSE;
	int NextPosition = 0xa000;

	GetCurrentDirectory(sizeof(SaveDir),SaveDir);
	CreateDirectory(Folder,NULL);
	User = (Folder[5] <= '9') ? Folder[5]-'0' : Folder[5]-'a'+10;
	if (User > 0x0f) return(IMG_BADDATA);
	if (!SetCurrentDirectory(Folder)) return(FALSE);
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User == User && Header.Records != 0x80) {
			struct PluginPanelItem Item;
			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			if (!CopyOneFile(Handle,User,Item.FindData.cFileName,Item)) break;
		}
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) {
			Success = TRUE;
			break;
		}
	}
	SetCurrentDirectory(SaveDir);
	return(Success);
}
//  
int DeleteOneFile(HANDLE Handle,int User,char *Source,struct PluginPanelItem Item)
{
	int NextPosition = 0xa000;
	BOOL Found = FALSE;

	strupr(Source);
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		if (!ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL)) return(FALSE);
		MakeCorrectName(FullName,Name,Ext);
		strupr(FullName);
		if (Header.User == User && strcmp(FullName,Source) == 0) {
			Found = TRUE;
			Header.User = 0xe5;
			SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (!WriteFile(Handle,&Header,sizeof(Header),&WriteSize,NULL)) return(FALSE);
		}
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) break;
	}
	return(Found);
}
//     
int DeleteOneFolder(HANDLE Handle,char *Folder,struct PluginPanelItem Item)
{
	int User;
	BOOL Success = FALSE;
	int NextPosition = 0xa000;

	User = (Folder[5] <= '9') ? Folder[5]-'0' : Folder[5]-'a'+10;
	if (User > 0x0f) return(IMG_BADDATA);
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User == User && Header.Records != 0x80) {
			struct PluginPanelItem Item;
			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			if (!DeleteOneFile(Handle,User,Item.FindData.cFileName,Item)) break;
		}
		NextPosition += sizeof(Header);
		if (NextPosition == 0xb000) {
			Success = TRUE;
			break;
		}
	}
	return(Success);
}