// ""   
BOOL ReadSector(HANDLE Handle,int Disk,int Track,int Head,int Sector,void *Buffer)
{
	memset(Buffer,0,1024);
	DWORD Offset = 0xa400+785*1024*(Disk-1)+Track*1024*10+Head*1024*5+(--Sector)*1024;
	SetFilePointer(Handle,Offset,NULL,FILE_BEGIN);
	return(ReadFile(Handle,Buffer,1024,&ReadSize,NULL));
}
//    ,   
void ClusterSplit(DWORD Cluster,int *Track,int *Head,int *Sector)
{
	*Track = Cluster / 5;
	*Head = *Track % 2;
	*Track >>= 1;
	*Sector = 1 + Cluster % 5;
	return;
}
//     
BOOL CreateChain(HANDLE Handle,int Disk,int User,char *Source,struct PluginPanelItem Item)
{
	DWORD Count = 0;

	memset(Chain,0,sizeof(Chain));
	int NextPosition = 0xa400+785*1024*(Disk-1);
	int EndPosition = NextPosition + 0x1000;

	if (*Source == 0) {
		//    ,      
        return(FALSE);
	} else {
		//        
		while (1) {
			NextPosition = SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
			if (Header.User == User) {
				MakeCorrectName(FullName,Name,Ext);
				if (strcmp(FullName,Source) == 0) {
					for (int I=0; I<8; I++,Count++) Chain[Count] = Header.FAT[I];
					if (Header.Records != 0x80) break;
				}
			}
			NextPosition += sizeof(Header);
			if (NextPosition == EndPosition) return(FALSE);
		}
		FileSizeOnImage = (Header.Extent << 14) + (Header.Records << 7);
	}
 	return(TRUE);
}
int CopyOneFile(HANDLE Handle,int Disk,int User,char *Name,struct PluginPanelItem Item)
{
	HANDLE WriteHandle;
	int I = 0;

	WriteHandle = CreateFile(Name,
		GENERIC_WRITE,
		0,
		NULL,
		CREATE_NEW,
		FILE_ATTRIBUTE_ARCHIVE|FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);
	if (WriteHandle == INVALID_HANDLE_VALUE) return(FALSE);

	if (!CreateChain(Handle,Disk,User,Name,Item)) {
		CloseHandle(WriteHandle);
		return(FALSE);
	}
	while (Chain[I] != 0) {
		DWORD Sum;
		int Tmp,Track,Head,Sector;

		Sum = 0;
		Tmp = Chain[I] << 1;
		for (int J=0; J<2; J++) {
			ClusterSplit(Tmp,&Track,&Head,&Sector);
			ReadSector(Handle,Disk,Track,Head,Sector,&Buffer[1024*J]);
			Sum += ReadSize;
			Tmp++;
		}
		if (FileSizeOnImage > 2048)
			FileSizeOnImage -= 2048;
		else 
			Sum = FileSizeOnImage;
		if (!WriteFile(WriteHandle,&Buffer,Sum,&WriteSize,NULL)) {
			CloseHandle(WriteHandle);
			return(FALSE);
		}
		I++;
	}
	CloseHandle(WriteHandle);
	return(TRUE);	
}
//     
int CopyOneUser(HANDLE Handle,int Disk,char *Folder,struct PluginPanelItem Item)
{
	char SaveDir[NM];
	int User;
	BOOL Success = FALSE;
	int NextPosition = 0xa400+785*1024*(Disk-1);
	int EndPosition = NextPosition + 0x1000;

	GetCurrentDirectory(sizeof(SaveDir),SaveDir);
	User = (Folder[5] <= '9') ? Folder[5]-'0' : Folder[5]-'a'+10;
	if (User > 0x0f) return(IMG_BADDATA);
	if (User != 0) {
		CreateDirectory(Folder,NULL);
		if (!SetCurrentDirectory(Folder)) return(FALSE);
	}
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User == User && Header.Records != 0x80) {
			struct PluginPanelItem Item;

			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			if (!CopyOneFile(Handle,Disk,User,Item.FindData.cFileName,Item)) break;
		}
		NextPosition += sizeof(Header);
		if (NextPosition == EndPosition) {
			Success = TRUE;
			break;
		}
	}
	if (User != 0) SetCurrentDirectory(SaveDir);
	return(Success);
}
int CopyOneFolder(HANDLE Handle,int Disk,char *Name,struct PluginPanelItem Item)
{
	char SaveDir[NM];
	BOOL UU[15];
	int D;
	int NextPosition;
	int EndPosition;
	BOOL Success = FALSE;

	if (Disk != -1) return(CopyOneUser(Handle,Disk,Name,Item));
	GetCurrentDirectory(sizeof(SaveDir),SaveDir);
	CreateDirectory(Name,NULL);
	if (!SetCurrentDirectory(Name)) return(FALSE);
	if ((strncmp(Name,"disk_",5) != 0)) return(IMG_FUNCNOTSUPPORTED);
	D = (Name[5] <= '9') ? Name[5]-'0' : Name[5]-'a'+10;
	D = D*16 + ((Name[6] <= '9') ? Name[6]-'0' : Name[6]-'a'+10);
	if (D > HowManyFDD) return(IMG_BADDATA);
	NextPosition = 0xa400 + 785*1024*(D-1);
	EndPosition = NextPosition + 0x1000;
	for (int I=0;I<15;I++) UU[I] = FALSE;
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User == 0) {
			struct PluginPanelItem Item;

			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			CopyOneFile(Handle,D,0,Item.FindData.cFileName,Item);
		} else if (Header.User < 0x10 && !UU[Header.User-1]) {
			char N[8],U[2];
	
			strcpy(N,"user_");
			ltoa(Header.User,U,16);
			strcat(N,U);
			UU[Header.User-1] = TRUE;
			CopyOneUser(Handle,D,N,Item);
		}
		NextPosition += sizeof(Header);
		if (NextPosition == EndPosition) {
			Success = TRUE;
			break;
		}
	}
	SetCurrentDirectory(SaveDir);
	return(Success);
}
//  
int DeleteOneFile(HANDLE Handle,int Disk,int User,char *Source,struct PluginPanelItem Item)
{
	BOOL Found = FALSE;
	int NextPosition = 0xa400 + 785*1024*(Disk-1);
	int EndPosition = NextPosition + 0x1000;

	strupr(Source);
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		if (!ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL)) return(FALSE);
		MakeCorrectName(FullName,Name,Ext);
		strupr(FullName);
		if (Header.User == User && strcmp(FullName,Source) == 0) {
			Found = TRUE;
			Header.User = 0xe5;
			SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
			if (!WriteFile(Handle,&Header,sizeof(Header),&WriteSize,NULL)) return(FALSE);
		}
		NextPosition += sizeof(Header);
		if (NextPosition == EndPosition) break;
	}
	return(Found);
}
int DeleteOneUser(HANDLE Handle,int Disk,char *Folder,struct PluginPanelItem Item)
{
	int User;
	BOOL Success = FALSE;
	int NextPosition = 0xa400+785*1024*(Disk-1);
	int EndPosition = NextPosition + 0x1000;

	User = (Folder[5] <= '9') ? Folder[5]-'0' : Folder[5]-'a'+10;
	if (User > 0x0f) return(IMG_BADDATA);
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User == User && Header.Records != 0x80) {
			struct PluginPanelItem Item;

			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			if (!DeleteOneFile(Handle,Disk,User,Item.FindData.cFileName,Item)) break;
		}
		NextPosition += sizeof(Header);
		if (NextPosition == EndPosition) {
			Success = TRUE;
			break;
		}
	}
	return(Success);
}
int DeleteOneFolder(HANDLE Handle,int Disk,char *Name,struct PluginPanelItem Item)
{
	BOOL UU[15];
	int D;
	int NextPosition;
	int EndPosition;
	BOOL Success = FALSE;

	if (Disk != -1) return(DeleteOneUser(Handle,Disk,Name,Item));
	if ((strncmp(Name,"disk_",5) != 0)) return(IMG_FUNCNOTSUPPORTED);
	D = (Name[5] <= '9') ? Name[5]-'0' : Name[5]-'a'+10;
	D = D*16 + ((Name[6] <= '9') ? Name[6]-'0' : Name[6]-'a'+10);
	if (D > HowManyFDD) return(IMG_BADDATA);
	NextPosition = 0xa400 + 785*1024*(D-1);
	EndPosition = NextPosition + 0x1000;
	for (int I=0;I<15;I++) UU[I] = FALSE;
	while (1) {
		SetFilePointer(Handle,NextPosition,NULL,FILE_BEGIN);
		ReadFile(Handle,&Header,sizeof(Header),&ReadSize,NULL);
		if (Header.User == 0) {
			struct PluginPanelItem Item;

			MakeCorrectName(Item.FindData.cFileName,Name,Ext);
			DeleteOneFile(Handle,D,0,Item.FindData.cFileName,Item);
		} else if (Header.User < 0x10 && !UU[Header.User-1]) {
			char N[8],U[2];
	
			strcpy(N,"user_");
			ltoa(Header.User,U,16);
			strcat(N,U);
			UU[Header.User-1] = TRUE;
			DeleteOneUser(Handle,D,N,Item);
		}
		NextPosition += sizeof(Header);
		if (NextPosition == EndPosition) {
			Success = TRUE;
			break;
		}
	}
	return(Success);
}