int MainConfig()
{
	const char *HistoryName="Masks";
	struct InitDialogItem InitItems[] = {
		DI_DOUBLEBOX,3,1,68,13,0,0,0,0,(char *)MConfigTitle,
		DI_CHECKBOX,5,3,0,0,1,0,0,0,(char *)MSelf,
		DI_CHECKBOX,5,4,0,0,0,0,0,0,(char *)MSaveRO,
		DI_TEXT,5,5,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
		DI_CHECKBOX,5,9,0,0,0,0,0,0,(char *)MDecodeLine,
		DI_EDIT,5,10,66,10,0,(DWORD)HistoryName,DIF_HISTORY,1,"",
		DI_TEXT,5,11,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
		DI_BUTTON,0,12,0,0,0,0,DIF_CENTERGROUP,1,(char *)MOk,
		DI_BUTTON,0,12,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCancel
	};
	struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
	InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]));
	
	DialogItems[1].Selected = Opt.HotKey;
	DialogItems[2].Selected = Opt.ProtectRO;
	DialogItems[4].Selected = Opt.Decoder;
	strcpy(DialogItems[5].Data,Opt.Files);
	int ExitCode = Info.Dialog(Info.ModuleNumber,-1,-1,72,15,"ImageCfg",DialogItems,
		sizeof(DialogItems)/sizeof(DialogItems[0]));
	if (ExitCode != 7) return(FALSE);
	Opt.HotKey = DialogItems[1].Selected;
	Opt.ProtectRO = DialogItems[2].Selected;
	Opt.Decoder = DialogItems[4].Selected;
	strcpy(Opt.Files,DialogItems[5].Data);
	SetRegKey(HKEY_CURRENT_USER,"","DecodeNames",Opt.Files);
	SetRegKey(HKEY_CURRENT_USER,"","Protect",Opt.ProtectRO);
	SetRegKey(HKEY_CURRENT_USER,"","UseDecoder",Opt.Decoder);
	SetRegKey(HKEY_CURRENT_USER,"","UseHotKeys",Opt.HotKey);
	return(TRUE);
}

BOOL FuncNotSupported(void)
{
	char *MsgItems[] = {
		GetMsg(MErrorLine),
		GetMsg(MNotSupportTitle),
		GetMsg(MErrorSmile)
	};
    int ExitCode = Info.Message(Info.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	return(ExitCode == 0);
}
BOOL CopyError(char *Str,struct PluginPanelItem Item)
{
	char *MsgItems[] = {
		GetMsg(MErrorLine),
		(Item.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) ? GetMsg(MCopyFolderError) : GetMsg(MCopyFileError),
		Str,
		GetMsg(MErrClose)
	};
    int ExitCode = Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	return(ExitCode == 0);
}
BOOL FileError(char *Str)
{
	char *MsgItems[] = {
		GetMsg(MErrorLine),
		GetMsg(MFileError),
		Str,
		GetMsg(MErrClose)
	};
    int ExitCode = Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	return(ExitCode == 0);
}
BOOL FileCreateError(char *Str)
{
	char *MsgItems[] = {
		GetMsg(MErrorLine),
		GetMsg(MFileCreateError),
		Str,
		GetMsg(MErrClose)
	};
    int ExitCode = Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	return(ExitCode == 0);
}
BOOL DeleteError(char *Str,DWORD Attr)
{
	char *MsgItems[] = {
		GetMsg(MErrorLine),
		(Attr & FILE_ATTRIBUTE_DIRECTORY) ? GetMsg(MFolderDeleteError) : GetMsg(MFileDeleteError),
		Str,
		GetMsg(MErrClose)
	};
    int ExitCode = Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	return(ExitCode == 0);
}

BOOL DeleteConfirm(struct PanelInfo PInfo)
{
	char String2[NM];

	if (PInfo.SelectedItemsNumber > 1) sprintf(String2,GetMsg(MFilesCount),PInfo.SelectedItemsNumber);
		else strcpy(String2,PInfo.SelectedItems[0].FindData.cFileName);
	char *MsgItems[] = {
		GetMsg(MDelTitle),
		(PInfo.SelectedItems[0].FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && PInfo.SelectedItemsNumber < 2) 
			? GetMsg(MDelFolder) : GetMsg(MDelFile),
		(char *)String2,
		GetMsg(MDelete),
		GetMsg(MCancel)
	};
	int ExitCode = Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),2);
	return(ExitCode == 0);
}
void WriteDeleteWindow(char *Name)
{
	char *MsgItems[] = {
		GetMsg(MDelTitle),
		GetMsg(MDelNow),
		Name
	};
	Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);
}
int CDeleteFile(char *Name,int How)
{
	char String[NM];
	sprintf(String,GetMsg(MFilesCount),How);
	char *MsgItems[] = {
		GetMsg(MDelFileTitle),
		GetMsg(MDelFile),
		(char *)String,
		GetMsg(MHotAll),
		GetMsg(MHotCancel)
	};
	return (Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_KEEPBACKGROUND|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),2));
}
int CDeleteFolder(char *Name)
{
	char *MsgItems[] = {
		GetMsg(MDelFolderTitle),
		GetMsg(MDelFolderTxt),
		Name,
		GetMsg(MHotDelete),
		GetMsg(MHotAll),
		GetMsg(MHotSkip),
		GetMsg(MHotCancel)
	};
	return (Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_KEEPBACKGROUND|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),4));
}
void BadData(char *Str)
{
	char *MsgItems[] = {
		GetMsg(MErrorLine),
			GetMsg(MPluginError),
			Str,
			GetMsg(MCancel)};
	Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
}