ImgPlugins::ImgPlugins(char *ModuleName)
{	
	PluginsData = NULL;
	PluginsCount = 0;
	char PluginsFolder[NM],PluginsMask[NM],*NamePtr;
	strcpy(PluginsFolder,ModuleName);
	if ((NamePtr = strrchr(PluginsFolder,'\\')) == NULL)
		return;
	strcpy(NamePtr,"\\Formats\\");
	sprintf(PluginsMask,"%s*.di",PluginsFolder);
	HANDLE FindHandle;
	WIN32_FIND_DATA fdata;
	int Done = ((FindHandle = FindFirstFile(PluginsMask,&fdata)) == INVALID_HANDLE_VALUE);
	while (!Done) {
		char PluginName[NM];
		sprintf(PluginName,"%s%s",PluginsFolder,fdata.cFileName);
		HMODULE hModule = LoadLibrary(PluginName);
		if (hModule != NULL) {
			struct PluginItem *NewPluginsData=(struct PluginItem *)realloc(PluginsData,sizeof(*PluginsData)*(PluginsCount+1));
			if (NewPluginsData == NULL)
				break;
			PluginsData = NewPluginsData;
			struct PluginItem CurPlugin;
			strcpy(CurPlugin.ModuleName,fdata.cFileName);
			CurPlugin.hModule=hModule;
			CurPlugin.pIsImage = (PLUGINISIMAGE)GetProcAddress(hModule,"IsImage");
			CurPlugin.pImgPrepare = (PLUGINIMGPREPARE)GetProcAddress(hModule,"ImgPrepare");
			CurPlugin.pGetImgItem = (PLUGINGETIMGITEM)GetProcAddress(hModule,"GetImgItem");
			CurPlugin.pGetFormatName = (PLUGINGETFORMATNAME)GetProcAddress(hModule,"GetFormatName");
			CurPlugin.pCopyFromPC = (PLUGINCOPYFROMPC)GetProcAddress(hModule,"CopyFromPC");
			CurPlugin.pCopyToPC = (PLUGINCOPYTOPC)GetProcAddress(hModule,"CopyToPC");
			CurPlugin.pMakeNewImage = (PLUGINMAKENEWIMAGE)GetProcAddress(hModule,"MakeNewImage");
			CurPlugin.pDelFile = (PLUGINDELFILE)GetProcAddress(hModule,"DelFile");
			CurPlugin.pFileExistOnImage = (PLUGINFILEEXISTONIMAGE)GetProcAddress(hModule,"FileExistOnImage");
			PluginsData[PluginsCount] = CurPlugin;
			PluginsCount++;
		}
		Done = !FindNextFile(FindHandle,&fdata);
	}
	FindClose(FindHandle);
}

ImgPlugins::~ImgPlugins()
{
	for (int I=0; I<PluginsCount; I++)
		FreeLibrary(PluginsData[I].hModule);
	delete PluginsData;
}

int ImgPlugins::IsImage(char *Name,const unsigned char *Data,int DataSize)
{
	char *ExtPtr = strrchr(Name,'.');
	if (ExtPtr != NULL) {
		ExtPtr++;
		for (int I=0; I<PluginsCount; I++) {
				char FormatName[200],DefExt[NM];
				GetFormatName(I,FormatName,DefExt);
				if (stricmp(ExtPtr,DefExt) == 0)
					if (PluginsData[I].pIsImage(Name,Data,DataSize)) {
						return(I);
				}
		}
	}
    for (int I=0; I<PluginsCount; I++)
		if (PluginsData[I].pIsImage)
			if (PluginsData[I].pIsImage(Name,Data,DataSize)) {
				return(I);
			}
	return(-1);
}

int ImgPlugins::ImgPrepare(int PluginNumber,HANDLE Handle)
{
	if (PluginNumber >= 0 && PluginsData[PluginNumber].pImgPrepare)
		return(PluginsData[PluginNumber].pImgPrepare(Handle));
	return(FALSE);
}

int ImgPlugins::GetImgItem(int PluginNumber,HANDLE Handle,struct PluginPanelItem *Item)
{
	if (PluginNumber >= 0 && PluginsData[PluginNumber].pGetImgItem)
		return(PluginsData[PluginNumber].pGetImgItem(Handle,Item));
	return(FALSE);
}

BOOL ImgPlugins::GetFormatName(int PluginNumber,char *FormatName,char *DefaultExt)
{
	*FormatName = 0;
	if (PluginNumber >= 0 && PluginNumber < PluginsCount && PluginsData[PluginNumber].pGetFormatName)
		return(PluginsData[PluginNumber].pGetFormatName(FormatName,DefaultExt));
	return(FALSE);
}

int ImgPlugins::CopyFromPC(int PluginNumber,char *FileName,HANDLE Handle,struct PluginPanelItem Item,char *Data1,int Data2)
{
	if (PluginNumber >= 0 && PluginNumber < PluginsCount && PluginsData[PluginNumber].pCopyFromPC)
		return(PluginsData[PluginNumber].pCopyFromPC(FileName,Handle,Item,Data1,Data2));
	return(FALSE);
}
int ImgPlugins::CopyToPC(int PluginNumber,HANDLE Handle,char *Source,struct PluginPanelItem Item)
{
	if (PluginNumber >= 0 && PluginNumber < PluginsCount && PluginsData[PluginNumber].pCopyToPC)
		return(PluginsData[PluginNumber].pCopyToPC(Handle,Source,Item));
	return(FALSE);
}

int ImgPlugins::DelFile(int PluginNumber,HANDLE Handle,char *Source,struct PluginPanelItem Item)
{
	if (PluginNumber >= 0 && PluginNumber < PluginsCount && PluginsData[PluginNumber].pDelFile)
		return(PluginsData[PluginNumber].pDelFile(Handle,Source,Item));
	return(FALSE);
}


int ImgPlugins::MakeNewImage(int PluginNumber,HANDLE Handle)
{
	if (PluginNumber >= 0 && PluginNumber < PluginsCount && PluginsData[PluginNumber].pMakeNewImage)
		return(PluginsData[PluginNumber].pMakeNewImage(Handle));
	return(FALSE);
}
int ImgPlugins::FileExistOnImage(int PluginNumber,HANDLE Handle,WIN32_FIND_DATA FindData,char *Data)
{
	if (PluginNumber >= 0 && PluginNumber < PluginsCount && PluginsData[PluginNumber].pFileExistOnImage)
		return(PluginsData[PluginNumber].pFileExistOnImage(Handle,FindData,Data));
	return(FALSE);
}