int PluginClass::DeleteFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode)
{
	struct PanelInfo PInfo;
	BOOL Success = TRUE;

	if (ItemsNumber == 0) return(0);
	Handle = OpenPluginFile(ImgName);
	if (Handle == INVALID_HANDLE_VALUE) {
		FileError(ImgName);
		return(0);
	}
	Info.Control(this,FCTL_GETPANELINFO,&PInfo);
	if (DeleteConfirm(PInfo)) {
		int FileFQ = (PInfo.SelectedItemsNumber > 1) ? -1 : -2;
		int FolderFQ = -1;

		for (int I=0; I<PInfo.SelectedItemsNumber; I++) {
			char Source[NM];

			MakeName(Source,CurDir,PInfo.SelectedItems[I].FindData.cFileName);
			WriteDeleteWindow(Source);
			if (FolderFQ == -1 && PInfo.SelectedItems[I].FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				FolderFQ = CDeleteFolder(Source);
				if (FolderFQ == 2) {
					FolderFQ = -1;
					continue;
				}
				else
					if (FolderFQ == -1 || FolderFQ == 3) break;
						else if (FolderFQ == 0) FolderFQ = -1;
					
			}
			if (FileFQ == -1 && PInfo.SelectedItems[I].FindData.dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE) {
				FileFQ = CDeleteFile(Source,PInfo.SelectedItemsNumber);
				if (FileFQ == -1 || FileFQ == 1) break;
			}
			int ExitCode = ImgPlugin->DelFile(ImgPluginNumber,Handle,Source,PInfo.SelectedItems[I]);
			if (!ExitCode) {
				DeleteError(Source,PInfo.SelectedItems[I].FindData.dwFileAttributes);
				Success = FALSE;
				break;
			}
			if (ExitCode == IMG_FUNCNOTSUPPORTED) {
				FuncNotSupported();
				Success = FALSE;
				break;
			}
		}
	} else Success = FALSE;
	ClosePluginFile(Handle);
	return(Success);
}


int PluginClass::ProcessHostFile(struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode)
{
	return(FALSE);
}
int PluginClass::GetFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode)
{
	char SaveDir[NM];
	char NewName[NM];
	char ResultName[NM];
	char Source[NM];
	struct PanelInfo PInfo;
	const char *HistoryName="Copy";

	if (*DestPath) AddEndSlash(DestPath);
	GetCurrentDirectory(sizeof(SaveDir),SaveDir);
	if (ItemsNumber == 0) return(0);
	//  
	if (OpMode & OPM_EDIT) return(0);
	if (OpMode & OPM_TOPLEVEL) strcpy(ResultName,GetMsg(MExtractAllFiles));
	else {
		Info.Control(this,FCTL_GETPANELINFO,&PInfo);
		if (PInfo.SelectedItemsNumber > 1) 
			sprintf(ResultName,(Move == 0) ? GetMsg(MCopySeveralFiles) : GetMsg(MMoveSeveralFiles),PInfo.SelectedItemsNumber);
		else {
			char *OldName=PInfo.SelectedItems[0].FindData.cFileName;
			OemToChar(OldName,NewName);
			sprintf(ResultName,(Move == 0) ? GetMsg(MCopyOneFile) : GetMsg(MMoveOneFile),NewName);
		}
	}
	struct InitDialogItem InitItems[] = {
		DI_DOUBLEBOX,3,1,72,8,0,0,0,0,(Move == 0) ? GetMsg(MExtractTitle) : GetMsg(MMoveTitle),
		DI_TEXT,5,2,0,0,0,0,0,0,ResultName,
		DI_EDIT,5,3,70,3,1,(DWORD)HistoryName,DIF_HISTORY,0,DestPath,
		DI_TEXT,3,4,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
		DI_CHECKBOX,5,5,0,0,0,0,0,0,(char *)MFromSystemTrack,
		DI_TEXT,3,6,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
		DI_BUTTON,0,7,0,0,0,0,DIF_CENTERGROUP,1,(char *)MHotExtract,
		DI_BUTTON,0,7,0,0,0,0,DIF_CENTERGROUP,0,(char *)MHotCancel
	};
	struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
	InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]));
	if (!(OpMode & OPM_SILENT)) {
		int AskCode = Info.Dialog(Info.ModuleNumber,-1,-1,76,10,"ExtractFiles",DialogItems,sizeof(DialogItems)/sizeof(DialogItems[0]));
		if (AskCode == 7 || AskCode == -1) return(FALSE);
		strcpy(DestPath,DialogItems[2].Data);
	}
	int SpaceOnly = TRUE;
	for (int I=0; DestPath[I]!=0; I++) if (DestPath[I] != ' ') {
		SpaceOnly = FALSE;
		break;
	}
	if (!SpaceOnly) {
		for (char *ChPtr = DestPath; *ChPtr != 0; ChPtr++) if (*ChPtr == '\\') {
			*ChPtr = 0;
			CreateDirectory(DestPath,NULL);
			*ChPtr = '\\';
		}
		CreateDirectory(DestPath,NULL);
	}
	SetCurrentDirectory(DestPath);
	if ((OpMode & OPM_VIEW) != 0) {
		//    ,  
		char *OldName = PInfo.PanelItems[PInfo.CurrentItem].FindData.cFileName;

		Handle = OpenPluginFile(ImgName);
		if (Handle != INVALID_HANDLE_VALUE) {
			MakeName(Source,CurDir,OldName);
			if (!ImgPlugin->CopyToPC(ImgPluginNumber,Handle,Source,PInfo.PanelItems[PInfo.CurrentItem]))
				CopyError(Source,PInfo.PanelItems[PInfo.CurrentItem]);
			ClosePluginFile(Handle);
		} else FileError(Source);
	} else if (OpMode & OPM_TOPLEVEL) for (I=0; I<ItemsNumber; I++) {
		//    (Shift-F2)
		char *OldName = PanelItem[I].FindData.cFileName;

		Handle = OpenPluginFile(ImgName);	
		if (Handle != INVALID_HANDLE_VALUE) {
			MakeName(Source,CurDir,OldName);
			if (!ImgPlugin->CopyToPC(ImgPluginNumber,Handle,Source,PanelItem[I])) CopyError(Source,PanelItem[I]);
			ClosePluginFile(Handle);
		} else FileError(Source);
	} else for (I=0; I<PInfo.SelectedItemsNumber; I++) {
		//     
		char *OldName = PInfo.SelectedItems[I].FindData.cFileName;

		Handle = OpenPluginFile(ImgName);	
		if (Handle != INVALID_HANDLE_VALUE) {
			MakeName(Source,CurDir,OldName);
			int ExitCode = ImgPlugin->CopyToPC(ImgPluginNumber,Handle,Source,PInfo.SelectedItems[I]);
			if (!ExitCode) CopyError(Source,PInfo.SelectedItems[I]);
			if (ExitCode == IMG_FUNCNOTSUPPORTED) {
				FuncNotSupported();
				ClosePluginFile(Handle);
				break;
			}
			if (Move) {
				int ExitCode = ImgPlugin->DelFile(ImgPluginNumber,Handle,Source,PInfo.SelectedItems[I]);
				if (!ExitCode) DeleteError(Source,PInfo.SelectedItems[I].FindData.dwFileAttributes);
				if (ExitCode == IMG_FUNCNOTSUPPORTED) {
					FuncNotSupported();
					ClosePluginFile(Handle);
					break;
				}
			}
			ClosePluginFile(Handle);
		} else FileError(Source);
	} 
	SetCurrentDirectory(SaveDir);
	return(TRUE);
}


int PluginClass::PutFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode)
{
	if (ItemsNumber == 0 || ImgPluginNumber == -1) return(0);
	
	char Data[NM];
	char Source[NM];
	struct InitDialogItem InitItems[] = {
		DI_DOUBLEBOX,3,1,72,8,0,0,0,0,(Move == 0) ? GetMsg(MCopyOnImage) : GetMsg(MMoveOnImage),
		DI_TEXT,5,2,0,0,0,0,0,0,GetMsg(MUserNumber),
		DI_EDIT,5,3,70,3,1,0,0,0,"",
		DI_TEXT,3,4,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
		DI_CHECKBOX,5,5,0,0,0,0,0,0,(char *)MOnSystemTrack,
		DI_TEXT,3,6,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
		DI_BUTTON,0,7,0,0,0,0,DIF_CENTERGROUP,1,(char *)MHotCopy,
		DI_BUTTON,0,7,0,0,0,0,DIF_CENTERGROUP,0,(char *)MHotCancel
	};
	struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];

	InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]));
	strcpy(DialogItems[2].Data,CurDir);
	int AskCode = Info.Dialog(Info.ModuleNumber,-1,-1,76,10,"ExtractFiles",DialogItems,sizeof(DialogItems)/sizeof(DialogItems[0]));
	if (AskCode == 7 || AskCode == -1) return(FALSE);
	strcpy(Data,DialogItems[2].Data);

	for (int I=0; I<ItemsNumber; I++) {
		char *Name = PanelItem[I].FindData.cFileName;

		strcpy(Source,Name);
		Handle = OpenPluginFile(ImgName);
		if (Handle != INVALID_HANDLE_VALUE) {
			char *_Message;
			//   ,   ...
			int ExCode = ImgPlugin->FileExistOnImage(ImgPluginNumber,Handle,PanelItem[I].FindData,Data);
			if (ExCode == TRUE) {
				CopyError(Source,PanelItem[I]);
				ClosePluginFile(Handle);
				continue;
			}
			if (ExCode == IMG_BADDATA) {
				BadData("FileExist");
				goto Bad;
			}
			if (ExCode == IMG_FUNCNOTSUPPORTED) {
				FuncNotSupported();
				goto Bad;
			}
			//     
			int ExitCode = ImgPlugin->CopyFromPC(ImgPluginNumber,Source,Handle,PanelItem[I],Data,DialogItems[4].Selected);
			ClosePluginFile(Handle);
			//    ,   ,   
			if (!ExitCode) CopyError(Source,PanelItem[I]);
			else {
				switch(ExitCode) {
					case IMG_FUNCNOTSUPPORTED:
						FuncNotSupported(); 
						return(FALSE);
					case IMG_DISKFULL:
						_Message = GetMsg(MDiskFull);
						break;
					case IMG_NOENTRY:
						_Message = GetMsg(MNoDirectoryEntry);
						break;
					default : break;
				}
				if (ExitCode != TRUE) {
					//      
					char *MsgItems[] = {GetMsg(MErrorLine),_Message,Source,GetMsg(MErrRetry),GetMsg(MCancel)};
					if (Info.Message(Info.ModuleNumber,FMSG_WARNING|FMSG_DOWN,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),2) == 1)
						return(FALSE);
				}
			}
		} else FileError(Source);
	}
	return(TRUE);
Bad:
	ClosePluginFile(Handle);
	return(FALSE);
}

int PluginClass::SelectFormat(char *ImgFormat)
{
	struct FarMenuItem *MenuItems = NULL;
	int MenuItemsNumber = 0;
	char Format[NM],Ext[NM];
	char HotKey[3];
	BOOL FirstCall = TRUE;

	strcpy(HotKey,"1 ");
	for (int I=0; ; I++) {
		if (!ImgPlugin->GetFormatName(I,Format,Ext)) break;
		MenuItems = (struct FarMenuItem *)realloc(MenuItems,(MenuItemsNumber+1)*sizeof(*MenuItems));
		if (MenuItems == NULL) return(FALSE);
		strcpy(MenuItems[MenuItemsNumber].Text,HotKey);
		HotKey[0]++;
		if (HotKey[0] > '9' && FirstCall == TRUE) {
			HotKey[0] = 'A';
			FirstCall = FALSE;
		}
		strcat(MenuItems[MenuItemsNumber].Text,Format);
		MenuItems[MenuItemsNumber].Selected = (MenuItemsNumber == 0 && *ImgFormat == 0 || strcmp(ImgFormat,Format) == 0);
		MenuItems[MenuItemsNumber].Checked = FALSE;
		MenuItems[MenuItemsNumber].Separator = FALSE;
		MenuItemsNumber++;
	}
	if (MenuItemsNumber == 0) return(FALSE);
	int ExitCode = Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_AUTOHIGHLIGHT,GetMsg(MSelectImage),NULL,NULL,NULL,NULL,MenuItems,MenuItemsNumber);
	if (ExitCode >= 0) strcpy(ImgFormat,MenuItems[ExitCode].Text);
	delete MenuItems;
	return(ExitCode >= 0);
}

int PluginClass::FormatToPlugin(char *Format,int &PluginNumber,char *Ext)
{
	char PluginFormat[NM];

	for (int I=0; ; I++) {
		if (!ImgPlugin->GetFormatName(I,PluginFormat,Ext)) break;
		if (stricmp(PluginFormat,Format) == 0) {
			PluginNumber = I;
			return(TRUE);
		}
	}
	return(FALSE);
}

void PluginClass::ProcessFunctions(void)
{
	char Title[128];
	char DefaultFormat[128],DefaultExt[128];
	char OldFormat[128],OldExt[128];
	BOOL FirstCall = TRUE;

	*OldFormat = 0; *DefaultFormat = 0;
	*OldExt = 0;	*DefaultExt = 0;
	ImgPlugin->GetFormatName(ImgPluginNumber,OldFormat,OldExt);
	if (!GetRegKey(HKEY_CURRENT_USER,"","DefaultFormat",DefaultFormat,"",sizeof(DefaultFormat))) {
L1:
		if (PluginClass::SelectFormat(DefaultFormat)) {
			string_delete(DefaultFormat,0,2);
			SetRegKey(HKEY_CURRENT_USER,"","DefaultFormat",DefaultFormat);
		}
		else if (FirstCall) return;
	};
	if (!FormatToPlugin(DefaultFormat,ImgPluginNumber,DefaultExt)) goto L1;
	sprintf(Title,GetMsg(MCommandTitle),DefaultFormat);

	struct FarMenuItem MenuItems[4];
	memset(MenuItems,0,sizeof(MenuItems));
	MenuItems[0].Selected = TRUE;
	strcpy(MenuItems[0].Text,GetMsg(MNewImage));
	strcpy(MenuItems[1].Text,GetMsg(MAddImage));
	MenuItems[2].Separator = TRUE;
	strcpy(MenuItems[3].Text,GetMsg(MChangeFormat));
	int ExitCode2 = FALSE;
	int ExitCode1 = Info.Menu(Info.ModuleNumber,-1,-1,0,0,Title,NULL,
		"ImageGlobalFunc",NULL,NULL,MenuItems,sizeof(MenuItems)/sizeof(MenuItems[0]));
	if (ExitCode1 >= 0) {
		if (ExitCode1 == 3) {
			FirstCall = FALSE;
			goto L1;
		}
		if (ExitCode1 == 0) {
			//       
			char NewName[NM];
			*NewName = 0;
	
			if (GetFileName(NewName,DefaultExt,DefaultFormat,TRUE)) {
				HANDLE NewHandle = CreateFile(NewName,
					GENERIC_WRITE,
					0,
					NULL,
					CREATE_NEW,
					FILE_ATTRIBUTE_ARCHIVE|FILE_FLAG_SEQUENTIAL_SCAN,
					NULL);
				if (NewHandle != INVALID_HANDLE_VALUE) {
					ExitCode2 = ImgPlugin->MakeNewImage(ImgPluginNumber,NewHandle);
					CloseHandle(NewHandle);
					if (ExitCode2 != FALSE) {
						//   ,   
						Info.Control(INVALID_HANDLE_VALUE,FCTL_UPDATEPANEL,(void *)TRUE);
						Info.Control(INVALID_HANDLE_VALUE,FCTL_REDRAWPANEL,NULL);
					} else FileCreateError(NewName);
				} else FileCreateError(NewName);
			}
		}
		else if (ExitCode1 == 1) {
			//  -     
			ExitCode2 = IMG_FUNCNOTSUPPORTED;
		}
		//    ,   
		if (ExitCode2 == IMG_FUNCNOTSUPPORTED) FuncNotSupported();
	}
	FormatToPlugin(OldFormat,ImgPluginNumber,OldExt);
	return;
}