PluginClass::PluginClass(int ImgPluginNumber)
{
	*ImgName = 0;
	*CurDir = 0;
	ImgData = NULL;
	ImgDataCount = 0;
	PluginClass::ImgPluginNumber = ImgPluginNumber;
}

PluginClass::~PluginClass()
{
	for (int I=0; I<ImgDataCount; I++)
		if (ImgData[I].Description != NULL)
			delete ImgData[I].Description;
	delete ImgData;
}
HANDLE PluginClass::OpenPluginFile(char *Name)
{
	HANDLE Handle = CreateFile(Name,
		GENERIC_WRITE|GENERIC_READ,
		FILE_SHARE_READ|FILE_SHARE_WRITE,
		NULL,
		OPEN_EXISTING,
		FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);
	return(Handle);
}
int PluginClass::ClosePluginFile(HANDLE Handle)
{
	return(CloseHandle(Handle));
}
int PluginClass::ReadImage(char *Name)
{
	delete ImgData;
	ImgData = NULL;
	ImgDataCount = 0;

	HANDLE ImgFindHandle;
	ImgFindHandle = FindFirstFile(Name,&ImgFindData);
	FindClose(ImgFindHandle);

	Handle = OpenPluginFile(Name);
	if (Handle == INVALID_HANDLE_VALUE) return(FALSE);
	if (!ImgPlugin->ImgPrepare(ImgPluginNumber,Handle)) {
		ClosePluginFile(Handle);
		return(FALSE);
	}
	strcpy(ImgName,Name);
	if (strchr(PointToName(ImgName),'.') == NULL) strcat(ImgName,".");

	int GetItemCode;
	clock_t StartTime = clock();
	HANDLE hScreen = Info.SaveScreen(0,0,-1,-1);
	int WaitMessage=FALSE;
	
	while (1) {
		PluginPanelItem CurImgData;
		memset(&CurImgData,0,sizeof(CurImgData));
		GetItemCode = ImgPlugin->GetImgItem(ImgPluginNumber,Handle,&CurImgData);
		if (GetItemCode != IMG_SUCCESS) break;
		if (((ImgDataCount & 0x1f) == 0) && ((clock()-StartTime > 500))) {
			char FilesMsg[100];

			sprintf(FilesMsg,GetMsg(MHowManyFiles),ImgDataCount);
			char *MsgItems[] = {GetMsg(MWait),GetMsg(MImgReading),Name,FilesMsg};
			Info.Message(Info.ModuleNumber,WaitMessage ? FMSG_KEEPBACKGROUND:0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);
			WaitMessage = TRUE;
		}
		CurImgData.Flags = 0;
		*CurImgData.FindData.cAlternateFileName = 0;
		for (int I=0; CurImgData.FindData.cFileName[I]; I++)
			if (CurImgData.FindData.cFileName[I] == '/') CurImgData.FindData.cFileName[I]='\\';
	    char *NamePtr = CurImgData.FindData.cFileName;
		while (*NamePtr == '\\') NamePtr++;
		if (NamePtr[0] == '.') {
			if (NamePtr[1] == '\\') 
				NamePtr += 2;
			else
				if (NamePtr[1] == '.' && NamePtr[2] == '\\') NamePtr += 3;
		}
		if (NamePtr != CurImgData.FindData.cFileName)
			memmove(CurImgData.FindData.cFileName,NamePtr,strlen(NamePtr)+1);
		int Length = strlen(CurImgData.FindData.cFileName);
		if (Length > 0 && (CurImgData.FindData.cFileName[Length-1] == '\\')) {
			CurImgData.FindData.cFileName[Length-1] = 0;
			CurImgData.FindData.dwFileAttributes |= FILE_ATTRIBUTE_DIRECTORY;
		}
		PluginPanelItem *NewImgData = ImgData;
		if ((ImgDataCount & 15) == 0)
			NewImgData = (PluginPanelItem *)realloc(ImgData,(ImgDataCount+16+1)*sizeof(*ImgData));
		if (NewImgData == NULL) break;
		ImgData = NewImgData;
		ImgData[ImgDataCount] = CurImgData;
		ImgDataCount++;
	}
	ClosePluginFile(Handle);
	switch(GetItemCode) {
	case IMG_READERROR : {
		char *MsgItems[] = {GetMsg(MErrorLine),GetMsg(MReadError),GetMsg(MOk)};
		Info.Message(Info.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	} break;
	case IMG_BADENTRY :	{
		char *MsgItems[] = {GetMsg(MErrorLine),GetMsg(MWrongFormat),GetMsg(MOk)};
		Info.Message(Info.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
	} break;
	default : 
		break;
	}	
	Info.RestoreScreen(hScreen);
	return(TRUE);
}

int PluginClass::GetFindData(PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode)
{
	HANDLE ImgFindHandle;
	WIN32_FIND_DATA NewImgFindData;
	ImgFindHandle = FindFirstFile(ImgName,&NewImgFindData);
	FindClose(ImgFindHandle);

	if (ImgFindHandle == INVALID_HANDLE_VALUE) return(FALSE);
	if (CompareFileTime(&ImgFindData.ftLastWriteTime,&NewImgFindData.ftLastWriteTime) !=0 ||
		NewImgFindData.nFileSizeLow != ImgFindData.nFileSizeLow || ImgData == NULL)
		if (ReadImage(ImgName) != TRUE) return(FALSE);
  
	unsigned int CurDirLength = strlen(CurDir);
	*pPanelItem = NULL;
	*pItemsNumber = 0;
	for (int I=0;I<ImgDataCount;I++) {
		char Name[NM];
		int Append = 0;

		PluginPanelItem CurItem = ImgData[I];
		strcpy(Name,CurItem.FindData.cFileName);
		if (strlen(Name) > CurDirLength && strnicmp(Name,CurDir,CurDirLength) == 0 && (CurDirLength == 0 || Name[CurDirLength] == '\\')) {
			char *StartName,*EndName;

			StartName = Name + CurDirLength + (CurDirLength != 0);
			if ((EndName = strchr(StartName,'\\')) != NULL) {
				*EndName=0;
				CurItem.FindData.dwFileAttributes = FILE_ATTRIBUTE_DIRECTORY;
				CurItem.FindData.nFileSizeLow = CurItem.PackSize = 0;
			}
		strcpy(CurItem.FindData.cFileName,StartName);
		Append = TRUE;
		if (CurItem.FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) for (int J=0; J<*pItemsNumber; J++)
			if ((*pPanelItem)[J].FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				if (stricmp(CurItem.FindData.cFileName,(*pPanelItem)[J].FindData.cFileName) == 0)
					Append=FALSE;
		}
		if (Append) {
			PluginPanelItem *NewPanelItem = (PluginPanelItem *)realloc(*pPanelItem,(*pItemsNumber+1)*sizeof(PluginPanelItem));
			if (NewPanelItem == NULL) break;
			*pPanelItem = NewPanelItem;
			NewPanelItem[*pItemsNumber] = CurItem;
			(*pItemsNumber)++;
		}
	}
	return(TRUE);
}

void PluginClass::FreeFindData(PluginPanelItem *PanelItem,int ItemsNumber)
{
	delete PanelItem;
}

int PluginClass::SetDirectory(char *Dir,int OpMode)
{
	if (*Dir == '\\')
		if (*(++Dir) == 0) {
			*CurDir = 0;
			return(TRUE);
	}
	if (strcmp(Dir,"..") == 0) {
		if (*CurDir == 0)
			return(FALSE);
		char *Slash = strrchr(CurDir,'\\');
		if (Slash != NULL)
			*Slash=0;
		else
			*CurDir=0;
	}
	else {
		int Found = FALSE;
		unsigned int CurDirLength = strlen(CurDir);
		if (CurDirLength != 0)
			CurDirLength++;
		int NewDirLength = strlen(Dir);
		for (int I=0; I<ImgDataCount; I++) {
			char *CurName = ImgData[I].FindData.cFileName;
			if (strlen(CurName) >= CurDirLength+NewDirLength && LocalStrnicmp(CurName+CurDirLength,Dir,NewDirLength) == 0) {
				char Ch = CurName[CurDirLength+NewDirLength];
				if (Ch == '\\' || Ch == '/' || Ch == 0) {
					Found = TRUE;
					break;
				}
			}
		}
		if (!Found)	return(FALSE);
		if (*CurDir == 0 || *Dir == 0 || strchr(Dir,'\\') != 0)
			strcpy(CurDir,Dir);
		else {
			AddEndSlash(CurDir);
			strcat(CurDir,Dir);
		}
	}
	return(TRUE);
}

void PluginClass::GetOpenPluginInfo(struct OpenPluginInfo *Info)
{
	Info->StructSize = sizeof(*Info);
	Info->Flags = OPIF_USEFILTER | OPIF_USESORTGROUPS | OPIF_USEHIGHLIGHTING | OPIF_ADDDOTS;
	Info->HostFile = ImgName;
	Info->CurDir = CurDir;

	char FormatName[100];
	static char Format[100],DefExt[NM],Title[100];
	ImgPlugin->GetFormatName(ImgPluginNumber,FormatName,DefExt);
	sprintf(Format,GetMsg(MImgFormat),FormatName);
	Info->Format = Format;
	sprintf(Title," %s:%s",FormatName,PointToName(ImgName));
	if (*CurDir) {
		strcat(Title,"\\");
		strcat(Title,CurDir);
	}
	strcat(Title," ");

	Info->PanelTitle = Title;
	static struct InfoPanelLine InfoLines[14];

	memset(InfoLines,0,sizeof(InfoLines));

	Info->InfoLines = InfoLines;
	Info->InfoLinesNumber = sizeof(InfoLines)/sizeof(InfoLines[0]);

	static struct KeyBarTitles KeyBar;
	memset(&KeyBar,0,sizeof(KeyBar));
	KeyBar.Titles[3] = GetMsg(MEmpty);
	KeyBar.Titles[6] = GetMsg(MEmpty);
	KeyBar.AltTitles[3] = GetMsg(MEmpty);
	KeyBar.AltTitles[4] = GetMsg(MEmpty);
	KeyBar.AltTitles[5] = GetMsg(MEmpty);
	KeyBar.AltTitles[9] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [0] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [2] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [3] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [4] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [5] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [6] = GetMsg(MEmpty);
	KeyBar.ShiftTitles [7] = GetMsg(MEmpty);
	Info->KeyBar=&KeyBar;
}
