char *GetMsg(int MsgId)
{
	return(Info.GetMsg(Info.ModuleNumber,MsgId));
}
void InitDialogItems(struct InitDialogItem *Init,struct FarDialogItem *Item,int ItemsNumber)
{
	for (int I=0; I<ItemsNumber; I++) {
		Item[I].Type=Init[I].Type;
		Item[I].X1=Init[I].X1;
		Item[I].Y1=Init[I].Y1;
		Item[I].X2=Init[I].X2;
		Item[I].Y2=Init[I].Y2;
		Item[I].Focus=Init[I].Focus;
		Item[I].Selected=Init[I].Selected;
		Item[I].Flags=Init[I].Flags;
		Item[I].DefaultButton=Init[I].DefaultButton;
		if ((unsigned int)Init[I].Data<2000)
			strcpy(Item[I].Data,GetMsg((unsigned int)Init[I].Data));
		else
			strcpy(Item[I].Data,Init[I].Data);
	}
}

char* PointToName(char *Path)
{
	char *NamePtr=Path;
	while (*Path) {
		if (*Path=='\\' || *Path=='/' || *Path==':')
			NamePtr=Path+1;
		Path++;
	}
	return(NamePtr);
}

BOOL CheckForEsc(void)
{
	int ExitCode = FALSE;
	while (1) {
		INPUT_RECORD rec;
		static HANDLE hConInp = GetStdHandle(STD_INPUT_HANDLE);
		DWORD ReadCount;
		PeekConsoleInput(hConInp,&rec,1,&ReadCount);
		if (ReadCount == 0) break;
		ReadConsoleInput(hConInp,&rec,1,&ReadCount);
		if (rec.EventType == KEY_EVENT)
			if (rec.Event.KeyEvent.wVirtualKeyCode == VK_ESCAPE)
				ExitCode = TRUE;
	}
	return(ExitCode);
}

int LocalStrnicmp(char *Str1,char *Str2,int Length)
{
	char AnsiStr1[8192],AnsiStr2[8192];
	OemToChar(Str1,AnsiStr1);
	OemToChar(Str2,AnsiStr2);
	AnsiStr1[Length] = AnsiStr2[Length]=0;
	CharLower(AnsiStr1);
	CharLower(AnsiStr2);
	return(strcmp(AnsiStr1,AnsiStr2));
}

void AddEndSlash(char *Path)
{
	int Length = strlen(Path);
	if (Length == 0 || Path[Length-1] != '\\')
		strcat(Path,"\\");
}

void string_delete(char *String,int Start,int Count)
{
	int index1,index2;
	index1 = index2 = 0;
	index2 = Start+Count;
	for (index1 = Start; String[index1] = String[index2]; index1++) index2++;
}

BOOL GetFileName(char *Name, char *DExt,char *DFormat,BOOL CheckDot)
{
	const char *HistoryName="NewEdit";
	char NewTitle[256];

	sprintf(NewTitle,GetMsg(MNewFileNameTitle),DFormat);
	struct InitDialogItem InitItems[] = {
		DI_DOUBLEBOX,3,1,72,4,0,0,0,0,NewTitle,
		DI_TEXT,5,2,0,0,0,0,0,0,(char *)MNewName,
		DI_EDIT,5,3,70,3,1,(DWORD)HistoryName,DIF_HISTORY,1,""
    };
    struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
    InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]));
	int ExitCode = Info.Dialog(Info.ModuleNumber,-1,-1,76,6,NULL,DialogItems,
		sizeof(DialogItems)/sizeof(DialogItems[0]));
	if (ExitCode == -1) return(FALSE);
	strcpy(Name,DialogItems[2].Data);
	if (*Name && CheckDot) {
		char *p;
		if ((p = strchr(Name,'.')) == NULL) {
			strcat(Name,".");
			if (!IsCaseMixed(Name)) strupr(Name);
			strcat(Name,DExt);
		}
	}
	return(*Name != 0);
}

int IsCaseMixed(char *Str)
{
	while (*Str && !IsCharAlpha(*Str)) Str++;
	int Case = IsCharLower(*Str);
	while (*(Str++)) if (IsCharAlpha(*Str) && IsCharLower(*Str) != Case) return(TRUE);
	return(FALSE);
}
void MakeName(char *Source,char *Folder,char *File)
{
	*Source = 0;
	if (*Folder) {
		strcat(Source,Folder);
		strcat(Source,"\\");
	}
	strcat(Source,File);
	return;
}