#include "multiimage.hpp"
#include "img_reg.cpp"
#include "img_util.cpp"
#include "img_dlg.cpp"
#include "img_plugin.cpp"
#include "img_read.cpp"
#include "img_proc.cpp"

void WINAPI SetStartupInfo(struct PluginStartupInfo *Info)
{
	::Info = *Info;
	sprintf(PluginRootKey,"%s\\MultiImage",Info->RootKey);
	if (ImgPlugin == NULL)
		ImgPlugin = new ImgPlugins(Info->ModuleName);
	Opt.ProtectRO = GetRegKey(HKEY_CURRENT_USER,"","Protect",1);
	Opt.Decoder = GetRegKey(HKEY_CURRENT_USER,"","UseDecoder",0);
	Opt.HotKey = GetRegKey(HKEY_CURRENT_USER,"","UseHotKeys",1);
	GetRegKey(HKEY_CURRENT_USER,"","DecodeNames",Opt.Files,"*.txt,*.doc",sizeof(Opt.Files));
}

HANDLE WINAPI OpenFilePlugin(char *Name,const unsigned char *Data,unsigned int DataSize)
{
	if (ImgPlugin == NULL)
		return(INVALID_HANDLE_VALUE);
	int ImgPluginNumber = -1;
	if (Name == NULL) 
		return(INVALID_HANDLE_VALUE);
	else {
		ImgPluginNumber = ImgPlugin->IsImage(Name,Data,DataSize);
		if (ImgPluginNumber == -1)
			return(INVALID_HANDLE_VALUE);
	}
	HANDLE hPlugin = new PluginClass(ImgPluginNumber);
	
	if (hPlugin == NULL)
		return(INVALID_HANDLE_VALUE);
	PluginClass *Plugin=(PluginClass *)hPlugin;
		int ReadCode = Plugin->ReadImage(Name);
		if (ReadCode == 0)
			return(INVALID_HANDLE_VALUE);
		if (ReadCode == -1)
			return((HANDLE)-2);
	return(hPlugin);
}

int WINAPI  GetFindData(HANDLE hPlugin,struct PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode)
{
	PluginClass *Plugin=(PluginClass *)hPlugin;
	return(Plugin->GetFindData(pPanelItem,pItemsNumber,OpMode));
}

void WINAPI GetPluginInfo(struct PluginInfo *Info)
{
	Info->StructSize = sizeof(*Info);
	Info->Flags = 0;
	Info->DiskMenuStrings = NULL;
	Info->DiskMenuNumbers = NULL;
	Info->DiskMenuStringsNumber = 0;
	static char *PluginMenuStrings[1];
	PluginMenuStrings[0] = GetMsg(MPluginLine);
	Info->PluginMenuStrings = PluginMenuStrings;
	Info->PluginMenuStringsNumber = sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
	static char *PluginCfgStrings[1];
	PluginCfgStrings[0] = GetMsg(MCfgLine);
	Info->PluginConfigStrings = PluginCfgStrings;
	Info->PluginConfigStringsNumber = sizeof(PluginCfgStrings)/sizeof(PluginCfgStrings[0]);
}

void WINAPI ClosePlugin(HANDLE hPlugin)
{
	delete (PluginClass *)hPlugin;
}

void WINAPI ExitFAR()
{
	delete ImgPlugin;
}

int WINAPI Configure(int ItemNumber)
{
	return(MainConfig());
}

void WINAPI FreeFindData(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber)
{
	PluginClass *Plugin = (PluginClass *)hPlugin;
	Plugin->FreeFindData(PanelItem,ItemsNumber);
}

HANDLE WINAPI OpenPlugin(int OpenFrom,int Item)
{
	HANDLE hPlugin = new PluginClass(-1);
	PluginClass *Plugin = (PluginClass *)hPlugin;
	Plugin->ProcessFunctions();
	delete (PluginClass *)hPlugin;
	return(INVALID_HANDLE_VALUE);
}


void WINAPI GetOpenPluginInfo(HANDLE hPlugin,struct OpenPluginInfo *Info)
{
	PluginClass *Plugin = (PluginClass *)hPlugin;
	Plugin->GetOpenPluginInfo(Info);
}

int WINAPI SetDirectory(HANDLE hPlugin,char *Dir,int OpMode)
{
	PluginClass *Plugin=(PluginClass *)hPlugin;
	return(Plugin->SetDirectory(Dir,OpMode));
}

int WINAPI  DeleteFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode)
{
	PluginClass *Plugin=(PluginClass *)hPlugin;
	return(Plugin->DeleteFiles(PanelItem,ItemsNumber,OpMode));
}

int WINAPI GetFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode)
{
	PluginClass *Plugin=(PluginClass *)hPlugin;
	return(Plugin->GetFiles(PanelItem,ItemsNumber,Move,DestPath,OpMode));
}

int WINAPI PutFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode)
{
	PluginClass *Plugin=(PluginClass *)hPlugin;
	return(Plugin->PutFiles(PanelItem,ItemsNumber,Move,OpMode));
}

int WINAPI ProcessHostFile(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode)
{
	PluginClass *Plugin=(PluginClass *)hPlugin;
	return(Plugin->ProcessHostFile(PanelItem,ItemsNumber,OpMode));
}
