#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <time.h>
#include <io.h>
#include "plugin.hpp"
#include "marks.hpp"
#include "formats\di.hpp"

extern "C" {
	void WINAPI ClosePlugin(HANDLE hPlugin);
	int WINAPI Configure(int ItemNumber);
	int WINAPI DeleteFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode);
	void WINAPI ExitFAR();
	void WINAPI FreeFindData(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber);
	int WINAPI GetFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode);
	int WINAPI  GetFindData(HANDLE hPlugin,struct PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode);
	void WINAPI GetOpenPluginInfo(HANDLE hPlugin,struct OpenPluginInfo *Info);
	void WINAPI GetPluginInfo(struct PluginInfo *Info);
	void WINAPI SetStartupInfo(struct PluginStartupInfo *Info);
	HANDLE WINAPI OpenFilePlugin(char *Name,const unsigned char *Data,unsigned int DataSize);
	HANDLE WINAPI OpenPlugin(int OpenFrom,int Item);
	int WINAPI ProcessHostFile(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode);
	int WINAPI PutFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode);
	int WINAPI SetDirectory(HANDLE hPlugin,char *Dir,int OpMode);
}

typedef BOOL (WINAPI *PLUGINISIMAGE)(char *Name,const unsigned char *Data,int DataSize);
typedef BOOL (WINAPI *PLUGINIMGPREPARE)(HANDLE Handle);
typedef int (WINAPI *PLUGINGETIMGITEM)(HANDLE Handle,struct PluginPanelItem *Item);
typedef BOOL (WINAPI *PLUGINGETFORMATNAME)(char *FormatName,char *DefaultExt);
typedef BOOL (WINAPI *PLUGINCOPYFROMPC)(char *FileName,HANDLE Handle,struct PluginPanelItem Item,char *Data1,int Data2);
typedef BOOL (WINAPI *PLUGINCOPYTOPC)(HANDLE Handle,char *Source,struct PluginPanelItem Item);
typedef BOOL (WINAPI *PLUGINMAKENEWIMAGE)(HANDLE Handle);
typedef BOOL (WINAPI *PLUGINDELFILE)(HANDLE Handle,char *Source,struct PluginPanelItem Item);
typedef int (WINAPI *PLUGINFILEEXISTONIMAGE)(HANDLE Handle,WIN32_FIND_DATA FindData,char *Data);

struct PluginItem
{
	char ModuleName[NM];
	HMODULE hModule;
	PLUGINISIMAGE pIsImage;
	PLUGINIMGPREPARE pImgPrepare;
	PLUGINGETIMGITEM pGetImgItem;
	PLUGINGETFORMATNAME pGetFormatName;
	PLUGINCOPYFROMPC pCopyFromPC;
	PLUGINCOPYTOPC pCopyToPC;
	PLUGINMAKENEWIMAGE pMakeNewImage;
	PLUGINDELFILE pDelFile;
	PLUGINFILEEXISTONIMAGE pFileExistOnImage;
};

class ImgPlugins
{
	private:
		struct PluginItem *PluginsData;
		int PluginsCount;
	public:
		ImgPlugins(char *ModuleName);
		~ImgPlugins();
		int IsImage(char *Name,const unsigned char *Data,int DataSize);
		BOOL ImgPrepare(int PluginNumber,HANDLE Handle);
		int GetImgItem(int PluginNumber,HANDLE Handle,struct PluginPanelItem *Item);
		BOOL GetFormatName(int PluginNumber,char *FormatName,char *DefaultExt);
		int CopyToPC(int PluginNumber,HANDLE Handle,char *Source,struct PluginPanelItem Item);
		int CopyFromPC(int PluginNumber,char *FileName,HANDLE Handle,struct PluginPanelItem Item,char *Data1,int Data2);
		int MakeNewImage(int PluginNumber,HANDLE Handle);
		int DelFile(int PluginNumber,HANDLE Handle,char *Source,struct PluginPanelItem Item);
		int FileExistOnImage(int PluginNumber,HANDLE Handle,WIN32_FIND_DATA FindData,char *Data);
};

class PluginClass
{
	private:
		char ImgName[NM];
		char CurDir[NM];
		PluginPanelItem *ImgData;
		int ImgDataCount;
		WIN32_FIND_DATA ImgFindData;
		int ImgPluginNumber;
		int LastTestState,LastWithoutPathsState;
		HANDLE Handle;
	public:
		PluginClass(int ImgPluginNumber);
		~PluginClass();
		int ReadImage(char *Name);
		int GetFindData(PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode);
		void FreeFindData(PluginPanelItem *PanelItem,int ItemsNumber);
		int SetDirectory(char *Dir,int OpMode);
		//HANDLE OpenPluginFile4Read(char *Name);
		//HANDLE OpenPluginFile4Write(char *Name);
		HANDLE OpenPluginFile(char *Name);
		int ClosePluginFile(HANDLE Handle);
		void GetOpenPluginInfo(struct OpenPluginInfo *Info);
		int DeleteFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode);
		int ProcessHostFile(struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode);
		int GetFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode);
		int PutFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode);
		int SelectFormat(char *ImgFormat);
		int FormatToPlugin(char *Format,int &PluginNumber,char *Ext);
		int ProcessKey(int Key,unsigned int ControlState);
		void ProcessFunctions(void);
};

struct InitDialogItem
{
	unsigned char Type;
	unsigned char X1,Y1,X2,Y2;
	unsigned char Focus;
	unsigned int Selected;
	unsigned int Flags;
	unsigned char DefaultButton;
	char *Data;
};

void SetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData);
void SetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD ValueData);
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData,char *Default,DWORD DataSize);
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default);
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default);

int MainConfig();
char *GetMsg(int);
void InitDialogItems(struct InitDialogItem,struct FarDialogItem,int);
char* PointToName(char*);
BOOL CheckForEsc(void);
int LocalStrnicmp(char*,char*,int);
void AddEndSlash(char*);
void string_delete(char*,int,int);
BOOL GetFileName(char*,char*,char*,BOOL);
int IsCaseMixed(char*);
BOOL FuncNotSupported(void);
BOOL CopyError(char*,struct PluginPanelItem);
BOOL FileError(char*);
BOOL FileCreateErrorOnPC(char*);
BOOL DeleteConfirm(struct PanelInfo);
void WriteDeleteWindow(char*);
void MakeName(char*,char*,char*);
int CDeleteFile(char*,int);
int CDeleteFolder(char*);
BOOL DeleteError(char*,DWORD);
void BadData(char*);

struct PluginStartupInfo Info;
class ImgPlugins *ImgPlugin = NULL;
char PluginRootKey[80];

struct Options
{
	int ProtectRO;
	int Decoder;
	int HotKey;
	char Files[NM];
} Opt;
